/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import jfxtras.labs.scene.control.ListSpinner;

public class ListSpinnerBehavior<T>
extends BehaviorBase<ListSpinner<T>> {
    private static final String EVENT_PREVIOUS = "PreviousPressed";
    private static final String EVENT_NEXT = "NextPressed";
    protected static final List<KeyBinding> KEY_BINDINGS = new ArrayList<KeyBinding>();

    public ListSpinnerBehavior(ListSpinner<T> control) {
        super(control);
        this.construct();
    }

    private void construct() {
    }

    public void parse(String text) {
        Integer lIndex;
        String lPrefix;
        String lText = text;
        String lPostfix = ((ListSpinner)this.getControl()).getPostfix();
        if (lPostfix.length() > 0 && lText.endsWith(lPostfix)) {
            lText = lText.substring(0, lText.length() - lPostfix.length());
        }
        if ((lPrefix = ((ListSpinner)this.getControl()).getPrefix()).length() > 0 && lText.startsWith(lPrefix)) {
            lText = lText.substring(lPrefix.length());
        }
        Object lValue = ((ListSpinner)this.getControl()).getStringConverter().fromString(lText);
        int lItemIndex = ((ListSpinner)this.getControl()).getItems().indexOf(lValue);
        if (lItemIndex >= 0) {
            ((ListSpinner)this.getControl()).setValue(lValue);
            return;
        }
        Callback lAddCallback = ((ListSpinner)this.getControl()).getAddCallback();
        if (lAddCallback != null && (lIndex = (Integer)lAddCallback.call(lValue)) != null) {
            ((ListSpinner)this.getControl()).setIndex(lIndex);
            return;
        }
    }

    public void mousePressed(MouseEvent evt) {
        ListSpinner lControl = (ListSpinner)this.getControl();
        if (!lControl.isFocused() && lControl.isFocusTraversable()) {
            lControl.requestFocus();
        }
    }

    protected List<KeyBinding> createKeyBindings() {
        return KEY_BINDINGS;
    }

    protected void callAction(String name) {
        if (EVENT_PREVIOUS.equals(name)) {
            ((ListSpinner)this.getControl()).decrement();
        } else if (EVENT_NEXT.equals(name)) {
            ((ListSpinner)this.getControl()).increment();
        } else {
            super.callAction(name);
        }
    }

    static {
        KEY_BINDINGS.add(new KeyBinding(KeyCode.MINUS, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.PLUS, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.SUBTRACT, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.ADD, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.UP, EVENT_NEXT));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.DOWN, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.LEFT, EVENT_PREVIOUS));
        KEY_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, EVENT_NEXT));
        KEY_BINDINGS.addAll(TRAVERSAL_BINDINGS);
    }
}

