/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ScrollPaneBuilder;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import jfxtras.labs.animation.Timer;
import jfxtras.labs.internal.scene.control.behavior.AgendaBehavior;
import jfxtras.labs.scene.control.Agenda;
import jfxtras.labs.scene.control.CalendarTextField;
import jfxtras.labs.util.NodeUtil;

public class AgendaWeekSkin
extends SkinBase<Agenda, AgendaBehavior>
implements Agenda.AgendaSkin {
    private SimpleDateFormat dayOfWeekDateFormat = null;
    private SimpleDateFormat dateFormat = null;
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private Pane dragPane = null;
    private BorderPane borderPane = null;
    private WeekHeaderPane weekHeaderPane = null;
    private ScrollPane weekScrollPane = null;
    private WeekPane weekPane = null;
    private Image closeIconImage = null;
    AbstractAppointmentPane focused = null;
    final Rectangle nowLine = new Rectangle(0.0, 0.0, 0.0, 0.0);
    Runnable nowUpdateRunnable = new Runnable(){
        {
            AgendaWeekSkin.this.nowLine.getStyleClass().add((Object)"Now");
            AgendaWeekSkin.this.nowLine.setHeight(3.0);
        }

        @Override
        public void run() {
            Calendar lNow = Calendar.getInstance();
            boolean lFound = false;
            for (DayPane lDayPane : ((AgendaWeekSkin)AgendaWeekSkin.this).weekPane.dayPanes) {
                if (!AgendaWeekSkin.this.isSameDay((Calendar)lDayPane.calendarObjectProperty.get(), lNow)) {
                    lDayPane.getStyleClass().remove((Object)"today");
                } else {
                    if (!lDayPane.getStyleClass().contains((Object)"today")) {
                        lDayPane.getStyleClass().add((Object)"today");
                    }
                    lFound = true;
                    if (!AgendaWeekSkin.this.weekPane.getChildren().contains((Object)AgendaWeekSkin.this.nowLine)) {
                        AgendaWeekSkin.this.weekPane.getChildren().add((Object)AgendaWeekSkin.this.nowLine);
                        AgendaWeekSkin.this.nowLine.xProperty().bind((ObservableValue)lDayPane.layoutXProperty());
                    }
                    int lOffsetY = lNow.get(11) * 60 + lNow.get(12);
                    AgendaWeekSkin.this.nowLine.setY(AgendaWeekSkin.this.dayHeightProperty.get() / 1440.0 * (double)lOffsetY);
                    if (!AgendaWeekSkin.this.nowLine.widthProperty().isBound()) {
                        AgendaWeekSkin.this.nowLine.widthProperty().bind((ObservableValue)AgendaWeekSkin.this.dayWidthProperty);
                    }
                }
                for (AbstractClusteredDayAppointmentPane abstractClusteredDayAppointmentPane : lDayPane.clusteredAppointmentPanes) {
                    abstractClusteredDayAppointmentPane.historicalVisualizer.setVisible(abstractClusteredDayAppointmentPane.start.before(lNow));
                }
                for (WholedayAppointmentPane wholedayAppointmentPane : lDayPane.wholedayAppointmentPanes) {
                    wholedayAppointmentPane.historicalVisualizer.setVisible(wholedayAppointmentPane.start.before(lNow));
                }
            }
            if (!lFound) {
                AgendaWeekSkin.this.weekPane.getChildren().remove((Object)AgendaWeekSkin.this.nowLine);
            }
            for (DayHeaderPane lDayHeaderPane : ((AgendaWeekSkin)AgendaWeekSkin.this).weekHeaderPane.dayHeaderPanes) {
                for (AppointmentHeaderPane appointmentHeaderPane : lDayHeaderPane.appointmentHeaderPanes) {
                    appointmentHeaderPane.historicalVisualizer.setVisible(appointmentHeaderPane.appointment.getStartTime().before(lNow));
                }
            }
        }
    };
    Timer nowTimer = new Timer(this.nowUpdateRunnable).withCycleDuration(new Duration(60000.0)).withDelay(new Duration((double)((60 - Calendar.getInstance().get(13)) * 1000))).start();
    private final double padding = 3.0;
    private final double timeColumnWhitespace = 10.0;
    private final double wholedayAppointmentWidth = 5.0;
    private final IntegerProperty highestNumberOfWholedayAppointmentsProperty = new SimpleIntegerProperty(0);
    private final DoubleProperty textHeightProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty titleCalendarHeightProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty headerHeightProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty wholedayTitleHeightProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty timeWidthProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty dayFirstColumnXProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty dayWidthProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty dayContentWidthProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty dayHeightProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty durationInMSPerPixelProperty = new SimpleDoubleProperty(0.0);
    private final DoubleProperty hourHeighProperty = new SimpleDoubleProperty(0.0);

    public AgendaWeekSkin(Agenda control) {
        super((Control)control, (BehaviorBase)new AgendaBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((Agenda)this.getSkinnable()).localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                AgendaWeekSkin.this.refreshLocale();
            }
        });
        this.refreshLocale();
        ((Agenda)this.getSkinnable()).displayedCalendar().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                AgendaWeekSkin.this.assignCalendarToTheDayPanes();
                AgendaWeekSkin.this.setupAppointments();
            }
        });
        this.assignCalendarToTheDayPanes();
        ((Agenda)this.getSkinnable()).appointments().addListener((ListChangeListener)new ListChangeListener<Agenda.Appointment>(){

            public void onChanged(ListChangeListener.Change<? extends Agenda.Appointment> arg0) {
                AgendaWeekSkin.this.setupAppointments();
            }
        });
        this.setupAppointments();
        ((Agenda)this.getSkinnable()).selectedAppointments().addListener((ListChangeListener)new ListChangeListener<Agenda.Appointment>(){

            public void onChanged(ListChangeListener.Change<? extends Agenda.Appointment> changes) {
                AgendaWeekSkin.this.setOrRemoveSelected();
            }
        });
        this.setOrRemoveSelected();
    }

    private void setOrRemoveSelected() {
        for (DayPane lDayPane : this.weekPane.dayPanes) {
            for (AbstractAppointmentPane lAppointmentPane : lDayPane.allAbstractAppointmentPanes()) {
                if (lAppointmentPane.getStyleClass().contains((Object)"Selected") && !((Agenda)this.getSkinnable()).selectedAppointments().contains((Object)lAppointmentPane.appointment)) {
                    lAppointmentPane.getStyleClass().remove((Object)"Selected");
                }
                if (lAppointmentPane.getStyleClass().contains((Object)"Selected") || !((Agenda)this.getSkinnable()).selectedAppointments().contains((Object)lAppointmentPane.appointment)) continue;
                lAppointmentPane.getStyleClass().add((Object)"Selected");
            }
        }
    }

    private void assignCalendarToTheDayPanes() {
        Calendar lCalendar = this.getFirstDayOfWeekCalendar();
        Calendar lStartCalendar = (Calendar)lCalendar.clone();
        Calendar lEndCalendar = null;
        for (int i = 0; i < 7; ++i) {
            DayPane lDayPane = this.weekPane.dayPanes.get(i);
            lDayPane.calendarObjectProperty.set((Object)((Calendar)lCalendar.clone()));
            if (i == 6) {
                lEndCalendar = (Calendar)lCalendar.clone();
            }
            lCalendar.add(5, 1);
        }
        this.nowUpdateRunnable.run();
        if (((Agenda)this.getSkinnable()).getCalendarRangeCallback() != null) {
            Agenda.CalendarRange lCalendarRange = new Agenda.CalendarRange(lStartCalendar, lEndCalendar);
            ((Agenda)this.getSkinnable()).getCalendarRangeCallback().call((Object)lCalendarRange);
        }
    }

    private void refreshLocale() {
        this.dayOfWeekDateFormat = new SimpleDateFormat("E", ((Agenda)this.getSkinnable()).getLocale());
        this.dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, ((Agenda)this.getSkinnable()).getLocale());
        int lCnt = 0;
        for (DayPane lDayPane : this.weekPane.dayPanes) {
            if (lDayPane.calendarObjectProperty.get() != null) {
                lDayPane.calendarObjectProperty.set((Object)((Calendar)((Calendar)lDayPane.calendarObjectProperty.get()).clone()));
            }
            String lWeekendOrWeekday = this.isWeekdayWeekend(lCnt) ? "weekend" : "weekday";
            lDayPane.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayPane.getStyleClass().add((Object)lWeekendOrWeekday);
            lDayPane.dayHeaderPane.calendarText.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayPane.dayHeaderPane.calendarText.getStyleClass().add((Object)lWeekendOrWeekday);
            ++lCnt;
        }
    }

    private void setupAppointments() {
        this.calculateSizes();
        for (DayPane lDay : this.weekPane.dayPanes) {
            lDay.setupAppointments();
        }
        this.calculateSizes();
        this.nowUpdateRunnable.run();
    }

    @Override
    public void refresh() {
        this.refreshLocale();
        this.assignCalendarToTheDayPanes();
        this.setupAppointments();
        this.setOrRemoveSelected();
        this.nowUpdateRunnable.run();
    }

    private void createNodes() {
        this.borderPane = new BorderPane();
        this.weekPane = new WeekPane();
        this.weekScrollPane = ScrollPaneBuilder.create().content((Node)this.weekPane).hbarPolicy(ScrollPane.ScrollBarPolicy.NEVER).fitToWidth(true).pannable(false).build();
        this.borderPane.setCenter((Node)this.weekScrollPane);
        this.weekScrollPane.viewportBoundsProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable viewportBoundsProperty) {
                AgendaWeekSkin.this.calculateSizes();
                AgendaWeekSkin.this.nowUpdateRunnable.run();
            }
        });
        this.weekHeaderPane = new WeekHeaderPane();
        this.weekHeaderPane.prefWidthProperty().bind((ObservableValue)this.weekPane.widthProperty());
        this.weekHeaderPane.prefHeightProperty().bind((ObservableValue)this.headerHeightProperty);
        this.weekHeaderPane.setTranslateX(1.0);
        this.borderPane.setTop((Node)this.weekHeaderPane);
        this.dragPane = new Pane();
        this.dragPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.dragPane.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.dragPane.getChildren().add((Object)this.borderPane);
        this.borderPane.prefWidthProperty().bind((ObservableValue)this.dragPane.widthProperty());
        this.borderPane.prefHeightProperty().bind((ObservableValue)this.dragPane.heightProperty());
        this.getStyleClass().add((Object)this.getClass().getSimpleName());
        this.getChildren().add((Object)this.dragPane);
        this.closeIconImage = new Image(this.getClass().getResourceAsStream(this.getClass().getSimpleName() + "PopupCloseWindowIcon.png"));
    }

    private void showMenu(MouseEvent evt, final AbstractAppointmentPane abstractAppointmentPane) {
        Callback<Agenda.Appointment, Void> lEditCallback = ((Agenda)this.getSkinnable()).getEditAppointmentCallback();
        if (lEditCallback != null) {
            lEditCallback.call((Object)abstractAppointmentPane.appointment);
            return;
        }
        final Popup lPopup = new Popup();
        lPopup.setAutoFix(true);
        lPopup.setAutoHide(true);
        lPopup.setHideOnEscape(true);
        lPopup.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                AgendaWeekSkin.this.setupAppointments();
            }
        });
        BorderPane lBorderPane = new BorderPane();
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)((Agenda)this.getSkinnable()))).getClass().getSimpleName() + "Popup"));
        lPopup.getContent().add((Object)lBorderPane);
        ImageView lImageView = new ImageView(this.closeIconImage);
        lImageView.setPickOnBounds(true);
        lImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                lPopup.hide();
            }
        });
        lBorderPane.setRight((Node)lImageView);
        VBox lMenuVBox = new VBox(3.0);
        lBorderPane.setCenter((Node)lMenuVBox);
        lMenuVBox.getChildren().add((Object)new Text("Time:"));
        CalendarTextField lStartCalendarTextField = new CalendarTextField().withDateFormat(SimpleDateFormat.getDateTimeInstance());
        lStartCalendarTextField.setLocale(((Agenda)this.getSkinnable()).getLocale());
        lStartCalendarTextField.setValue(abstractAppointmentPane.appointment.getStartTime());
        lMenuVBox.getChildren().add((Object)lStartCalendarTextField);
        final CalendarTextField lEndCalendarTextField = new CalendarTextField().withDateFormat(SimpleDateFormat.getDateTimeInstance());
        lEndCalendarTextField.setLocale(((Agenda)this.getSkinnable()).getLocale());
        lEndCalendarTextField.setValue(abstractAppointmentPane.appointment.getEndTime());
        lMenuVBox.getChildren().add((Object)lEndCalendarTextField);
        lEndCalendarTextField.valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> arg0, Calendar oldValue, Calendar newValue) {
                abstractAppointmentPane.appointment.setEndTime(newValue);
            }
        });
        lEndCalendarTextField.setVisible(abstractAppointmentPane.appointment.getEndTime() != null);
        if (abstractAppointmentPane.appointment.isWholeDay() != null && abstractAppointmentPane.appointment.isWholeDay().booleanValue() || abstractAppointmentPane.appointment.getEndTime() != null) {
            CheckBox lWholedayCheckBox = new CheckBox("Wholeday");
            lWholedayCheckBox.selectedProperty().set(abstractAppointmentPane.appointment.isWholeDay().booleanValue());
            lMenuVBox.getChildren().add((Object)lWholedayCheckBox);
            lWholedayCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                    abstractAppointmentPane.appointment.setWholeDay(newValue);
                    if (newValue.booleanValue()) {
                        abstractAppointmentPane.appointment.setEndTime(null);
                    } else {
                        Calendar lEndTime = (Calendar)abstractAppointmentPane.appointment.getStartTime().clone();
                        lEndTime.add(12, 30);
                        abstractAppointmentPane.appointment.setEndTime(lEndTime);
                        lEndCalendarTextField.setValue(abstractAppointmentPane.appointment.getEndTime());
                    }
                    lEndCalendarTextField.setVisible(abstractAppointmentPane.appointment.getEndTime() != null);
                }
            });
        }
        lStartCalendarTextField.valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> arg0, Calendar oldValue, Calendar newValue) {
                if (abstractAppointmentPane.appointment.isWholeDay().booleanValue()) {
                    abstractAppointmentPane.appointment.setStartTime(newValue);
                } else {
                    Calendar lOldStart = abstractAppointmentPane.appointment.getStartTime();
                    abstractAppointmentPane.appointment.setStartTime(newValue);
                    if (abstractAppointmentPane.appointment.getEndTime() != null) {
                        long lDurationInMS = abstractAppointmentPane.appointment.getEndTime().getTimeInMillis() - lOldStart.getTimeInMillis();
                        Calendar lEndCalendar = (Calendar)abstractAppointmentPane.appointment.getStartTime().clone();
                        lEndCalendar.add(14, (int)lDurationInMS);
                        abstractAppointmentPane.appointment.setEndTime(lEndCalendar);
                        lEndCalendarTextField.setValue(abstractAppointmentPane.appointment.getEndTime());
                    }
                }
            }
        });
        lMenuVBox.getChildren().add((Object)new Text("Summary:"));
        TextField lSummaryTextField = new TextField();
        lSummaryTextField.setText(abstractAppointmentPane.appointment.getSummary());
        lSummaryTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
                abstractAppointmentPane.appointment.setSummary(newValue);
            }
        });
        lMenuVBox.getChildren().add((Object)lSummaryTextField);
        lMenuVBox.getChildren().add((Object)new Text("Location:"));
        TextField lLocationTextField = new TextField();
        lLocationTextField.setText(abstractAppointmentPane.appointment.getLocation() == null ? "" : abstractAppointmentPane.appointment.getLocation());
        lLocationTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
                abstractAppointmentPane.appointment.setLocation(newValue);
            }
        });
        lMenuVBox.getChildren().add((Object)lLocationTextField);
        lMenuVBox.getChildren().add((Object)new Text("Actions:"));
        HBox lHBox = new HBox();
        lMenuVBox.getChildren().add((Object)lHBox);
        ImageButton lImageButton = new ImageButton(new Image(this.getClass().getResourceAsStream("jqueryMobileBlack16x16/delete.png")));
        lImageButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                lPopup.hide();
                ((Agenda)AgendaWeekSkin.this.getSkinnable()).appointments().remove((Object)abstractAppointmentPane.appointment);
            }
        });
        Tooltip.install((Node)lImageButton, (Tooltip)new Tooltip("Delete"));
        lHBox.getChildren().add((Object)lImageButton);
        lMenuVBox.getChildren().add((Object)new Text("Group:"));
        GridPane lAppointmentGroupGridPane = new GridPane();
        lMenuVBox.getChildren().add((Object)lAppointmentGroupGridPane);
        lAppointmentGroupGridPane.getStyleClass().add((Object)"AppointmentGroups");
        lAppointmentGroupGridPane.setHgap(2.0);
        lAppointmentGroupGridPane.setVgap(2.0);
        int lCnt = 0;
        for (Agenda.AppointmentGroup lAppointmentGroup : ((Agenda)this.getSkinnable()).appointmentGroups()) {
            final Pane lPane = new Pane();
            lPane.setPrefSize(15.0, 15.0);
            lPane.getStyleClass().addAll((Object[])new String[]{"AppointmentGroup", lAppointmentGroup.getStyleClass()});
            lAppointmentGroupGridPane.add((Node)lPane, lCnt % 10, lCnt / 10);
            ++lCnt;
            Tooltip.install((Node)lPane, (Tooltip)new Tooltip(lAppointmentGroup.getDescription()));
            lPane.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        mouseEvent.consume();
                        lPane.setCursor(Cursor.HAND);
                    }
                }
            });
            lPane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        mouseEvent.consume();
                        lPane.setCursor(Cursor.DEFAULT);
                    }
                }
            });
            final Agenda.AppointmentGroup lAppointmentGroupFinal = lAppointmentGroup;
            lPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    abstractAppointmentPane.appointment.setAppointmentGroup(lAppointmentGroupFinal);
                    lPopup.hide();
                }
            });
        }
        lPopup.show((Node)abstractAppointmentPane, NodeUtil.screenX((Node)abstractAppointmentPane), NodeUtil.screenY((Node)abstractAppointmentPane.menuIcon) + abstractAppointmentPane.menuIcon.getHeight());
    }

    protected boolean isWeekday(int idx, int weekdaynr) {
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 4 + ((Agenda)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek());
        ((Calendar)lCalendar).add(5, idx);
        int lDayOfWeek = lCalendar.get(7);
        return lDayOfWeek == weekdaynr;
    }

    protected boolean isWeekdayWeekend(int idx) {
        return this.isWeekday(idx, 7) || this.isWeekday(idx, 1);
    }

    private void calculateSizes() {
        double lScrollbarSize = new ScrollBar().getWidth();
        this.textHeightProperty.set(new Text("X").getBoundsInParent().getHeight());
        this.highestNumberOfWholedayAppointmentsProperty.set(0);
        for (DayPane lDay : this.weekPane.dayPanes) {
            if (lDay.wholedayAppointmentPanes.size() <= this.highestNumberOfWholedayAppointmentsProperty.get()) continue;
            this.highestNumberOfWholedayAppointmentsProperty.set(lDay.wholedayAppointmentPanes.size());
        }
        this.titleCalendarHeightProperty.set(1.5 * this.textHeightProperty.get());
        this.wholedayTitleHeightProperty.set(this.textHeightProperty.get() + 5.0);
        this.headerHeightProperty.set(this.titleCalendarHeightProperty.get() + (double)this.highestNumberOfWholedayAppointmentsProperty.get() * this.wholedayTitleHeightProperty.get());
        this.timeWidthProperty.set(new Text("88:88").getBoundsInParent().getWidth() + 10.0);
        this.dayFirstColumnXProperty.set(this.timeWidthProperty.get());
        if (this.weekScrollPane.viewportBoundsProperty().get() != null) {
            this.dayWidthProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getWidth() - this.timeWidthProperty.get()) / 7.0);
        }
        this.dayContentWidthProperty.set(this.dayWidthProperty.get() - 10.0);
        this.hourHeighProperty.set(2.0 * this.textHeightProperty.get() + 10.0);
        if (this.weekScrollPane.viewportBoundsProperty().get() != null && ((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize > this.hourHeighProperty.get() * 24.0) {
            this.hourHeighProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize) / 24.0);
        }
        this.dayHeightProperty.set(this.hourHeighProperty.get() * 24.0);
        this.durationInMSPerPixelProperty.set(8.64E7 / this.dayHeightProperty.get());
    }

    protected Calendar getFirstDayOfWeekCalendar() {
        Locale locale = ((Agenda)this.getSkinnable()).getLocale();
        Calendar c = ((Agenda)this.getSkinnable()).getDisplayedCalendar();
        int lFirstDayOfWeek = Calendar.getInstance(locale).getFirstDayOfWeek();
        int lCurrentDayOfWeek = c.get(7);
        int lDelta = 0;
        lDelta = lFirstDayOfWeek <= lCurrentDayOfWeek ? -lCurrentDayOfWeek + lFirstDayOfWeek : -lCurrentDayOfWeek - (7 - lFirstDayOfWeek);
        c = (Calendar)c.clone();
        c.add(5, lDelta);
        return c;
    }

    private boolean isSameDay(Calendar c1, Calendar c2) {
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    private int determineTrackWhereAppointmentCanBeAdded(List<List<AbstractClusteredDayAppointmentPane>> tracks, AbstractClusteredDayAppointmentPane appointmentPane) {
        int lTrackNr = 0;
        while (true) {
            if (lTrackNr == tracks.size()) {
                tracks.add(new ArrayList());
            }
            if (!this.checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(tracks, lTrackNr, appointmentPane)) {
                return lTrackNr;
            }
            ++lTrackNr;
        }
    }

    private boolean checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(List<List<AbstractClusteredDayAppointmentPane>> tracks, int tracknr, AbstractClusteredDayAppointmentPane appointmentPane) {
        List<AbstractClusteredDayAppointmentPane> lTrack = tracks.get(tracknr);
        for (AbstractClusteredDayAppointmentPane lAppointmentPane : lTrack) {
            if (!lAppointmentPane.start.equals(appointmentPane.start) && appointmentPane.end != null && !lAppointmentPane.start.before(appointmentPane.end) || lAppointmentPane.end == null || !lAppointmentPane.end.equals(appointmentPane.start) && !lAppointmentPane.end.after(appointmentPane.start)) continue;
            return true;
        }
        return false;
    }

    private Calendar setTimeTo0000(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    private Calendar setTimeTo2359(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c;
    }

    private Calendar setTimeToNearestMinutes(Calendar c, int minutes) {
        c.set(14, 0);
        c.set(13, 0);
        int lMinutes = c.get(12) % minutes;
        if (lMinutes < minutes / 2) {
            c.add(12, -1 * lMinutes);
        } else {
            c.add(12, minutes - lMinutes);
        }
        return c;
    }

    private Calendar copyYMD(Calendar from, Calendar to) {
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        return to;
    }

    class ImageButton
    extends ImageView {
        public ImageButton(Image i) {
            super(i);
            this.setPickOnBounds(true);
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        ImageButton.this.setCursor(Cursor.HAND);
                    }
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        ImageButton.this.setCursor(Cursor.DEFAULT);
                    }
                }
            });
        }
    }

    abstract class AbstractAppointmentPane
    extends Pane {
        Agenda.Appointment appointment = null;
        boolean isFirstAreaOfAppointment = true;
        boolean isLastAreaOfAppointment = true;
        boolean isDraggable = true;
        Rectangle dragRectangle;
        double startX = 0.0;
        double startY = 0.0;
        boolean dragEventHasOccurred = false;
        Rectangle menuIcon = null;
        Rectangle historicalVisualizer = null;

        public AbstractAppointmentPane(Agenda.Appointment appointment) {
            this.appointment = appointment;
            Tooltip.install((Node)this, (Tooltip)new Tooltip(appointment.getSummary()));
            this.menuIcon = new MenuIcon(this);
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        return;
                    }
                    if (!AbstractAppointmentPane.this.isDraggable) {
                        return;
                    }
                    boolean bl = AbstractAppointmentPane.this.dragEventHasOccurred = !mouseEvent.isPrimaryButtonDown();
                    if (!AbstractAppointmentPane.this.isFirstAreaOfAppointment) {
                        return;
                    }
                    AbstractAppointmentPane.this.setCursor(Cursor.MOVE);
                    double lX = NodeUtil.screenX((Node)AbstractAppointmentPane.this) - NodeUtil.screenX((Node)AgendaWeekSkin.this.dragPane);
                    double lY = NodeUtil.screenY((Node)AbstractAppointmentPane.this) - NodeUtil.screenY((Node)AgendaWeekSkin.this.dragPane);
                    AbstractAppointmentPane.this.dragRectangle = new Rectangle(lX, lY, AbstractAppointmentPane.this.getWidth(), AbstractAppointmentPane.this.appointment.isWholeDay() != false ? AgendaWeekSkin.this.titleCalendarHeightProperty.get() : AbstractAppointmentPane.this.getHeight());
                    AbstractAppointmentPane.this.dragRectangle.getStyleClass().add((Object)"GhostRectangle");
                    AgendaWeekSkin.this.dragPane.getChildren().add((Object)AbstractAppointmentPane.this.dragRectangle);
                    AbstractAppointmentPane.this.startX = mouseEvent.getScreenX();
                    AbstractAppointmentPane.this.startY = mouseEvent.getScreenY();
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        return;
                    }
                    AbstractAppointmentPane.this.dragEventHasOccurred = true;
                    if (AbstractAppointmentPane.this.dragRectangle == null) {
                        return;
                    }
                    double lDeltaX = mouseEvent.getScreenX() - AbstractAppointmentPane.this.startX;
                    double lDeltaY = mouseEvent.getScreenY() - AbstractAppointmentPane.this.startY;
                    double lX = NodeUtil.screenX((Node)AbstractAppointmentPane.this) - NodeUtil.screenX((Node)AgendaWeekSkin.this.dragPane) + lDeltaX;
                    double lY = NodeUtil.screenY((Node)AbstractAppointmentPane.this) - NodeUtil.screenY((Node)AgendaWeekSkin.this.dragPane) + lDeltaY;
                    AbstractAppointmentPane.this.dragRectangle.setX(lX);
                    AbstractAppointmentPane.this.dragRectangle.setY(lY);
                    mouseEvent.consume();
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    Agenda.Appointment lAppointment;
                    double lDayY;
                    double lDayX;
                    mouseEvent.consume();
                    boolean lDragRectangleWasVisible = AbstractAppointmentPane.this.dragRectangle != null;
                    AbstractAppointmentPane.this.setCursor(Cursor.HAND);
                    AgendaWeekSkin.this.dragPane.getChildren().remove((Object)AbstractAppointmentPane.this.dragRectangle);
                    AbstractAppointmentPane.this.dragRectangle = null;
                    if (!AbstractAppointmentPane.this.dragEventHasOccurred) {
                        if (!mouseEvent.isShiftDown()) {
                            ((Agenda)AgendaWeekSkin.this.getSkinnable()).selectedAppointments().clear();
                        }
                        if (!((Agenda)AgendaWeekSkin.this.getSkinnable()).selectedAppointments().contains((Object)AbstractAppointmentPane.this.appointment)) {
                            ((Agenda)AgendaWeekSkin.this.getSkinnable()).selectedAppointments().add((Object)AbstractAppointmentPane.this.appointment);
                        }
                        return;
                    }
                    if (!lDragRectangleWasVisible) {
                        return;
                    }
                    for (DayPane lDayPane : ((AgendaWeekSkin)AgendaWeekSkin.this).weekPane.dayPanes) {
                        Calendar lStartCalendar;
                        lDayX = NodeUtil.screenX((Node)lDayPane);
                        lDayY = NodeUtil.screenY((Node)lDayPane);
                        if (!(lDayX <= mouseEvent.getScreenX()) || !(mouseEvent.getScreenX() < lDayX + lDayPane.getWidth()) || !(lDayY <= mouseEvent.getScreenY()) || !(mouseEvent.getScreenY() < lDayY + lDayPane.getHeight())) continue;
                        lAppointment = AbstractAppointmentPane.this.appointment;
                        Calendar lDroppedOnCalendar = (Calendar)lDayPane.calendarObjectProperty.get();
                        if (lAppointment.isWholeDay().booleanValue()) {
                            lStartCalendar = AgendaWeekSkin.this.copyYMD(lDroppedOnCalendar, (Calendar)lAppointment.getStartTime().clone());
                            Calendar lEndCalendar = lAppointment.getEndTime() == null ? AgendaWeekSkin.this.setTimeTo2359((Calendar)lDroppedOnCalendar.clone()) : AgendaWeekSkin.this.copyYMD(lDroppedOnCalendar, (Calendar)lAppointment.getEndTime().clone());
                            lAppointment.setStartTime(lStartCalendar);
                            lAppointment.setEndTime(lEndCalendar);
                            lAppointment.setWholeDay(false);
                        }
                        lStartCalendar = AgendaWeekSkin.this.copyYMD(lDroppedOnCalendar, (Calendar)lAppointment.getStartTime().clone());
                        int lDeltaDurationInMS = (int)((mouseEvent.getScreenY() - AbstractAppointmentPane.this.startY) * AgendaWeekSkin.this.durationInMSPerPixelProperty.get());
                        lStartCalendar.add(14, lDeltaDurationInMS);
                        AgendaWeekSkin.this.setTimeToNearestMinutes(lStartCalendar, 5);
                        while (!AgendaWeekSkin.this.isSameDay(lStartCalendar, lDroppedOnCalendar) && lStartCalendar.before(lDroppedOnCalendar)) {
                            lStartCalendar.add(12, 1);
                        }
                        while (!AgendaWeekSkin.this.isSameDay(lStartCalendar, lDroppedOnCalendar) && lStartCalendar.after(lDroppedOnCalendar)) {
                            lStartCalendar.add(12, -1);
                        }
                        Calendar lEndCalendar = null;
                        if (lAppointment.getEndTime() != null) {
                            long lDurationInMS = lAppointment.getEndTime().getTimeInMillis() - lAppointment.getStartTime().getTimeInMillis();
                            lEndCalendar = (Calendar)lStartCalendar.clone();
                            lEndCalendar.add(14, (int)lDurationInMS);
                        }
                        lAppointment.setStartTime(lStartCalendar);
                        lAppointment.setEndTime(lEndCalendar);
                    }
                    for (DayHeaderPane lDayHeaderPane : ((AgendaWeekSkin)AgendaWeekSkin.this).weekHeaderPane.dayHeaderPanes) {
                        lDayX = NodeUtil.screenX((Node)lDayHeaderPane);
                        lDayY = NodeUtil.screenY((Node)lDayHeaderPane);
                        if (!(lDayX <= mouseEvent.getScreenX()) || !(mouseEvent.getScreenX() < lDayX + lDayHeaderPane.getWidth()) || !(lDayY <= mouseEvent.getScreenY()) || !(mouseEvent.getScreenY() < lDayY + lDayHeaderPane.getHeight())) continue;
                        lAppointment = AbstractAppointmentPane.this.appointment;
                        Calendar lStartCalendar = AgendaWeekSkin.this.copyYMD((Calendar)lDayHeaderPane.dayPane.calendarObjectProperty.get(), (Calendar)lAppointment.getStartTime().clone());
                        lAppointment.setStartTime(lStartCalendar);
                        lAppointment.setWholeDay(true);
                    }
                    AgendaWeekSkin.this.setupAppointments();
                }
            });
        }
    }

    abstract class AbstractDayAppointmentPane
    extends AbstractAppointmentPane {
        final DayPane dayPane;
        Calendar start;
        String startAsString;
        Calendar end;
        String endAsString;
        long durationInMS;
        DurationDragger durationDragger;

        public AbstractDayAppointmentPane(Agenda.Appointment appointment, DayPane dayPane) {
            super(appointment);
            this.start = null;
            this.startAsString = null;
            this.end = null;
            this.endAsString = null;
            this.durationInMS = 0L;
            this.durationDragger = null;
            this.dayPane = dayPane;
            this.getStyleClass().add((Object)"Appointment");
            this.getStyleClass().add((Object)appointment.getAppointmentGroup().getStyleClass());
        }
    }

    class DurationDragger
    extends Rectangle {
        final AbstractDayAppointmentPane appointmentPane;
        Rectangle resizeRectangle;

        public DurationDragger(AbstractDayAppointmentPane appointmentPane) {
            this.appointmentPane = appointmentPane;
            this.xProperty().bind((ObservableValue)appointmentPane.widthProperty().multiply(0.25));
            this.yProperty().bind((ObservableValue)appointmentPane.heightProperty().subtract(5));
            this.widthProperty().bind((ObservableValue)appointmentPane.widthProperty().multiply(0.5));
            this.setHeight(3.0);
            this.getStyleClass().add((Object)"DurationDragger");
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        DurationDragger.this.setCursor(Cursor.HAND);
                        mouseEvent.consume();
                    }
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        DurationDragger.this.setCursor(Cursor.DEFAULT);
                        mouseEvent.consume();
                    }
                }
            });
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    DurationDragger.this.setCursor(Cursor.V_RESIZE);
                    DurationDragger.this.resizeRectangle = new Rectangle(DurationDragger.this.appointmentPane.getLayoutX(), DurationDragger.this.appointmentPane.getLayoutY(), DurationDragger.this.appointmentPane.getWidth(), DurationDragger.this.appointmentPane.getHeight());
                    DurationDragger.this.resizeRectangle.getStyleClass().add((Object)"GhostRectangle");
                    DurationDragger.this.appointmentPane.dayPane.getChildren().add((Object)DurationDragger.this.resizeRectangle);
                    mouseEvent.consume();
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    double lNodeScreenY = NodeUtil.screenY((Node)DurationDragger.this.appointmentPane);
                    double lMouseY = mouseEvent.getScreenY();
                    double lHeight = lMouseY - lNodeScreenY;
                    if (lHeight < 5.0) {
                        lHeight = 5.0;
                    }
                    DurationDragger.this.resizeRectangle.setHeight(lHeight);
                    mouseEvent.consume();
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    int ms = (int)(DurationDragger.this.resizeRectangle.getHeight() * AgendaWeekSkin.this.durationInMSPerPixelProperty.get());
                    Calendar lCalendar = (Calendar)DurationDragger.this.appointmentPane.appointment.getStartTime().clone();
                    lCalendar.add(14, ms);
                    AgendaWeekSkin.this.setTimeToNearestMinutes(lCalendar, 5);
                    DurationDragger.this.appointmentPane.appointment.setEndTime(lCalendar);
                    AgendaWeekSkin.this.setupAppointments();
                    DurationDragger.this.setCursor(Cursor.HAND);
                    DurationDragger.this.appointmentPane.dayPane.getChildren().remove((Object)DurationDragger.this.resizeRectangle);
                    DurationDragger.this.resizeRectangle = null;
                    mouseEvent.consume();
                }
            });
        }
    }

    class MenuIcon
    extends Rectangle {
        public MenuIcon(final AbstractAppointmentPane abstractAppointmentPane) {
            this.setX(3.0);
            this.setY(3.0);
            this.setWidth(6.0);
            this.setHeight(3.0);
            this.getStyleClass().add((Object)"MenuIcon");
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        MenuIcon.this.setCursor(Cursor.HAND);
                        mouseEvent.consume();
                    }
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPrimaryButtonDown()) {
                        MenuIcon.this.setCursor(Cursor.DEFAULT);
                        mouseEvent.consume();
                    }
                }
            });
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                }
            });
            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    AgendaWeekSkin.this.showMenu(mouseEvent, abstractAppointmentPane);
                }
            });
        }
    }

    class HistoricalVisualizer
    extends Rectangle {
        public HistoricalVisualizer(Pane pane) {
            this.setMouseTransparent(true);
            this.xProperty().set(0.0);
            this.yProperty().set(0.0);
            this.widthProperty().bind((ObservableValue)pane.prefWidthProperty());
            this.heightProperty().bind((ObservableValue)pane.prefHeightProperty());
            this.setVisible(false);
            this.getStyleClass().add((Object)"History");
        }
    }

    abstract class AbstractClusteredDayAppointmentPane
    extends AbstractDayAppointmentPane {
        List<AbstractClusteredDayAppointmentPane> clusterMembers;
        List<List<AbstractClusteredDayAppointmentPane>> clusterTracks;
        AbstractClusteredDayAppointmentPane clusterOwner;
        int clusterTrackIdx;

        public AbstractClusteredDayAppointmentPane(Agenda.Appointment appointment, DayPane dayPane) {
            super(appointment, dayPane);
            this.clusterMembers = null;
            this.clusterTracks = null;
            this.clusterOwner = null;
            this.clusterTrackIdx = -1;
        }
    }

    class TaskAppointmentPane
    extends AbstractClusteredDayAppointmentPane {
        public TaskAppointmentPane(Agenda.Appointment appointment, DayPane dayPane) {
            super(appointment, dayPane);
            Calendar lDayStartCalendar = AgendaWeekSkin.this.setTimeTo0000((Calendar)((Calendar)dayPane.calendarObjectProperty.get()).clone());
            this.start = appointment.getStartTime().before(lDayStartCalendar) ? lDayStartCalendar : (Calendar)appointment.getStartTime().clone();
            this.durationInMS = 0L;
            this.isFirstAreaOfAppointment = true;
            this.isLastAreaOfAppointment = true;
            this.startAsString = timeFormat.format(this.start.getTime());
            this.endAsString = "";
            this.historicalVisualizer = new HistoricalVisualizer(this);
            this.getChildren().add((Object)this.historicalVisualizer);
            final Text lTimeText = new Text(this.startAsString + " " + appointment.getSummary());
            lTimeText.getStyleClass().add((Object)"AppointmentTimeLabel");
            lTimeText.setX(this.menuIcon.getWidth() + 3.0);
            lTimeText.setY(lTimeText.prefHeight(0.0) / 2.0);
            lTimeText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(3.0));
            lTimeText.fontProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    Rectangle lClip = new Rectangle();
                    lClip.widthProperty().bind((ObservableValue)TaskAppointmentPane.this.widthProperty().subtract(3.0));
                    lClip.heightProperty().set(((Font)lTimeText.fontProperty().getValue()).getSize());
                    lTimeText.setClip((Node)lClip);
                }
            });
            this.getChildren().add((Object)lTimeText);
            if (!appointment.isWholeDay().booleanValue()) {
                this.getChildren().add((Object)this.menuIcon);
            }
        }

        public String toString() {
            return super.toString() + ";" + this.startAsString + ";" + this.appointment.getSummary();
        }
    }

    class RegularAppointmentPane
    extends AbstractClusteredDayAppointmentPane {
        public RegularAppointmentPane(Agenda.Appointment appointment, DayPane dayPane) {
            super(appointment, dayPane);
            Calendar lDayStartCalendar = AgendaWeekSkin.this.setTimeTo0000((Calendar)((Calendar)dayPane.calendarObjectProperty.get()).clone());
            this.start = appointment.getStartTime().before(lDayStartCalendar) ? lDayStartCalendar : (Calendar)appointment.getStartTime().clone();
            Calendar lDayEndCalendar = AgendaWeekSkin.this.setTimeTo2359((Calendar)((Calendar)dayPane.calendarObjectProperty.get()).clone());
            this.end = appointment.getEndTime().after(lDayEndCalendar) ? lDayEndCalendar : (Calendar)appointment.getEndTime().clone();
            this.durationInMS = this.end.getTimeInMillis() - this.start.getTimeInMillis();
            this.isFirstAreaOfAppointment = this.start.equals(appointment.getStartTime());
            this.isLastAreaOfAppointment = this.end.equals(appointment.getEndTime());
            this.startAsString = timeFormat.format(this.start.getTime());
            this.endAsString = timeFormat.format(this.end.getTime());
            if (this.isLastAreaOfAppointment) {
                this.durationDragger = new DurationDragger(this);
                this.getChildren().add((Object)this.durationDragger);
            }
            if (!appointment.isWholeDay().booleanValue()) {
                this.getChildren().add((Object)this.menuIcon);
            }
            this.historicalVisualizer = new HistoricalVisualizer(this);
            this.getChildren().add((Object)this.historicalVisualizer);
            Text lTimeText = new Text(this.startAsString + "-" + this.endAsString);
            lTimeText.getStyleClass().add((Object)"AppointmentTimeLabel");
            lTimeText.setX(3.0);
            lTimeText.setY(lTimeText.prefHeight(0.0));
            Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
            lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract(3.0));
            lClip.heightProperty().bind((ObservableValue)this.heightProperty());
            lTimeText.setClip((Node)lClip);
            this.getChildren().add((Object)lTimeText);
            Text lSummaryText = new Text(appointment.getSummary());
            lSummaryText.getStyleClass().add((Object)"AppointmentLabel");
            lSummaryText.setX(3.0);
            lSummaryText.setY(lTimeText.getY() + AgendaWeekSkin.this.textHeightProperty.get());
            lSummaryText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(3.0));
            Rectangle lClip2 = new Rectangle(0.0, 0.0, 0.0, 0.0);
            lClip2.widthProperty().bind((ObservableValue)this.widthProperty());
            lClip2.heightProperty().bind((ObservableValue)this.heightProperty().subtract(3.0));
            lSummaryText.setClip((Node)lClip2);
            this.getChildren().add((Object)lSummaryText);
        }

        public String toString() {
            return super.toString() + ";" + this.startAsString + "-" + this.endAsString + ";" + this.durationInMS + "ms" + ";" + this.appointment.getSummary();
        }
    }

    class WholedayAppointmentPane
    extends AbstractDayAppointmentPane {
        public WholedayAppointmentPane(Agenda.Appointment appointment, DayPane dayPane) {
            super(appointment, dayPane);
            this.isDraggable = false;
            this.start = AgendaWeekSkin.this.setTimeTo0000((Calendar)appointment.getStartTime().clone());
            this.end = AgendaWeekSkin.this.setTimeTo2359((Calendar)appointment.getStartTime().clone());
            this.durationInMS = this.end.getTimeInMillis() - this.start.getTimeInMillis();
            this.startAsString = timeFormat.format(this.start.getTime());
            this.endAsString = timeFormat.format(this.end.getTime());
            this.historicalVisualizer = new HistoricalVisualizer(this);
            this.getChildren().add((Object)this.historicalVisualizer);
        }

        public String toString() {
            return super.toString() + ";" + this.startAsString + " wholeday" + ";" + this.appointment.getSummary();
        }
    }

    class DayPane
    extends Pane {
        ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar");
        DayHeaderPane dayHeaderPane = null;
        Rectangle resizeRectangle = null;
        boolean dragged = false;
        final List<AbstractClusteredDayAppointmentPane> clusteredAppointmentPanes = new ArrayList<AbstractClusteredDayAppointmentPane>();
        final List<WholedayAppointmentPane> wholedayAppointmentPanes = new ArrayList<WholedayAppointmentPane>();

        public DayPane() {
            this.getStyleClass().add((Object)"Day");
            this.widthProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    DayPane.this.relayout();
                }
            });
            this.heightProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    DayPane.this.relayout();
                }
            });
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (((Agenda)AgendaWeekSkin.this.getSkinnable()).createAppointmentCallbackProperty().get() == null) {
                        return;
                    }
                    DayPane.this.setCursor(Cursor.V_RESIZE);
                    double lY = mouseEvent.getScreenY() - NodeUtil.screenY((Node)DayPane.this);
                    DayPane.this.resizeRectangle = new Rectangle(0.0, lY, AgendaWeekSkin.this.dayWidthProperty.get(), 10.0);
                    DayPane.this.resizeRectangle.getStyleClass().add((Object)"GhostRectangle");
                    DayPane.this.getChildren().add((Object)DayPane.this.resizeRectangle);
                    mouseEvent.consume();
                    DayPane.this.dragged = false;
                    ((Agenda)AgendaWeekSkin.this.getSkinnable()).selectedAppointments().clear();
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (DayPane.this.resizeRectangle == null) {
                        return;
                    }
                    double lHeight = mouseEvent.getScreenY() - NodeUtil.screenY((Node)DayPane.this.resizeRectangle);
                    if (lHeight < 5.0) {
                        lHeight = 5.0;
                    }
                    DayPane.this.resizeRectangle.setHeight(lHeight);
                    mouseEvent.consume();
                    DayPane.this.dragged = true;
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (DayPane.this.resizeRectangle == null) {
                        return;
                    }
                    mouseEvent.consume();
                    DayPane.this.setCursor(Cursor.HAND);
                    DayPane.this.getChildren().remove((Object)DayPane.this.resizeRectangle);
                    if (!DayPane.this.dragged) {
                        return;
                    }
                    Calendar lStartCalendar = AgendaWeekSkin.this.setTimeTo0000((Calendar)((Calendar)DayPane.this.calendarObjectProperty.get()).clone());
                    lStartCalendar.add(14, (int)(DayPane.this.resizeRectangle.getY() * AgendaWeekSkin.this.durationInMSPerPixelProperty.get()));
                    AgendaWeekSkin.this.setTimeToNearestMinutes(lStartCalendar, 5);
                    Calendar lEndCalendar = (Calendar)lStartCalendar.clone();
                    lEndCalendar.add(14, (int)(DayPane.this.resizeRectangle.getHeight() * AgendaWeekSkin.this.durationInMSPerPixelProperty.get()));
                    AgendaWeekSkin.this.setTimeToNearestMinutes(lEndCalendar, 5);
                    DayPane.this.resizeRectangle = null;
                    Agenda.Appointment lAppointment = (Agenda.Appointment)((Callback)((Agenda)AgendaWeekSkin.this.getSkinnable()).createAppointmentCallbackProperty().get()).call((Object)new Agenda.CalendarRange(lStartCalendar, lEndCalendar));
                    if (lAppointment != null) {
                        ((Agenda)AgendaWeekSkin.this.getSkinnable()).appointments().add((Object)lAppointment);
                    }
                }
            });
        }

        public List<AbstractAppointmentPane> allAbstractAppointmentPanes() {
            ArrayList<AbstractAppointmentPane> lPanes = new ArrayList<AbstractAppointmentPane>(this.clusteredAppointmentPanes);
            lPanes.addAll(this.wholedayAppointmentPanes);
            lPanes.addAll(this.dayHeaderPane.appointmentHeaderPanes);
            return lPanes;
        }

        private void relayout() {
            int lWholedayCnt = 0;
            for (WholedayAppointmentPane lAppointmentPane : this.wholedayAppointmentPanes) {
                lAppointmentPane.setLayoutX((double)lWholedayCnt * 5.0);
                lAppointmentPane.setLayoutY(0.0);
                lAppointmentPane.setPrefSize(5.0, AgendaWeekSkin.this.dayHeightProperty.get());
                ++lWholedayCnt;
            }
            double lRemainingWidthForRegularAppointments = AgendaWeekSkin.this.dayContentWidthProperty.get() - (double)lWholedayCnt * 5.0;
            for (AbstractClusteredDayAppointmentPane lClusteredDayAppointmentPanePane : this.clusteredAppointmentPanes) {
                lClusteredDayAppointmentPanePane.setLayoutX((double)lWholedayCnt * 5.0 + lRemainingWidthForRegularAppointments / (double)lClusteredDayAppointmentPanePane.clusterOwner.clusterTracks.size() * (double)lClusteredDayAppointmentPanePane.clusterTrackIdx);
                int lTimeFactor = lClusteredDayAppointmentPanePane.start.get(11) * 60 + lClusteredDayAppointmentPanePane.start.get(12);
                lClusteredDayAppointmentPanePane.setLayoutY(AgendaWeekSkin.this.dayHeightProperty.get() / 1440.0 * (double)lTimeFactor);
                double lW = (AgendaWeekSkin.this.dayContentWidthProperty.get() - (double)this.wholedayAppointmentPanes.size() * 5.0) * (1.0 / (double)lClusteredDayAppointmentPanePane.clusterOwner.clusterTracks.size());
                if (lClusteredDayAppointmentPanePane.clusterTrackIdx < lClusteredDayAppointmentPanePane.clusterOwner.clusterTracks.size() - 1) {
                    lW *= 1.75;
                }
                lClusteredDayAppointmentPanePane.setPrefWidth(lW);
                double lH = AgendaWeekSkin.this.dayHeightProperty.get() / 1440.0 * (double)(lClusteredDayAppointmentPanePane.durationInMS / 1000L / 60L);
                if (lH < 6.0) {
                    lH = 6.0;
                }
                lClusteredDayAppointmentPanePane.setPrefHeight(lH);
            }
        }

        public void setupAppointments() {
            ArrayList<AbstractClusteredDayAppointmentPane> lOldClusteredDayAppointmentPanes = new ArrayList<AbstractClusteredDayAppointmentPane>(this.clusteredAppointmentPanes);
            ArrayList<WholedayAppointmentPane> lOldWholedayAppointmentPanes = new ArrayList<WholedayAppointmentPane>(this.wholedayAppointmentPanes);
            this.clusteredAppointmentPanes.clear();
            this.wholedayAppointmentPanes.clear();
            if (this.calendarObjectProperty.get() == null) {
                return;
            }
            for (Agenda.Appointment lAppointment : ((Agenda)AgendaWeekSkin.this.getSkinnable()).appointments()) {
                AbstractDayAppointmentPane lAppointmentPane;
                if (lAppointment.isWholeDay().booleanValue()) {
                    if (!AgendaWeekSkin.this.isSameDay((Calendar)this.calendarObjectProperty.get(), lAppointment.getStartTime())) continue;
                    lAppointmentPane = new WholedayAppointmentPane(lAppointment, this);
                    this.wholedayAppointmentPanes.add((WholedayAppointmentPane)lAppointmentPane);
                    continue;
                }
                if (lAppointment.getEndTime() == null) {
                    if (!AgendaWeekSkin.this.isSameDay((Calendar)this.calendarObjectProperty.get(), lAppointment.getStartTime())) continue;
                    lAppointmentPane = new TaskAppointmentPane(lAppointment, this);
                    this.clusteredAppointmentPanes.add((AbstractClusteredDayAppointmentPane)lAppointmentPane);
                    continue;
                }
                lAppointmentPane = new RegularAppointmentPane(lAppointment, this);
                if (!AgendaWeekSkin.this.isSameDay((Calendar)this.calendarObjectProperty.get(), lAppointmentPane.start) || !AgendaWeekSkin.this.isSameDay((Calendar)this.calendarObjectProperty.get(), lAppointmentPane.end)) continue;
                this.clusteredAppointmentPanes.add((AbstractClusteredDayAppointmentPane)lAppointmentPane);
            }
            Collections.sort(this.clusteredAppointmentPanes, new Comparator<AbstractDayAppointmentPane>(){

                @Override
                public int compare(AbstractDayAppointmentPane o1, AbstractDayAppointmentPane o2) {
                    if (!o1.startAsString.equals(o2.startAsString)) {
                        return o1.startAsString.compareTo(o2.startAsString);
                    }
                    return o1.durationInMS > o2.durationInMS ? -1 : 1;
                }
            });
            AbstractClusteredDayAppointmentPane lClusterOwner = null;
            for (AbstractDayAppointmentPane lAppointmentPane : this.clusteredAppointmentPanes) {
                int lTrackNr;
                if (lClusterOwner == null) {
                    lClusterOwner = lAppointmentPane;
                    lClusterOwner.clusterTracks = new ArrayList<List<AbstractClusteredDayAppointmentPane>>();
                }
                if ((lTrackNr = AgendaWeekSkin.this.determineTrackWhereAppointmentCanBeAdded(lClusterOwner.clusterTracks, lAppointmentPane)) == 0) {
                    boolean lOverlaps = false;
                    for (int i = 1; i < lClusterOwner.clusterTracks.size() && !lOverlaps; ++i) {
                        lOverlaps = AgendaWeekSkin.this.checkIfTheAppointmentOverlapsAnAppointmentAlreadyInThisTrack(lClusterOwner.clusterTracks, i, lAppointmentPane);
                    }
                    if (!lOverlaps) {
                        lClusterOwner = lAppointmentPane;
                        lClusterOwner.clusterMembers = new ArrayList<AbstractClusteredDayAppointmentPane>();
                        lClusterOwner.clusterTracks = new ArrayList<List<AbstractClusteredDayAppointmentPane>>();
                        lClusterOwner.clusterTracks.add(new ArrayList());
                    }
                }
                lClusterOwner.clusterMembers.add((AbstractClusteredDayAppointmentPane)lAppointmentPane);
                lClusterOwner.clusterTracks.get(lTrackNr).add((AbstractClusteredDayAppointmentPane)lAppointmentPane);
                lAppointmentPane.clusterOwner = lClusterOwner;
                lAppointmentPane.clusterTrackIdx = lTrackNr;
            }
            this.relayout();
            this.getChildren().removeAll(lOldClusteredDayAppointmentPanes);
            this.getChildren().removeAll(lOldWholedayAppointmentPanes);
            this.getChildren().addAll(this.wholedayAppointmentPanes);
            this.getChildren().addAll(this.clusteredAppointmentPanes);
            this.dayHeaderPane.setupAppointments();
        }
    }

    class WeekPane
    extends Pane {
        final List<DayPane> dayPanes = new ArrayList<DayPane>();

        public WeekPane() {
            this.getStyleClass().add((Object)"Week");
            for (int lHour = 0; lHour < 24; ++lHour) {
                Line l = new Line(0.0, 10.0, 100.0, 10.0);
                l.getStyleClass().add((Object)"HourLine");
                l.startXProperty().set(0.0);
                l.startYProperty().bind((ObservableValue)AgendaWeekSkin.this.hourHeighProperty.multiply(lHour));
                l.endXProperty().bind((ObservableValue)this.widthProperty());
                l.endYProperty().bind((ObservableValue)l.startYProperty());
                this.getChildren().add((Object)l);
                l = new Line(0.0, 10.0, 100.0, 10.0);
                l.getStyleClass().add((Object)"HalfHourLine");
                l.startXProperty().bind((ObservableValue)AgendaWeekSkin.this.timeWidthProperty);
                l.endXProperty().bind((ObservableValue)this.widthProperty());
                l.startYProperty().bind((ObservableValue)AgendaWeekSkin.this.hourHeighProperty.multiply((double)lHour + 0.5));
                l.endYProperty().bind((ObservableValue)l.startYProperty());
                this.getChildren().add((Object)l);
                Text t = new Text(lHour + ":00");
                t.xProperty().bind((ObservableValue)AgendaWeekSkin.this.timeWidthProperty.subtract(t.getBoundsInParent().getWidth()).subtract(5.0));
                t.yProperty().bind((ObservableValue)AgendaWeekSkin.this.hourHeighProperty.multiply(lHour));
                t.setTranslateY(t.getBoundsInParent().getHeight());
                t.getStyleClass().add((Object)"HourLabel");
                t.setFontSmoothingType(FontSmoothingType.LCD);
                this.getChildren().add((Object)t);
            }
            for (int i = 0; i < 7; ++i) {
                DayPane lDay = new DayPane();
                lDay.layoutXProperty().bind((ObservableValue)AgendaWeekSkin.this.dayWidthProperty.multiply(i).add((ObservableNumberValue)AgendaWeekSkin.this.dayFirstColumnXProperty));
                lDay.layoutYProperty().set(0.0);
                lDay.prefWidthProperty().bind((ObservableValue)AgendaWeekSkin.this.dayWidthProperty);
                lDay.prefHeightProperty().bind((ObservableValue)AgendaWeekSkin.this.dayHeightProperty);
                this.getChildren().add((Object)lDay);
                this.dayPanes.add(lDay);
            }
        }
    }

    class AppointmentHeaderPane
    extends AbstractAppointmentPane {
        public AppointmentHeaderPane(Agenda.Appointment appointment) {
            super(appointment);
            this.getStyleClass().add((Object)"Appointment");
            this.getStyleClass().add((Object)appointment.getAppointmentGroup().getStyleClass());
            this.historicalVisualizer = new HistoricalVisualizer(this);
            this.getChildren().add((Object)this.historicalVisualizer);
            Text lSummaryText = new Text(appointment.getSummary());
            lSummaryText.getStyleClass().add((Object)"AppointmentLabel");
            lSummaryText.setX(3.0);
            lSummaryText.setY(AgendaWeekSkin.this.textHeightProperty.get());
            Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
            lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract(3.0));
            lClip.heightProperty().bind((ObservableValue)this.heightProperty());
            lSummaryText.setClip((Node)lClip);
            this.getChildren().add((Object)lSummaryText);
            this.getChildren().add((Object)this.menuIcon);
        }
    }

    class DayHeaderPane
    extends Pane {
        DayPane dayPane = null;
        Text calendarText = null;
        final List<AppointmentHeaderPane> appointmentHeaderPanes = new ArrayList<AppointmentHeaderPane>();

        public DayHeaderPane(DayPane dayPane) {
            this.getStyleClass().add((Object)"DayHeader");
            this.dayPane = dayPane;
            dayPane.dayHeaderPane = this;
            this.calendarText = new Text("?");
            this.calendarText.getStyleClass().add((Object)"Calendar");
            this.calendarText.setX(3.0);
            this.calendarText.setY(this.calendarText.prefHeight(0.0));
            Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
            lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract(3.0));
            lClip.heightProperty().bind((ObservableValue)this.heightProperty());
            this.calendarText.setClip((Node)lClip);
            this.getChildren().add((Object)this.calendarText);
            dayPane.calendarObjectProperty.addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    String lLabel = DayHeaderPane.this.dayPane.calendarObjectProperty.get() == null ? "" : AgendaWeekSkin.this.dayOfWeekDateFormat.format(((Calendar)DayHeaderPane.this.dayPane.calendarObjectProperty.get()).getTime()) + " " + AgendaWeekSkin.this.dateFormat.format(((Calendar)DayHeaderPane.this.dayPane.calendarObjectProperty.get()).getTime());
                    DayHeaderPane.this.calendarText.setText(lLabel);
                }
            });
            this.widthProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    DayHeaderPane.this.relayout();
                }
            });
            this.heightProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    DayHeaderPane.this.relayout();
                }
            });
            this.relayout();
        }

        public void relayout() {
            int lOffset = AgendaWeekSkin.this.highestNumberOfWholedayAppointmentsProperty.get() - this.appointmentHeaderPanes.size();
            for (AppointmentHeaderPane lAppointmentHeaderPane : this.appointmentHeaderPanes) {
                int lIdx = this.appointmentHeaderPanes.indexOf((Object)lAppointmentHeaderPane);
                lAppointmentHeaderPane.setLayoutX((double)lIdx * 5.0);
                lAppointmentHeaderPane.setLayoutY(AgendaWeekSkin.this.titleCalendarHeightProperty.get() + (double)(lIdx + lOffset) * AgendaWeekSkin.this.wholedayTitleHeightProperty.get());
                lAppointmentHeaderPane.setPrefSize(AgendaWeekSkin.this.dayWidthProperty.get() - (double)lIdx * 5.0, (double)(this.appointmentHeaderPanes.size() - lIdx) * AgendaWeekSkin.this.wholedayTitleHeightProperty.get());
            }
        }

        public void setupAppointments() {
            this.getChildren().removeAll(this.appointmentHeaderPanes);
            this.appointmentHeaderPanes.clear();
            for (WholedayAppointmentPane lAppointmentPane : this.dayPane.wholedayAppointmentPanes) {
                AppointmentHeaderPane lAppointmentHeaderPane = new AppointmentHeaderPane(lAppointmentPane.appointment);
                this.getChildren().add((Object)lAppointmentHeaderPane);
                this.appointmentHeaderPanes.add(lAppointmentHeaderPane);
            }
            this.relayout();
        }
    }

    class WeekHeaderPane
    extends Pane {
        final List<DayHeaderPane> dayHeaderPanes = new ArrayList<DayHeaderPane>();

        public WeekHeaderPane() {
            for (int i = 0; i < 7; ++i) {
                DayHeaderPane lDayHeader = new DayHeaderPane(((AgendaWeekSkin)AgendaWeekSkin.this).weekPane.dayPanes.get(i));
                lDayHeader.layoutXProperty().bind((ObservableValue)((AgendaWeekSkin)AgendaWeekSkin.this).weekPane.dayPanes.get(i).layoutXProperty());
                lDayHeader.layoutYProperty().set(0.0);
                lDayHeader.prefWidthProperty().bind((ObservableValue)((AgendaWeekSkin)AgendaWeekSkin.this).weekPane.dayPanes.get(i).prefWidthProperty());
                lDayHeader.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                this.getChildren().add((Object)lDayHeader);
                this.dayHeaderPanes.add(lDayHeader);
            }
        }
    }
}

