/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import jfxtras.labs.internal.scene.control.skin.CalendarPickerMonthlySkinAbstract;
import jfxtras.labs.scene.control.CalendarPicker;
import jfxtras.labs.scene.control.CalendarTimePicker;
import jfxtras.labs.scene.control.ListSpinner;
import jfxtras.labs.scene.control.ListSpinnerIntegerList;

public class CalendarPickerControlSkin
extends CalendarPickerMonthlySkinAbstract<CalendarPickerControlSkin> {
    private ListSpinner<String> monthListSpinner = null;
    private ListSpinner<Integer> yearListSpinner = null;
    private final List<Label> weekdayLabels = new ArrayList<Label>();
    private final List<Label> weeknumberLabels = new ArrayList<Label>();
    private final List<ToggleButton> dayButtons = new ArrayList<ToggleButton>();
    private final CalendarTimePicker timePicker = new CalendarTimePicker();
    private final Map<BooleanProperty, ToggleButton> booleanPropertyToDayToggleButtonMap = new WeakHashMap<BooleanProperty, ToggleButton>();
    private final ChangeListener<Boolean> toggleButtonSelectedPropertyChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
            CalendarPickerControlSkin.this.refreshDayButtonToggleState();
        }
    };
    private final EventHandler<MouseEvent> toggleButtonMouseReleasedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
        }
    };
    private final EventHandler<KeyEvent> toggleButtonKeyReleasedPropertyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            if (" ".equals(event.getText())) {
                CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
            }
        }
    };
    private final EventHandler<MouseEvent> weekdayLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                return;
            }
            int lColIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int lRowIdx = 0; lRowIdx < 6; ++lRowIdx) {
                int lIdx = lRowIdx * 7 + lColIdx;
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(lIdx);
                if (!lToggleButton.isVisible()) continue;
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private final EventHandler<MouseEvent> weeknumerLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().clear();
            }
            int lRowIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int i = lRowIdx * 7; i < lRowIdx * 7 + 7; ++i) {
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(i);
                if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                    ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().add((Object)CalendarPickerControlSkin.this.calendarForToggleButton(lToggleButton));
                    continue;
                }
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private Calendar iLastSelected = null;
    private final AtomicInteger iRefreshingSelection = new AtomicInteger(0);

    public CalendarPickerControlSkin(CalendarPicker control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarPicker)this.getSkinnable()).calendarProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getCalendar() != null) {
                    CalendarPickerControlSkin.this.setDisplayedCalendar(((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getCalendar());
                }
            }
        });
        if (((CalendarPicker)this.getSkinnable()).getCalendar() != null) {
            this.setDisplayedCalendar(((CalendarPicker)this.getSkinnable()).getCalendar());
        }
        ((CalendarPicker)this.getSkinnable()).calendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> arg0) {
                CalendarPickerControlSkin.this.refreshDayButtonToggleState();
            }
        });
        this.displayedCalendar().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                CalendarPickerControlSkin.this.refresh();
            }
        });
        this.refresh();
    }

    private void createNodes() {
        Label lLabel;
        int i;
        GridPane lGridPane = new GridPane();
        lGridPane.setVgap(2.0);
        lGridPane.setHgap(2.0);
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        lGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsNeverGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow});
        List<String> lMonthLabels = this.getMonthLabels();
        this.monthListSpinner = new ListSpinner<String>(lMonthLabels).withIndex(Calendar.getInstance().get(2)).withCyclic(Boolean.TRUE);
        this.monthListSpinner.setOnCycle(new EventHandler<ListSpinner.CycleEvent>(){

            public void handle(ListSpinner.CycleEvent evt) {
                if (evt.cycledDown()) {
                    CalendarPickerControlSkin.this.yearListSpinner.increment();
                } else {
                    CalendarPickerControlSkin.this.yearListSpinner.decrement();
                }
            }
        });
        this.monthListSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue arg0, String arg1, String arg2) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        lGridPane.add(this.monthListSpinner, 1, 0, 4, 1);
        this.yearListSpinner = new ListSpinner<Integer>(new ListSpinnerIntegerList()).withValue(Calendar.getInstance().get(1));
        this.yearListSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue observableValue, Integer oldValue, Integer newValue) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        lGridPane.add(this.yearListSpinner, 5, 0, 3, 1);
        Label lTodayLabel = new Label("   ");
        lTodayLabel.onMouseClickedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() < 1) {
                    return;
                }
                CalendarPickerControlSkin.this.setDisplayedCalendarToToday();
            }
        });
        lGridPane.add((Node)lTodayLabel, 0, 1);
        for (i = 0; i < 7; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weekday-label");
            lLabel.setMaxWidth(2.147483647E9);
            lGridPane.add((Node)lLabel, i + 1, 1);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weekdayLabelMouseClickedPropertyEventHandler);
            this.weekdayLabels.add(lLabel);
        }
        for (i = 0; i < 6; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weeknumber");
            lLabel.setAlignment(Pos.BASELINE_RIGHT);
            this.weeknumberLabels.add(lLabel);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weeknumerLabelMouseClickedPropertyEventHandler);
            lGridPane.add((Node)this.weeknumberLabels.get(i), 0, i + 2);
        }
        for (i = 0; i < 42; ++i) {
            ToggleButton lToggleButton = new ToggleButton("" + i);
            lToggleButton.getStyleClass().add((Object)"day-button");
            lToggleButton.selectedProperty().addListener(this.toggleButtonSelectedPropertyChangeListener);
            lToggleButton.onMouseReleasedProperty().set(this.toggleButtonMouseReleasedPropertyEventHandler);
            lToggleButton.onKeyReleasedProperty().set(this.toggleButtonKeyReleasedPropertyEventHandler);
            this.booleanPropertyToDayToggleButtonMap.put(lToggleButton.selectedProperty(), lToggleButton);
            lGridPane.add((Node)lToggleButton, i % 7 + 1, i / 7 + 2);
            lToggleButton.setMaxWidth(Double.MAX_VALUE);
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            this.dayButtons.add(lToggleButton);
        }
        if (((CalendarPicker)this.getSkinnable()).getMode().equals((Object)CalendarPicker.Mode.SINGLE) && ((Boolean)((CalendarPicker)this.getSkinnable()).showTimeProperty().get()).booleanValue()) {
            lGridPane.add((Node)this.timePicker, 1, 8, 7, 1);
            Bindings.bindBidirectional(this.timePicker.calendarProperty(), ((CalendarPicker)this.getSkinnable()).calendarProperty());
        }
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)lGridPane);
    }

    private Calendar calendarForToggleButton(ToggleButton toggleButton) {
        int lDayToggleButtonIdx = this.dayButtons.indexOf(toggleButton);
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        int lDayOfMonth = lDayToggleButtonIdx - lFirstOfMonthIdx + 1;
        Calendar lToggledCalendar = (Calendar)this.getDisplayedCalendar().clone();
        lToggledCalendar.set(1, this.getDisplayedCalendar().get(1));
        lToggledCalendar.set(2, this.getDisplayedCalendar().get(2));
        lToggledCalendar.set(5, lDayOfMonth);
        if (this.timePicker.isVisible() && this.timePicker.getCalendar() != null) {
            lToggledCalendar.set(11, this.timePicker.getCalendar().get(11));
            lToggledCalendar.set(12, this.timePicker.getCalendar().get(12));
        }
        return lToggledCalendar;
    }

    private void toggle(ToggleButton toggleButton, boolean shiftIsPressed) {
        Calendar lToggledCalendar = this.calendarForToggleButton(toggleButton);
        ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
        Calendar lFoundCalendar = this.find((List<Calendar>)lCalendars, lToggledCalendar);
        if (lFoundCalendar == null) {
            lCalendars.add(lToggledCalendar);
            while (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE && lCalendars.size() > 1) {
                lCalendars.remove(0);
            }
            while (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE && lCalendars.size() > 1) {
                lCalendars.remove(0);
            }
            while (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE && !shiftIsPressed && lCalendars.size() > 1) {
                lCalendars.remove(0);
            }
            if ((((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.MULTIPLE || ((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) && shiftIsPressed && this.iLastSelected != null) {
                Calendar lOtherCalendar = this.iLastSelected;
                if (lOtherCalendar.after(lToggledCalendar)) {
                    Calendar lSwap = lOtherCalendar;
                    lOtherCalendar = lToggledCalendar;
                    lToggledCalendar = lSwap;
                }
                Calendar lWalker = (Calendar)lOtherCalendar.clone();
                lWalker.add(5, 1);
                while (lWalker.before(lToggledCalendar)) {
                    lCalendars.add((Calendar)lWalker.clone());
                    lWalker.add(5, 1);
                }
                Collections.sort(lCalendars);
            }
            this.iLastSelected = (Calendar)lToggledCalendar.clone();
        } else {
            lCalendars.remove(lFoundCalendar);
            this.iLastSelected = null;
        }
        this.refreshDayButtonToggleState();
    }

    private void setDisplayedCalendarFromSpinners() {
        int lYear = this.yearListSpinner.getValue();
        int lMonth = this.monthListSpinner.getIndex();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        lCalendar.set(1, lYear);
        lCalendar.set(2, lMonth);
        this.setDisplayedCalendar(lCalendar);
    }

    private void setDisplayedCalendarToToday() {
        Calendar lTodayCalendar = Calendar.getInstance();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        lCalendar.set(1, lTodayCalendar.get(1));
        lCalendar.set(2, lTodayCalendar.get(2));
        this.setDisplayedCalendar(lCalendar);
    }

    private void refresh() {
        this.refreshSpinner();
        this.refreshWeekdayLabels();
        this.refreshWeeknumberLabels();
        this.refreshDayButtonsVisibilityAndLabel();
        this.refreshDayButtonToggleState();
    }

    private void refreshSpinner() {
        Calendar lCalendar = this.getDisplayedCalendar();
        List<String> lMonthLabels = this.getMonthLabels();
        String lMonthLabel = lMonthLabels.get(lCalendar.get(2));
        this.monthListSpinner.setValue(lMonthLabel);
        this.yearListSpinner.setValue(lCalendar.get(1));
    }

    private void refreshWeekdayLabels() {
        List<String> lWeekdayLabels = this.getWeekdayLabels();
        for (int i = 0; i < this.weekdayLabels.size(); ++i) {
            Label lLabel = this.weekdayLabels.get(i);
            lLabel.setText(lWeekdayLabels.get(i));
            lLabel.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lLabel.getStyleClass().add((Object)(this.isWeekdayWeekend(i) ? "weekend" : "weekday"));
        }
    }

    private void refreshWeeknumberLabels() {
        List<Integer> lWeeknumbers = this.getWeeknumbers();
        for (int i = 0; i < lWeeknumbers.size(); ++i) {
            this.weeknumberLabels.get(i).setText((lWeeknumbers.get(i) < 10 ? "0" : "") + lWeeknumbers.get(i).toString());
        }
    }

    private void refreshDayButtonsVisibilityAndLabel() {
        int i;
        int i2;
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        for (i2 = 0; i2 < lFirstOfMonthIdx; ++i2) {
            this.dayButtons.get(i2).setVisible(false);
        }
        for (i2 = 1; i2 < 6; ++i2) {
            this.weeknumberLabels.get(i2).setVisible(false);
        }
        int lDaysInMonth = this.determineDaysInMonth();
        Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
        for (i = 1; i <= lDaysInMonth; ++i) {
            lCalendar.set(5, i);
            int lIdx = lFirstOfMonthIdx + i - 1;
            ToggleButton lToggleButton = this.dayButtons.get(lIdx);
            lToggleButton.setVisible(true);
            lToggleButton.setText("" + i);
            lToggleButton.getStyleClass().remove((Object)"weekend");
            lToggleButton.getStyleClass().remove((Object)"weekday");
            lToggleButton.getStyleClass().add((Object)(this.isWeekdayWeekend(lIdx % 7) ? "weekend" : "weekday"));
            this.weeknumberLabels.get(lIdx / 7).setVisible(true);
            if (this.isToday(lCalendar)) {
                lToggleButton.getStyleClass().add((Object)"today");
                continue;
            }
            lToggleButton.getStyleClass().remove((Object)"today");
        }
        for (i = lFirstOfMonthIdx + lDaysInMonth; i < 42; ++i) {
            this.dayButtons.get(i).setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDayButtonToggleState() {
        this.iRefreshingSelection.addAndGet(1);
        try {
            int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
            ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
            int lDaysInMonth = this.determineDaysInMonth();
            Calendar lCalendar = (Calendar)this.getDisplayedCalendar().clone();
            for (int i = 1; i <= lDaysInMonth; ++i) {
                lCalendar.set(5, i);
                int lIdx = lFirstOfMonthIdx + i - 1;
                boolean lSelected = this.find((List<Calendar>)lCalendars, lCalendar) != null;
                this.dayButtons.get(lIdx).setSelected(lSelected);
            }
        }
        finally {
            this.iRefreshingSelection.addAndGet(-1);
        }
    }

    private Calendar find(List<Calendar> calendars, Calendar calendar) {
        for (Calendar c : calendars) {
            if (c.get(1) != calendar.get(1) || c.get(2) != calendar.get(2) || c.get(5) != calendar.get(5)) continue;
            return c;
        }
        return null;
    }
}

