/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Calendar;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.labs.internal.scene.control.behavior.CalendarTimePickerBehavior;
import jfxtras.labs.scene.control.CalendarTimePicker;

public class CalendarTimePickerSkin
extends SkinBase<CalendarTimePicker, CalendarTimePickerBehavior> {
    private final Slider hourScrollSlider = new Slider();
    private final Slider minuteScrollSlider = new Slider();
    private final Text timeText = new Text("XX:XX");
    final Pane hourLabelsPane = new Pane(){
        {
            this.prefWidthProperty().bind((ObservableValue)CalendarTimePickerSkin.this.hourScrollSlider.prefWidthProperty());
            this.layoutChildren();
        }

        protected void layoutChildren() {
            double lX;
            Text lText;
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            Text lText2 = new Text("0");
            Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText2.prefHeight(0.0));
            lRectangle.setFill((Paint)Color.TRANSPARENT);
            this.getChildren().add((Object)lRectangle);
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 24;
            if (lNumberOfLabels >= 24) {
                lStep = 1;
            } else if (lNumberOfLabels >= 12) {
                lStep = 2;
            } else if (lNumberOfLabels >= 8) {
                lStep = 3;
            } else if (lNumberOfLabels >= 6) {
                lStep = 4;
            } else if (lNumberOfLabels > 4) {
                lStep = 6;
            } else if (lNumberOfLabels > 2) {
                lStep = 12;
            }
            for (i = 0; i < 24; i += lStep) {
                lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 23 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i < 24; ++i) {
                lText = new Text("0");
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, lText.prefHeight(0.0) + 3.0, lX, lText.prefHeight(0.0) + 3.0 + 3.0));
            }
        }
    };
    final Pane minuteLabelsPane = new Pane(){
        {
            this.layoutChildren();
        }

        protected void layoutChildren() {
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            if (((Boolean)((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).showLabelsProperty().get()).booleanValue()) {
                Text lText = new Text("0");
                Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText.prefHeight(0.0));
                lRectangle.setFill((Paint)Color.TRANSPARENT);
                this.getChildren().add((Object)lRectangle);
            }
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 60;
            if (lNumberOfLabels >= 60) {
                lStep = 1;
            } else if (lNumberOfLabels >= 30) {
                lStep = 2;
            } else if (lNumberOfLabels >= 20) {
                lStep = 3;
            } else if (lNumberOfLabels >= 15) {
                lStep = 4;
            } else if (lNumberOfLabels >= 12) {
                lStep = 5;
            } else if (lNumberOfLabels >= 6) {
                lStep = 10;
            } else if (lNumberOfLabels >= 4) {
                lStep = 15;
            } else if (lNumberOfLabels >= 2) {
                lStep = 30;
            }
            if (lStep < ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep()) {
                lStep = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
            }
            for (i = 0; i <= 59; i += lStep) {
                Text lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 59 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i <= 59; ++i) {
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, 0.0, lX, 3.0));
            }
        }
    };

    public CalendarTimePickerSkin(CalendarTimePicker control) {
        super((Control)control, (BehaviorBase)new CalendarTimePickerBehavior(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTimePicker)this.getSkinnable()).calendarProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                CalendarTimePickerSkin.this.refresh();
            }
        });
        this.refresh();
        ((CalendarTimePicker)this.getSkinnable()).minuteStepProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                CalendarTimePickerSkin.this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep().doubleValue());
            }
        });
        this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).showLabelsProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                CalendarTimePickerSkin.this.refreshLayout();
            }
        });
    }

    private void createNodes() {
        this.hourScrollSlider.minProperty().set(0.0);
        this.hourScrollSlider.maxProperty().set(23.0);
        this.hourScrollSlider.setMajorTickUnit(12.0);
        this.hourScrollSlider.setMinorTickCount(3);
        this.minuteScrollSlider.minProperty().set(0.0);
        this.minuteScrollSlider.maxProperty().set(59.0);
        this.minuteScrollSlider.setMajorTickUnit(10.0);
        this.hourScrollSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Calendar lCalendar = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getCalendar();
                lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
                lCalendar.set(11, newValue.intValue());
                ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).setCalendar(lCalendar);
            }
        });
        this.minuteScrollSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Calendar lCalendar = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getCalendar();
                lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
                int lMinutes = newValue.intValue();
                int lMinuteStep = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
                if (lMinuteStep > 1 && (lMinutes += ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep() / 2) > 59) {
                    lMinutes -= lMinuteStep;
                }
                lCalendar.set(12, lMinutes);
                lCalendar = CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep());
                ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).setCalendar(lCalendar);
            }
        });
        this.timeText.setDisable(true);
        this.timeText.getStyleClass().add((Object)"timeLabel");
        this.refreshLayout();
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void refreshLayout() {
        this.getChildren().clear();
        VBox lVBox = new VBox(0.0);
        lVBox.alignmentProperty().set((Object)Pos.CENTER);
        if (((CalendarTimePicker)this.getSkinnable()).getShowLabels().booleanValue()) {
            lVBox.getChildren().add((Object)this.hourLabelsPane);
        }
        lVBox.getChildren().add((Object)this.hourScrollSlider);
        lVBox.getChildren().add((Object)this.minuteScrollSlider);
        if (((CalendarTimePicker)this.getSkinnable()).getShowLabels().booleanValue()) {
            lVBox.getChildren().add((Object)this.minuteLabelsPane);
        }
        this.getChildren().add((Object)lVBox);
        this.getChildren().add((Object)this.timeText);
    }

    private void refresh() {
        Calendar lCalendar = ((CalendarTimePicker)this.getSkinnable()).getCalendar();
        int lHour = lCalendar == null ? 0 : lCalendar.get(11);
        int lMinute = lCalendar == null ? 0 : lCalendar.get(12);
        this.hourScrollSlider.valueProperty().set((double)lHour);
        this.minuteScrollSlider.valueProperty().set((double)lMinute);
        this.timeText.setText(CalendarTimePickerSkin.calendarTimeToText(lCalendar));
    }

    public static String calendarTimeToText(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        int lHour = calendar.get(11);
        int lMinute = calendar.get(12);
        String lText = (lHour < 10 ? "0" : "") + lHour + ":" + (lMinute < 10 ? "0" : "") + lMinute;
        return lText;
    }

    public static Calendar blockMinutesToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lMinutes = calendar.get(12);
        if (stepSize == 1) {
            return calendar;
        }
        lMinutes /= stepSize.intValue();
        if (calendar.get(12) != (lMinutes *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(12, lMinutes);
            calendar = lCalendar;
        }
        return calendar;
    }
}

