/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.ClockBehavior;
import jfxtras.labs.scene.control.gauge.Clock;

public class ClockSkin
extends SkinBase<Clock, ClockBehavior> {
    private static final long INTERVAL = 50000000L;
    private static final Calendar CAL = Calendar.getInstance();
    private Clock control;
    private int dst;
    private Group hourPointer;
    private Group hourPointerShadow;
    private Group minutePointer;
    private Group minutePointerShadow;
    private Group secondPointer;
    private Group secondPointerShadow;
    private Group clock;
    private DoubleProperty hourAngle;
    private DoubleProperty minuteAngle;
    private DoubleProperty secondAngle;
    private int hourOffset;
    private int minuteOffset;
    private int lastHour;
    private DoubleProperty minute;
    private long lastTimerCall;
    private boolean isDay;
    private Timeline timeline;
    private AnimationTimer timer;
    private boolean isDirty;
    private boolean initialized;

    public ClockSkin(Clock CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new ClockBehavior(CONTROL));
        this.control = CONTROL;
        CAL.setTimeZone(TimeZone.getTimeZone(this.control.getTimeZone()));
        this.dst = this.control.isDaylightSavingTime() ? 1 : 0;
        this.hourPointer = new Group();
        this.hourPointerShadow = new Group(new Node[]{this.hourPointer});
        this.minutePointer = new Group();
        this.minutePointerShadow = new Group(new Node[]{this.minutePointer});
        this.secondPointer = new Group();
        this.secondPointerShadow = new Group(new Node[]{this.secondPointer});
        this.clock = new Group();
        this.hourAngle = new SimpleDoubleProperty((double)(30 * Calendar.getInstance().get(10) + this.dst));
        this.minuteAngle = new SimpleDoubleProperty((double)(6 * Calendar.getInstance().get(12)));
        this.secondAngle = new SimpleDoubleProperty((double)(6 * Calendar.getInstance().get(13)));
        this.hourOffset = CAL.get(11) - Calendar.getInstance().get(11);
        this.minuteOffset = CAL.get(12) - Calendar.getInstance().get(12);
        this.lastHour = CAL.get(11);
        this.minute = new SimpleDoubleProperty(0.0);
        this.lastTimerCall = 0L;
        this.isDay = true;
        this.timeline = new Timeline();
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime >= ClockSkin.this.lastTimerCall + 50000000L) {
                    CAL.setTimeZone(TimeZone.getTimeZone(ClockSkin.this.control.getTimeZone()));
                    if (CAL.get(11) < ClockSkin.this.lastHour) {
                        ClockSkin.this.checkForNight();
                        ClockSkin.this.repaint();
                    }
                    ClockSkin.this.secondAngle.set((double)(Calendar.getInstance().get(13) * 6) + (double)Calendar.getInstance().get(14) * 0.006);
                    ClockSkin.this.minute.set((double)((ClockSkin.this.minuteOffset + Calendar.getInstance().get(12)) * 6));
                    ClockSkin.this.hourAngle.set((double)((ClockSkin.this.hourOffset + Calendar.getInstance().get(10)) * 30) + 0.5 * (double)Calendar.getInstance().get(12));
                    ClockSkin.this.lastTimerCall = currentNanoTime;
                    ClockSkin.this.lastHour = CAL.get(11);
                    ClockSkin.this.control.setHour(CAL.get(11));
                    ClockSkin.this.control.setMinute(CAL.get(12));
                    ClockSkin.this.control.setSecond(CAL.get(13));
                }
            }
        };
        this.minute.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                ClockSkin.this.moveMinutePointer(newValue.doubleValue());
            }
        });
        this.isDirty = false;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(200.0, 200.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        if (this.control.getBrightBackgroundPaint() == null) {
            this.control.setBrightBackgroundPaint((Paint)new RadialGradient(0.0, 0.0, this.getPrefWidth() / 2.0, this.getPrefHeight() / 2.0, this.getPrefWidth() / 2.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)191, (int)207, (int)197)), new Stop(0.7, Color.rgb((int)226, (int)239, (int)229)), new Stop(1.0, Color.rgb((int)199, (int)216, (int)206))}));
        }
        if (this.control.getDarkBackgroundPaint() == null) {
            this.control.setDarkBackgroundPaint((Paint)new LinearGradient(0.0, 0.0, 0.0, this.getPrefHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0))}));
        }
        if (this.secondPointer.visibleProperty().isBound()) {
            this.secondPointer.visibleProperty().unbind();
        }
        this.secondPointer.visibleProperty().bind((ObservableValue)this.control.secondPointerVisibleProperty());
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.runningProperty(), "RUNNING");
        this.registerChangeListener((ObservableValue)this.control.timeZoneProperty(), "TIME_ZONE");
        this.registerChangeListener((ObservableValue)this.secondAngle, "SECOND_ANGLE");
        this.registerChangeListener((ObservableValue)this.minuteAngle, "MINUTE_ANGLE");
        this.registerChangeListener((ObservableValue)this.hourAngle, "HOUR_ANGLE");
        this.registerChangeListener((ObservableValue)this.control.themeProperty(), "THEME");
        this.registerChangeListener((ObservableValue)this.control.clockStyleProperty(), "CLOCK_STYLE");
        this.registerChangeListener((ObservableValue)this.control.brightBackgroundPaintProperty(), "BRIGHT_BACKGROUND_PAINT");
        this.registerChangeListener((ObservableValue)this.control.darkBackgroundPaintProperty(), "DARK_BACKGROUND_PAINT");
        this.registerChangeListener((ObservableValue)this.control.brightPointerPaintProperty(), "BRIGHT_POINTER_PAINT");
        this.registerChangeListener((ObservableValue)this.control.darkPointerPaintProperty(), "DARK_POINTER_PAINT");
        this.registerChangeListener((ObservableValue)this.control.brightTickMarkPaintProperty(), "BRIGHT_TICK_MARK_PAINT");
        this.registerChangeListener((ObservableValue)this.control.darkTickMarkPaintProperty(), "DARK_TICK_MARK_PAINT");
        this.registerChangeListener((ObservableValue)this.control.secondPointerPaintProperty(), "SECOND_POINTER_PAINT");
        this.registerChangeListener((ObservableValue)this.control.titleProperty(), "TITLE");
        this.registerChangeListener((ObservableValue)this.control.hourProperty(), "HOUR");
        this.registerChangeListener((ObservableValue)this.control.minuteProperty(), "MINUTE");
        this.registerChangeListener((ObservableValue)this.control.secondProperty(), "SECOND");
        this.setTime();
        this.initialized = true;
        this.checkForNight();
        this.repaint();
        if (this.control.isRunning()) {
            this.timer.start();
        } else if (this.control.getHour() != 0 || this.control.getMinute() != 0 || this.control.getSecond() != 0) {
            this.setTime(this.control.getHour(), this.control.getMinute(), this.control.getSecond());
        }
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("TIME_ZONE".equals(PROPERTY)) {
            this.setTime();
        } else if ("RUNNING".equals(PROPERTY)) {
            if (this.control.isRunning()) {
                this.setTime();
                this.timer.start();
            } else {
                this.timer.stop();
            }
        } else if ("SECOND_ANGLE".equals(PROPERTY)) {
            this.secondPointer.setRotate(this.secondAngle.get());
        } else if ("MINUTE_ANGLE".equals(PROPERTY)) {
            this.minutePointer.setRotate(this.minuteAngle.get());
        } else if ("HOUR_ANGLE".equals(PROPERTY)) {
            this.hourPointer.setRotate(this.hourAngle.get());
        } else if ("TYPE".equals(PROPERTY)) {
            this.checkForNight();
            this.repaint();
        } else if ("THEME".equals(PROPERTY)) {
            this.repaint();
        } else if ("CLOCK_STYLE".equals(PROPERTY)) {
            this.drawSecondPointer();
        } else if ("BRIGHT_BACKGROUND_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("DARK_BACKGROUND_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("BRIGHT_POINTER_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("DARK_POINTER_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("BRIGHT_TICK_MARK_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("DARK_TICK_MARK_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("SECOND_POINTER_PAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("TITLE".equals(PROPERTY)) {
            this.repaint();
        } else if ("HOUR".equals(PROPERTY)) {
            if (!this.control.isRunning()) {
                this.setTime(this.control.getHour(), this.control.getMinute(), this.control.getSecond());
            }
        } else if ("MINUTE".equals(PROPERTY)) {
            if (!this.control.isRunning()) {
                this.setTime(this.control.getHour(), this.control.getMinute(), this.control.getSecond());
            }
        } else if ("SECOND".equals(PROPERTY)) {
            if (!this.control.isRunning()) {
                this.setTime(this.control.getHour(), this.control.getMinute(), this.control.getSecond());
            }
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawClock();
            this.drawMinutePointer();
            this.drawHourPointer();
            this.drawSecondPointer();
            this.drawShadows();
            this.getChildren().setAll((Object[])new Node[]{this.clock, this.minutePointerShadow, this.hourPointerShadow, this.secondPointerShadow});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final Clock getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_HEIGHT) {
        double prefHeight = 200.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    protected double computePrefHeight(double PREF_WIDTH) {
        double prefWidth = 200.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    private void setTime() {
        CAL.setTimeZone(TimeZone.getTimeZone(this.control.getTimeZone()));
        this.dst = this.control.isDaylightSavingTime() ? 1 : 0;
        int localDst = Calendar.getInstance().getTimeZone().inDaylightTime(new Date()) ? 1 : 0;
        this.hourOffset = CAL.get(11) + this.dst - Calendar.getInstance().get(11) + localDst;
        this.minuteOffset = CAL.get(12) - Calendar.getInstance().get(12);
        this.secondAngle.set((double)(Calendar.getInstance().get(13) * 6) + (double)Calendar.getInstance().get(14) * 0.006);
        this.minuteAngle.set((double)((this.minuteOffset + Calendar.getInstance().get(12)) * 6));
        this.hourAngle.set((double)((this.hourOffset + Calendar.getInstance().get(10)) * 30) + 0.5 * (double)Calendar.getInstance().get(12));
        this.checkForNight();
    }

    private void setTime(int HOUR, int MINUTE, int SECOND) {
        this.secondAngle.set((double)(SECOND * 6));
        this.minuteAngle.set((double)(MINUTE * 6));
        this.hourAngle.set((double)(HOUR * 30) + 0.5 * (double)MINUTE);
        this.checkForNight();
    }

    private void moveMinutePointer(double newMinuteAngle) {
        KeyValue kv = new KeyValue((WritableValue)this.minuteAngle, (Object)newMinuteAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
        KeyFrame kf = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kv});
        this.timeline = new Timeline();
        this.timeline.getKeyFrames().add((Object)kf);
        this.timeline.play();
    }

    private void checkForNight() {
        this.isDay = this.control.isAutoDimEnabled() ? CAL.get(11) > 6 && CAL.get(11) < 18 : this.control.getTheme() == Clock.Theme.BRIGHT;
    }

    public void drawClock() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.clock.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.clock.getChildren().add((Object)IBOUNDS);
        Circle FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.5 * WIDTH);
        FRAME.getStyleClass().clear();
        FRAME.getStyleClass().add((Object)"clock-frame-fill");
        FRAME.setStroke(null);
        InnerShadow HIGHLIGHT = new InnerShadow();
        HIGHLIGHT.setWidth(0.15 * SIZE);
        HIGHLIGHT.setHeight(0.15 * SIZE);
        HIGHLIGHT.setOffsetY(-0.025 * SIZE);
        HIGHLIGHT.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.65));
        InnerShadow SHADOW = new InnerShadow();
        SHADOW.setInput((Effect)HIGHLIGHT);
        SHADOW.setWidth(0.15 * SIZE);
        SHADOW.setHeight(0.15 * SIZE);
        SHADOW.setOffsetY(0.025 * SIZE);
        SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.1));
        FRAME.setEffect((Effect)SHADOW);
        Circle BACKGROUND = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4921259842519685 * WIDTH);
        if (this.control.isAutoDimEnabled()) {
            if (this.isDay) {
                BACKGROUND.setFill(this.control.getBrightBackgroundPaint());
            } else {
                BACKGROUND.setFill(this.control.getDarkBackgroundPaint());
            }
        } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
            BACKGROUND.setFill(this.control.getBrightBackgroundPaint());
        } else {
            BACKGROUND.setFill(this.control.getDarkBackgroundPaint());
        }
        BACKGROUND.setStroke(null);
        Text TITLE = new Text(this.control.getTitle());
        TITLE.setFontSmoothingType(FontSmoothingType.LCD);
        TITLE.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.06 * SIZE)));
        TITLE.setTextAlignment(TextAlignment.CENTER);
        TITLE.setX((SIZE - TITLE.getLayoutBounds().getWidth()) / 2.0);
        TITLE.setY(0.6 * SIZE + TITLE.getLayoutBounds().getHeight());
        if (this.control.isAutoDimEnabled()) {
            if (this.isDay) {
                TITLE.setFill(this.control.getBrightTickMarkPaint());
            } else {
                TITLE.setFill(this.control.getDarkTickMarkPaint());
            }
        } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
            TITLE.setFill(this.control.getBrightTickMarkPaint());
        } else {
            TITLE.setFill(this.control.getDarkTickMarkPaint());
        }
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.0929889298892989 * BACKGROUND.getLayoutBounds().getWidth());
        INNER_SHADOW.setHeight(0.0929889298892989 * BACKGROUND.getLayoutBounds().getHeight());
        INNER_SHADOW.setOffsetY(0.008856088560885609 * SIZE);
        INNER_SHADOW.setRadius(0.0929889298892989 * BACKGROUND.getLayoutBounds().getWidth());
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6470588235));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.inputProperty().set(null);
        BACKGROUND.setEffect((Effect)INNER_SHADOW);
        Path GLASS_EFFECT = new Path();
        if (this.control.getClockStyle() == Clock.ClockStyle.IOS6) {
            GLASS_EFFECT.setFillRule(FillRule.EVEN_ODD);
            GLASS_EFFECT.getElements().add((Object)new MoveTo(0.023622047244094488 * WIDTH, 0.36220472440944884 * HEIGHT));
            GLASS_EFFECT.getElements().add((Object)new CubicCurveTo(0.08661417322834646 * WIDTH, 0.15748031496062992 * HEIGHT, 0.2677165354330709 * WIDTH, 0.007874015748031496 * HEIGHT, 0.5039370078740157 * WIDTH, 0.007874015748031496 * HEIGHT));
            GLASS_EFFECT.getElements().add((Object)new CubicCurveTo(0.7322834645669292 * WIDTH, 0.007874015748031496 * HEIGHT, 0.9133858267716536 * WIDTH, 0.15748031496062992 * HEIGHT, 0.9763779527559056 * WIDTH, 0.36220472440944884 * HEIGHT));
            GLASS_EFFECT.getElements().add((Object)new CubicCurveTo(0.984251968503937 * WIDTH, 0.3858267716535433 * HEIGHT, 0.7480314960629921 * WIDTH, 0.5039370078740157 * HEIGHT, 0.5039370078740157 * WIDTH, 0.5039370078740157 * HEIGHT));
            GLASS_EFFECT.getElements().add((Object)new CubicCurveTo(0.25196850393700787 * WIDTH, 0.49606299212598426 * HEIGHT, 0.015748031496062992 * WIDTH, 0.3858267716535433 * HEIGHT, 0.023622047244094488 * WIDTH, 0.36220472440944884 * HEIGHT));
            GLASS_EFFECT.getElements().add((Object)new ClosePath());
            GLASS_EFFECT.setFill((Paint)Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.15));
            GLASS_EFFECT.setStroke(null);
        }
        Group TICK_MARKS = new Group();
        for (int angle = 0; angle < 360; angle += 6) {
            Rectangle TICK;
            Rotate TRANSFORM = Transform.rotate((double)angle, (double)(SIZE / 2.0), (double)(SIZE / 2.0));
            if (angle % 30 == 0) {
                switch (this.control.getClockStyle()) {
                    case IOS6: {
                        if (angle % 90 == 0) {
                            TICK = new Rectangle(0.4763779528 * WIDTH, 0.023622047244094488 * HEIGHT, 0.0472440945 * WIDTH, 0.110701107 * HEIGHT);
                            break;
                        }
                        TICK = new Rectangle(0.48031496062992124 * WIDTH, 0.023622047244094488 * HEIGHT, 0.03937007874015748 * WIDTH, 0.110701107 * HEIGHT);
                        break;
                    }
                    case DB: {
                        TICK = new Rectangle(0.48031496062992124 * WIDTH, 0.023622047244094488 * HEIGHT, 0.03937007874015748 * WIDTH, 0.110701107 * HEIGHT);
                        break;
                    }
                    default: {
                        TICK = new Rectangle(0.49606299212598426 * WIDTH, 0.031496062992125984 * HEIGHT, 0.015748031496062992 * WIDTH, 0.06299212598425197 * HEIGHT);
                        TICK.setArcWidth(0.0078740157 * WIDTH);
                        TICK.setArcHeight(0.0078740157 * HEIGHT);
                        break;
                    }
                }
            } else {
                switch (this.control.getClockStyle()) {
                    case IOS6: {
                        TICK = new Rectangle(0.4960629921 * WIDTH, 0.023622047244094488 * HEIGHT, 0.0078740157 * WIDTH, 0.047244094488188976 * HEIGHT);
                        break;
                    }
                    case DB: {
                        TICK = new Rectangle(0.4881889763779528 * WIDTH, 0.023622047244094488 * HEIGHT, 0.023622047244094488 * WIDTH, 0.047244094488188976 * HEIGHT);
                        break;
                    }
                    default: {
                        TICK = new Rectangle(0.49606299212598426 * WIDTH, 0.031496062992125984 * HEIGHT, 0.007874015748031496 * WIDTH, 0.03937007874015748 * HEIGHT);
                        TICK.setArcWidth(0.0039370079 * WIDTH);
                        TICK.setArcHeight(0.0039370079 * HEIGHT);
                    }
                }
            }
            if (this.control.isAutoDimEnabled()) {
                if (this.isDay) {
                    TICK.setFill(this.control.getBrightTickMarkPaint());
                } else {
                    TICK.setFill(this.control.getDarkTickMarkPaint());
                }
            } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
                TICK.setFill(this.control.getBrightTickMarkPaint());
            } else {
                TICK.setFill(this.control.getDarkTickMarkPaint());
            }
            TICK.setStroke(null);
            TICK.getTransforms().add((Object)TRANSFORM);
            TICK_MARKS.getChildren().add((Object)TICK);
        }
        this.clock.getChildren().addAll((Object[])new Node[]{FRAME, BACKGROUND, TITLE, GLASS_EFFECT, TICK_MARKS});
        this.clock.setCache(true);
    }

    public void drawMinutePointer() {
        Rectangle MINUTE;
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.minutePointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.minutePointer.getChildren().add((Object)IBOUNDS);
        switch (this.control.getClockStyle()) {
            case IOS6: {
                MINUTE = new Rectangle(0.4783464567 * WIDTH, 0.047244094488188976 * HEIGHT, 0.0433070866 * WIDTH, 0.5511811024 * HEIGHT);
                break;
            }
            case DB: {
                MINUTE = new Rectangle(0.48031496062992124 * WIDTH, 0.047244094488188976 * HEIGHT, 0.03937007874015748 * WIDTH, 0.47244094488188976 * HEIGHT);
                break;
            }
            default: {
                Circle MINUTE_CIRCLE = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.03543307086614173 * WIDTH);
                Rectangle MINUTE_RECT = new Rectangle(0.4881889763779528 * WIDTH, 0.12598425196850394 * HEIGHT, 0.023622047244094488 * WIDTH, 0.4881889763779528 * HEIGHT);
                MINUTE_RECT.setArcWidth(0.011811023622047244 * WIDTH);
                MINUTE_RECT.setArcHeight(0.011811023622047244 * HEIGHT);
                MINUTE = Shape.union((Shape)MINUTE_CIRCLE, (Shape)MINUTE_RECT);
            }
        }
        if (this.control.isAutoDimEnabled()) {
            if (this.isDay) {
                MINUTE.setFill(this.control.getBrightPointerPaint());
            } else {
                MINUTE.setFill(this.control.getDarkPointerPaint());
            }
        } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
            MINUTE.setFill(this.control.getBrightPointerPaint());
        } else {
            MINUTE.setFill(this.control.getDarkPointerPaint());
        }
        MINUTE.setStroke(null);
        this.minutePointer.setRotate(this.minuteAngle.get());
        this.minutePointer.getChildren().add((Object)MINUTE);
        if (this.control.getClockStyle() == Clock.ClockStyle.STANDARD) {
            Rectangle MINUTE_FLOUR = new Rectangle(0.49606299212598426 * WIDTH, 0.13385826771653545 * HEIGHT, 0.007874015748031496 * WIDTH, 0.2992125984251969 * HEIGHT);
            MINUTE_FLOUR.setArcWidth(0.003937007874015748 * WIDTH);
            MINUTE_FLOUR.setArcHeight(0.003937007874015748 * HEIGHT);
            Color MINUTEFLOUR_FILL = Color.color((double)0.8274509804, (double)0.8666666667, (double)0.6156862745, (double)1.0);
            MINUTE_FLOUR.setFill((Paint)MINUTEFLOUR_FILL);
            MINUTE_FLOUR.setStroke(null);
            this.minutePointer.getChildren().add((Object)MINUTE_FLOUR);
        }
        this.minutePointer.setCache(true);
    }

    public void drawHourPointer() {
        Rectangle HOUR;
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.hourPointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.hourPointer.getChildren().add((Object)IBOUNDS);
        switch (this.control.getClockStyle()) {
            case IOS6: {
                HOUR = new Rectangle(0.4783464567 * WIDTH, 0.2440944882 * HEIGHT, 0.0433070866 * WIDTH, 0.3543307087 * HEIGHT);
                break;
            }
            case DB: {
                HOUR = new Rectangle(0.47244094488188976 * WIDTH, 0.2125984251968504 * HEIGHT, 0.05511811023622047 * WIDTH, 0.2992125984251969 * HEIGHT);
                break;
            }
            default: {
                Circle HOUR_CIRCLE = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.051181102362204724 * WIDTH);
                Rectangle HOUR_RECT = new Rectangle(0.48031496062992124 * WIDTH, 0.2047244094488189 * HEIGHT, 0.03937007874015748 * WIDTH, 0.3937007874015748 * HEIGHT);
                HOUR_RECT.setArcWidth(0.01968503937007874 * WIDTH);
                HOUR_RECT.setArcHeight(0.01968503937007874 * HEIGHT);
                HOUR = Shape.union((Shape)HOUR_CIRCLE, (Shape)HOUR_RECT);
            }
        }
        if (this.control.isAutoDimEnabled()) {
            if (this.isDay) {
                HOUR.setFill(this.control.getBrightPointerPaint());
            } else {
                HOUR.setFill(this.control.getDarkPointerPaint());
            }
        } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
            HOUR.setFill(this.control.getBrightPointerPaint());
        } else {
            HOUR.setFill(this.control.getDarkPointerPaint());
        }
        HOUR.setStroke(null);
        this.hourPointer.setRotate(this.hourAngle.get());
        this.hourPointer.getChildren().add((Object)HOUR);
        if (this.control.getClockStyle() == Clock.ClockStyle.STANDARD) {
            Rectangle HOUR_FLOUR = new Rectangle(0.4881889763779528 * WIDTH, 0.2204724409448819 * HEIGHT, 0.023622047244094488 * WIDTH, 0.2125984251968504 * HEIGHT);
            HOUR_FLOUR.setArcWidth(0.011811023622047244 * WIDTH);
            HOUR_FLOUR.setArcHeight(0.011811023622047244 * HEIGHT);
            Color HOURFLOUR_FILL = Color.color((double)0.8235294118, (double)0.8588235294, (double)0.5882352941, (double)1.0);
            HOUR_FLOUR.setFill((Paint)HOURFLOUR_FILL);
            HOUR_FLOUR.setStroke(null);
            this.hourPointer.getChildren().add((Object)HOUR_FLOUR);
        }
        this.hourPointer.setCache(true);
    }

    public void drawSecondPointer() {
        Circle CENTER_KNOB;
        Path second;
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.secondPointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.secondPointer.getChildren().add((Object)IBOUNDS);
        switch (this.control.getClockStyle()) {
            case IOS6: {
                Circle TOP_CIRCLE = new Circle(0.5 * WIDTH, 0.20078740157480315 * HEIGHT, 0.036900369 * WIDTH);
                Rectangle BODY = new Rectangle(0.4926199262 * WIDTH, 0.2204724409 * HEIGHT, 0.0147601476 * WIDTH, 0.4409448819 * HEIGHT);
                BODY.setFill((Paint)Color.BLACK);
                Circle CENTER_CIRCLE = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.0236220472 * WIDTH);
                Shape tmp = Path.union((Shape)TOP_CIRCLE, (Shape)BODY);
                tmp.setFill((Paint)Color.BLACK);
                second = (Path)Path.union((Shape)tmp, (Shape)CENTER_CIRCLE);
                break;
            }
            case DB: {
                Circle OUTER_CIRCLE = new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0454545454);
                Circle INNER_CIRCLE = new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0363636364);
                second = (Path)Path.subtract((Shape)OUTER_CIRCLE, (Shape)INNER_CIRCLE);
                second.getElements().add((Object)new MoveTo(WIDTH * 0.4863636364, SIZE * 0.5));
                second.getElements().add((Object)new LineTo(WIDTH * 0.5136363636, SIZE * 0.5));
                second.getElements().add((Object)new LineTo(WIDTH * 0.5045454545, WIDTH * 0.0363636364));
                second.getElements().add((Object)new LineTo(WIDTH * 0.4954545455, WIDTH * 0.0363636364));
                second.getElements().add((Object)new ClosePath());
                second = (Path)Path.subtract((Shape)second, (Shape)new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0363636364));
                break;
            }
            default: {
                Circle SECOND_CIRCLE = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.027559055118110236 * WIDTH);
                Rectangle SECOND_RECT = new Rectangle(0.49606299212598426 * WIDTH, 0.06299212598425197 * HEIGHT, 0.007874015748031496 * WIDTH, 0.4251968503937008 * HEIGHT);
                SECOND_RECT.setArcWidth(0.007874015748031496 * WIDTH);
                SECOND_RECT.setArcHeight(0.007874015748031496 * HEIGHT);
                second = (Path)Shape.union((Shape)SECOND_CIRCLE, (Shape)SECOND_RECT);
            }
        }
        second.setFill(this.control.getSecondPointerPaint());
        second.setStroke(null);
        this.secondPointer.getChildren().add((Object)second);
        if (this.control.getClockStyle() == Clock.ClockStyle.STANDARD) {
            Rectangle SECOND_FLOUR = new Rectangle(0.49606299212598426 * WIDTH, 0.06299212598425197 * HEIGHT, 0.007874015748031496 * WIDTH, 0.03937007874015748 * HEIGHT);
            SECOND_FLOUR.setArcWidth(0.007874015748031496 * WIDTH);
            SECOND_FLOUR.setArcHeight(0.007874015748031496 * HEIGHT);
            Color SECONDFLOUR_FILL = Color.color((double)0.8039215686, (double)0.8549019608, (double)0.5921568627, (double)1.0);
            SECOND_FLOUR.setFill((Paint)SECONDFLOUR_FILL);
            SECOND_FLOUR.setStroke(null);
            this.secondPointer.getChildren().add((Object)SECOND_FLOUR);
        }
        this.secondPointer.setRotate(this.secondAngle.get());
        switch (this.control.getClockStyle()) {
            case DB: {
                CENTER_KNOB = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.051181102362204724 * WIDTH);
                CENTER_KNOB.getStyleClass().clear();
                if (this.control.isAutoDimEnabled()) {
                    if (this.isDay) {
                        CENTER_KNOB.setFill(this.control.getBrightPointerPaint());
                    } else {
                        CENTER_KNOB.setFill(this.control.getDarkPointerPaint());
                    }
                } else if (Clock.Theme.BRIGHT == this.control.getTheme()) {
                    CENTER_KNOB.setFill(this.control.getBrightPointerPaint());
                } else {
                    CENTER_KNOB.setFill(this.control.getDarkPointerPaint());
                }
                CENTER_KNOB.setStroke(null);
                break;
            }
            case IOS6: {
                CENTER_KNOB = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.0078740157 * WIDTH);
                CENTER_KNOB.setFill((Paint)Color.color((double)0.8745098039, (double)0.8745098039, (double)0.8156862745, (double)1.0));
                CENTER_KNOB.setStroke(null);
                break;
            }
            default: {
                CENTER_KNOB = new Circle(0.5 * WIDTH, 0.5 * WIDTH, 0.25 * WIDTH);
                CENTER_KNOB.setFill((Paint)Color.TRANSPARENT);
                CENTER_KNOB.setStroke((Paint)Color.TRANSPARENT);
            }
        }
        this.secondPointer.getChildren().add((Object)CENTER_KNOB);
        this.secondPointer.setCache(true);
    }

    private void drawShadows() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        Light.Distant LIGHT = new Light.Distant();
        LIGHT.setAzimuth(270.0);
        LIGHT.setElevation(50.0);
        Lighting LIGHTING = new Lighting();
        LIGHTING.setLight((Light)LIGHT);
        DropShadow DROP_SHADOW = new DropShadow();
        DROP_SHADOW.setInput((Effect)LIGHTING);
        DROP_SHADOW.setOffsetY(0.015 * SIZE);
        DROP_SHADOW.setRadius(0.015 * SIZE);
        DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DROP_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.55));
        if (this.control.isAutoDimEnabled()) {
            if (this.isDay) {
                this.minutePointerShadow.setEffect((Effect)DROP_SHADOW);
                this.hourPointerShadow.setEffect((Effect)DROP_SHADOW);
            }
        } else if (this.control.getTheme() == Clock.Theme.BRIGHT) {
            this.minutePointerShadow.setEffect((Effect)DROP_SHADOW);
            this.hourPointerShadow.setEffect((Effect)DROP_SHADOW);
        }
        this.secondPointerShadow.setEffect((Effect)DROP_SHADOW);
    }
}

