/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.LedBargraphBehavior;
import jfxtras.labs.scene.control.gauge.Led;
import jfxtras.labs.scene.control.gauge.LedBargraph;

public class LedBargraphSkin
extends SkinBase<LedBargraph, LedBargraphBehavior> {
    public static final long PEAK_TIMEOUT = 1500000000L;
    private LedBargraph control;
    private boolean isDirty;
    private boolean initialized;
    private Group bargraph;
    private List<Led> ledList;
    private long lastTimerCall;
    private DoubleProperty stepSize;
    private int peakLedIndex;
    private AnimationTimer timer;

    public LedBargraphSkin(LedBargraph CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new LedBargraphBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.bargraph = new Group();
        this.ledList = new ArrayList<Led>(this.control.getNoOfLeds());
        for (int i = 0; i < this.control.getNoOfLeds(); ++i) {
            Led led = new Led();
            led.setPrefSize(this.control.getLedSize(), this.control.getLedSize());
            this.ledList.add(led);
        }
        this.lastTimerCall = 0L;
        this.stepSize = new SimpleDoubleProperty(1.0 / (double)this.control.getNoOfLeds());
        this.peakLedIndex = 0;
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime > LedBargraphSkin.this.lastTimerCall + 1500000000L) {
                    ((Led)((Object)LedBargraphSkin.this.ledList.get(LedBargraphSkin.this.peakLedIndex))).setOn(false);
                    LedBargraphSkin.this.peakLedIndex = 0;
                    LedBargraphSkin.this.timer.stop();
                }
            }
        };
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(16.0, 16.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(16.0, 16.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.ledTypeProperty(), "LED_TYPE");
        this.registerChangeListener((ObservableValue)this.control.frameVisibleProperty(), "FRAME_VISIBLE");
        this.registerChangeListener((ObservableValue)this.control.ledSizeProperty(), "LED_SIZE");
        this.registerChangeListener((ObservableValue)this.control.orientationProperty(), "ORIENTATION");
        this.registerChangeListener((ObservableValue)this.control.noOfLedsProperty(), "LED_NUMBER");
        this.registerChangeListener((ObservableValue)this.control.ledColorsProperty(), "LED_COLOR");
        if (this.control.getValue() > 0.0) {
            for (int i = 0; i < this.control.getNoOfLeds(); ++i) {
                if (Double.compare((double)i * this.stepSize.doubleValue(), this.control.getValue()) <= 0) {
                    this.ledList.get(i).setOn(true);
                    continue;
                }
                this.ledList.get(i).setOn(false);
            }
        }
        this.control.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                int currentLedPeakIndex = 0;
                for (int i = 0; i < LedBargraphSkin.this.control.getNoOfLeds(); ++i) {
                    if (Double.compare((double)i * LedBargraphSkin.this.stepSize.doubleValue(), newValue.doubleValue()) <= 0) {
                        ((Led)((Object)LedBargraphSkin.this.ledList.get(i))).setOn(true);
                        currentLedPeakIndex = i;
                    } else {
                        ((Led)((Object)LedBargraphSkin.this.ledList.get(i))).setOn(false);
                    }
                    ((Led)((Object)LedBargraphSkin.this.ledList.get(LedBargraphSkin.this.peakLedIndex))).setOn(true);
                }
                if (LedBargraphSkin.this.control.isPeakValueVisible() && currentLedPeakIndex > LedBargraphSkin.this.peakLedIndex) {
                    LedBargraphSkin.this.peakLedIndex = currentLedPeakIndex;
                    LedBargraphSkin.this.timer.stop();
                    LedBargraphSkin.this.lastTimerCall = System.nanoTime();
                    LedBargraphSkin.this.timer.start();
                }
            }
        });
        this.setLedColors();
        this.setLedTypes();
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("FRAME_VISIBLE".equals(PROPERTY)) {
            for (Led led : this.ledList) {
                led.setFrameVisible(this.control.isFrameVisible());
            }
            this.repaint();
        } else if ("LED_SIZE".equals(PROPERTY)) {
            this.ledList.clear();
            for (int i = 0; i < this.control.getNoOfLeds(); ++i) {
                Led led = new Led();
                led.setPrefSize(this.control.getLedSize(), this.control.getLedSize());
                this.ledList.add(led);
            }
            this.setLedColors();
            this.repaint();
        } else if ("ORIENTATION".equals(PROPERTY)) {
            this.repaint();
        } else if ("LED_NUMBER".equals(PROPERTY)) {
            this.stepSize.set(1.0 / (double)this.control.getNoOfLeds());
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.setLedColors();
            this.repaint();
        } else if ("LED_TYPE".equals(PROPERTY)) {
            this.setLedTypes();
            this.repaint();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawLed();
            this.getChildren().setAll((Object[])new Node[]{this.bargraph});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final LedBargraph getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 16.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 16.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private final void setLedColors() {
        for (int i = 0; i < this.control.getNoOfLeds(); ++i) {
            this.ledList.get(i).setColor(this.control.getLedColor(i));
        }
    }

    private final void setLedTypes() {
        for (int i = 0; i < this.control.getNoOfLeds(); ++i) {
            this.ledList.get(i).setType(this.control.getLedType());
        }
    }

    private final void drawLed() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.bargraph.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.bargraph.getChildren().add((Object)IBOUNDS);
        int NO_OF_LEDS = this.control.getNoOfLeds();
        if (this.control.getOrientation() == Orientation.VERTICAL) {
            VBox pane = new VBox();
            pane.setSpacing(0.0);
            pane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            for (int i = 0; i < NO_OF_LEDS; ++i) {
                pane.getChildren().add(i, (Object)this.ledList.get(NO_OF_LEDS - 1 - i));
            }
            this.bargraph.getChildren().add((Object)pane);
        } else {
            HBox pane = new HBox();
            pane.setSpacing(0.0);
            pane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            for (int i = 0; i < NO_OF_LEDS; ++i) {
                pane.getChildren().add(i, (Object)this.ledList.get(i));
            }
            this.bargraph.getChildren().add((Object)pane);
        }
    }
}

