/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.animation.AnimationTimer;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.MatrixPanelBehavior;
import jfxtras.labs.scene.control.gauge.Content;
import jfxtras.labs.scene.control.gauge.MatrixPanel;
import jfxtras.labs.scene.control.gauge.UtilHex;
import jfxtras.labs.util.ConicalGradient;
import jfxtras.labs.util.Util;

public class MatrixPanelSkin
extends SkinBase<MatrixPanel, MatrixPanelBehavior> {
    private static final Rectangle PREF_SIZE = new Rectangle(170.0, 350.0);
    private MatrixPanel control;
    private Rectangle gaugeBounds;
    private Point2D framelessOffset;
    private Group frame;
    private Group background;
    private Group matrix;
    private Group foreground;
    private boolean isDirty;
    private boolean initialized;
    private IntegerProperty ledWidth;
    private IntegerProperty ledHeight;
    private Group dots;
    private ObservableList<Content> contents;
    private Map<Integer, Shape> dotMap;
    private BooleanProperty[] visibleContent = null;
    private final int toneScale = 85;
    private final Color COLOR_OFF = Color.rgb((int)39, (int)39, (int)39, (double)0.25);
    private double radio = 0.0;
    private final int LED_COLUMN = 0;
    private final int LED_ROW = 1;
    private final int LED_INTENSITY = 2;
    private ArrayList<int[][]> fullAreas = null;
    private Rectangle[] visibleArea = null;
    private ArrayList<ContentPair> pairs = null;
    private ArrayList<Animation> Anim = null;

    public MatrixPanelSkin(MatrixPanel CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new MatrixPanelBehavior(CONTROL));
        this.control = CONTROL;
        this.gaugeBounds = new Rectangle(800.0, 600.0);
        this.framelessOffset = new Point2D(0.0, 0.0);
        this.frame = new Group();
        this.background = new Group();
        this.matrix = new Group();
        this.foreground = new Group();
        this.ledWidth = new SimpleIntegerProperty(0);
        this.ledHeight = new SimpleIntegerProperty(0);
        this.dots = new Group();
        this.isDirty = false;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        this.ledWidth.bind((ObservableValue)this.control.ledWidthProperty());
        this.ledHeight.bind((ObservableValue)this.control.ledHeightProperty());
        this.contents = this.control.getContents();
        this.addBindings();
        this.addListeners();
        this.initialized = true;
        this.paint();
    }

    private void addBindings() {
        if (this.frame.visibleProperty().isBound()) {
            this.frame.visibleProperty().unbind();
        }
        this.frame.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
    }

    private void addListeners() {
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                MatrixPanelSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                MatrixPanelSkin.this.isDirty = true;
            }
        });
        this.ledHeight.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                MatrixPanelSkin.this.isDirty = true;
            }
        });
        this.ledWidth.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                MatrixPanelSkin.this.isDirty = true;
            }
        });
        this.contents.addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change c) {
                MatrixPanelSkin.this.updatePanel();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("FRAME_DESIGN".equals(PROPERTY)) {
            this.drawFrame();
        } else if ("SIMPLE_GRADIENT_BASE".equals(PROPERTY)) {
            this.isDirty = true;
        }
    }

    public void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.calcGaugeBounds();
        this.setTranslateX(this.framelessOffset.getX());
        this.setTranslateY(this.framelessOffset.getY());
        this.getChildren().clear();
        this.drawFrame();
        this.drawBackground();
        this.drawPanel();
        this.drawForeground();
        this.getChildren().addAll((Object[])new Node[]{this.frame, this.background, this.matrix, this.foreground});
        this.updatePanel();
        this.isDirty = false;
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
        }
        super.layoutChildren();
    }

    public MatrixPanel getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double WIDTH) {
        double prefWidth = PREF_SIZE.getWidth();
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double HEIGHT) {
        double prefHeight = PREF_SIZE.getHeight();
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefHeight);
    }

    private void calcGaugeBounds() {
        if (this.control.getPrefWidth() == 0.0) {
            this.control.setPrefWidth(800.0);
        }
        if (this.control.getPrefHeight() == 0.0) {
            this.control.setPrefHeight(600.0);
        }
        if (this.control.getLedHeight() > 0 && this.control.getLedWidth() > 0) {
            double scale = Math.min(this.control.getPrefWidth() / (double)this.control.getLedWidth(), this.control.getPrefHeight() / (double)this.control.getLedHeight());
            this.control.setPrefWidth(scale * (double)this.control.getLedWidth());
            this.control.setPrefHeight(scale * (double)this.control.getLedHeight());
        }
        this.gaugeBounds.setWidth(this.control.getPrefWidth());
        this.gaugeBounds.setHeight(this.control.getPrefHeight());
        this.framelessOffset = new Point2D(0.0, 0.0);
    }

    public void drawFrame() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.frame.getChildren().clear();
        Rectangle SUBTRACT = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        SUBTRACT.setArcWidth(0.05 * SIZE);
        SUBTRACT.setArcHeight(0.05 * SIZE);
        Rectangle OUTER_FRAME = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        OUTER_FRAME.setArcWidth(0.09333333333333334 * SIZE);
        OUTER_FRAME.setArcHeight(0.09333333333333334 * SIZE);
        OUTER_FRAME.setFill((Paint)Color.color((double)0.5176470588, (double)0.5176470588, (double)0.5176470588, (double)1.0));
        OUTER_FRAME.setStroke(null);
        this.frame.getChildren().add((Object)OUTER_FRAME);
        Rectangle MAIN_FRAME = new Rectangle(1.0, 1.0, WIDTH - 2.0, HEIGHT - 2.0);
        MAIN_FRAME.setArcWidth(0.08 * SIZE);
        MAIN_FRAME.setArcHeight(0.08 * SIZE);
        MAIN_FRAME.setStroke(null);
        Rectangle INNER_FRAME = new Rectangle(0.0841121495 * SIZE, 0.0841121495 * SIZE, WIDTH - 0.168224299 * SIZE, HEIGHT - 0.168224299 * SIZE);
        INNER_FRAME.setArcWidth(0.05 * SIZE);
        INNER_FRAME.setArcHeight(0.05 * SIZE);
        INNER_FRAME.setFill((Paint)Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.8));
        INNER_FRAME.setStroke(null);
        switch (this.control.getFrameDesign()) {
            case BLACK_METAL: {
                ConicalGradient bmGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.3472, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.5, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.6805, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.875, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254)));
                MAIN_FRAME.setFill((Paint)bmGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case SHINY_METAL: {
                ConicalGradient smGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Util.darker(this.control.getFrameBaseColor(), 0.15)), new Stop(0.25, this.control.getFrameBaseColor().darker()), new Stop(0.3472, this.control.getFrameBaseColor().brighter()), new Stop(0.5, this.control.getFrameBaseColor().darker().darker()), new Stop(0.6527, this.control.getFrameBaseColor().brighter()), new Stop(0.75, this.control.getFrameBaseColor().darker()), new Stop(0.875, Util.darker(this.control.getFrameBaseColor(), 0.15)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254)));
                MAIN_FRAME.setFill((Paint)smGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case CHROME: {
                ConicalGradient cmGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.WHITE), new Stop(0.09, Color.WHITE), new Stop(0.12, Color.rgb((int)136, (int)136, (int)138)), new Stop(0.16, Color.rgb((int)164, (int)185, (int)190)), new Stop(0.25, Color.rgb((int)158, (int)179, (int)182)), new Stop(0.29, Color.rgb((int)112, (int)112, (int)112)), new Stop(0.33, Color.rgb((int)221, (int)227, (int)227)), new Stop(0.38, Color.rgb((int)155, (int)176, (int)179)), new Stop(0.48, Color.rgb((int)156, (int)176, (int)177)), new Stop(0.52, Color.rgb((int)254, (int)255, (int)255)), new Stop(0.63, Color.WHITE), new Stop(0.68, Color.rgb((int)156, (int)180, (int)180)), new Stop(0.8, Color.rgb((int)198, (int)209, (int)211)), new Stop(0.83, Color.rgb((int)246, (int)248, (int)247)), new Stop(0.87, Color.rgb((int)204, (int)216, (int)216)), new Stop(0.97, Color.rgb((int)164, (int)188, (int)190)), new Stop(1.0, Color.WHITE));
                MAIN_FRAME.setFill((Paint)cmGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case GLOSSY_METAL: {
                MAIN_FRAME.setFill((Paint)new LinearGradient(0.4714285714285714 * WIDTH, 0.014285714285714285 * HEIGHT, 0.47142857142857153 * WIDTH, 0.9785714285714285 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.1, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.26, Color.WHITE), new Stop(0.73, Color.color((double)0.1137254902, (double)0.1137254902, (double)0.1137254902, (double)1.0)), new Stop(1.0, Color.color((double)0.8196078431, (double)0.8196078431, (double)0.8196078431, (double)1.0))}));
                Rectangle GLOSSY2 = new Rectangle(0.08571428571428572 * WIDTH, 0.08571428571428572 * HEIGHT, 0.8285714285714286 * WIDTH, 0.8285714285714286 * HEIGHT);
                GLOSSY2.setArcWidth(0.05714285714285714 * SIZE);
                GLOSSY2.setArcHeight(0.05714285714285714 * SIZE);
                GLOSSY2.setFill((Paint)new LinearGradient(0.0, GLOSSY2.getLayoutBounds().getMinY(), 0.0, GLOSSY2.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.23, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.36, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.59, Color.color((double)0.1137254902, (double)0.1137254902, (double)0.1137254902, (double)1.0)), new Stop(0.76, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.7529411765, (double)1.0)), new Stop(1.0, Color.color((double)0.8196078431, (double)0.8196078431, (double)0.8196078431, (double)1.0))}));
                Rectangle GLOSSY3 = new Rectangle(INNER_FRAME.getX() - 2.0, INNER_FRAME.getY() - 2.0, INNER_FRAME.getWidth() + 4.0, INNER_FRAME.getHeight() + 4.0);
                GLOSSY3.setArcWidth(INNER_FRAME.getArcWidth() + 1.0);
                GLOSSY3.setArcHeight(INNER_FRAME.getArcHeight() + 1.0);
                GLOSSY3.setFill((Paint)Color.web((String)"#F6F6F6"));
                Rectangle GLOSSY4 = new Rectangle(GLOSSY3.getX() + 2.0, GLOSSY3.getY() + 2.0, GLOSSY3.getWidth() - 4.0, GLOSSY3.getHeight() - 4.0);
                GLOSSY4.setArcWidth(GLOSSY3.getArcWidth() - 1.0);
                GLOSSY4.setArcHeight(GLOSSY3.getArcHeight() - 1.0);
                GLOSSY4.setFill((Paint)Color.web((String)"#333333"));
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, GLOSSY2, GLOSSY3, GLOSSY4});
                break;
            }
            case DARK_GLOSSY: {
                MAIN_FRAME.setFill((Paint)new LinearGradient(0.8551401869158879 * WIDTH, 0.14953271028037382 * HEIGHT, 0.15794611761513314 * WIDTH, 0.8467267795811287 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.84, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0))}));
                Rectangle DARK_GLOSSY2 = new Rectangle(0.08571428571428572 * WIDTH, 0.08571428571428572 * HEIGHT, 0.8285714285714286 * WIDTH, 0.8285714285714286 * HEIGHT);
                DARK_GLOSSY2.setArcWidth(0.05714285714285714 * SIZE);
                DARK_GLOSSY2.setArcHeight(0.05714285714285714 * SIZE);
                DARK_GLOSSY2.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.985981308411215 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(0.42, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(1.0, Color.color((double)0.0509803922, (double)0.0509803922, (double)0.0509803922, (double)1.0))}));
                DARK_GLOSSY2.setStroke(null);
                Rectangle DARK_GLOSSY3 = new Rectangle(MAIN_FRAME.getX(), MAIN_FRAME.getY(), MAIN_FRAME.getWidth(), MAIN_FRAME.getHeight() * 0.5);
                DARK_GLOSSY3.setArcWidth(MAIN_FRAME.getArcWidth());
                DARK_GLOSSY3.setArcHeight(MAIN_FRAME.getArcHeight());
                DARK_GLOSSY3.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.5280373831775701 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26009998, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
                DARK_GLOSSY3.setStroke(null);
                Rectangle DARK_GLOSSY4 = new Rectangle(INNER_FRAME.getX() - 2.0, INNER_FRAME.getY() - 2.0, INNER_FRAME.getWidth() + 4.0, INNER_FRAME.getHeight() + 4.0);
                DARK_GLOSSY4.setArcWidth(INNER_FRAME.getArcWidth() + 1.0);
                DARK_GLOSSY4.setArcHeight(INNER_FRAME.getArcHeight() + 1.0);
                DARK_GLOSSY4.setFill((Paint)new LinearGradient(0.8037383177570093 * WIDTH, 0.1822429906542056 * HEIGHT, 0.18584594354259637 * WIDTH, 0.8001353648686187 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.6745098039, (double)0.6745098039, (double)0.6784313725, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.91, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0)), new Stop(1.0, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0))}));
                DARK_GLOSSY4.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, DARK_GLOSSY2, DARK_GLOSSY3, DARK_GLOSSY4});
                break;
            }
            default: {
                ImageView IMAGE_VIEW = new ImageView();
                IMAGE_VIEW.setVisible(false);
                MAIN_FRAME.getStyleClass().add((Object)this.control.getFrameDesign().CSS);
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
            }
        }
        this.frame.setCache(true);
    }

    public void drawBackground() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.background.getChildren().add((Object)IBOUNDS);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.2 * SIZE);
        INNER_SHADOW.setHeight(0.2 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        LinearGradient HL_GRADIENT = new LinearGradient(0.0, 0.0, WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6)), new Stop(0.4, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(0.6, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6))});
        Rectangle BACKGROUND = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        BACKGROUND.setArcWidth(0.05 * SIZE);
        BACKGROUND.setArcHeight(0.05 * SIZE);
        BACKGROUND.setStroke(null);
        Rectangle CLIP_SHAPE = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        CLIP_SHAPE.setArcWidth(0.05 * SIZE);
        CLIP_SHAPE.setArcHeight(0.05 * SIZE);
        BACKGROUND.setEffect((Effect)INNER_SHADOW);
        this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND});
        this.background.setCache(true);
    }

    public void drawForeground() {
        Point2D STOP;
        Point2D START;
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.foreground.getChildren().clear();
        Insets INSETS = new Insets(0.0841121495 * SIZE + 2.0, WIDTH - 0.0841121495 * SIZE - 2.0, HEIGHT - 0.0841121495 * SIZE - 2.0, 0.0841121495 * SIZE + 2.0);
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.foreground.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        Path FOREGROUND = new Path();
        if (WIDTH >= HEIGHT) {
            FOREGROUND.setFillRule(FillRule.EVEN_ODD);
            FOREGROUND.getElements().add((Object)new MoveTo(INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getRight(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight(), INSETS.getBottom(), INSETS.getRight() - 13.0, 0.7 * HEIGHT, INSETS.getRight() - 13.0, 0.5 * HEIGHT));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight() - 13.0, 0.3 * HEIGHT, INSETS.getRight(), INSETS.getTop(), INSETS.getRight(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft(), INSETS.getTop(), INSETS.getLeft() + 13.0, 0.3 * HEIGHT, INSETS.getLeft() + 13.0, 0.5 * HEIGHT));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft() + 13.0, 0.7 * HEIGHT, INSETS.getLeft(), INSETS.getBottom(), INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new ClosePath());
            START = new Point2D(0.0, FOREGROUND.getLayoutBounds().getMaxY());
            STOP = new Point2D(0.0, FOREGROUND.getLayoutBounds().getMinY());
        } else {
            FOREGROUND.setFillRule(FillRule.EVEN_ODD);
            FOREGROUND.getElements().add((Object)new MoveTo(INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft(), INSETS.getBottom(), 0.3 * WIDTH, INSETS.getBottom() - 13.0, 0.5 * WIDTH, INSETS.getBottom() - 13.0));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(0.7 * WIDTH, INSETS.getBottom() - 13.0, INSETS.getRight(), INSETS.getBottom(), INSETS.getRight(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getRight(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight(), INSETS.getTop(), 0.7 * WIDTH, INSETS.getTop() + 13.0, 0.5 * WIDTH, INSETS.getTop() + 13.0));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(0.3 * WIDTH, INSETS.getTop() + 13.0, INSETS.getLeft(), INSETS.getTop(), INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new ClosePath());
            START = new Point2D(FOREGROUND.getLayoutBounds().getMinX(), 0.0);
            STOP = new Point2D(FOREGROUND.getLayoutBounds().getMaxX(), 0.0);
        }
        LinearGradient GRADIENT = new LinearGradient(START.getX(), START.getY(), STOP.getX(), STOP.getY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.06, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.07, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.12, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.05)), new Stop(0.17, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.18, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.23, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.02)), new Stop(0.3, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.8, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.84, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.08)), new Stop(0.93, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.18)), new Stop(0.94, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.96, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1)), new Stop(0.97, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        FOREGROUND.setFill((Paint)GRADIENT);
        FOREGROUND.setStroke(null);
        this.foreground.getChildren().addAll((Object[])new Node[]{FOREGROUND});
        this.foreground.setCache(true);
    }

    public void drawPanel() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth() - 2.0 * (0.0841121495 * SIZE + 5.0);
        double HEIGHT = this.gaugeBounds.getHeight() - 2.0 * (0.0841121495 * SIZE + 5.0);
        this.matrix.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0841121495 * SIZE + 5.0, 0.0841121495 * SIZE + 5.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.matrix.getChildren().add((Object)IBOUNDS);
        double gapW = this.radio = WIDTH / (3.0 * this.ledWidth.doubleValue() + 1.0);
        double gapH = (HEIGHT - 2.0 * this.radio * this.ledHeight.doubleValue()) / (this.ledHeight.doubleValue() + 1.0);
        this.dots.getChildren().clear();
        this.dotMap = new HashMap<Integer, Shape>(this.ledWidth.intValue() * this.ledHeight.intValue());
        for (int i = 0; i < this.ledHeight.intValue(); ++i) {
            for (int j = 0; j < this.ledWidth.intValue(); ++j) {
                Circle circ = new Circle(0.0841121495 * SIZE + 5.0 + gapW + this.radio + (double)j * (gapW + 2.0 * this.radio), 0.0841121495 * SIZE + 5.0 + gapH + this.radio + (double)i * (gapH + 2.0 * this.radio), this.radio, (Paint)Color.DARKGREY);
                circ.setFill((Paint)this.COLOR_OFF);
                this.dotMap.put(new Integer(j + i * this.ledWidth.intValue()), (Shape)circ);
                this.dots.getChildren().add((Object)circ);
            }
        }
        this.dots.setCache(true);
        this.matrix.getChildren().add((Object)this.dots);
    }

    public void updatePanel() {
        if (this.contents == null) {
            return;
        }
        this.stop();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int contAreas = 0;
                MatrixPanelSkin.this.fullAreas = new ArrayList();
                MatrixPanelSkin.this.pairs = new ArrayList();
                MatrixPanelSkin.access$302(MatrixPanelSkin.this, new Rectangle[MatrixPanelSkin.this.contents.size()]);
                for (Content content : MatrixPanelSkin.this.contents) {
                    int x0 = (int)content.getOrigin().getX() + (int)content.getArea().getX();
                    int y0 = (int)content.getOrigin().getY() + (int)content.getArea().getY();
                    int maxX = Math.min((int)content.getArea().getWidth(), MatrixPanelSkin.this.ledWidth.intValue());
                    int maxY = Math.min((int)content.getArea().getHeight(), MatrixPanelSkin.this.ledHeight.intValue());
                    ((MatrixPanelSkin)MatrixPanelSkin.this).visibleArea[contAreas] = new Rectangle((double)Math.max(x0, 0), (double)Math.max(y0, 0), (double)maxX, (double)maxY);
                    if (content.getType().equals((Object)Content.Type.IMAGE)) {
                        UtilHex img = new UtilHex();
                        img.convertsBmp(content.getBmpName(), 65, 190, true, true, true);
                        String sBytes = img.getRawData();
                        if (sBytes != null) {
                            String[] v = sBytes.split("\\s");
                            int levels = 3;
                            int bmpHeight = UtilHex.word2Int(v[8], v[9]);
                            int tamLineaBMT = (int)(UtilHex.dword2Long(v[20], v[21], v[22], v[23]) / (long)bmpHeight / 3L / 3L);
                            int pos = 32;
                            int[][] area = new int[bmpHeight][tamLineaBMT * 8];
                            int[] colors = new int[]{content.getColor().equals((Object)Content.MatrixColor.RED) || content.getColor().equals((Object)Content.MatrixColor.YELLOW) || content.getColor().equals((Object)Content.MatrixColor.RGB) ? 1 : 0, content.getColor().equals((Object)Content.MatrixColor.GREEN) || content.getColor().equals((Object)Content.MatrixColor.YELLOW) || content.getColor().equals((Object)Content.MatrixColor.RGB) ? 1 : 0, content.getColor().equals((Object)Content.MatrixColor.BLUE) || content.getColor().equals((Object)Content.MatrixColor.RGB) ? 1 : 0};
                            for (int j = 0; j < 3; ++j) {
                                for (int k = 0; k < 3; ++k) {
                                    for (int fila = 0; fila < bmpHeight; ++fila) {
                                        for (int i = 0; i < tamLineaBMT; ++i) {
                                            String bits = UtilHex.hex2bin(v[pos++]);
                                            for (int m = 0; m < 8; ++m) {
                                                int[] nArray = area[fila];
                                                int n = i * 8 + m;
                                                nArray[n] = (int)((double)nArray[n] + (double)(bits.substring(m, m + 1).equalsIgnoreCase("1") ? 1 : 0) * Math.pow(10.0, k) * (double)colors[k]);
                                            }
                                        }
                                    }
                                }
                            }
                            MatrixPanelSkin.this.fullAreas.add(contAreas, area);
                        } else {
                            MatrixPanelSkin.this.fullAreas.add(contAreas, null);
                        }
                    } else if (content.getType().equals((Object)Content.Type.TEXT)) {
                        MatrixPanel.DotFont dotF = new MatrixPanel.DotFont(content.getTxtContent(), content.getMatrixFont(), content.getFontGap().getGapWidth());
                        boolean[][] bDots = dotF.getDotString();
                        if (bDots != null) {
                            int color = content.getColor().equals((Object)Content.MatrixColor.RED) ? 3 : (content.getColor().equals((Object)Content.MatrixColor.GREEN) ? 30 : (content.getColor().equals((Object)Content.MatrixColor.BLUE) ? 300 : (content.getColor().equals((Object)Content.MatrixColor.YELLOW) ? 33 : 333)));
                            int[][] area = new int[bDots.length][bDots[0].length];
                            for (int fila = 0; fila < bDots.length; ++fila) {
                                for (int j = 0; j < bDots[fila].length; ++j) {
                                    area[fila][j] = bDots[fila][j] ? color : 0;
                                }
                            }
                            MatrixPanelSkin.this.fullAreas.add(contAreas, area);
                        } else {
                            MatrixPanelSkin.this.fullAreas.add(contAreas, null);
                        }
                    }
                    ++contAreas;
                }
                block8: for (Content content1 : MatrixPanelSkin.this.contents) {
                    if (!content1.getOrder().equals((Object)Content.RotationOrder.FIRST)) continue;
                    int iContent1 = MatrixPanelSkin.this.contents.indexOf((Object)content1);
                    for (Content content2 : MatrixPanelSkin.this.contents) {
                        int iContent2 = MatrixPanelSkin.this.contents.indexOf((Object)content2);
                        if (!content2.getOrder().equals((Object)Content.RotationOrder.SECOND) || !content1.getArea().getBoundsInLocal().equals(content2.getArea().getBoundsInLocal())) continue;
                        ContentPair pair = new ContentPair(iContent1, iContent2);
                        MatrixPanelSkin.this.pairs.add(pair);
                        continue block8;
                    }
                }
                MatrixPanelSkin.access$702(MatrixPanelSkin.this, (BooleanProperty[])new SimpleBooleanProperty[MatrixPanelSkin.this.contents.size()]);
                for (Shape entry : MatrixPanelSkin.this.dotMap.values()) {
                    ((Circle)entry).setFill((Paint)MatrixPanelSkin.this.COLOR_OFF);
                }
                MatrixPanelSkin.this.Anim = new ArrayList();
                for (Content content : MatrixPanelSkin.this.contents) {
                    int iContent = MatrixPanelSkin.this.contents.indexOf((Object)content);
                    if (MatrixPanelSkin.this.fullAreas.get(iContent) == null) continue;
                    Animation iAnim = new Animation(iContent, content);
                    iAnim.initAnimation();
                    MatrixPanelSkin.this.Anim.add(iAnim);
                }
                for (Animation a : MatrixPanelSkin.this.Anim) {
                    a.start();
                }
            }
        });
    }

    public void stop() {
        if (this.Anim != null) {
            for (Animation a : this.Anim) {
                a.stop();
            }
            this.Anim.clear();
            this.Anim = null;
        }
    }

    static /* synthetic */ Rectangle[] access$302(MatrixPanelSkin x0, Rectangle[] x1) {
        x0.visibleArea = x1;
        return x1;
    }

    static /* synthetic */ BooleanProperty[] access$702(MatrixPanelSkin x0, BooleanProperty[] x1) {
        x0.visibleContent = x1;
        return x1;
    }

    private static class ContentPair {
        private int indexFirst;
        private int indexSecond;
        private boolean bVisibleFirst;

        public ContentPair(int index1, int index2) {
            this.indexFirst = index1;
            this.bVisibleFirst = true;
            this.indexSecond = index2;
        }

        public void setFirstIndex(int index) {
            this.indexFirst = index;
            this.bVisibleFirst = true;
        }

        public void setSecondIndex(int index) {
            this.indexSecond = index;
        }

        public void changeIndex() {
            this.bVisibleFirst = !this.bVisibleFirst;
        }

        public int getFirstIndex() {
            return this.indexFirst;
        }

        public int getSecondIndex() {
            return this.indexSecond;
        }

        public boolean isVisibleFirst() {
            return this.bVisibleFirst;
        }

        public boolean isVisibleSecond() {
            return !this.bVisibleFirst;
        }

        private boolean isInPair(int iContent) {
            return this.indexFirst == iContent || this.indexSecond == iContent;
        }
    }

    private class Animation
    extends AnimationTimer {
        private long lastUpdate = 0L;
        private boolean bBlink = false;
        private int contBlink = 0;
        private int iter = 0;
        private int iContent;
        private Content content = null;
        private int oriX;
        private int oriY;
        private int endX;
        private int endY;
        private int areaWidth;
        private int areaHeight;
        private int contentWidth;
        private int contentHeight;
        private IntegerProperty posX;
        private IntegerProperty posY;
        private IntegerProperty posXIni;
        private IntegerProperty posYIni;
        private int[][] contentArea = null;
        private int realLapse;
        private int advance;
        private int limX;
        private int limitBlink;
        private int iterLeds;
        private boolean isBlinkEffect;
        private LinkedHashMap<Integer, int[]> brightLeds = null;
        private ArrayList<int[]> arrBrightLeds = null;
        private IntegerProperty incrPos = null;

        public Animation(int iContent, Content theContent) {
            this.iContent = iContent;
            this.content = theContent;
            this.incrPos = new SimpleIntegerProperty(1);
            ((MatrixPanelSkin)MatrixPanelSkin.this).visibleContent[iContent] = new SimpleBooleanProperty(true);
            if (this.content.getOrder().equals((Object)Content.RotationOrder.SECOND)) {
                MatrixPanelSkin.this.visibleContent[iContent].setValue(Boolean.valueOf(false));
            }
        }

        public void initAnimation() {
            this.contentArea = (int[][])MatrixPanelSkin.this.fullAreas.get(this.iContent);
            this.oriX = (int)MatrixPanelSkin.this.visibleArea[this.iContent].getX();
            this.oriY = (int)MatrixPanelSkin.this.visibleArea[this.iContent].getY();
            this.endX = (int)MatrixPanelSkin.this.visibleArea[this.iContent].getWidth();
            this.endY = (int)MatrixPanelSkin.this.visibleArea[this.iContent].getHeight();
            this.areaWidth = this.endX - this.oriX;
            this.areaHeight = this.endY - this.oriY;
            this.contentWidth = this.contentArea[0].length;
            this.contentHeight = this.contentArea.length;
            this.posXIni = new SimpleIntegerProperty(0);
            this.posYIni = new SimpleIntegerProperty(0);
            this.posYIni.set(0);
            if (this.content.getTxtAlign().equals((Object)Content.Align.LEFT)) {
                this.posXIni.set(0);
                this.limX = 0;
            } else if (this.content.getTxtAlign().equals((Object)Content.Align.CENTER)) {
                this.posXIni.set(this.contentWidth / 2 - this.areaWidth / 2);
                this.limX = -this.areaWidth / 2 + this.contentWidth / 2;
            } else if (this.content.getTxtAlign().equals((Object)Content.Align.RIGHT)) {
                this.posXIni.set(this.contentWidth - this.areaWidth);
                this.limX = this.contentWidth - this.areaWidth;
            }
            if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_RIGHT)) {
                this.posXIni.set(this.contentWidth);
            } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_LEFT)) {
                this.posXIni.set(-this.areaWidth);
            } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_UP)) {
                this.posYIni.set(-this.areaHeight);
            } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_DOWN)) {
                this.posYIni.set(this.contentHeight);
            } else if (this.content.getEffect().equals((Object)Content.Effect.MIRROR)) {
                if (this.content.getTxtAlign().equals((Object)Content.Align.LEFT)) {
                    this.posXIni.set(-this.contentWidth / 2);
                } else if (this.content.getTxtAlign().equals((Object)Content.Align.CENTER)) {
                    this.posXIni.set(0 - this.areaWidth / 2);
                } else if (this.content.getTxtAlign().equals((Object)Content.Align.RIGHT)) {
                    this.posXIni.set(this.contentWidth / 2 - this.areaWidth);
                }
            }
            this.posX = new SimpleIntegerProperty(this.posXIni.get());
            this.posY = new SimpleIntegerProperty(this.posYIni.get());
            int n = this.realLapse = this.content.getLapse() >= 250 ? this.content.getLapse() : 250;
            if (this.content.getLapse() > 0) {
                this.advance = this.realLapse / this.content.getLapse();
                this.realLapse = this.advance * this.content.getLapse();
            } else {
                this.advance = 10;
            }
            boolean bl = this.isBlinkEffect = this.content.getEffect().equals((Object)Content.Effect.BLINK) || this.content.getEffect().equals((Object)Content.Effect.BLINK_4) || this.content.getEffect().equals((Object)Content.Effect.BLINK_10);
            int n2 = this.content.getEffect().equals((Object)Content.Effect.BLINK) ? 10000 : (this.content.getEffect().equals((Object)Content.Effect.BLINK_4) ? 7 : (this.limitBlink = this.content.getEffect().equals((Object)Content.Effect.BLINK_10) ? 19 : 0));
            if (this.content.getEffect().equals((Object)Content.Effect.SPRAY)) {
                this.brightLeds = new LinkedHashMap();
                this.arrBrightLeds = new ArrayList();
                for (int i = this.oriY; i < this.endY; ++i) {
                    for (int j = this.oriX; j < this.endX; ++j) {
                        Integer dot = new Integer(j + i * MatrixPanelSkin.this.ledWidth.intValue());
                        if (MatrixPanelSkin.this.dotMap.get(dot) == null) continue;
                        int val = 0;
                        if (j + this.posX.intValue() < this.oriX || j + this.posX.intValue() >= this.contentWidth + this.oriX || i + this.posY.intValue() < this.oriY || i + this.posY.intValue() >= this.contentHeight + this.oriY || (val = this.contentArea[i + this.posY.intValue() - this.oriY][j + this.posX.intValue() - this.oriX]) <= 0) continue;
                        int[] led = new int[]{j, i, val};
                        this.arrBrightLeds.add(led);
                    }
                }
                Collections.shuffle(this.arrBrightLeds);
                Iterator<int[]> vIter = this.arrBrightLeds.iterator();
                for (int k = 0; k < this.arrBrightLeds.size(); ++k) {
                    this.brightLeds.put(k, vIter.next());
                }
                this.arrBrightLeds.clear();
                this.iterLeds = this.brightLeds.size() / this.advance;
            }
        }

        public void handle(long now) {
            if (now > this.lastUpdate + (long)(this.realLapse * 1000000) && MatrixPanelSkin.this.visibleContent[this.iContent].getValue().booleanValue() && this.incrPos.intValue() == 1) {
                if (this.content.getEffect().equals((Object)Content.Effect.SPRAY)) {
                    for (int buc = 0; buc < this.iterLeds; ++buc) {
                        int[] led = this.brightLeds.get(this.brightLeds.size() - this.iter - 1);
                        int toneB = led[2] / 100;
                        int toneG = (led[2] - toneB * 100) / 10;
                        int toneR = led[2] - toneB * 100 - toneG * 10;
                        Integer dot = new Integer(led[0] + led[1] * MatrixPanelSkin.this.ledWidth.intValue());
                        ((Circle)MatrixPanelSkin.this.dotMap.get(dot)).setFill((Paint)Color.rgb((int)(85 * toneR), (int)(85 * toneG), (int)(85 * toneB)));
                        this.iter = this.iter < this.brightLeds.size() - 1 ? this.iter + 1 : this.iter;
                    }
                } else {
                    for (int j = this.oriX; j < this.endX; ++j) {
                        for (int i = this.oriY; i < this.endY; ++i) {
                            Integer dot = new Integer(j + i * MatrixPanelSkin.this.ledWidth.intValue());
                            if (MatrixPanelSkin.this.dotMap.get(dot) == null) continue;
                            int pos = this.posX.intValue();
                            if (this.content.getEffect().equals((Object)Content.Effect.MIRROR)) {
                                if (this.content.getTxtAlign().equals((Object)Content.Align.LEFT) && j - this.oriX > this.contentWidth / 2) {
                                    pos = -pos;
                                } else if (this.content.getTxtAlign().equals((Object)Content.Align.CENTER) && (double)(j - this.oriX) > (double)this.areaWidth / 2.0) {
                                    pos = -pos - this.areaWidth + this.contentWidth;
                                } else if (this.content.getTxtAlign().equals((Object)Content.Align.RIGHT) && j - this.oriX > -this.contentWidth / 2 + this.areaWidth) {
                                    pos = -pos + 2 * (this.contentWidth - this.areaWidth);
                                }
                            }
                            int val = 0;
                            if (j + pos >= this.oriX && j + pos < this.contentWidth + this.oriX && i + this.posY.intValue() >= this.oriY && i + this.posY.intValue() < this.contentHeight + this.oriY) {
                                val = this.contentArea[i + this.posY.intValue() - this.oriY][j + pos - this.oriX];
                            }
                            if (val > 0 && !this.isBlinkEffect || val > 0 && this.isBlinkEffect && this.bBlink) {
                                int toneB = val / 100;
                                int toneG = (val - toneB * 100) / 10;
                                int toneR = val - toneB * 100 - toneG * 10;
                                ((Circle)MatrixPanelSkin.this.dotMap.get(dot)).setFill((Paint)Color.rgb((int)(85 * toneR), (int)(85 * toneG), (int)(85 * toneB)));
                                continue;
                            }
                            ((Circle)MatrixPanelSkin.this.dotMap.get(dot)).setFill((Paint)MatrixPanelSkin.this.COLOR_OFF);
                        }
                    }
                }
                boolean endRotation = false;
                if (this.content.getEffect().equals((Object)Content.Effect.NONE)) {
                    endRotation = true;
                } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_RIGHT)) {
                    boolean bl = endRotation = this.posX.intValue() <= this.limX;
                    if (this.posX.intValue() - this.advance * this.incrPos.getValue() <= this.limX) {
                        this.posX.set(this.limX);
                    } else {
                        this.posX.set(this.posX.intValue() - this.advance * this.incrPos.getValue());
                    }
                } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_LEFT) || this.content.getEffect().equals((Object)Content.Effect.MIRROR)) {
                    boolean bl = endRotation = this.posX.intValue() >= this.limX;
                    if (this.posX.intValue() + this.advance * this.incrPos.getValue() >= this.limX) {
                        this.posX.set(this.limX);
                    } else {
                        this.posX.set(this.posX.intValue() + this.advance * this.incrPos.getValue());
                    }
                } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_DOWN)) {
                    this.posY.set(this.posY.intValue() - this.incrPos.getValue());
                    endRotation = this.posY.intValue() < 0;
                } else if (this.content.getEffect().equals((Object)Content.Effect.SCROLL_UP)) {
                    this.posY.set(this.posY.intValue() + this.incrPos.getValue());
                    endRotation = this.posY.intValue() > 0;
                } else if (this.isBlinkEffect) {
                    if (this.contBlink == this.limitBlink) {
                        endRotation = true;
                        this.contBlink = -1;
                    } else if (this.incrPos.getValue() == 1) {
                        endRotation = false;
                        ++this.contBlink;
                        this.bBlink = !this.bBlink;
                    }
                } else if (this.content.getEffect().equals((Object)Content.Effect.SPRAY)) {
                    if (this.iter >= this.brightLeds.size() - 1) {
                        endRotation = true;
                        this.iter = 0;
                    } else {
                        endRotation = false;
                    }
                }
                if (endRotation) {
                    if (this.content.getPostEffect().equals((Object)Content.PostEffect.STOP)) {
                        this.stop();
                    } else if (this.content.getPostEffect().equals((Object)Content.PostEffect.REPEAT) || this.content.getPostEffect().equals((Object)Content.PostEffect.PAUSE)) {
                        this.posX.set(this.posXIni.get());
                        this.posY.set(this.posYIni.get());
                        this.incrPos.setValue((Number)0);
                        PauseTransition t = new PauseTransition();
                        if (this.content.getPostEffect().equals((Object)Content.PostEffect.REPEAT)) {
                            t.setDuration(Duration.millis((double)10.0));
                        } else {
                            t.setDuration(Duration.millis((double)this.content.getPause()));
                        }
                        t.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                Animation.this.incrPos.setValue((Number)1);
                                if (Animation.this.content.getClear() || Animation.this.content.getEffect().equals((Object)Content.Effect.SPRAY)) {
                                    for (int i = Animation.this.oriY; i < Animation.this.endY; ++i) {
                                        for (int j = Animation.this.oriX; j < Animation.this.endX; ++j) {
                                            Integer dot = new Integer(j + i * MatrixPanelSkin.this.ledWidth.intValue());
                                            ((Circle)MatrixPanelSkin.this.dotMap.get(dot)).setFill((Paint)MatrixPanelSkin.this.COLOR_OFF);
                                        }
                                    }
                                }
                                if (!Animation.this.content.getOrder().equals((Object)Content.RotationOrder.SINGLE)) {
                                    for (ContentPair pair : MatrixPanelSkin.this.pairs) {
                                        if (!pair.isInPair(Animation.this.iContent)) continue;
                                        MatrixPanelSkin.this.visibleContent[pair.getFirstIndex()].setValue(Boolean.valueOf(!pair.isVisibleFirst()));
                                        MatrixPanelSkin.this.visibleContent[pair.getSecondIndex()].setValue(Boolean.valueOf(!pair.isVisibleSecond()));
                                        ((ContentPair)MatrixPanelSkin.this.pairs.get(MatrixPanelSkin.this.pairs.indexOf(pair))).changeIndex();
                                        break;
                                    }
                                }
                            }
                        });
                        t.playFromStart();
                    }
                }
                this.lastUpdate = now;
            }
        }
    }
}

