/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.skin.ButtonSkin;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import jfxtras.labs.scene.control.MiniIconButton;

public class MiniIconButtonSkin
extends ButtonSkin {
    private final TranslateTransition jumpTransition = new TranslateTransition();
    private final Timeline blinkTimeline = new Timeline();
    private KeyFrame kf;
    private static final double JUMP_DISTANCE = 4.0;
    private static final double MARGIN = 6.0;
    private static final double MINIMUM_OPACITY_FOR_BLINKING = 0.0;

    public MiniIconButtonSkin(MiniIconButton miniIconButton) {
        super((Button)miniIconButton);
        this.setMiniIcon(miniIconButton.getMiniIcon());
        this.positionMiniIcon(miniIconButton);
        this.calculateAndSetNewMiniIconSize(miniIconButton);
        this.defaultConfigJumpingAnimation();
        this.defaultConfigBlinkingAnimation();
        this.configureJumping(miniIconButton);
        this.configureBlinking(miniIconButton);
        this.startAnimation(miniIconButton);
        this.addImageViewSizeBindings();
        this.addChangeListeners();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        MiniIconButton miniIconButton = (MiniIconButton)this.getSkinnable();
        ImageView miniIcon = miniIconButton.getMiniIcon();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = 0.0;
        double left = 0.0;
        double baselineOffset = this.getBaselineOffset();
        Pos childAlignment = StackPane.getAlignment((Node)miniIcon);
        this.layoutInArea((Node)miniIcon, 0.0, 0.0, width, height, baselineOffset, MiniIconButtonSkin.getMargin((Node)miniIcon), childAlignment != null ? childAlignment.getHpos() : this.getAlignment().getHpos(), childAlignment != null ? childAlignment.getVpos() : this.getAlignment().getVpos());
    }

    private void addChangeListeners() {
        final MiniIconButton miniIconButton = (MiniIconButton)this.getSkinnable();
        miniIconButton.animationDurationProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldDuraction, Number newDuration) {
                MiniIconButtonSkin.this.stopAnimation(miniIconButton);
                MiniIconButtonSkin.this.configureJumping(miniIconButton);
                MiniIconButtonSkin.this.configureBlinking(miniIconButton);
                MiniIconButtonSkin.this.startAnimation(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
        miniIconButton.animationTypeProperty().addListener((ChangeListener)new ChangeListener<MiniIconButton.AnimationType>(){

            public void changed(ObservableValue<? extends MiniIconButton.AnimationType> observableValue, MiniIconButton.AnimationType oldAnimationType, MiniIconButton.AnimationType newAnimationType) {
                MiniIconButtonSkin.this.startAnimation(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
        miniIconButton.miniIconPositionProperty().addListener((ChangeListener)new ChangeListener<Pos>(){

            public void changed(ObservableValue<? extends Pos> observableValue, Pos oldPosition, Pos newPosition) {
                StackPane.setAlignment((Node)miniIconButton.getMiniIcon(), (Pos)newPosition);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
        miniIconButton.miniIconProperty().addListener((ChangeListener)new ChangeListener<ImageView>(){

            public void changed(ObservableValue<? extends ImageView> observableValue, ImageView oldMiniIcon, ImageView newMiniIcon) {
                MiniIconButtonSkin.this.stopAnimation(miniIconButton);
                MiniIconButtonSkin.this.changeMiniIcon(oldMiniIcon, newMiniIcon);
                MiniIconButtonSkin.this.positionMiniIcon(miniIconButton);
                MiniIconButtonSkin.this.configureJumping(miniIconButton);
                MiniIconButtonSkin.this.configureBlinking(miniIconButton);
                MiniIconButtonSkin.this.calculateAndSetNewMiniIconSize(miniIconButton);
                MiniIconButtonSkin.this.startAnimation(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
        miniIconButton.miniIconRatioProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldNumber, Number newNumber) {
                MiniIconButtonSkin.this.stopAnimation(miniIconButton);
                MiniIconButtonSkin.this.calculateAndSetNewMiniIconSize(miniIconButton);
                MiniIconButtonSkin.this.startAnimation(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
    }

    private void changeMiniIcon(ImageView oldMiniIcon, ImageView newMiniIcon) {
        this.getChildren().remove((Object)oldMiniIcon);
        this.setMiniIcon(newMiniIcon);
    }

    private void setMiniIcon(ImageView miniIcon) {
        this.getChildren().add((Object)miniIcon);
    }

    private void configureBlinking(MiniIconButton miniIconButton) {
        this.blinkTimeline.getKeyFrames().remove((Object)this.kf);
        KeyValue kv = new KeyValue((WritableValue)miniIconButton.getMiniIcon().opacityProperty(), (Object)0.0);
        this.kf = new KeyFrame(Duration.millis((double)miniIconButton.getAnimationDuration()), new KeyValue[]{kv});
        this.blinkTimeline.getKeyFrames().add((Object)this.kf);
    }

    private void configureJumping(MiniIconButton miniIconButton) {
        ImageView miniIcon = miniIconButton.getMiniIcon();
        this.jumpTransition.setNode((Node)miniIcon);
        this.jumpTransition.setDuration(Duration.millis((double)miniIconButton.getAnimationDuration()));
    }

    private void positionMiniIcon(MiniIconButton miniIconButton) {
        ImageView miniIcon = miniIconButton.getMiniIcon();
        StackPane.setAlignment((Node)miniIcon, (Pos)miniIconButton.getMiniIconPosition());
        StackPane.setMargin((Node)miniIcon, (Insets)new Insets(6.0, 6.0, 6.0, 6.0));
    }

    private void addImageViewSizeBindings() {
        final MiniIconButton miniIconButton = (MiniIconButton)this.getSkinnable();
        this.widthProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue o, Object oldVal, Object newVal) {
                MiniIconButtonSkin.this.calculateAndSetNewMiniIconSize(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
        this.heightProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue o, Object oldVal, Object newVal) {
                MiniIconButtonSkin.this.calculateAndSetNewMiniIconSize(miniIconButton);
                MiniIconButtonSkin.this.requestLayout();
            }
        });
    }

    private void calculateAndSetNewMiniIconSize(MiniIconButton miniIconButton) {
        ImageView miniIcon = miniIconButton.getMiniIcon();
        double buttonWidth = this.getWidth() * miniIconButton.getMiniIconRatio();
        double buttonHeight = this.getHeight() * miniIconButton.getMiniIconRatio();
        double fitWidth = buttonWidth;
        double fitHeight = buttonHeight;
        if (miniIcon.getImage() != null) {
            double originalWidth = miniIcon.getImage().getWidth();
            double originalHeight = miniIcon.getImage().getHeight();
            fitWidth = Math.min(originalWidth, buttonWidth);
            fitHeight = Math.min(originalHeight, buttonHeight);
        }
        miniIcon.setPreserveRatio(true);
        if (fitWidth > 0.0) {
            miniIcon.setFitWidth(fitWidth);
        }
        if (fitHeight > 0.0) {
            miniIcon.setFitHeight(fitHeight);
        }
    }

    private void startAnimation(MiniIconButton miniIconButton) {
        switch (miniIconButton.getAnimationType()) {
            case BLINK: {
                this.jumpTransition.stop();
                this.blinkTimeline.play();
                break;
            }
            case JUMP: {
                this.blinkTimeline.stop();
                this.jumpTransition.play();
                break;
            }
            default: {
                this.blinkTimeline.stop();
                this.jumpTransition.stop();
            }
        }
    }

    private void stopAnimation(MiniIconButton miniIconButton) {
        ImageView miniIcon = miniIconButton.getMiniIcon();
        this.jumpTransition.stop();
        this.blinkTimeline.stop();
        miniIcon.setOpacity(1.0);
        miniIcon.setTranslateY(0.0);
    }

    private void defaultConfigJumpingAnimation() {
        double start = 0.0;
        double end = -4.0;
        this.jumpTransition.setFromY(0.0);
        this.jumpTransition.setToY(-4.0);
        this.jumpTransition.setCycleCount(-1);
        this.jumpTransition.setAutoReverse(true);
        this.jumpTransition.setInterpolator(Interpolator.EASE_BOTH);
    }

    private void defaultConfigBlinkingAnimation() {
        this.blinkTimeline.setCycleCount(-1);
        this.blinkTimeline.setAutoReverse(true);
    }
}

