/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.OdometerBehavior;
import jfxtras.labs.scene.control.gauge.Odometer;

public class OdometerSkin
extends SkinBase<Odometer, OdometerBehavior> {
    private Odometer control;
    private boolean isDirty;
    private boolean initialized;
    private Group foreground;
    private List<Dial> listOfDials;
    private Group background;
    private Font font;

    public OdometerSkin(Odometer CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new OdometerBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.foreground = new Group();
        this.listOfDials = new LinkedList<Dial>();
        this.background = new Group();
        this.init();
    }

    private void init() {
        double prefWidth = this.control.getPrefWidth();
        double prefHeight = this.control.getPrefHeight();
        if (prefWidth <= 0.0) {
            if (prefHeight <= 0.0) {
                prefHeight = 40.0;
            }
            prefWidth = 0.5925925925925926 * prefHeight * (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals());
        }
        if (prefHeight <= 0.0) {
            if (prefWidth <= 0.0) {
                prefWidth = 23.703703703703702 * (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals());
            }
            prefHeight = prefWidth / (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals()) * 1.6875;
        }
        this.control.setPrefSize(prefWidth, prefHeight);
        this.registerChangeListener((ObservableValue)this.control.rotationsProperty(), "ROTATION");
        this.registerChangeListener((ObservableValue)this.control.rotationPresetProperty(), "ROTATION_PRESET");
        this.registerChangeListener((ObservableValue)this.control.noOfDigitsProperty(), "NO_OF_DIGITS");
        this.registerChangeListener((ObservableValue)this.control.noOfDecimalsProperty(), "NO_OF_DECIMALS");
        this.registerChangeListener((ObservableValue)this.control.decimalColorProperty(), "DECIMAL_COLOR");
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("ROTATION_PRESET".equals(PROPERTY)) {
            String rot = Integer.toString(this.control.getRotations());
            int noOfDials = this.control.getNoOfDigits() + this.control.getNoOfDecimals();
            if (rot.length() > noOfDials) {
                rot = rot.substring(rot.length() - noOfDials);
            } else if (rot.length() < noOfDials) {
                StringBuilder rotSB = new StringBuilder(noOfDials);
                for (int i = 0; i < noOfDials - rot.length(); ++i) {
                    rotSB.append("0");
                }
                rotSB.append(rot);
                rot = rotSB.toString();
            }
            int index = this.listOfDials.size() - 1;
            for (char c : rot.toCharArray()) {
                this.listOfDials.get(index).setToNumber(Integer.parseInt(String.valueOf(c)));
                --index;
            }
        } else if ("ROTATION".equals(PROPERTY)) {
            for (int i = 1; i < this.control.getNoOfDigits() + this.control.getNoOfDecimals() + 1; ++i) {
                if (this.control.getRotations() == 0) {
                    this.listOfDials.get(i - 1).reset();
                    continue;
                }
                this.listOfDials.get(i - 1).setNumber(this.control.getDialPosition(i));
            }
        } else if ("NO_OF_DIGITS".equals(PROPERTY)) {
            this.control.setPrefSize(0.5925925925925926 * this.getPrefHeight() * (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals()), this.getPrefHeight());
            this.repaint();
        } else if ("NO_OF_DECIMALS".equals(PROPERTY)) {
            this.control.setPrefSize(0.5925925925925926 * this.getPrefHeight() * (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals()), this.getPrefHeight());
            this.repaint();
        } else if ("DECIMAL_COLOR".equals(PROPERTY)) {
            this.repaint();
        } else if ("COLOR".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            double prefHeight = this.control.getPrefWidth() / (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals()) * 1.6875;
            if (Double.compare(this.control.getPrefHeight(), prefHeight) != 0) {
                this.control.setPrefHeight(prefHeight);
            }
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            double prefWidth = this.control.getPrefHeight() * 0.5925925925925926 * (double)(this.control.getNoOfDigits() + this.control.getNoOfDecimals());
            if (Double.compare(this.control.getPrefWidth(), prefWidth) != 0) {
                this.control.setPrefWidth(prefWidth);
            }
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.font = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/droidsansmono.ttf"), (double)(0.85 * this.control.getPrefHeight()));
            this.setClip((Node)new Rectangle(0.0, 1.0, this.control.getPrefWidth(), this.control.getPrefHeight()));
            this.getChildren().clear();
            this.drawBackground();
            this.setupDials();
            this.drawForeground();
            this.getChildren().add((Object)this.background);
            for (Dial dial : this.listOfDials) {
                this.getChildren().addAll((Object[])new Node[]{dial.getNextNumberGroup(), dial.getCurrentNumberGroup()});
            }
            this.getChildren().add((Object)this.foreground);
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final Odometer getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    public final void drawBackground() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        double COLUMN_WIDTH = this.control.getPrefHeight() * 0.5925925925925926;
        this.background.getChildren().clear();
        Rectangle digitBackground = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        digitBackground.setFill((Paint)this.control.getColor());
        digitBackground.setStroke(null);
        this.background.getChildren().add((Object)digitBackground);
        Rectangle decimalBackground = new Rectangle(0.0, 0.0, (double)this.control.getNoOfDecimals() * COLUMN_WIDTH, HEIGHT);
        decimalBackground.setFill((Paint)this.control.getDecimalColor());
        decimalBackground.setStroke(null);
        decimalBackground.setTranslateX(WIDTH - decimalBackground.getLayoutBounds().getWidth());
        this.background.getChildren().add((Object)decimalBackground);
        for (int i = 0; i < this.control.getNoOfDigits(); ++i) {
            Path path = new Path();
            path.setFillRule(FillRule.EVEN_ODD);
            path.getElements().add((Object)new MoveTo(0.0, 0.0));
            path.getElements().add((Object)new LineTo(0.0, HEIGHT));
            path.getElements().add((Object)new MoveTo(COLUMN_WIDTH, 0.0));
            path.getElements().add((Object)new LineTo(COLUMN_WIDTH, HEIGHT));
            path.setStrokeWidth(0.5);
            path.setStrokeType(StrokeType.CENTERED);
            path.setTranslateX((double)i * COLUMN_WIDTH);
            path.setStroke((Paint)Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.8));
            this.background.getChildren().add((Object)path);
        }
        Path path = new Path();
        path.setFillRule(FillRule.EVEN_ODD);
        path.getElements().add((Object)new MoveTo(WIDTH, 0.0));
        path.getElements().add((Object)new LineTo(WIDTH, HEIGHT));
        path.setStrokeWidth(0.5);
        path.setStrokeType(StrokeType.CENTERED);
        path.setStroke((Paint)Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.8));
        this.background.getChildren().add((Object)path);
        this.background.setCache(true);
    }

    public final void drawForeground() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.foreground.getChildren().clear();
        Rectangle OVERLAY = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        LinearGradient OVERLAY_FILL = new LinearGradient(0.0, 0.0, 0.0, HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.15, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.4)), new Stop(0.33, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.45)), new Stop(0.46, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.85, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.4)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0))});
        OVERLAY.setFill((Paint)OVERLAY_FILL);
        OVERLAY.setStroke(null);
        this.foreground.getChildren().add((Object)OVERLAY);
    }

    public final void setupDials() {
        double COLUMN_WIDTH = this.control.getPrefHeight() * 0.5925925925925926;
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        for (int i = 0; i < this.control.getNoOfDigits() + this.control.getNoOfDecimals(); ++i) {
            double offsetX = WIDTH / 2.0 - (double)(i + 1) * COLUMN_WIDTH + COLUMN_WIDTH / 2.0;
            Color numberColor = i < this.control.getNoOfDecimals() ? this.control.getNumberDecimalColor() : this.control.getNumberColor();
            Dial dial = new Dial(numberColor, offsetX, HEIGHT);
            this.listOfDials.add(dial);
        }
    }

    private class Dial {
        private Group nextNumberGroup;
        private Text nextNumber = new Text();
        private Group currentNumberGroup;
        private Text currentNumber;
        private TranslateTransition next;
        private TranslateTransition current;
        private ParallelTransition parallel;

        protected Dial(Color NUMBER_COLOR, double OFFSET_X, double HEIGHT) {
            this.nextNumberGroup = this.createGroup(NUMBER_COLOR, this.nextNumber, 1, OFFSET_X, -HEIGHT);
            this.currentNumber = new Text();
            this.currentNumberGroup = this.createGroup(NUMBER_COLOR, this.currentNumber, 0, OFFSET_X, 0.0);
            this.next = new TranslateTransition(Duration.millis((double)OdometerSkin.this.control.getInterval()), (Node)this.nextNumberGroup);
            this.current = new TranslateTransition(Duration.millis((double)OdometerSkin.this.control.getInterval()), (Node)this.currentNumberGroup);
            this.next.setFromY(-OdometerSkin.this.control.getPrefHeight());
            this.next.setToY(0.0);
            this.next.setInterpolator(Interpolator.LINEAR);
            this.current.setFromY(0.0);
            this.current.setToY(OdometerSkin.this.control.getPrefHeight());
            this.current.setInterpolator(Interpolator.LINEAR);
            this.current.setDelay(Duration.ZERO);
            this.parallel = new ParallelTransition(new Animation[]{this.next, this.current});
        }

        protected void setNumber(int NUMBER) {
            if (this.parallel.getStatus() == Animation.Status.RUNNING) {
                this.parallel.stop();
                this.increaseNumbers();
            }
            if (!Integer.toString(NUMBER).equals(this.currentNumber.getText())) {
                this.parallel.play();
                this.parallel.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        Dial.this.increaseNumbers();
                    }
                });
            }
        }

        protected void reset() {
            this.parallel.stop();
            this.nextNumberGroup.setTranslateY(-OdometerSkin.this.control.getPrefHeight());
            this.nextNumber.setText("1");
            this.currentNumberGroup.setTranslateY(0.0);
            this.currentNumber.setText("0");
        }

        protected void setToNumber(int NUMBER) {
            int thisNumber = NUMBER < 0 ? 0 : (NUMBER > 9 ? 9 : NUMBER);
            int commingNumber = thisNumber + 1 > 9 ? 0 : thisNumber + 1;
            this.parallel.stop();
            this.nextNumberGroup.setTranslateY(-OdometerSkin.this.control.getPrefHeight());
            this.nextNumber.setText(Integer.toString(commingNumber));
            this.currentNumberGroup.setTranslateY(0.0);
            this.currentNumber.setText(Integer.toString(thisNumber));
        }

        protected Group getNextNumberGroup() {
            return this.nextNumberGroup;
        }

        protected Group getCurrentNumberGroup() {
            return this.currentNumberGroup;
        }

        private Group createGroup(Color NUMBER_COLOR, Text text, int NUMBER, double OFFSET_X, double OFFSET_Y) {
            Group group = new Group();
            text.setText(Integer.toString(NUMBER));
            text.setTextAlignment(TextAlignment.CENTER);
            text.setTextOrigin(VPos.CENTER);
            text.setFont(OdometerSkin.this.font);
            text.setFill((Paint)NUMBER_COLOR);
            text.setStroke(null);
            text.setFontSmoothingType(FontSmoothingType.LCD);
            group.getChildren().addAll((Object[])new Node[]{text});
            group.setTranslateX(OFFSET_X);
            group.setTranslateY(OFFSET_Y);
            return group;
        }

        private void increaseNumbers() {
            int number = Integer.parseInt(this.nextNumber.getText());
            this.nextNumberGroup.setTranslateY(-OdometerSkin.this.control.getPrefHeight());
            this.nextNumber.setText(number == 9 ? "0" : Integer.toString(number + 1));
            this.currentNumberGroup.setTranslateY(0.0);
            this.currentNumber.setText(Integer.toString(number));
        }
    }
}

