/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.RadialQuarterEBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.RadialQuarterE;
import jfxtras.labs.scene.control.gauge.Section;

public class RadialQuarterESkin
extends GaugeSkinBase<RadialQuarterE, RadialQuarterEBehavior> {
    private static final Rectangle MIN_SIZE = new Rectangle(25.0, 25.0);
    private static final Rectangle PREF_SIZE = new Rectangle(200.0, 200.0);
    private static final Rectangle MAX_SIZE = new Rectangle(1024.0, 1024.0);
    private RadialQuarterE control;
    private Rectangle gaugeBounds;
    private Point2D framelessOffset;
    private Group frame;
    private Group background;
    private Group trend;
    private Group sections;
    private Group areas;
    private Group markers;
    private Group titleAndUnit;
    private Group tickmarks;
    private Group glowOff;
    private Group glowOn;
    private ArrayList<Color> glowColors;
    private Group knobs;
    private Group knobsShadow;
    private Group threshold;
    private Group minMeasured;
    private Group maxMeasured;
    private Group pointer;
    private Group pointerShadow;
    private Group ledOff;
    private Group ledOn;
    private Group userLedOff;
    private Group userLedOn;
    private Group foreground;
    private Point2D center;
    private Point2D rotationCenter;
    private Timeline rotationAngleTimeline;
    private DoubleProperty gaugeValue;
    private DoubleProperty currentValue;
    private DoubleProperty lcdValue;
    private FadeTransition glowPulse;
    private Rotate pointerRotation;
    private AnimationTimer ledTimer;
    private boolean ledOnVisible;
    private long lastLedTimerCall;
    private AnimationTimer userLedTimer;
    private boolean userLedOnVisible;
    private long lastUserLedTimerCall;
    private boolean isDirty;
    private boolean initialized;

    public RadialQuarterESkin(RadialQuarterE CONTROL) {
        super(CONTROL, new RadialQuarterEBehavior(CONTROL));
        this.control = CONTROL;
        this.gaugeBounds = new Rectangle(200.0, 200.0);
        this.framelessOffset = new Point2D(0.0, 0.0);
        this.center = new Point2D(0.0, 0.0);
        this.rotationCenter = new Point2D(0.0, 0.0);
        this.frame = new Group();
        this.background = new Group();
        this.trend = new Group();
        this.sections = new Group();
        this.areas = new Group();
        this.markers = new Group();
        this.titleAndUnit = new Group();
        this.tickmarks = new Group();
        this.glowOff = new Group();
        this.glowOn = new Group();
        this.glowColors = new ArrayList(4);
        this.knobs = new Group();
        this.knobsShadow = new Group(new Node[]{this.knobs});
        this.threshold = new Group();
        this.minMeasured = new Group();
        this.maxMeasured = new Group();
        this.pointer = new Group();
        this.pointerShadow = new Group(new Node[]{this.pointer});
        this.ledOff = new Group();
        this.ledOn = new Group();
        this.userLedOff = new Group();
        this.userLedOn = new Group();
        this.foreground = new Group();
        this.rotationAngleTimeline = new Timeline();
        this.gaugeValue = new SimpleDoubleProperty(0.0);
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.glowPulse = new FadeTransition(Duration.millis((double)800.0), (Node)this.glowOn);
        this.pointerRotation = new Rotate();
        this.isDirty = false;
        this.ledTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialQuarterESkin.this.lastLedTimerCall + RadialQuarterESkin.this.getBlinkInterval()) {
                    RadialQuarterESkin.this.ledOnVisible = (byte)(RadialQuarterESkin.this.ledOnVisible ^ 1);
                    if (RadialQuarterESkin.this.ledOnVisible) {
                        RadialQuarterESkin.this.ledOn.setOpacity(1.0);
                    } else {
                        RadialQuarterESkin.this.ledOn.setOpacity(0.0);
                    }
                    RadialQuarterESkin.this.lastLedTimerCall = NOW;
                }
            }
        };
        this.lastLedTimerCall = 0L;
        this.ledOnVisible = false;
        this.userLedTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialQuarterESkin.this.lastUserLedTimerCall + RadialQuarterESkin.this.getBlinkInterval()) {
                    RadialQuarterESkin.this.userLedOnVisible = (byte)(RadialQuarterESkin.this.userLedOnVisible ^ 1);
                    if (RadialQuarterESkin.this.userLedOnVisible) {
                        RadialQuarterESkin.this.userLedOn.setOpacity(1.0);
                    } else {
                        RadialQuarterESkin.this.userLedOn.setOpacity(0.0);
                    }
                    RadialQuarterESkin.this.lastUserLedTimerCall = NOW;
                }
            }
        };
        this.lastUserLedTimerCall = 0L;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.control.recalcRange();
        this.glowColors.clear();
        Color GLOW_COLOR = this.control.getGlowColor();
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowPulse.setFromValue(0.1);
        this.glowPulse.setToValue(1.0);
        this.glowPulse.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.4, (double)1.0));
        this.glowPulse.setInterpolator(Interpolator.EASE_OUT);
        this.glowPulse.setCycleCount(-1);
        this.glowPulse.setAutoReverse(true);
        if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
            if (!this.glowOn.isVisible()) {
                this.glowOn.setVisible(true);
            }
            if (this.glowOn.getOpacity() < 1.0) {
                this.glowOn.setOpacity(1.0);
            }
            this.glowPulse.play();
        } else {
            this.glowPulse.stop();
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isGlowVisible()) {
            this.glowOff.setVisible(true);
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else {
            this.glowOff.setVisible(false);
            this.glowOn.setOpacity(0.0);
        }
        this.ledOn.setOpacity(0.0);
        if (this.control.isUserLedOn()) {
            this.userLedOn.setOpacity(1.0);
        } else {
            this.userLedOn.setOpacity(0.0);
        }
        if (this.control.isUserLedBlinking()) {
            this.userLedTimer.start();
        }
        if (!this.control.getSections().isEmpty()) {
            this.updateSections();
        }
        if (!this.control.getAreas().isEmpty()) {
            this.updateAreas();
        }
        if (this.gaugeValue.get() < this.control.getMinValue()) {
            this.gaugeValue.set(this.control.getMinValue());
        } else if (this.gaugeValue.get() > this.control.getMaxValue()) {
            this.gaugeValue.set(this.control.getMaxValue());
        }
        this.control.recalcRange();
        this.control.setMinMeasuredValue(this.control.getMaxValue());
        this.control.setMaxMeasuredValue(this.control.getMinValue());
        this.addBindings();
        this.addListeners();
        this.calcGaugeBounds();
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.frame.visibleProperty().isBound()) {
            this.frame.visibleProperty().unbind();
        }
        this.frame.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
        if (this.background.visibleProperty().isBound()) {
            this.background.visibleProperty().unbind();
        }
        this.background.visibleProperty().bind((ObservableValue)this.control.backgroundVisibleProperty());
        if (this.sections.visibleProperty().isBound()) {
            this.sections.visibleProperty().unbind();
        }
        this.sections.visibleProperty().bind((ObservableValue)this.control.sectionsVisibleProperty());
        if (this.areas.visibleProperty().isBound()) {
            this.areas.visibleProperty().unbind();
        }
        this.areas.visibleProperty().bind((ObservableValue)this.control.areasVisibleProperty());
        if (this.markers.visibleProperty().isBound()) {
            this.markers.visibleProperty().unbind();
        }
        this.markers.visibleProperty().bind((ObservableValue)this.control.markersVisibleProperty());
        if (this.ledOff.visibleProperty().isBound()) {
            this.ledOff.visibleProperty().unbind();
        }
        this.ledOff.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.ledOn.visibleProperty().isBound()) {
            this.ledOn.visibleProperty().unbind();
        }
        this.ledOn.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.userLedOff.visibleProperty().isBound()) {
            this.userLedOff.visibleProperty().unbind();
        }
        this.userLedOff.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.userLedOn.visibleProperty().isBound()) {
            this.userLedOn.visibleProperty().unbind();
        }
        this.userLedOn.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.threshold.visibleProperty().isBound()) {
            this.threshold.visibleProperty().unbind();
        }
        this.threshold.visibleProperty().bind((ObservableValue)this.control.thresholdVisibleProperty());
        if (this.minMeasured.visibleProperty().isBound()) {
            this.minMeasured.visibleProperty().unbind();
        }
        this.minMeasured.visibleProperty().bind((ObservableValue)this.control.minMeasuredValueVisibleProperty());
        if (this.maxMeasured.visibleProperty().isBound()) {
            this.maxMeasured.visibleProperty().unbind();
        }
        this.maxMeasured.visibleProperty().bind((ObservableValue)this.control.maxMeasuredValueVisibleProperty());
        if (this.lcdValue.isBound()) {
            this.lcdValue.unbind();
        }
        this.lcdValue.bind((ObservableValue)this.control.valueProperty());
        if (this.foreground.visibleProperty().isBound()) {
            this.foreground.visibleProperty().unbind();
        }
        this.foreground.visibleProperty().bind((ObservableValue)this.control.foregroundVisibleProperty());
        if (this.trend.visibleProperty().isBound()) {
            this.trend.visibleProperty().unbind();
        }
        this.trend.visibleProperty().bind((ObservableValue)this.control.trendVisibleProperty());
    }

    private void addListeners() {
        this.control.getAreas().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialQuarterESkin.this.updateAreas();
                RadialQuarterESkin.this.drawCircularAreas(RadialQuarterESkin.this.control, RadialQuarterESkin.this.areas, RadialQuarterESkin.this.gaugeBounds);
            }
        });
        this.control.getSections().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialQuarterESkin.this.updateSections();
                RadialQuarterESkin.this.drawCircularSections(RadialQuarterESkin.this.control, RadialQuarterESkin.this.sections, RadialQuarterESkin.this.gaugeBounds);
            }
        });
        this.control.getMarkers().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialQuarterESkin.this.drawCircularIndicators(RadialQuarterESkin.this.control, RadialQuarterESkin.this.markers, RadialQuarterESkin.this.center, RadialQuarterESkin.this.gaugeBounds);
            }
        });
        this.control.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                if (RadialQuarterESkin.this.rotationAngleTimeline.getStatus() != Animation.Status.STOPPED) {
                    RadialQuarterESkin.this.rotationAngleTimeline.stop();
                }
                if (newValue.doubleValue() > oldValue.doubleValue() - RadialQuarterESkin.this.control.getRedrawToleranceValue() && newValue.doubleValue() < oldValue.doubleValue() + RadialQuarterESkin.this.control.getRedrawToleranceValue()) {
                    return;
                }
                if (RadialQuarterESkin.this.control.isValueAnimationEnabled()) {
                    KeyValue kv = new KeyValue((WritableValue)RadialQuarterESkin.this.gaugeValue, (Object)newValue, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    KeyFrame kf = new KeyFrame(Duration.millis((double)RadialQuarterESkin.this.control.getAnimationDuration()), new KeyValue[]{kv});
                    RadialQuarterESkin.this.rotationAngleTimeline = new Timeline();
                    RadialQuarterESkin.this.rotationAngleTimeline.getKeyFrames().add((Object)kf);
                    RadialQuarterESkin.this.rotationAngleTimeline.play();
                } else {
                    RadialQuarterESkin.this.pointerRotation.setPivotX(RadialQuarterESkin.this.center.getX());
                    RadialQuarterESkin.this.pointerRotation.setPivotY(RadialQuarterESkin.this.center.getY());
                    RadialQuarterESkin.this.pointerRotation.setAngle((newValue.doubleValue() - RadialQuarterESkin.this.control.getMinValue()) * RadialQuarterESkin.this.control.getAngleStep());
                    RadialQuarterESkin.this.pointer.getTransforms().add((Object)Transform.rotate((double)(-((RadialQuarterESkin)RadialQuarterESkin.this).control.getRadialRange().ROTATION_OFFSET), (double)RadialQuarterESkin.this.center.getX(), (double)RadialQuarterESkin.this.center.getY()));
                    RadialQuarterESkin.this.pointer.getTransforms().add((Object)RadialQuarterESkin.this.pointerRotation);
                }
                RadialQuarterESkin.this.checkMarkers(RadialQuarterESkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
                if (RadialQuarterESkin.this.control.isSectionsHighlighting()) {
                    InnerShadow SECTION_INNER_GLOW = new InnerShadow();
                    SECTION_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow SECTION_GLOW = new DropShadow();
                    SECTION_GLOW.setWidth(0.05 * RadialQuarterESkin.this.gaugeBounds.getWidth());
                    SECTION_GLOW.setHeight(0.05 * RadialQuarterESkin.this.gaugeBounds.getHeight());
                    SECTION_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section section : RadialQuarterESkin.this.control.getSections()) {
                        Shape currentSection = section.getSectionArea();
                        if (section.contains(newValue.doubleValue())) {
                            SECTION_INNER_GLOW.setColor(section.getColor().darker());
                            SECTION_GLOW.setInput((Effect)SECTION_INNER_GLOW);
                            SECTION_GLOW.setColor(section.getColor().brighter());
                            currentSection.setEffect((Effect)SECTION_GLOW);
                            continue;
                        }
                        currentSection.setEffect(null);
                    }
                }
                if (RadialQuarterESkin.this.control.isAreasHighlighting()) {
                    InnerShadow AREA_INNER_GLOW = new InnerShadow();
                    AREA_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow AREA_GLOW = new DropShadow();
                    AREA_GLOW.setWidth(0.05 * RadialQuarterESkin.this.gaugeBounds.getWidth());
                    AREA_GLOW.setHeight(0.05 * RadialQuarterESkin.this.gaugeBounds.getHeight());
                    AREA_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section area : RadialQuarterESkin.this.control.getAreas()) {
                        Shape currentArea = area.getFilledArea();
                        if (area.contains(newValue.doubleValue())) {
                            AREA_INNER_GLOW.setColor(area.getColor().darker());
                            AREA_GLOW.setInput((Effect)AREA_INNER_GLOW);
                            AREA_GLOW.setColor(area.getColor().brighter());
                            currentArea.setEffect((Effect)AREA_GLOW);
                            continue;
                        }
                        currentArea.setEffect(null);
                    }
                }
            }
        });
        this.gaugeValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                RadialQuarterESkin.this.pointer.getTransforms().clear();
                RadialQuarterESkin.this.pointer.setRotate(((RadialQuarterESkin)RadialQuarterESkin.this).control.getRadialRange().ANGLE_RANGE);
                RadialQuarterESkin.this.pointerRotation.setPivotX(RadialQuarterESkin.this.rotationCenter.getX());
                RadialQuarterESkin.this.pointerRotation.setPivotY(RadialQuarterESkin.this.rotationCenter.getY());
                RadialQuarterESkin.this.pointerRotation.setAngle(-(newValue.doubleValue() - RadialQuarterESkin.this.control.getMinValue()) * RadialQuarterESkin.this.control.getAngleStep());
                RadialQuarterESkin.this.pointer.getTransforms().add((Object)Transform.rotate((double)(-((RadialQuarterESkin)RadialQuarterESkin.this).control.getRadialRange().ANGLE_RANGE + ((RadialQuarterESkin)RadialQuarterESkin.this).control.getRadialRange().ROTATION_OFFSET), (double)RadialQuarterESkin.this.rotationCenter.getX(), (double)RadialQuarterESkin.this.rotationCenter.getY()));
                RadialQuarterESkin.this.pointer.getTransforms().add((Object)RadialQuarterESkin.this.pointerRotation);
                RadialQuarterESkin.this.currentValue.set(newValue.doubleValue());
                if (Double.compare(RadialQuarterESkin.this.currentValue.get(), RadialQuarterESkin.this.control.getMinMeasuredValue()) < 0) {
                    RadialQuarterESkin.this.control.setMinMeasuredValue(RadialQuarterESkin.this.currentValue.get());
                } else if (Double.compare(RadialQuarterESkin.this.currentValue.get(), RadialQuarterESkin.this.control.getMaxMeasuredValue()) > 0) {
                    RadialQuarterESkin.this.control.setMaxMeasuredValue(RadialQuarterESkin.this.currentValue.get());
                }
                if (RadialQuarterESkin.this.control.isThresholdBehaviorInverted()) {
                    RadialQuarterESkin.this.control.setThresholdExceeded(RadialQuarterESkin.this.currentValue.get() < RadialQuarterESkin.this.control.getThreshold());
                } else {
                    RadialQuarterESkin.this.control.setThresholdExceeded(RadialQuarterESkin.this.currentValue.get() > RadialQuarterESkin.this.control.getThreshold());
                }
                if (!RadialQuarterESkin.this.control.isThresholdExceeded()) {
                    RadialQuarterESkin.this.ledOn.setOpacity(0.0);
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (!"ANIMATION_DURATION".equals(PROPERTY)) {
            if ("RADIAL_RANGE".equals(PROPERTY)) {
                this.isDirty = true;
            } else if ("FRAME_DESIGN".equals(PROPERTY)) {
                this.drawCircularFrame(this.control, this.frame, this.gaugeBounds);
            } else if ("BACKGROUND_DESIGN".equals(PROPERTY)) {
                this.drawCircularBackground(this.control, this.background, this.gaugeBounds);
                this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            } else if ("KNOB_DESIGN".equals(PROPERTY)) {
                this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            } else if ("KNOB_COLOR".equals(PROPERTY)) {
                this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            } else if ("POINTER_TYPE".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("VALUE_COLOR".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("FOREGROUND_TYPE".equals(PROPERTY)) {
                this.drawCircularForeground(this.control, this.foreground, this.gaugeBounds);
            } else if ("USER_LED_BLINKING".equals(PROPERTY)) {
                if (this.userLedOff.isVisible() && this.userLedOn.isVisible()) {
                    if (this.control.isUserLedBlinking()) {
                        this.userLedTimer.start();
                    } else {
                        this.userLedTimer.stop();
                        this.userLedOn.setOpacity(0.0);
                    }
                }
            } else if ("LED_BLINKING".equals(PROPERTY)) {
                if (this.ledOff.isVisible() && this.ledOn.isVisible()) {
                    if (this.control.isLedBlinking()) {
                        this.ledTimer.start();
                    } else {
                        this.ledTimer.stop();
                        this.ledOn.setOpacity(0.0);
                    }
                }
            } else if ("GLOW_COLOR".equals(PROPERTY)) {
                this.glowColors.clear();
                Color GLOW_COLOR = this.control.getGlowColor();
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
                this.drawCircularGlowOn(this.control, this.glowOn, this.glowColors, this.gaugeBounds);
            } else if ("GLOW_VISIBILITY".equals(PROPERTY)) {
                this.glowOff.setVisible(this.control.isGlowVisible());
                if (!this.control.isGlowVisible()) {
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("GLOW_ON".equals(PROPERTY)) {
                if (this.glowOff.isVisible() && this.control.isGlowOn()) {
                    this.glowOn.setOpacity(1.0);
                    this.glowOff.setVisible(true);
                } else {
                    this.glowOff.setVisible(true);
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("PULSATING_GLOW".equals(PROPERTY)) {
                if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
                    if (!this.glowOn.isVisible()) {
                        this.glowOn.setVisible(true);
                    }
                    if (this.glowOn.getOpacity() < 1.0) {
                        this.glowOn.setOpacity(1.0);
                    }
                    this.glowPulse.play();
                } else {
                    this.glowPulse.stop();
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("TICKMARKS".equals(PROPERTY)) {
                this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            } else if ("MIN_MEASURED_VALUE".equals(PROPERTY)) {
                double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
                this.minMeasured.setRotate(this.control.getRadialRange().ANGLE_RANGE);
                this.minMeasured.getTransforms().clear();
                this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(-ZERO_OFFSET - this.control.getMinMeasuredValue() * this.control.getAngleStep()), (double)this.rotationCenter.getX(), (double)this.rotationCenter.getY()));
            } else if ("MAX_MEASURED_VALUE".equals(PROPERTY)) {
                double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
                this.maxMeasured.setRotate(this.control.getRadialRange().ANGLE_RANGE);
                this.maxMeasured.getTransforms().clear();
                this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(-ZERO_OFFSET - this.control.getMaxMeasuredValue() * this.control.getAngleStep()), (double)this.rotationCenter.getX(), (double)this.rotationCenter.getY()));
            } else if ("TREND".equals(PROPERTY)) {
                this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
            } else if ("GAUGE_MODEL".equals(PROPERTY)) {
                this.addBindings();
                this.repaint();
            } else if ("STYLE_MODEL".equals(PROPERTY)) {
                this.addBindings();
                this.repaint();
            } else if ("THRESHOLD_EXCEEDED".equals(PROPERTY)) {
                if (this.control.isThresholdExceeded()) {
                    this.ledTimer.start();
                } else {
                    this.ledTimer.stop();
                }
            } else if ("PREF_WIDTH".equals(PROPERTY)) {
                this.repaint();
            } else if ("PREF_HEIGHT".equals(PROPERTY)) {
                this.repaint();
            } else if ("AREAS".equals(PROPERTY)) {
                this.updateAreas();
                this.drawCircularAreas(this.control, this.areas, this.gaugeBounds);
            } else if ("SECTIONS".equals(PROPERTY)) {
                this.updateSections();
                this.drawCircularSections(this.control, this.sections, this.gaugeBounds);
            } else if ("MARKERS".equals(PROPERTY)) {
                this.drawCircularIndicators(this.control, this.markers, this.center, this.gaugeBounds);
            }
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.calcGaugeBounds();
            this.setTranslateX(this.framelessOffset.getX());
            this.setTranslateY(this.framelessOffset.getY());
            this.center = new Point2D(this.gaugeBounds.getWidth() * 0.265, this.gaugeBounds.getHeight() * 0.5);
            this.rotationCenter = new Point2D(this.gaugeBounds.getWidth() * 0.5, this.gaugeBounds.getHeight() * 0.735);
            this.drawCircularFrame(this.control, this.frame, this.gaugeBounds);
            this.drawCircularBackground(this.control, this.background, this.gaugeBounds);
            this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
            this.updateSections();
            this.drawCircularSections(this.control, this.sections, this.gaugeBounds);
            this.updateAreas();
            this.drawCircularAreas(this.control, this.areas, this.gaugeBounds);
            this.drawTitleAndUnit();
            this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            this.drawCircularLed(this.control, this.ledOff, this.ledOn, this.gaugeBounds);
            this.drawCircularUserLed(this.control, this.userLedOff, this.userLedOn, this.gaugeBounds);
            this.drawThreshold();
            this.drawCircularGlowOff(this.glowOff, this.gaugeBounds);
            this.drawCircularGlowOn(this.control, this.glowOn, this.glowColors, this.gaugeBounds);
            this.drawMinMeasuredIndicator();
            this.drawMaxMeasuredIndicator();
            this.drawPointer();
            this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            this.drawCircularForeground(this.control, this.foreground, this.gaugeBounds);
            if (this.control.isPointerShadowEnabled() && !this.control.isPointerGlowEnabled()) {
                this.addDropShadow(this.control, new Node[]{this.knobs, this.pointerShadow});
            }
            this.getChildren().setAll((Object[])new Node[]{this.frame, this.background, this.trend, this.sections, this.areas, this.ledOff, this.ledOn, this.userLedOff, this.userLedOn, this.titleAndUnit, this.tickmarks, this.threshold, this.glowOff, this.glowOn, this.minMeasured, this.maxMeasured, this.markers, this.pointerShadow, this.knobsShadow, this.foreground});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public RadialQuarterE getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        double prefWidth = PREF_SIZE.getWidth();
        if (HEIGHT != -1.0) {
            prefWidth = Math.max(0.0, HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        double prefHeight = PREF_SIZE.getHeight();
        if (WIDTH != -1.0) {
            prefHeight = Math.max(0.0, WIDTH - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    @Override
    protected double computeMinWidth(double WIDTH) {
        return super.computeMinWidth(Math.max(MIN_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMinHeight(double HEIGHT) {
        return super.computeMinHeight(Math.max(MIN_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    @Override
    protected double computeMaxWidth(double WIDTH) {
        return super.computeMaxWidth(Math.max(MAX_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMaxHeight(double HEIGHT) {
        return super.computeMaxHeight(Math.max(MAX_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private void calcGaugeBounds() {
        if (this.control.isFrameVisible()) {
            this.gaugeBounds.setWidth(this.control.getPrefWidth());
            this.gaugeBounds.setHeight(this.control.getPrefHeight());
            this.framelessOffset = new Point2D(0.0, 0.0);
        } else {
            this.gaugeBounds.setWidth(this.control.getPrefWidth() * 1.202247191);
            this.gaugeBounds.setHeight(this.control.getPrefHeight() * 1.202247191);
            this.framelessOffset = new Point2D(-this.gaugeBounds.getWidth() * 0.0841121495, -this.gaugeBounds.getWidth() * 0.0841121495);
        }
    }

    private void updateSections() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.5;
        double INNER_RADIUS = this.control.isExpandedSections() ? OUTER_RADIUS - this.control.getPrefWidth() * 0.12 : OUTER_RADIUS - this.control.getPrefWidth() * 0.04;
        Circle INNER = new Circle(this.center.getX(), this.center.getY(), INNER_RADIUS);
        double ANGLE_OFFSET = this.control.getMinValue() * this.control.getAngleStep() + this.control.getRadialRange().ROTATION_OFFSET;
        double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
        for (Section section : this.control.getSections()) {
            double SECTION_START = section.getStart() < this.control.getMinValue() ? this.control.getMinValue() : section.getStart();
            double SECTION_STOP = section.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : section.getStop();
            double ANGLE_START = ZERO_OFFSET + this.control.getRadialRange().SECTIONS_OFFSET + SECTION_START * this.control.getAngleStep() - this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = (SECTION_STOP - SECTION_START) * this.control.getAngleStep();
            Arc OUTER_ARC = new Arc();
            OUTER_ARC.setType(ArcType.ROUND);
            OUTER_ARC.setCenterX(this.center.getX());
            OUTER_ARC.setCenterY(this.center.getY());
            OUTER_ARC.setRadiusX(OUTER_RADIUS);
            OUTER_ARC.setRadiusY(OUTER_RADIUS);
            OUTER_ARC.setStartAngle(ANGLE_OFFSET + ANGLE_START);
            OUTER_ARC.setLength(ANGLE_EXTEND);
            Shape SECTION = Shape.subtract((Shape)OUTER_ARC, (Shape)INNER);
            section.setSectionArea(SECTION);
        }
    }

    private void updateAreas() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.5;
        double INNER_RADIUS = this.control.isExpandedSections() ? this.control.getPrefWidth() * 0.12 : this.control.getPrefWidth() * 0.04;
        double RADIUS = OUTER_RADIUS - INNER_RADIUS;
        double ANGLE_OFFSET = this.control.getMinValue() * this.control.getAngleStep() + this.control.getRadialRange().ROTATION_OFFSET;
        double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
        for (Section area : this.control.getAreas()) {
            double AREA_START = area.getStart() < this.control.getMinValue() ? this.control.getMinValue() : area.getStart();
            double AREA_STOP = area.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : area.getStop();
            double ANGLE_START = ZERO_OFFSET + this.control.getRadialRange().SECTIONS_OFFSET + AREA_START * this.control.getAngleStep() - this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = (AREA_STOP - AREA_START) * this.control.getAngleStep();
            Arc ARC = new Arc();
            ARC.setType(ArcType.ROUND);
            ARC.setCenterX(this.center.getX());
            ARC.setCenterY(this.center.getY());
            ARC.setRadiusX(RADIUS);
            ARC.setRadiusY(RADIUS);
            ARC.setStartAngle(ANGLE_OFFSET + ANGLE_START);
            ARC.setLength(ANGLE_EXTEND);
            area.setFilledArea((Shape)ARC);
        }
    }

    public void drawTitleAndUnit() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        this.titleAndUnit.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        this.titleAndUnit.getChildren().add((Object)IBOUNDS);
        Font TITLE_FONT = Font.font((String)this.control.getTitleFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * SIZE));
        Text title = new Text();
        title.setTextOrigin(VPos.BOTTOM);
        title.setFont(TITLE_FONT);
        title.setText(this.control.getTitle());
        title.setX((SIZE * 0.75 - title.getLayoutBounds().getWidth()) / 2.0);
        title.setY(0.3 * SIZE + title.getLayoutBounds().getHeight());
        title.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        Font UNIT_FONT = Font.font((String)this.control.getUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * SIZE));
        Text unit = new Text();
        unit.setTextOrigin(VPos.BOTTOM);
        unit.setFont(UNIT_FONT);
        unit.setText(this.control.getUnit());
        unit.setX((SIZE * 0.75 - unit.getLayoutBounds().getWidth()) / 2.0);
        unit.setY(0.365 * SIZE + unit.getLayoutBounds().getHeight());
        unit.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        this.titleAndUnit.getChildren().addAll((Object[])new Node[]{title, unit});
    }

    public void drawThreshold() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.threshold.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.threshold.getChildren().add((Object)IBOUNDS);
        Path THRESHOLD = this.createTriangleShape(0.03 * WIDTH, 0.03 * HEIGHT, false);
        THRESHOLD.setStrokeType(StrokeType.CENTERED);
        THRESHOLD.setStrokeLineCap(StrokeLineCap.ROUND);
        THRESHOLD.setStrokeLineJoin(StrokeLineJoin.ROUND);
        THRESHOLD.setStrokeWidth(0.002 * HEIGHT);
        THRESHOLD.getStyleClass().add((Object)"root");
        THRESHOLD.setStyle(this.control.getThresholdColor().CSS);
        THRESHOLD.getStyleClass().add((Object)"threshold-gradient");
        THRESHOLD.setTranslateX(0.485 * WIDTH);
        THRESHOLD.setTranslateY(0.25 * HEIGHT);
        this.threshold.getChildren().addAll((Object[])new Node[]{THRESHOLD});
        double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
        this.threshold.setRotate(this.control.getRadialRange().ANGLE_RANGE);
        this.threshold.getTransforms().clear();
        this.threshold.getTransforms().add((Object)Transform.rotate((double)(-ZERO_OFFSET - this.control.getThreshold() * this.control.getAngleStep()), (double)this.rotationCenter.getX(), (double)this.rotationCenter.getY()));
    }

    public void drawMinMeasuredIndicator() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.minMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.minMeasured.getChildren().add((Object)IBOUNDS);
        Path MIN_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * HEIGHT, true);
        MIN_MEASURED.setFill((Paint)Color.color((double)0.0, (double)0.0, (double)0.8));
        MIN_MEASURED.setStroke(null);
        MIN_MEASURED.setTranslateX(0.485 * WIDTH);
        MIN_MEASURED.setTranslateY(0.21 * HEIGHT);
        this.minMeasured.getChildren().add((Object)MIN_MEASURED);
        double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
        this.minMeasured.setRotate(this.control.getRadialRange().ANGLE_RANGE);
        this.minMeasured.getTransforms().clear();
        this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(-ZERO_OFFSET - this.control.getMinMeasuredValue() * this.control.getAngleStep()), (double)this.rotationCenter.getX(), (double)this.rotationCenter.getY()));
    }

    public void drawMaxMeasuredIndicator() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.maxMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.maxMeasured.getChildren().add((Object)IBOUNDS);
        Path MAX_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * HEIGHT, true);
        MAX_MEASURED.setFill((Paint)Color.color((double)0.8, (double)0.0, (double)0.0));
        MAX_MEASURED.setStroke(null);
        MAX_MEASURED.setTranslateX(0.485 * WIDTH);
        MAX_MEASURED.setTranslateY(0.21 * HEIGHT);
        this.maxMeasured.getChildren().add((Object)MAX_MEASURED);
        double ZERO_OFFSET = -45.0 - this.control.getMinValue() * this.control.getAngleStep();
        this.maxMeasured.setRotate(this.control.getRadialRange().ANGLE_RANGE);
        this.maxMeasured.getTransforms().clear();
        this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(-ZERO_OFFSET - this.control.getMaxMeasuredValue() * this.control.getAngleStep()), (double)this.rotationCenter.getX(), (double)this.rotationCenter.getY()));
    }

    public void drawPointer() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.pointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.pointer.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        Path POINTER = new Path();
        Path POINTER_FRONT = new Path();
        POINTER.setSmooth(true);
        POINTER.getStyleClass().add((Object)"root");
        POINTER.setStyle("-fx-value: " + this.control.getValueColor().CSS);
        switch (this.control.getPointerType()) {
            case TYPE2: {
                POINTER.getStyleClass().add((Object)"pointer2-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.52 * WIDTH, 0.71 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.695 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.545 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.545 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.695 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.71 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.48 * WIDTH, 0.71 * HEIGHT, 0.465 * WIDTH, 0.72 * HEIGHT, 0.465 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.465 * WIDTH, 0.75 * HEIGHT, 0.48 * WIDTH, 0.765 * HEIGHT, 0.5 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.765 * HEIGHT, 0.535 * WIDTH, 0.75 * HEIGHT, 0.535 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.535 * WIDTH, 0.72 * HEIGHT, 0.52 * WIDTH, 0.71 * HEIGHT, 0.52 * WIDTH, 0.71 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE3: {
                POINTER.getStyleClass().add((Object)"pointer3-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE4: {
                POINTER.getStyleClass().add((Object)"pointer4-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.265 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.535 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.855 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.855 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.465 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.265 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE5: {
                POINTER.getStyleClass().add((Object)"pointer5-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.245 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE6: {
                POINTER.getStyleClass().add((Object)"pointer6-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.475 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.595 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.49 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.495 * WIDTH, 0.255 * HEIGHT, 0.495 * WIDTH, 0.25 * HEIGHT, 0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.505 * WIDTH, 0.25 * HEIGHT, 0.505 * WIDTH, 0.255 * HEIGHT, 0.505 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.52 * WIDTH, 0.49 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.595 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.595 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.505 * WIDTH, 0.595 * HEIGHT, 0.505 * WIDTH, 0.495 * HEIGHT, 0.5 * WIDTH, 0.495 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.495 * WIDTH, 0.495 * HEIGHT, 0.495 * WIDTH, 0.595 * HEIGHT, 0.495 * WIDTH, 0.595 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE7: {
                POINTER.getStyleClass().add((Object)"pointer7-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.49 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.47 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE8: {
                POINTER.getStyleClass().add((Object)"pointer8-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.535 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.535 * WIDTH, 0.735 * HEIGHT, 0.505 * WIDTH, 0.65 * HEIGHT, 0.5 * WIDTH, 0.255 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.495 * WIDTH, 0.65 * HEIGHT, 0.465 * WIDTH, 0.735 * HEIGHT, 0.465 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE9: {
                POINTER.getStyleClass().add((Object)"pointer9-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.495 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.66 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.66 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.getElements().add((Object)new MoveTo(0.49 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.475 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.475 * WIDTH, 0.765 * HEIGHT, 0.475 * WIDTH, 0.855 * HEIGHT, 0.475 * WIDTH, 0.855 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.475 * WIDTH, 0.855 * HEIGHT, 0.48 * WIDTH, 0.86 * HEIGHT, 0.5 * WIDTH, 0.86 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.52 * WIDTH, 0.86 * HEIGHT, 0.525 * WIDTH, 0.855 * HEIGHT, 0.525 * WIDTH, 0.855 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.525 * WIDTH, 0.855 * HEIGHT, 0.525 * WIDTH, 0.765 * HEIGHT, 0.525 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.525 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                POINTER_FRONT.getStyleClass().add((Object)"root");
                POINTER_FRONT.setStyle("-fx-value: " + this.control.getValueColor().CSS);
                POINTER_FRONT.getStyleClass().add((Object)"pointer9-box");
                POINTER_FRONT.setFillRule(FillRule.EVEN_ODD);
                POINTER_FRONT.getElements().add((Object)new MoveTo(0.495 * WIDTH, 0.355 * HEIGHT));
                POINTER_FRONT.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.355 * HEIGHT));
                POINTER_FRONT.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.255 * HEIGHT));
                POINTER_FRONT.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.255 * HEIGHT));
                POINTER_FRONT.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.355 * HEIGHT));
                POINTER_FRONT.getElements().add((Object)new ClosePath());
                POINTER_FRONT.setStroke(null);
                break;
            }
            case TYPE10: {
                POINTER.getStyleClass().add((Object)"pointer10-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.25 * HEIGHT, 0.435 * WIDTH, 0.715 * HEIGHT, 0.435 * WIDTH, 0.725 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.435 * WIDTH, 0.765 * HEIGHT, 0.465 * WIDTH, 0.795 * HEIGHT, 0.5 * WIDTH, 0.795 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.535 * WIDTH, 0.795 * HEIGHT, 0.565 * WIDTH, 0.765 * HEIGHT, 0.565 * WIDTH, 0.725 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.565 * WIDTH, 0.715 * HEIGHT, 0.5 * WIDTH, 0.25 * HEIGHT, 0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE11: {
                POINTER.getStyleClass().add((Object)"pointer11-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.485 * WIDTH, 0.735 * HEIGHT, 0.485 * WIDTH, 0.81 * HEIGHT, 0.5 * WIDTH, 0.81 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.81 * HEIGHT, 0.515 * WIDTH, 0.735 * HEIGHT, 0.515 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE12: {
                POINTER.getStyleClass().add((Object)"pointer12-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.75 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE13: {
                POINTER.getStyleClass().add((Object)"pointer13-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.485 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.245 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE14: {
                POINTER.getStyleClass().add((Object)"pointer14-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.485 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.245 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE15: {
                POINTER.getStyleClass().add((Object)"pointer15-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.485 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.46 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.245 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.535 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.37 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.485 * WIDTH, 0.745 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE16: {
                POINTER.getStyleClass().add((Object)"pointer16-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.86 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.52 * WIDTH, 0.86 * HEIGHT, 0.54 * WIDTH, 0.845 * HEIGHT, 0.54 * WIDTH, 0.845 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.53 * WIDTH, 0.835 * HEIGHT, 0.51 * WIDTH, 0.765 * HEIGHT, 0.51 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.51 * WIDTH, 0.295 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.29 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.24 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.24 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.29 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.295 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49 * WIDTH, 0.765 * HEIGHT, 0.47 * WIDTH, 0.835 * HEIGHT, 0.46 * WIDTH, 0.845 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.46 * WIDTH, 0.845 * HEIGHT, 0.475 * WIDTH, 0.86 * HEIGHT, 0.5 * WIDTH, 0.86 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            default: {
                POINTER.setStyle("-fx-pointer: " + this.control.getValueColor().CSS);
                POINTER.getStyleClass().add((Object)"pointer1-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.515 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.69 * HEIGHT, 0.51 * WIDTH, 0.63 * HEIGHT, 0.51 * WIDTH, 0.615 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.505 * WIDTH, 0.6 * HEIGHT, 0.5 * WIDTH, 0.25 * HEIGHT, 0.5 * WIDTH, 0.25 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.25 * HEIGHT, 0.49 * WIDTH, 0.595 * HEIGHT, 0.49 * WIDTH, 0.61 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49 * WIDTH, 0.63 * HEIGHT, 0.485 * WIDTH, 0.69 * HEIGHT, 0.485 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.475 * WIDTH, 0.715 * HEIGHT, 0.465 * WIDTH, 0.725 * HEIGHT, 0.465 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.465 * WIDTH, 0.75 * HEIGHT, 0.48 * WIDTH, 0.765 * HEIGHT, 0.5 * WIDTH, 0.765 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.52 * WIDTH, 0.765 * HEIGHT, 0.535 * WIDTH, 0.75 * HEIGHT, 0.535 * WIDTH, 0.735 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.535 * WIDTH, 0.725 * HEIGHT, 0.525 * WIDTH, 0.715 * HEIGHT, 0.515 * WIDTH, 0.705 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
            }
        }
        if (this.control.isPointerGlowEnabled()) {
            DropShadow GLOW = new DropShadow();
            GLOW.setWidth(0.04 * SIZE);
            GLOW.setHeight(0.04 * SIZE);
            GLOW.setOffsetX(0.0);
            GLOW.setOffsetY(0.0);
            GLOW.setRadius(0.04 * SIZE);
            GLOW.setColor(this.control.getValueColor().COLOR);
            GLOW.setBlurType(BlurType.GAUSSIAN);
            if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
                POINTER_FRONT.setEffect((Effect)GLOW);
            } else {
                POINTER.setEffect((Effect)GLOW);
            }
        }
        this.pointer.getChildren().addAll((Object[])new Node[]{POINTER});
        if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
            this.pointer.getChildren().add((Object)POINTER_FRONT);
        }
        this.pointer.setRotate(this.control.getRadialRange().ANGLE_RANGE);
        this.pointer.setCache(true);
        this.pointer.setCacheHint(CacheHint.ROTATE);
    }
}

