/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotParametersBuilder;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.RadialBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.Radial;
import jfxtras.labs.scene.control.gauge.Section;

public class RadialSkin
extends GaugeSkinBase<Radial, RadialBehavior> {
    private static final Rectangle MIN_SIZE = new Rectangle(25.0, 25.0);
    private static final Rectangle PREF_SIZE = new Rectangle(200.0, 200.0);
    private static final Rectangle MAX_SIZE = new Rectangle(1024.0, 1024.0);
    private final SnapshotParameters SNAPSHOT_PARAMETER = SnapshotParametersBuilder.create().fill((Paint)Color.TRANSPARENT).build();
    private Radial control;
    private Rectangle gaugeBounds;
    private Point2D framelessOffset;
    private Group frame;
    private Group background;
    private Group trend;
    private Group sections;
    private Group areas;
    private Group markers;
    private Group titleAndUnit;
    private Group tickmarks;
    private Group glowOff;
    private Group glowOn;
    private ArrayList<Color> glowColors;
    private Group lcd;
    private Group lcdContent;
    private Font lcdUnitFont;
    private Font lcdValueFont;
    private Text lcdValueString;
    private Text lcdUnitString;
    private Group lcdThresholdIndicator;
    private Group knobs;
    private Group knobsShadow;
    private Group threshold;
    private Group minMeasured;
    private Group maxMeasured;
    private Group pointer;
    private Group pointerShadow;
    private Group bargraphOff;
    private Group bargraphOn;
    private Group ledOff;
    private Group ledOn;
    private Group userLedOff;
    private Group userLedOn;
    private Group foreground;
    private Timeline rotationAngleTimeline;
    private DoubleProperty gaugeValue;
    private double negativeOffset;
    private Point2D center;
    private int noOfLeds;
    private ArrayList<Shape> ledsOff;
    private ArrayList<Shape> ledsOn;
    private DoubleProperty currentValue;
    private DoubleProperty formerValue;
    private DoubleProperty lcdValue;
    private DoubleProperty currentLcdValue;
    private FadeTransition glowPulse;
    private Rotate pointerRotation;
    private AnimationTimer ledTimer;
    private boolean ledOnVisible;
    private long lastLedTimerCall;
    private AnimationTimer userLedTimer;
    private boolean userLedOnVisible;
    private long lastUserLedTimerCall;
    private Group histogram;
    private ImageView histogramImage;
    private WritableImage img;
    private long histogramInterval;
    private long lastHistogramFadingTimerCall;
    private AnimationTimer histogramFadingTimer;
    private boolean isDirty;
    private boolean initialized;

    public RadialSkin(Radial CONTROL) {
        super(CONTROL, new RadialBehavior(CONTROL));
        this.control = CONTROL;
        this.gaugeBounds = new Rectangle(200.0, 200.0);
        this.framelessOffset = new Point2D(0.0, 0.0);
        this.center = new Point2D(0.0, 0.0);
        this.frame = new Group();
        this.background = new Group();
        this.trend = new Group();
        this.sections = new Group();
        this.areas = new Group();
        this.markers = new Group();
        this.titleAndUnit = new Group();
        this.tickmarks = new Group();
        this.glowOff = new Group();
        this.glowOn = new Group();
        this.glowColors = new ArrayList(4);
        this.lcd = new Group();
        this.lcdContent = new Group();
        this.lcdValueString = new Text();
        this.lcdUnitString = new Text();
        this.lcdThresholdIndicator = new Group();
        this.knobs = new Group();
        this.knobsShadow = new Group(new Node[]{this.knobs});
        this.threshold = new Group();
        this.minMeasured = new Group();
        this.maxMeasured = new Group();
        this.pointer = new Group();
        this.pointerShadow = new Group(new Node[]{this.pointer});
        this.bargraphOff = new Group();
        this.bargraphOn = new Group();
        this.ledOff = new Group();
        this.ledOn = new Group();
        this.userLedOff = new Group();
        this.userLedOn = new Group();
        this.foreground = new Group();
        this.rotationAngleTimeline = new Timeline();
        this.gaugeValue = new SimpleDoubleProperty(0.0);
        this.negativeOffset = 0.0;
        this.noOfLeds = 60;
        this.ledsOff = new ArrayList(this.noOfLeds);
        this.ledsOn = new ArrayList(this.noOfLeds);
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.formerValue = new SimpleDoubleProperty(0.0);
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.currentLcdValue = new SimpleDoubleProperty(0.0);
        this.glowPulse = new FadeTransition(Duration.millis((double)800.0), (Node)this.glowOn);
        this.pointerRotation = new Rotate();
        this.isDirty = false;
        this.ledTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialSkin.this.lastLedTimerCall + RadialSkin.this.getBlinkInterval()) {
                    RadialSkin.this.ledOnVisible = (byte)(RadialSkin.this.ledOnVisible ^ 1);
                    if (RadialSkin.this.ledOnVisible) {
                        RadialSkin.this.ledOn.setOpacity(1.0);
                    } else {
                        RadialSkin.this.ledOn.setOpacity(0.0);
                    }
                    RadialSkin.this.lastLedTimerCall = NOW;
                }
            }
        };
        this.lastLedTimerCall = 0L;
        this.ledOnVisible = false;
        this.userLedTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialSkin.this.lastUserLedTimerCall + RadialSkin.this.getBlinkInterval()) {
                    RadialSkin.this.userLedOnVisible = (byte)(RadialSkin.this.userLedOnVisible ^ 1);
                    if (RadialSkin.this.userLedOnVisible) {
                        RadialSkin.this.userLedOn.setOpacity(1.0);
                    } else {
                        RadialSkin.this.userLedOn.setOpacity(0.0);
                    }
                    RadialSkin.this.lastUserLedTimerCall = NOW;
                }
            }
        };
        this.lastUserLedTimerCall = 0L;
        this.userLedOnVisible = false;
        this.histogram = new Group();
        this.histogramImage = new ImageView();
        this.histogramImage.setSmooth(true);
        this.histogramInterval = (long)this.control.histogramDataPeriodInMinutesProperty().get() * 60000000000L / 100L;
        this.lastHistogramFadingTimerCall = 0L;
        this.histogramFadingTimer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime > RadialSkin.this.lastHistogramFadingTimerCall + RadialSkin.this.histogramInterval) {
                    RadialSkin.this.reduceHistogramOpacity();
                    RadialSkin.this.lastHistogramFadingTimerCall = currentNanoTime;
                }
            }
        };
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.control.recalcRange();
        this.glowColors.clear();
        Color GLOW_COLOR = this.control.getGlowColor();
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowPulse.setFromValue(0.1);
        this.glowPulse.setToValue(1.0);
        this.glowPulse.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.4, (double)1.0));
        this.glowPulse.setInterpolator(Interpolator.EASE_OUT);
        this.glowPulse.setCycleCount(-1);
        this.glowPulse.setAutoReverse(true);
        if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
            if (!this.glowOn.isVisible()) {
                this.glowOn.setVisible(true);
            }
            if (this.glowOn.getOpacity() < 1.0) {
                this.glowOn.setOpacity(1.0);
            }
            this.glowPulse.play();
        } else {
            this.glowPulse.stop();
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isGlowVisible()) {
            this.glowOff.setVisible(true);
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else {
            this.glowOff.setVisible(false);
            this.glowOn.setOpacity(0.0);
        }
        this.ledOn.setOpacity(0.0);
        if (this.control.isUserLedOn()) {
            this.userLedOn.setOpacity(1.0);
        } else {
            this.userLedOn.setOpacity(0.0);
        }
        if (this.control.isUserLedBlinking()) {
            this.userLedTimer.start();
        }
        if (!this.control.getSections().isEmpty()) {
            this.updateSections();
        }
        if (!this.control.getAreas().isEmpty()) {
            this.updateAreas();
        }
        this.noOfLeds = (int)(this.control.getRadialRange().ANGLE_RANGE / 5.0);
        if (this.gaugeValue.get() < this.control.getMinValue()) {
            this.gaugeValue.set(this.control.getMinValue());
        } else if (this.gaugeValue.get() > this.control.getMaxValue()) {
            this.gaugeValue.set(this.control.getMaxValue());
        }
        this.control.recalcRange();
        this.control.setMinMeasuredValue(this.control.getMaxValue());
        this.control.setMaxMeasuredValue(this.control.getMinValue());
        this.negativeOffset = this.control.getMinValue() < 0.0 ? this.control.getMinValue() * this.control.getAngleStep() : 0.0;
        this.addBindings();
        this.addListeners();
        this.registerChangeListener((ObservableValue)this.control.histogramCreationEnabledProperty(), "HISTOGRAM_CREATION");
        this.registerChangeListener((ObservableValue)this.control.histogramDataPeriodInMinutesProperty(), "HISTOGRAM_PERIOD");
        if (this.control.isHistogramCreationEnabled()) {
            this.histogramFadingTimer.start();
        }
        this.pointerRotation.angleProperty().bind((ObservableValue)this.gaugeValue.subtract((ObservableNumberValue)this.control.minValueProperty()).multiply((ObservableNumberValue)this.control.angleStepProperty()).add(this.control.getRadialRange().ROTATION_OFFSET));
        this.calcGaugeBounds();
        this.lcdUnitString.getStyleClass().clear();
        this.lcdUnitString.getStyleClass().add((Object)"lcd");
        this.lcdUnitString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdUnitString.getStyleClass().add((Object)"lcd-text");
        this.lcdValueString.getStyleClass().clear();
        this.lcdValueString.getStyleClass().add((Object)"lcd");
        this.lcdValueString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdValueString.getStyleClass().add((Object)"lcd-text");
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.frame.visibleProperty().isBound()) {
            this.frame.visibleProperty().unbind();
        }
        this.frame.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
        if (this.background.visibleProperty().isBound()) {
            this.background.visibleProperty().unbind();
        }
        this.background.visibleProperty().bind((ObservableValue)this.control.backgroundVisibleProperty());
        if (this.histogram.visibleProperty().isBound()) {
            this.histogram.visibleProperty().unbind();
        }
        this.histogram.visibleProperty().bind((ObservableValue)this.control.histogramVisibleProperty());
        if (this.sections.visibleProperty().isBound()) {
            this.sections.visibleProperty().unbind();
        }
        this.sections.visibleProperty().bind((ObservableValue)this.control.sectionsVisibleProperty());
        if (this.areas.visibleProperty().isBound()) {
            this.areas.visibleProperty().unbind();
        }
        this.areas.visibleProperty().bind((ObservableValue)this.control.areasVisibleProperty());
        if (this.bargraphOff.visibleProperty().isBound()) {
            this.bargraphOff.visibleProperty().unbind();
        }
        this.bargraphOff.visibleProperty().bind((ObservableValue)this.control.bargraphProperty());
        if (this.bargraphOn.visibleProperty().isBound()) {
            this.bargraphOn.visibleProperty().unbind();
        }
        this.bargraphOn.visibleProperty().bind((ObservableValue)this.control.bargraphProperty());
        this.pointer.setVisible(!this.bargraphOff.isVisible());
        this.knobs.setVisible(!this.bargraphOff.isVisible());
        if (this.bargraphOff.isVisible()) {
            this.areas.setOpacity(0.0);
            this.sections.setOpacity(0.0);
        } else {
            this.areas.setOpacity(1.0);
            this.sections.setOpacity(1.0);
        }
        if (this.markers.visibleProperty().isBound()) {
            this.markers.visibleProperty().unbind();
        }
        this.markers.visibleProperty().bind((ObservableValue)this.control.markersVisibleProperty());
        if (this.ledOff.visibleProperty().isBound()) {
            this.ledOff.visibleProperty().unbind();
        }
        this.ledOff.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.ledOn.visibleProperty().isBound()) {
            this.ledOn.visibleProperty().unbind();
        }
        this.ledOn.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.userLedOff.visibleProperty().isBound()) {
            this.userLedOff.visibleProperty().unbind();
        }
        this.userLedOff.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.userLedOn.visibleProperty().isBound()) {
            this.userLedOn.visibleProperty().unbind();
        }
        this.userLedOn.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.threshold.visibleProperty().isBound()) {
            this.threshold.visibleProperty().unbind();
        }
        this.threshold.visibleProperty().bind((ObservableValue)this.control.thresholdVisibleProperty());
        if (this.minMeasured.visibleProperty().isBound()) {
            this.minMeasured.visibleProperty().unbind();
        }
        this.minMeasured.visibleProperty().bind((ObservableValue)this.control.minMeasuredValueVisibleProperty());
        if (this.maxMeasured.visibleProperty().isBound()) {
            this.maxMeasured.visibleProperty().unbind();
        }
        this.maxMeasured.visibleProperty().bind((ObservableValue)this.control.maxMeasuredValueVisibleProperty());
        if (this.lcdValue.isBound()) {
            this.lcdValue.unbind();
        }
        this.lcdValue.bind((ObservableValue)this.control.valueProperty());
        if (this.lcd.visibleProperty().isBound()) {
            this.lcd.visibleProperty().unbind();
        }
        this.lcd.visibleProperty().bind((ObservableValue)this.control.lcdVisibleProperty());
        if (this.lcdContent.visibleProperty().isBound()) {
            this.lcdContent.visibleProperty().unbind();
        }
        this.lcdContent.visibleProperty().bind((ObservableValue)this.control.lcdVisibleProperty());
        if (this.lcdThresholdIndicator.visibleProperty().isBound()) {
            this.lcdThresholdIndicator.visibleProperty().unbind();
        }
        if (this.control.isLcdThresholdVisible() && this.control.isLcdValueCoupled()) {
            this.lcdThresholdIndicator.visibleProperty().bind((ObservableValue)this.control.thresholdVisibleProperty());
        }
        if (this.foreground.visibleProperty().isBound()) {
            this.foreground.visibleProperty().unbind();
        }
        this.foreground.visibleProperty().bind((ObservableValue)this.control.foregroundVisibleProperty());
        if (this.trend.visibleProperty().isBound()) {
            this.trend.visibleProperty().unbind();
        }
        this.trend.visibleProperty().bind((ObservableValue)this.control.trendVisibleProperty());
    }

    private void addListeners() {
        this.control.getAreas().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialSkin.this.updateAreas();
                RadialSkin.this.drawCircularAreas(RadialSkin.this.control, RadialSkin.this.areas, RadialSkin.this.gaugeBounds);
            }
        });
        this.control.getSections().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialSkin.this.updateSections();
                RadialSkin.this.drawCircularSections(RadialSkin.this.control, RadialSkin.this.sections, RadialSkin.this.gaugeBounds);
            }
        });
        this.control.getMarkers().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialSkin.this.drawCircularIndicators(RadialSkin.this.control, RadialSkin.this.markers, RadialSkin.this.center, RadialSkin.this.gaugeBounds);
            }
        });
        this.control.realValueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                RadialSkin.this.formerValue.set(oldValue.doubleValue());
                if (RadialSkin.this.rotationAngleTimeline.getStatus() != Animation.Status.STOPPED) {
                    RadialSkin.this.rotationAngleTimeline.stop();
                }
                if (RadialSkin.this.control.isHistogramCreationEnabled()) {
                    RadialSkin.this.addValueToHistogram(oldValue.doubleValue());
                }
                if (newValue.doubleValue() > oldValue.doubleValue() - RadialSkin.this.control.getRedrawToleranceValue() && newValue.doubleValue() < oldValue.doubleValue() + RadialSkin.this.control.getRedrawToleranceValue()) {
                    return;
                }
                if (RadialSkin.this.control.isValueAnimationEnabled()) {
                    KeyValue KEY_VALUE = new KeyValue((WritableValue)RadialSkin.this.gaugeValue, (Object)newValue, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)RadialSkin.this.control.getAnimationDuration()), new KeyValue[]{KEY_VALUE});
                    RadialSkin.this.rotationAngleTimeline = new Timeline();
                    RadialSkin.this.rotationAngleTimeline.getKeyFrames().add((Object)KEY_FRAME);
                    RadialSkin.this.rotationAngleTimeline.play();
                } else {
                    RadialSkin.this.gaugeValue.set(newValue.doubleValue());
                    RadialSkin.this.pointerRotation.setPivotX(RadialSkin.this.center.getX());
                    RadialSkin.this.pointerRotation.setPivotY(RadialSkin.this.center.getY());
                    RadialSkin.this.pointer.getTransforms().clear();
                    RadialSkin.this.pointer.getTransforms().add((Object)RadialSkin.this.pointerRotation);
                }
                RadialSkin.this.checkMarkers(RadialSkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
                if (RadialSkin.this.control.isSectionsHighlighting()) {
                    InnerShadow SECTION_INNER_GLOW = new InnerShadow();
                    SECTION_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow SECTION_GLOW = new DropShadow();
                    SECTION_GLOW.setWidth(0.05 * RadialSkin.this.gaugeBounds.getWidth());
                    SECTION_GLOW.setHeight(0.05 * RadialSkin.this.gaugeBounds.getHeight());
                    SECTION_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section section : RadialSkin.this.control.getSections()) {
                        Shape currentSection = section.getSectionArea();
                        if (section.contains(newValue.doubleValue())) {
                            SECTION_INNER_GLOW.setColor(section.getColor().darker());
                            SECTION_GLOW.setInput((Effect)SECTION_INNER_GLOW);
                            SECTION_GLOW.setColor(section.getColor().brighter());
                            currentSection.setEffect((Effect)SECTION_GLOW);
                            continue;
                        }
                        currentSection.setEffect(null);
                    }
                }
                if (RadialSkin.this.control.isAreasHighlighting()) {
                    InnerShadow AREA_INNER_GLOW = new InnerShadow();
                    AREA_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow AREA_GLOW = new DropShadow();
                    AREA_GLOW.setWidth(0.05 * RadialSkin.this.gaugeBounds.getWidth());
                    AREA_GLOW.setHeight(0.05 * RadialSkin.this.gaugeBounds.getHeight());
                    AREA_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section area : RadialSkin.this.control.getAreas()) {
                        Shape currentArea = area.getFilledArea();
                        if (area.contains(newValue.doubleValue())) {
                            AREA_INNER_GLOW.setColor(area.getColor().darker());
                            AREA_GLOW.setInput((Effect)AREA_INNER_GLOW);
                            AREA_GLOW.setColor(area.getColor().brighter());
                            currentArea.setEffect((Effect)AREA_GLOW);
                            continue;
                        }
                        currentArea.setEffect(null);
                    }
                }
            }
        });
        this.gaugeValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                if (RadialSkin.this.bargraphOff.isVisible()) {
                    int CURRENT_LED_INDEX;
                    int CALC_CURRENT_INDEX = RadialSkin.this.noOfLeds - 1 - (int)((newValue.doubleValue() - RadialSkin.this.control.getMinValue()) * RadialSkin.this.control.getAngleStep() / 5.0);
                    int CALC_FORMER_INDEX = RadialSkin.this.noOfLeds - 1 - (int)((oldValue.doubleValue() - RadialSkin.this.control.getMinValue()) * RadialSkin.this.control.getAngleStep() / 5.0);
                    int n = CALC_CURRENT_INDEX < 0 ? 0 : (CURRENT_LED_INDEX = CALC_CURRENT_INDEX > RadialSkin.this.noOfLeds ? RadialSkin.this.noOfLeds : CALC_CURRENT_INDEX);
                    int FORMER_LED_INDEX = CALC_FORMER_INDEX < 0 ? 0 : (CALC_FORMER_INDEX > RadialSkin.this.noOfLeds ? RadialSkin.this.noOfLeds : CALC_FORMER_INDEX);
                    int THRESHOLD_LED_INDEX = RadialSkin.this.noOfLeds - 1 - (int)((RadialSkin.this.control.getThreshold() - RadialSkin.this.control.getMinValue()) * RadialSkin.this.control.getAngleStep() / 5.0);
                    if (Double.compare(RadialSkin.this.control.getValue(), RadialSkin.this.formerValue.doubleValue()) >= 0) {
                        for (int i = CURRENT_LED_INDEX; i <= FORMER_LED_INDEX; ++i) {
                            ((Shape)RadialSkin.this.ledsOn.get(i)).setVisible(true);
                        }
                    } else {
                        for (int i = CURRENT_LED_INDEX; i >= FORMER_LED_INDEX; --i) {
                            ((Shape)RadialSkin.this.ledsOn.get(i)).setVisible(false);
                        }
                    }
                    if (RadialSkin.this.control.isThresholdVisible()) {
                        ((Shape)RadialSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).setVisible(true);
                        ((Shape)RadialSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).getStyleClass().clear();
                        ((Shape)RadialSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).getStyleClass().add((Object)"bargraph-threshold");
                    }
                } else {
                    RadialSkin.this.pointer.getTransforms().clear();
                    RadialSkin.this.pointerRotation.setPivotX(RadialSkin.this.center.getX());
                    RadialSkin.this.pointerRotation.setPivotY(RadialSkin.this.center.getY());
                    RadialSkin.this.pointer.getTransforms().add((Object)RadialSkin.this.pointerRotation);
                }
                RadialSkin.this.currentValue.set(newValue.doubleValue());
                RadialSkin.this.currentLcdValue.set(RadialSkin.this.control.isLcdValueCoupled() ? newValue.doubleValue() : RadialSkin.this.control.getLcdValue());
                if (Double.compare(RadialSkin.this.currentValue.get(), RadialSkin.this.control.getMinMeasuredValue()) < 0) {
                    RadialSkin.this.control.setMinMeasuredValue(RadialSkin.this.currentValue.get());
                } else if (Double.compare(RadialSkin.this.currentValue.get(), RadialSkin.this.control.getMaxMeasuredValue()) > 0) {
                    RadialSkin.this.control.setMaxMeasuredValue(RadialSkin.this.currentValue.get());
                }
                if (RadialSkin.this.control.isThresholdBehaviorInverted()) {
                    RadialSkin.this.control.setThresholdExceeded(RadialSkin.this.currentValue.doubleValue() < RadialSkin.this.control.getThreshold());
                } else {
                    RadialSkin.this.control.setThresholdExceeded(RadialSkin.this.currentValue.doubleValue() > RadialSkin.this.control.getThreshold());
                }
                if (!RadialSkin.this.control.isThresholdExceeded()) {
                    RadialSkin.this.ledOn.setOpacity(0.0);
                }
                if (RadialSkin.this.control.isLcdVisible()) {
                    RadialSkin.this.drawLcdContent();
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (!"ANIMATION_DURATION".equals(PROPERTY)) {
            if ("RADIAL_RANGE".equals(PROPERTY)) {
                this.noOfLeds = (int)(this.control.getRadialRange().ANGLE_RANGE / 5.0);
                this.isDirty = true;
                if (this.pointerRotation.angleProperty().isBound()) {
                    this.pointerRotation.angleProperty().unbind();
                }
                if (this.control.getRadialRange() == Gauge.RadialRange.RADIAL_360) {
                    this.pointerRotation.angleProperty().bind((ObservableValue)this.gaugeValue.multiply((ObservableNumberValue)this.control.angleStepProperty()).add(this.control.getRadialRange().ROTATION_OFFSET));
                } else {
                    this.pointerRotation.angleProperty().bind((ObservableValue)this.gaugeValue.subtract((ObservableNumberValue)this.control.minValueProperty()).multiply((ObservableNumberValue)this.control.angleStepProperty()).add(this.control.getRadialRange().ROTATION_OFFSET));
                }
            } else if ("FRAME_DESIGN".equals(PROPERTY)) {
                this.drawCircularFrame(this.control, this.frame, this.gaugeBounds);
            } else if ("BACKGROUND_DESIGN".equals(PROPERTY)) {
                this.drawCircularBackground(this.control, this.background, this.gaugeBounds);
                this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            } else if ("KNOB_DESIGN".equals(PROPERTY)) {
                this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            } else if ("KNOB_COLOR".equals(PROPERTY)) {
                this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            } else if ("POINTER_TYPE".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("VALUE_COLOR".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("THRESHOLD_COLOR".equals(PROPERTY)) {
                int THRESHOLD_LED_INDEX = this.noOfLeds - 1 - (int)((this.control.getThreshold() - this.control.getMinValue()) * this.control.getAngleStep() / 5.0);
                this.ledsOn.get(THRESHOLD_LED_INDEX).getStyleClass().clear();
                this.ledsOn.get(THRESHOLD_LED_INDEX).getStyleClass().add((Object)"bargraph-threshold");
                this.drawThreshold();
            } else if ("FOREGROUND_TYPE".equals(PROPERTY)) {
                this.drawCircularForeground(this.control, this.foreground, this.gaugeBounds);
            } else if ("LCD".equals(PROPERTY)) {
                this.drawCircularLcd(this.control, this.lcd, this.gaugeBounds);
                this.lcdUnitString.getStyleClass().clear();
                this.lcdUnitString.getStyleClass().add((Object)"lcd");
                this.lcdUnitString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
                this.lcdUnitString.getStyleClass().add((Object)"lcd-text");
                this.lcdValueString.getStyleClass().clear();
                this.lcdValueString.getStyleClass().add((Object)"lcd");
                this.lcdValueString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
                this.lcdValueString.getStyleClass().add((Object)"lcd-text");
                this.drawLcdContent();
            } else if ("USER_LED_BLINKING".equals(PROPERTY)) {
                if (this.userLedOff.isVisible() && this.userLedOn.isVisible()) {
                    if (this.control.isUserLedBlinking()) {
                        this.userLedTimer.start();
                    } else {
                        this.userLedTimer.stop();
                        this.userLedOn.setOpacity(0.0);
                    }
                }
            } else if ("LED_BLINKING".equals(PROPERTY)) {
                if (this.ledOff.isVisible() && this.ledOn.isVisible()) {
                    if (this.control.isLedBlinking()) {
                        this.ledTimer.start();
                    } else {
                        this.ledTimer.stop();
                        this.ledOn.setOpacity(0.0);
                    }
                }
            } else if ("GLOW_COLOR".equals(PROPERTY)) {
                this.glowColors.clear();
                Color GLOW_COLOR = this.control.getGlowColor();
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
                this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
                this.drawCircularGlowOn(this.control, this.glowOn, this.glowColors, this.gaugeBounds);
            } else if ("GLOW_VISIBILITY".equals(PROPERTY)) {
                this.glowOff.setVisible(this.control.isGlowVisible());
                if (!this.control.isGlowVisible()) {
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("GLOW_ON".equals(PROPERTY)) {
                if (this.glowOff.isVisible() && this.control.isGlowOn()) {
                    this.glowOn.setOpacity(1.0);
                    this.glowOff.setVisible(true);
                } else {
                    this.glowOff.setVisible(true);
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("PULSATING_GLOW".equals(PROPERTY)) {
                if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
                    if (!this.glowOn.isVisible()) {
                        this.glowOn.setVisible(true);
                    }
                    if (this.glowOn.getOpacity() < 1.0) {
                        this.glowOn.setOpacity(1.0);
                    }
                    this.glowPulse.play();
                } else {
                    this.glowPulse.stop();
                    this.glowOn.setOpacity(0.0);
                }
            } else if ("MIN_MEASURED_VALUE".equals(PROPERTY)) {
                this.minMeasured.getTransforms().clear();
                this.minMeasured.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getY()));
                this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getMinValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
                this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(this.control.getMinMeasuredValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
            } else if ("MAX_MEASURED_VALUE".equals(PROPERTY)) {
                this.maxMeasured.getTransforms().clear();
                this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getY()));
                this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getMinValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
                this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(this.control.getMaxMeasuredValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
            } else if ("TREND".equals(PROPERTY)) {
                this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
            } else if ("SIMPLE_GRADIENT_BASE".equals(PROPERTY)) {
                this.repaint();
            } else if ("TICKMARKS".equals(PROPERTY)) {
                this.negativeOffset = this.control.getMinValue() < 0.0 ? this.control.getMinValue() * this.control.getAngleStep() : 0.0;
                this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            } else if ("POINTER_GLOW".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("POINTER_SHADOW".equals(PROPERTY)) {
                this.drawPointer();
            } else if ("HISTOGRAM_CREATION".equals(PROPERTY)) {
                if (this.control.isHistogramCreationEnabled()) {
                    this.histogramFadingTimer.start();
                } else {
                    this.histogramFadingTimer.stop();
                }
            } else if ("HISTOGRAM_PERIOD".equals(PROPERTY)) {
                this.histogramInterval = (long)this.control.histogramDataPeriodInMinutesProperty().get() * 60000000000L / 100L;
            } else if ("GAUGE_MODEL".equals(PROPERTY)) {
                this.addBindings();
                this.repaint();
            } else if ("STYLE_MODEL".equals(PROPERTY)) {
                this.addBindings();
                this.repaint();
            } else if ("THRESHOLD_EXCEEDED".equals(PROPERTY)) {
                if (this.control.isThresholdExceeded()) {
                    this.ledTimer.start();
                } else {
                    this.ledTimer.stop();
                }
            } else if ("PREF_WIDTH".equals(PROPERTY)) {
                double SIZE;
                double d = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
                if (SIZE > 0.0) {
                    this.img = new WritableImage((int)SIZE, (int)SIZE);
                }
                this.calcGaugeBounds();
                this.repaint();
            } else if ("PREF_HEIGHT".equals(PROPERTY)) {
                double SIZE;
                double d = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
                if (SIZE > 0.0) {
                    this.img = new WritableImage((int)SIZE, (int)SIZE);
                }
                this.calcGaugeBounds();
                this.repaint();
            } else if ("AREAS".equals(PROPERTY)) {
                this.updateAreas();
                this.drawCircularAreas(this.control, this.areas, this.gaugeBounds);
            } else if ("SECTIONS".equals(PROPERTY)) {
                this.updateSections();
                this.drawCircularSections(this.control, this.sections, this.gaugeBounds);
            } else if ("MARKERS".equals(PROPERTY)) {
                this.drawCircularIndicators(this.control, this.markers, this.center, this.gaugeBounds);
            }
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        this.adjustLcdFont();
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.calcGaugeBounds();
            this.setTranslateX(this.framelessOffset.getX());
            this.setTranslateY(this.framelessOffset.getY());
            this.center = new Point2D(this.gaugeBounds.getWidth() * 0.5, this.gaugeBounds.getHeight() * 0.5);
            this.drawCircularFrame(this.control, this.frame, this.gaugeBounds);
            this.drawCircularBackground(this.control, this.background, this.gaugeBounds);
            this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
            this.updateSections();
            this.drawCircularSections(this.control, this.sections, this.gaugeBounds);
            this.updateAreas();
            this.drawCircularAreas(this.control, this.areas, this.gaugeBounds);
            this.drawTitleAndUnit();
            this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            this.drawCircularLed(this.control, this.ledOff, this.ledOn, this.gaugeBounds);
            this.drawCircularUserLed(this.control, this.userLedOff, this.userLedOn, this.gaugeBounds);
            this.drawThreshold();
            this.drawCircularGlowOff(this.glowOff, this.gaugeBounds);
            this.drawCircularGlowOn(this.control, this.glowOn, this.glowColors, this.gaugeBounds);
            this.drawMinMeasuredIndicator();
            this.drawMaxMeasuredIndicator();
            this.drawCircularIndicators(this.control, this.markers, this.center, this.gaugeBounds);
            this.drawCircularLcd(this.control, this.lcd, this.gaugeBounds);
            this.drawLcdContent();
            this.drawPointer();
            this.drawCircularBargraph(this.control, this.bargraphOff, this.noOfLeds, this.ledsOff, false, true, this.center, this.gaugeBounds);
            this.drawCircularBargraph(this.control, this.bargraphOn, this.noOfLeds, this.ledsOn, true, false, this.center, this.gaugeBounds);
            this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            this.drawCircularForeground(this.control, this.foreground, this.gaugeBounds);
            if (this.control.isPointerShadowEnabled() && !this.control.isPointerGlowEnabled()) {
                this.addDropShadow(this.control, new Node[]{this.knobs, this.pointerShadow});
            }
            this.getChildren().setAll((Object[])new Node[]{this.frame, this.background, this.histogram, this.trend, this.sections, this.areas, this.ledOff, this.ledOn, this.userLedOff, this.userLedOn, this.titleAndUnit, this.tickmarks, this.threshold, this.glowOff, this.glowOn, this.lcd, this.lcdContent, this.pointerShadow, this.bargraphOff, this.bargraphOn, this.minMeasured, this.maxMeasured, this.markers, this.knobsShadow, this.foreground});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public Radial getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        double prefWidth = PREF_SIZE.getWidth();
        if (HEIGHT != -1.0) {
            prefWidth = Math.max(0.0, HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        double prefHeight = PREF_SIZE.getHeight();
        if (WIDTH != -1.0) {
            prefHeight = Math.max(0.0, WIDTH - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefHeight);
    }

    @Override
    protected double computeMinWidth(double WIDTH) {
        return super.computeMinWidth(Math.max(MIN_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMinHeight(double HEIGHT) {
        return super.computeMinHeight(Math.max(MIN_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    @Override
    protected double computeMaxWidth(double WIDTH) {
        return super.computeMaxWidth(Math.max(MAX_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMaxHeight(double HEIGHT) {
        return super.computeMaxHeight(Math.max(MAX_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        int lcdDecimals = this.control.getLcdDecimals();
        boolean lcdScientificFormatEnabled = false;
        if (lcdDecimals > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < lcdDecimals; ++i) {
            DEC_BUFFER.append("0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    private void calcGaugeBounds() {
        if (this.control.isFrameVisible()) {
            this.gaugeBounds.setWidth(this.control.getPrefWidth());
            this.gaugeBounds.setHeight(this.control.getPrefHeight());
            this.framelessOffset = new Point2D(0.0, 0.0);
        } else {
            this.gaugeBounds.setWidth(this.control.getPrefWidth() * 1.202247191);
            this.gaugeBounds.setHeight(this.control.getPrefHeight() * 1.202247191);
            this.framelessOffset = new Point2D(-this.gaugeBounds.getWidth() * 0.0841121495, -this.gaugeBounds.getWidth() * 0.0841121495);
        }
    }

    private void updateSections() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.38;
        double INNER_RADIUS = this.control.isExpandedSections() ? OUTER_RADIUS - this.control.getPrefWidth() * 0.12 : OUTER_RADIUS - this.control.getPrefWidth() * 0.04;
        Circle INNER = new Circle(this.center.getX(), this.center.getY(), INNER_RADIUS);
        for (Section section : this.control.getSections()) {
            double SECTION_START = section.getStart() < this.control.getMinValue() ? this.control.getMinValue() : section.getStart();
            double SECTION_STOP = section.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : section.getStop();
            double ANGLE_START = this.control.getRadialRange().SECTIONS_OFFSET - SECTION_START * this.control.getAngleStep() + this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = -(SECTION_STOP - SECTION_START) * this.control.getAngleStep();
            Arc OUTER_ARC = new Arc();
            OUTER_ARC.setType(ArcType.ROUND);
            OUTER_ARC.setCenterX(this.center.getX());
            OUTER_ARC.setCenterY(this.center.getY());
            OUTER_ARC.setRadiusX(OUTER_RADIUS);
            OUTER_ARC.setRadiusY(OUTER_RADIUS);
            OUTER_ARC.setStartAngle(ANGLE_START);
            OUTER_ARC.setLength(ANGLE_EXTEND);
            Shape SECTION = Shape.subtract((Shape)OUTER_ARC, (Shape)INNER);
            section.setSectionArea(SECTION);
        }
    }

    private void updateAreas() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.38;
        double INNER_RADIUS = this.control.isExpandedSections() ? this.control.getPrefWidth() * 0.12 : this.control.getPrefWidth() * 0.04;
        double RADIUS = OUTER_RADIUS - INNER_RADIUS;
        for (Section area : this.control.getAreas()) {
            double AREA_START = area.getStart() < this.control.getMinValue() ? this.control.getMinValue() : area.getStart();
            double AREA_STOP = area.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : area.getStop();
            double ANGLE_START = this.control.getRadialRange().SECTIONS_OFFSET - AREA_START * this.control.getAngleStep() + this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = -(AREA_STOP - AREA_START) * this.control.getAngleStep();
            Arc ARC = new Arc();
            ARC.setType(ArcType.ROUND);
            ARC.setCenterX(this.center.getX());
            ARC.setCenterY(this.center.getY());
            ARC.setRadiusX(RADIUS);
            ARC.setRadiusY(RADIUS);
            ARC.setStartAngle(ANGLE_START);
            ARC.setLength(ANGLE_EXTEND);
            area.setFilledArea((Shape)ARC);
        }
    }

    private void adjustLcdFont() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double LCD_HEIGHT = SIZE * this.control.getRadialRange().LCD_FACTORS.getHeight();
        this.lcdUnitFont = Font.font((String)this.control.getLcdUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.4 * LCD_HEIGHT));
        switch (this.control.getLcdValueFont()) {
            case LCD: {
                this.lcdValueFont = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/digital.ttf"), (double)(0.75 * LCD_HEIGHT));
                break;
            }
            case BUS: {
                this.lcdValueFont = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/bus.otf"), (double)(0.6 * LCD_HEIGHT));
                break;
            }
            case PIXEL: {
                this.lcdValueFont = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/pixel.ttf"), (double)(0.6 * LCD_HEIGHT));
                break;
            }
            case PHONE_LCD: {
                this.lcdValueFont = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/phonelcd.ttf"), (double)(0.6 * LCD_HEIGHT));
                break;
            }
            default: {
                this.lcdValueFont = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.6 * LCD_HEIGHT));
            }
        }
    }

    private void addValueToHistogram(double VALUE) {
        double SIZE;
        double d = SIZE = this.control.getPrefWidth() <= this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        if (this.img == null) {
            this.img = new WritableImage((int)SIZE, (int)SIZE);
        }
        this.histogramImage.setImage((Image)this.histogram.snapshot(this.SNAPSHOT_PARAMETER, this.img));
        this.histogramImage.setClip((Node)new Circle(0.5 * SIZE, 0.5 * SIZE, 0.4158878504672897 * SIZE));
        this.histogramImage.setOpacity(1.0);
        this.histogram.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        Line line = new Line(this.center.getX(), this.center.getY() - SIZE * 0.22, this.center.getX(), this.center.getY() - SIZE * 0.25);
        line.setStrokeWidth(this.control.getHistogramLineWidth());
        line.setStroke((Paint)this.control.getHistogramColor());
        line.getTransforms().add((Object)Transform.rotate((double)(this.control.getRadialRange().ROTATION_OFFSET + (VALUE - this.control.getMinValue()) * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        line.setBlendMode(BlendMode.HARD_LIGHT);
        this.histogram.getChildren().addAll((Object[])new Node[]{IBOUNDS, this.histogramImage, line});
    }

    private void reduceHistogramOpacity() {
        if (Double.compare(this.histogramImage.getOpacity(), 0.0) > 0) {
            this.histogramImage.setOpacity(this.histogramImage.getOpacity() - this.control.histogramDataPeriodInMinutesProperty().doubleValue() / 100.0);
        }
    }

    public void drawTitleAndUnit() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        this.titleAndUnit.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.titleAndUnit.getChildren().add((Object)IBOUNDS);
        Font TITLE_FONT = Font.font((String)this.control.getTitleFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * SIZE));
        Text TITLE = new Text();
        TITLE.setTextOrigin(VPos.BOTTOM);
        TITLE.setFont(TITLE_FONT);
        TITLE.setText(this.control.getTitle());
        TITLE.setX((SIZE - TITLE.getLayoutBounds().getWidth()) / 2.0);
        TITLE.setY(0.3 * SIZE + TITLE.getLayoutBounds().getHeight());
        TITLE.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        Font UNIT_FONT = Font.font((String)this.control.getUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * SIZE));
        Text UNIT = new Text();
        UNIT.setTextOrigin(VPos.BOTTOM);
        UNIT.setFont(UNIT_FONT);
        UNIT.setText(this.control.getUnit());
        UNIT.setX((SIZE - UNIT.getLayoutBounds().getWidth()) / 2.0);
        UNIT.setY(0.365 * SIZE + UNIT.getLayoutBounds().getHeight());
        UNIT.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        this.titleAndUnit.getChildren().addAll((Object[])new Node[]{TITLE, UNIT});
        this.titleAndUnit.setCache(true);
    }

    public void drawThreshold() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.threshold.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.threshold.getChildren().add((Object)IBOUNDS);
        Path THRESHOLD = this.createTriangleShape(0.03 * WIDTH, 0.03 * HEIGHT, false);
        THRESHOLD.setStrokeType(StrokeType.CENTERED);
        THRESHOLD.setStrokeLineCap(StrokeLineCap.ROUND);
        THRESHOLD.setStrokeLineJoin(StrokeLineJoin.ROUND);
        THRESHOLD.setStrokeWidth(0.002 * HEIGHT);
        THRESHOLD.getStyleClass().add((Object)"root");
        THRESHOLD.getStyleClass().add((Object)this.control.getThresholdColor().CSS);
        THRESHOLD.getStyleClass().add((Object)"threshold-gradient");
        THRESHOLD.setTranslateX(0.485 * WIDTH);
        THRESHOLD.setTranslateY(0.14 * HEIGHT);
        this.threshold.getChildren().addAll((Object[])new Node[]{THRESHOLD});
        this.threshold.getTransforms().clear();
        this.threshold.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getY()));
        this.threshold.getTransforms().add((Object)Transform.rotate((double)(-this.control.getMinValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.threshold.getTransforms().add((Object)Transform.rotate((double)(this.control.getThreshold() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.threshold.setCache(true);
    }

    public void drawMinMeasuredIndicator() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.minMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.minMeasured.getChildren().add((Object)IBOUNDS);
        Path MIN_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * HEIGHT, true);
        MIN_MEASURED.setFill((Paint)Color.color((double)0.0, (double)0.0, (double)0.8));
        MIN_MEASURED.setStroke(null);
        MIN_MEASURED.setTranslateX(0.485 * WIDTH);
        MIN_MEASURED.setTranslateY(0.1 * HEIGHT);
        this.minMeasured.getChildren().add((Object)MIN_MEASURED);
        this.minMeasured.getTransforms().clear();
        this.minMeasured.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getY()));
        this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getMinValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(this.control.getMinMeasuredValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.minMeasured.setCache(true);
        this.minMeasured.setCacheHint(CacheHint.ROTATE);
    }

    public void drawMaxMeasuredIndicator() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.maxMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.maxMeasured.getChildren().add((Object)IBOUNDS);
        Path MAX_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * HEIGHT, true);
        MAX_MEASURED.setFill((Paint)Color.color((double)0.8, (double)0.0, (double)0.0));
        MAX_MEASURED.setStroke(null);
        MAX_MEASURED.setTranslateX(0.485 * WIDTH);
        MAX_MEASURED.setTranslateY(0.1 * HEIGHT);
        this.maxMeasured.getChildren().add((Object)MAX_MEASURED);
        this.maxMeasured.getTransforms().clear();
        this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getY()));
        this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getMinValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(this.control.getMaxMeasuredValue() * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.maxMeasured.setCache(true);
        this.maxMeasured.setCacheHint(CacheHint.ROTATE);
    }

    public void drawPointer() {
        double SIZE;
        double WIDTH = SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double HEIGHT = SIZE;
        this.pointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.pointer.getChildren().add((Object)IBOUNDS);
        Path POINTER = new Path();
        Path POINTER_FRONT = new Path();
        POINTER.setSmooth(true);
        POINTER.getStyleClass().add((Object)"root");
        POINTER.setStyle("-fx-value: " + this.control.getValueColor().CSS);
        switch (this.control.getPointerType()) {
            case TYPE2: {
                POINTER.getStyleClass().add((Object)"pointer2-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.46261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.3411214953271028 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.2336448598130841 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5046728971962616 * WIDTH, 0.2336448598130841 * HEIGHT, 0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT, 0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT, 0.49065420560747663 * WIDTH, 0.2336448598130841 * HEIGHT, 0.49065420560747663 * WIDTH, 0.2336448598130841 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.3411214953271028 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.46261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48130841121495327 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.48130841121495327 * WIDTH, 0.4719626168224299 * HEIGHT, 0.4672897196261682 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4672897196261682 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4672897196261682 * WIDTH, 0.5186915887850467 * HEIGHT, 0.48130841121495327 * WIDTH, 0.5327102803738317 * HEIGHT, 0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.514018691588785 * WIDTH, 0.5327102803738317 * HEIGHT, 0.5327102803738317 * WIDTH, 0.5186915887850467 * HEIGHT, 0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5327102803738317 * WIDTH, 0.49065420560747663 * HEIGHT, 0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT, 0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE3: {
                POINTER.getStyleClass().add((Object)"pointer3-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE4: {
                POINTER.getStyleClass().add((Object)"pointer4-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.1261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.13551401869158877 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5233644859813084 * WIDTH, 0.602803738317757 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4766355140186916 * WIDTH, 0.602803738317757 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.46261682242990654 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.13551401869158877 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE5: {
                POINTER.getStyleClass().add((Object)"pointer5-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.5, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5280373831775701, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.14953271028037382));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE6: {
                POINTER.getStyleClass().add((Object)"pointer6-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.48130841121495327, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48130841121495327, HEIGHT * 0.3925233644859813));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48598130841121495, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.514018691588785, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5186915887850467, HEIGHT * 0.3878504672897196));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5186915887850467, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.3878504672897196));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.3925233644859813));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48130841121495327, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE7: {
                POINTER.getStyleClass().add((Object)"pointer7-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4766355140186916 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5186915887850467 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE8: {
                POINTER.getStyleClass().add((Object)"pointer8-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT, 0.5046728971962616 * WIDTH, 0.45794392523364486 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49065420560747663 * WIDTH, 0.45794392523364486 * HEIGHT, 0.46261682242990654 * WIDTH, 0.5 * HEIGHT, 0.46261682242990654 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE9: {
                POINTER.getStyleClass().add((Object)"pointer9-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.4953271028037383, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.514018691588785, HEIGHT * 0.4392523364485981));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48598130841121495, HEIGHT * 0.4392523364485981));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.49065420560747663, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.5280373831775701));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4719626168224299, HEIGHT * 0.5280373831775701, WIDTH * 0.4766355140186916, HEIGHT * 0.602803738317757, WIDTH * 0.4766355140186916, HEIGHT * 0.602803738317757));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4766355140186916, HEIGHT * 0.6074766355140186, WIDTH * 0.48130841121495327, HEIGHT * 0.6074766355140186, WIDTH * 0.5, HEIGHT * 0.6074766355140186));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.6074766355140186, WIDTH * 0.5233644859813084, HEIGHT * 0.6074766355140186, WIDTH * 0.5233644859813084, HEIGHT * 0.602803738317757));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5233644859813084, HEIGHT * 0.602803738317757, WIDTH * 0.5280373831775701, HEIGHT * 0.5280373831775701, WIDTH * 0.5280373831775701, HEIGHT * 0.5280373831775701));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5280373831775701, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5093457943925234, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.49065420560747663, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                POINTER_FRONT.getStyleClass().add((Object)"root");
                POINTER_FRONT.setStyle("-fx-value: " + this.control.getValueColor().CSS);
                POINTER_FRONT.getStyleClass().add((Object)"pointer9-box");
                POINTER_FRONT.setFillRule(FillRule.EVEN_ODD);
                POINTER_FRONT.getElements().add((Object)new MoveTo(WIDTH * 0.4953271028037383, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.13551401869158877));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.13551401869158877));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new ClosePath());
                POINTER_FRONT.setStroke(null);
                break;
            }
            case TYPE10: {
                POINTER.getStyleClass().add((Object)"pointer10-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT, 0.4439252336448598 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4439252336448598 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4439252336448598 * WIDTH, 0.5327102803738317 * HEIGHT, 0.4672897196261682 * WIDTH, 0.5560747663551402 * HEIGHT, 0.4953271028037383 * WIDTH, 0.5560747663551402 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5280373831775701 * WIDTH, 0.5560747663551402 * HEIGHT, 0.5560747663551402 * WIDTH, 0.5327102803738317 * HEIGHT, 0.5560747663551402 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5560747663551402 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE11: {
                POINTER.getStyleClass().add((Object)"pointer11-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT, 0.48130841121495327 * WIDTH, 0.5841121495327103 * HEIGHT, 0.5 * WIDTH, 0.5841121495327103 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.514018691588785 * WIDTH, 0.5841121495327103 * HEIGHT, 0.5093457943925234 * WIDTH, 0.5 * HEIGHT, 0.5093457943925234 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE12: {
                POINTER.getStyleClass().add((Object)"pointer12-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE13: {
                POINTER.getStyleClass().add((Object)"pointer13-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE14: {
                POINTER.getStyleClass().add((Object)"pointer14-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE15: {
                POINTER.getStyleClass().add((Object)"pointer15-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.46 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.15 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.53 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE16: {
                POINTER.getStyleClass().add((Object)"pointer16-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.495 * WIDTH, 0.625 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.625 * HEIGHT, 0.535 * WIDTH, 0.61 * HEIGHT, 0.535 * WIDTH, 0.61 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.525 * WIDTH, 0.6 * HEIGHT, 0.505 * WIDTH, 0.53 * HEIGHT, 0.505 * WIDTH, 0.53 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.47 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.17 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.165 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.13 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.13 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.165 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.17 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.47 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.53 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49 * WIDTH, 0.53 * HEIGHT, 0.47 * WIDTH, 0.6 * HEIGHT, 0.465 * WIDTH, 0.61 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.465 * WIDTH, 0.61 * HEIGHT, 0.475 * WIDTH, 0.625 * HEIGHT, 0.495 * WIDTH, 0.625 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            default: {
                POINTER.setStyle("-fx-value: " + this.control.getValueColor().CSS);
                POINTER.getStyleClass().add((Object)"pointer1-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.514018691588785, HEIGHT * 0.45794392523364486, WIDTH * 0.5093457943925234, HEIGHT * 0.4158878504672897, WIDTH * 0.5093457943925234, HEIGHT * 0.40186915887850466));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5046728971962616, HEIGHT * 0.38317757009345793, WIDTH * 0.5, HEIGHT * 0.1308411214953271, WIDTH * 0.5, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5, HEIGHT * 0.1308411214953271, WIDTH * 0.49065420560747663, HEIGHT * 0.38317757009345793, WIDTH * 0.49065420560747663, HEIGHT * 0.397196261682243));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.49065420560747663, HEIGHT * 0.4158878504672897, WIDTH * 0.48598130841121495, HEIGHT * 0.45794392523364486, WIDTH * 0.48130841121495327, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4719626168224299, HEIGHT * 0.48130841121495327, WIDTH * 0.4672897196261682, HEIGHT * 0.49065420560747663, WIDTH * 0.4672897196261682, HEIGHT * 0.5));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4672897196261682, HEIGHT * 0.5186915887850467, WIDTH * 0.48130841121495327, HEIGHT * 0.5327102803738317, WIDTH * 0.5, HEIGHT * 0.5327102803738317));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.5327102803738317, WIDTH * 0.5327102803738317, HEIGHT * 0.5186915887850467, WIDTH * 0.5327102803738317, HEIGHT * 0.5));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5327102803738317, HEIGHT * 0.49065420560747663, WIDTH * 0.5280373831775701, HEIGHT * 0.48130841121495327, WIDTH * 0.5186915887850467, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
            }
        }
        if (this.control.isPointerGlowEnabled()) {
            DropShadow GLOW = new DropShadow();
            GLOW.setWidth(0.04 * SIZE);
            GLOW.setHeight(0.04 * SIZE);
            GLOW.setOffsetX(0.0);
            GLOW.setOffsetY(0.0);
            GLOW.setRadius(0.04 * SIZE);
            GLOW.setColor(this.control.getValueColor().COLOR);
            GLOW.setBlurType(BlurType.GAUSSIAN);
            if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
                POINTER_FRONT.setEffect((Effect)GLOW);
            } else {
                POINTER.setEffect((Effect)GLOW);
            }
        }
        this.pointer.getChildren().addAll((Object[])new Node[]{POINTER});
        if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
            this.pointer.getChildren().add((Object)POINTER_FRONT);
        }
        this.pointer.getTransforms().clear();
        double VALUE = this.control.getValue() < this.control.getMinValue() ? this.control.getMinValue() : this.control.getValue();
        this.pointer.getTransforms().add((Object)Transform.rotate((double)(this.control.getRadialRange().ROTATION_OFFSET + (VALUE - this.control.getMinValue()) * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getY()));
        this.pointer.setCache(true);
        this.pointer.setCacheHint(CacheHint.ROTATE);
    }

    public void drawLcdContent() {
        double UNIT_Y_OFFSET;
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        this.lcdContent.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.lcdContent.getChildren().add((Object)IBOUNDS);
        Rectangle LCD_FRAME = new Rectangle((SIZE - SIZE * this.control.getRadialRange().LCD_FACTORS.getX()) / 2.0, SIZE * this.control.getRadialRange().LCD_FACTORS.getY(), SIZE * this.control.getRadialRange().LCD_FACTORS.getWidth(), SIZE * this.control.getRadialRange().LCD_FACTORS.getHeight());
        switch (this.control.getLcdValueFont()) {
            case LCD: {
                UNIT_Y_OFFSET = 1.5;
                break;
            }
            case BUS: {
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            case PIXEL: {
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            case PHONE_LCD: {
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            default: {
                UNIT_Y_OFFSET = 2.0;
            }
        }
        if (this.lcdValueFont == null) {
            this.adjustLcdFont();
        }
        this.lcdValueString.setFont(this.lcdValueFont);
        this.lcdUnitString.setFont(this.lcdUnitFont);
        this.lcdUnitString.setText(this.control.isLcdValueCoupled() ? this.control.getUnit() : this.control.getLcdUnit());
        this.lcdUnitString.setTextOrigin(VPos.BOTTOM);
        this.lcdUnitString.setTextAlignment(TextAlignment.RIGHT);
        if (this.lcdUnitString.visibleProperty().isBound()) {
            this.lcdUnitString.visibleProperty().unbind();
        }
        this.lcdUnitString.visibleProperty().bind((ObservableValue)this.control.lcdUnitVisibleProperty());
        if (this.control.isLcdUnitVisible()) {
            this.lcdUnitString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdUnitString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0833333333);
            this.lcdUnitString.setY(LCD_FRAME.getY() + (LCD_FRAME.getHeight() + this.lcdValueString.getLayoutBounds().getHeight()) / UNIT_Y_OFFSET - this.lcdValueString.getLayoutBounds().getHeight() * 0.05);
        }
        this.lcdUnitString.setStroke(null);
        switch (this.control.getLcdNumberSystem()) {
            case HEXADECIMAL: {
                this.lcdValueString.setText(Integer.toHexString((int)this.currentLcdValue.get()).toUpperCase());
                break;
            }
            case OCTAL: {
                this.lcdValueString.setText(Integer.toOctalString((int)this.currentLcdValue.get()).toUpperCase());
                break;
            }
            default: {
                this.lcdValueString.setText(this.formatLcdValue(this.currentLcdValue.get()));
            }
        }
        if (this.control.isLcdUnitVisible()) {
            this.lcdValueString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdUnitString.getLayoutBounds().getWidth() - this.lcdValueString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0833333333);
        } else {
            this.lcdValueString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdValueString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0833333333);
        }
        this.lcdValueString.setY(LCD_FRAME.getY() + (LCD_FRAME.getHeight() + this.lcdValueString.getLayoutBounds().getHeight()) / 2.0);
        this.lcdValueString.setTextOrigin(VPos.BOTTOM);
        this.lcdValueString.setTextAlignment(TextAlignment.RIGHT);
        this.lcdValueString.setStroke(null);
        this.lcdContent.getChildren().addAll((Object[])new Node[]{this.lcdUnitString, this.lcdValueString});
    }
}

