/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import jfxtras.labs.internal.scene.control.behavior.SevenSegmentBehavior;
import jfxtras.labs.scene.control.gauge.SevenSegment;
import jfxtras.labs.util.Util;

public class SevenSegmentSkin
extends SkinBase<SevenSegment, SevenSegmentBehavior> {
    private SevenSegment control;
    private boolean isDirty;
    private boolean initialized;
    private Group segments;
    private Map<SevenSegment.Segment, Shape> segmentMap;

    public SevenSegmentSkin(SevenSegment CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SevenSegmentBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.segments = new Group();
        this.segmentMap = new HashMap<SevenSegment.Segment, Shape>(17);
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(40.0, 56.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(8.0, 11.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(400.0, 560.0);
        }
        this.createSegments();
        this.updateCharacter();
        this.registerChangeListener((ObservableValue)this.control.characterProperty(), "CHARACTER");
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.plainColorProperty(), "PLAIN_COLOR");
        this.registerChangeListener((ObservableValue)this.control.customSegmentMappingProperty(), "CUSTOM_MAPPING");
        this.registerChangeListener((ObservableValue)this.control.dotOnProperty(), "DOT_ON");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("CHARACTER".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("COLOR".equals(PROPERTY)) {
            this.updateSegmentColor();
        } else if ("PLAIN_COLOR".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("CUSTOM_MAPPING".equals(PROPERTY)) {
            this.updateCharacter();
        } else if ("DOT_ON".equals(PROPERTY)) {
            this.updateCharacter();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.updateCharacter();
            this.getChildren().setAll((Object[])new Node[]{this.segments});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final SevenSegment getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 40.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 56.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void updateSegmentColor() {
        this.control.setStyle("-fx-segment-color-on: " + Util.colorToCssColor(this.control.getColor()) + "-fx-segment-color-off: " + Util.colorToCssColor(Color.color((double)this.control.getColor().getRed(), (double)this.control.getColor().getGreen(), (double)this.control.getColor().getBlue(), (double)0.075)));
    }

    private void updateCharacter() {
        String ON_STYLE;
        this.updateSegmentColor();
        int ASCII = this.control.getCharacter().isEmpty() ? 20 : (int)this.control.getCharacter().toUpperCase().charAt(0);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setRadius(0.05 * this.control.getPrefWidth());
        INNER_SHADOW.setColor(Color.hsb((double)this.control.getColor().getHue(), (double)this.control.getColor().getSaturation(), (double)0.2));
        String CURRENT_STYLE = this.control.getStyle();
        String string = ON_STYLE = this.control.isPlainColor() ? "plain-on" : "on";
        if (this.control.getCustomSegmentMapping().isEmpty()) {
            for (SevenSegment.Segment segment : this.segmentMap.keySet()) {
                if (this.control.getSegmentMapping().containsKey(ASCII)) {
                    if (this.control.getSegmentMapping().get(ASCII).contains((Object)segment)) {
                        this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                        this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{ON_STYLE});
                        this.segmentMap.get((Object)segment).setEffect((Effect)INNER_SHADOW);
                        continue;
                    }
                    this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                    this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{"off"});
                    this.segmentMap.get((Object)segment).setEffect(null);
                    continue;
                }
                this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{"off"});
                this.segmentMap.get((Object)segment).setEffect(null);
            }
        } else {
            for (SevenSegment.Segment segment : this.segmentMap.keySet()) {
                if (this.control.getCustomSegmentMapping().containsKey(ASCII)) {
                    if (this.control.getCustomSegmentMapping().get(ASCII).contains((Object)segment)) {
                        this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                        this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{ON_STYLE});
                        this.segmentMap.get((Object)segment).setEffect((Effect)INNER_SHADOW);
                        continue;
                    }
                    this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                    this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{"off"});
                    this.segmentMap.get((Object)segment).setEffect(null);
                    continue;
                }
                this.segmentMap.get((Object)segment).setStyle(CURRENT_STYLE);
                this.segmentMap.get((Object)segment).getStyleClass().setAll((Object[])new String[]{"off"});
                this.segmentMap.get((Object)segment).setEffect(null);
            }
        }
        if (this.control.isDotOn()) {
            this.segmentMap.get((Object)SevenSegment.Segment.DOT).setStyle(CURRENT_STYLE);
            this.segmentMap.get((Object)SevenSegment.Segment.DOT).getStyleClass().setAll((Object[])new String[]{ON_STYLE});
            this.segmentMap.get((Object)SevenSegment.Segment.DOT).setEffect((Effect)INNER_SHADOW);
        }
    }

    private void createSegments() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.updateSegmentColor();
        this.segments.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.segments.getChildren().add((Object)IBOUNDS);
        Path A = new Path();
        A.setFillRule(FillRule.EVEN_ODD);
        A.getElements().add((Object)new MoveTo(0.11790393013100436 * WIDTH, 0.014925373134328358 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.11790393013100436 * WIDTH, 0.01791044776119403 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.1965065502183406 * WIDTH, 0.07164179104477612 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.8122270742358079 * WIDTH, 0.07164179104477612 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.8864628820960698 * WIDTH, 0.020895522388059702 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.8864628820960698 * WIDTH, 0.01791044776119403 * HEIGHT));
        A.getElements().add((Object)new LineTo(0.8602620087336245 * WIDTH, 0.0));
        A.getElements().add((Object)new LineTo(0.13973799126637554 * WIDTH, 0.0));
        A.getElements().add((Object)new LineTo(0.11790393013100436 * WIDTH, 0.014925373134328358 * HEIGHT));
        A.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.A, (Shape)A);
        Path B = new Path();
        B.setFillRule(FillRule.EVEN_ODD);
        B.getElements().add((Object)new MoveTo(0.8951965065502183 * WIDTH, 0.023880597014925373 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.9213973799126638 * WIDTH, 0.04477611940298507 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.9213973799126638 * WIDTH, 0.08358208955223881 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.8820960698689956 * WIDTH, 0.4626865671641791 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.8296943231441049 * WIDTH, 0.49850746268656715 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.777292576419214 * WIDTH, 0.4626865671641791 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.8209606986899564 * WIDTH, 0.07462686567164178 * HEIGHT));
        B.getElements().add((Object)new LineTo(0.8951965065502183 * WIDTH, 0.023880597014925373 * HEIGHT));
        B.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.B, (Shape)B);
        Path C2 = new Path();
        C2.setFillRule(FillRule.EVEN_ODD);
        C2.getElements().add((Object)new MoveTo(0.8296943231441049 * WIDTH, 0.5014925373134328 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.8777292576419214 * WIDTH, 0.5343283582089552 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.8296943231441049 * WIDTH, 0.9671641791044776 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.8078602620087336 * WIDTH, 0.982089552238806 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.7292576419213974 * WIDTH, 0.9253731343283582 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.7685589519650655 * WIDTH, 0.5432835820895522 * HEIGHT));
        C2.getElements().add((Object)new LineTo(0.8296943231441049 * WIDTH, 0.5014925373134328 * HEIGHT));
        C2.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.C, (Shape)C2);
        Path D = new Path();
        D.setFillRule(FillRule.EVEN_ODD);
        D.getElements().add((Object)new MoveTo(0.7205240174672489 * WIDTH, 0.9283582089552239 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.1091703056768559 * WIDTH, 0.9283582089552239 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.039301310043668124 * WIDTH, 0.9761194029850746 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.039301310043668124 * WIDTH, 0.982089552238806 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.06550218340611354 * WIDTH, HEIGHT));
        D.getElements().add((Object)new LineTo(0.7816593886462883 * WIDTH, HEIGHT));
        D.getElements().add((Object)new LineTo(0.7991266375545851 * WIDTH, 0.9880597014925373 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.7991266375545851 * WIDTH, 0.982089552238806 * HEIGHT));
        D.getElements().add((Object)new LineTo(0.7205240174672489 * WIDTH, 0.9283582089552239 * HEIGHT));
        D.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.D, (Shape)D);
        Path E = new Path();
        E.setFillRule(FillRule.EVEN_ODD);
        E.getElements().add((Object)new MoveTo(0.03056768558951965 * WIDTH, 0.9761194029850746 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.0, 0.9552238805970149 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.0, 0.9164179104477612 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.043668122270742356 * WIDTH, 0.5373134328358209 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.09606986899563319 * WIDTH, 0.5014925373134328 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.14410480349344978 * WIDTH, 0.5373134328358209 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.10043668122270742 * WIDTH, 0.9253731343283582 * HEIGHT));
        E.getElements().add((Object)new LineTo(0.03056768558951965 * WIDTH, 0.9761194029850746 * HEIGHT));
        E.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.E, (Shape)E);
        Path F = new Path();
        F.setFillRule(FillRule.EVEN_ODD);
        F.getElements().add((Object)new MoveTo(0.1091703056768559 * WIDTH, 0.01791044776119403 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.18777292576419213 * WIDTH, 0.07462686567164178 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.15283842794759825 * WIDTH, 0.45671641791044776 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.09170305676855896 * WIDTH, 0.49850746268656715 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.043668122270742356 * WIDTH, 0.4626865671641791 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.08733624454148471 * WIDTH, 0.03283582089552239 * HEIGHT));
        F.getElements().add((Object)new LineTo(0.1091703056768559 * WIDTH, 0.01791044776119403 * HEIGHT));
        F.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.F, (Shape)F);
        Path G = new Path();
        G.setFillRule(FillRule.EVEN_ODD);
        G.getElements().add((Object)new MoveTo(0.7729257641921398 * WIDTH, 0.5373134328358209 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.8253275109170306 * WIDTH, 0.49850746268656715 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.7685589519650655 * WIDTH, 0.4626865671641791 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.1572052401746725 * WIDTH, 0.4626865671641791 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.10043668122270742 * WIDTH, 0.49850746268656715 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.1572052401746725 * WIDTH, 0.5373134328358209 * HEIGHT));
        G.getElements().add((Object)new LineTo(0.7729257641921398 * WIDTH, 0.5373134328358209 * HEIGHT));
        G.getElements().add((Object)new ClosePath());
        this.segmentMap.put(SevenSegment.Segment.G, (Shape)G);
        Circle DOT = new Circle(0.9301310043668122 * WIDTH, 0.9522388059701492 * HEIGHT, 0.06986899563318777 * WIDTH);
        this.segmentMap.put(SevenSegment.Segment.DOT, (Shape)DOT);
        for (Shape shape : this.segmentMap.values()) {
            shape.getStyleClass().add((Object)"off");
        }
        this.segments.getChildren().addAll((Object[])new Node[]{A, B, C2, D, E, F, G, DOT});
        this.segments.setCache(true);
    }
}

