/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.SimpleLinearGaugeBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.SimpleLinearGauge;

public class SimpleLinearGaugeSkin
extends GaugeSkinBase<SimpleLinearGauge, SimpleLinearGaugeBehavior> {
    private SimpleLinearGauge control;
    private boolean isDirty;
    private boolean initialized;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane gauge;
    private Point2D center;
    private Line bar;
    private Text valueText;
    private NumberFormat valueFormat;
    private Text unitText;
    private Timeline timeline;
    private DoubleProperty gaugeValue;
    private double width;
    private double height;
    private Text minLabel;
    private Text maxLabel;
    private Orientation orientation;
    private double stepsize;
    private Stop[] barGradientStops;

    public SimpleLinearGaugeSkin(SimpleLinearGauge CONTROL) {
        super(CONTROL, new SimpleLinearGaugeBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.gauge = new Pane();
        this.center = new Point2D(100.0, 50.0);
        this.bar = new Line();
        this.valueText = new Text();
        this.valueFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        this.unitText = new Text();
        this.timeline = new Timeline();
        this.gaugeValue = new SimpleDoubleProperty(this.control.getValue());
        this.width = 200.0;
        this.height = 60.0;
        this.minLabel = new Text(this.valueFormat.format(this.control.getMinValue()));
        this.maxLabel = new Text(this.valueFormat.format(this.control.getMaxValue()));
        this.orientation = Orientation.HORIZONTAL;
        this.stepsize = 1.0;
        this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(200.0, 100.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(20.0, 10.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(800.0, 400.0);
        }
        this.center = new Point2D(this.control.getPrefWidth() / 2.0, this.control.getPrefHeight() / 2.0);
        this.registerChangeListener((ObservableValue)this.control.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.heightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.minWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.minHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.maxWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.maxHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.minValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.maxValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.gaugeModelProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barFrameColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barBackgroundColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.valueLabelColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.unitLabelColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.unitProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barColorProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.barWidthProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.roundedBarProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.valueLabelFontSizeProperty(), "LABEL");
        this.registerChangeListener((ObservableValue)this.control.noOfDecimalsProperty(), "LABEL");
        this.registerChangeListener((ObservableValue)this.control.minLabelColorProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.maxLabelColorProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.minMaxLabelFontSizeProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)this.control.minLabelVisibleProperty(), "MIN_LABEL_VISIBLE");
        this.registerChangeListener((ObservableValue)this.gaugeValue, "GAUGE_VALUE");
        this.valueText.setFill((Paint)this.control.getValueLabelColor());
        this.unitText.setFill((Paint)this.control.getUnitLabelColor());
        this.minLabel.setFill((Paint)this.control.getMinLabelColor());
        this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
        this.addBindings();
        this.updateNumberFormat();
        if (this.control.isCanvasMode()) {
            for (Section section : this.control.getSections()) {
                if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                    this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, section.getColor().darker()), new Stop(1.0, section.getColor().brighter())};
                    break;
                }
                this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
            }
        }
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.bar.visibleProperty().isBound()) {
            this.bar.visibleProperty().unbind();
        }
        this.bar.visibleProperty().bind((ObservableValue)this.gaugeValue.greaterThan((ObservableNumberValue)this.control.minValueProperty()));
        if (this.minLabel.visibleProperty().isBound()) {
            this.minLabel.visibleProperty().unbind();
        }
        this.minLabel.visibleProperty().bind((ObservableValue)this.control.minLabelVisibleProperty());
        if (this.maxLabel.visibleProperty().isBound()) {
            this.maxLabel.visibleProperty().unbind();
        }
        this.maxLabel.visibleProperty().bind((ObservableValue)this.control.maxLabelVisibleProperty());
        if (this.valueText.visibleProperty().isBound()) {
            this.valueText.visibleProperty().unbind();
        }
        this.valueText.visibleProperty().bind((ObservableValue)this.control.valueLabelVisibleProperty());
        if (this.unitText.visibleProperty().isBound()) {
            this.unitText.visibleProperty().unbind();
        }
        this.unitText.visibleProperty().bind((ObservableValue)this.control.unitLabelVisibleProperty());
        if (this.valueText.fillProperty().isBound()) {
            this.valueText.fillProperty().unbind();
        }
        this.valueText.fillProperty().bind(this.control.valueLabelColorProperty());
        if (this.unitText.fillProperty().isBound()) {
            this.unitText.fillProperty().unbind();
        }
        this.unitText.fillProperty().bind(this.control.unitLabelColorProperty());
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("WIDTH".equals(PROPERTY)) {
            this.width = this.control.getPrefWidth();
            this.height = this.control.getPrefHeight();
            this.orientation = this.width < this.height ? Orientation.VERTICAL : Orientation.HORIZONTAL;
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.repaint();
        } else if ("HEIGHT".equals(PROPERTY)) {
            this.width = this.control.getPrefWidth();
            this.height = this.control.getPrefHeight();
            this.orientation = this.width < this.height ? Orientation.VERTICAL : Orientation.HORIZONTAL;
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.repaint();
        } else if ("FULL_REPAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("VALUE".equals(PROPERTY)) {
            if (this.control.isValueAnimationEnabled()) {
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.gaugeValue, (Object)this.control.getValue(), Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{KEY_VALUE});
                this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        SimpleLinearGaugeSkin.this.gaugeValue.set(SimpleLinearGaugeSkin.this.control.getValue());
                    }
                });
                this.timeline = new Timeline();
                this.timeline.getKeyFrames().add((Object)KEY_FRAME);
                this.timeline.play();
            } else {
                this.gaugeValue.set(this.control.getValue());
            }
        } else if ("BAR".equals(PROPERTY)) {
            if (this.control.isCanvasMode()) {
                this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
                this.drawCanvasGauge(this.ctx);
            } else {
                this.drawNodeGauge();
            }
        } else if ("LABEL".equals(PROPERTY)) {
            this.updateNumberFormat();
            this.repaint();
        } else if ("MIN_MAX_LABEL".equals(PROPERTY)) {
            this.minLabel.setFill((Paint)this.control.getMinLabelColor());
            this.minLabel.setFont(Font.font((String)"Verdana", (double)this.control.getMinMaxLabelFontSize()));
            this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
            this.maxLabel.setFont(Font.font((String)"Verdana", (double)this.control.getMinMaxLabelFontSize()));
            this.repaint();
        } else if ("GAUGE_VALUE".equals(PROPERTY)) {
            if (!this.control.getSections().isEmpty()) {
                for (Section section : this.control.getSections()) {
                    if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                        this.updateBarColor(section.getColor());
                        break;
                    }
                    this.updateBarColor(this.control.getBarColor());
                }
            }
            if (this.control.isThresholdBehaviorInverted() && this.gaugeValue.doubleValue() < this.control.getThreshold()) {
                this.control.setThresholdExceeded(true);
            } else if (!this.control.isThresholdBehaviorInverted() && this.gaugeValue.doubleValue() > this.control.getThreshold()) {
                this.control.setThresholdExceeded(true);
            } else {
                this.control.setThresholdExceeded(false);
            }
            this.valueText.setText(this.valueFormat.format(this.gaugeValue.get()));
            switch (this.orientation) {
                case VERTICAL: {
                    this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) / 2.0);
                    this.bar.setEndY(this.height - this.control.getBarWidth() - (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize);
                    break;
                }
                default: {
                    this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) / 2.0);
                    this.bar.setEndX(this.control.getBarWidth() + (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize);
                }
            }
            if (this.control.isCanvasMode()) {
                for (Section section : this.control.getSections()) {
                    if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                        this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, section.getColor().darker()), new Stop(1.0, section.getColor().brighter())};
                        break;
                    }
                    this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
                }
                this.drawCanvasGauge(this.ctx);
            }
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.isCanvasMode()) {
            this.drawCanvasGauge(this.ctx);
            this.getChildren().setAll((Object[])new Node[]{this.canvas});
        } else {
            this.drawNodeGauge();
            this.getChildren().setAll((Object[])new Node[]{this.gauge});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final SimpleLinearGauge getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 200.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 100.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefHeight);
    }

    @Override
    protected double computeMinWidth(double MIN_WIDTH) {
        return super.computeMinWidth(Math.max(50.0, MIN_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMinHeight(double MIN_HEIGHT) {
        return super.computeMinHeight(Math.max(50.0, MIN_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    @Override
    protected double computeMaxWidth(double MAX_WIDTH) {
        return super.computeMaxWidth(Math.max(200.0, MAX_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMaxHeight(double MAX_HEIGHT) {
        return super.computeMaxHeight(Math.max(200.0, MAX_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private void updateNumberFormat() {
        StringBuilder noOfDecimals = new StringBuilder(5);
        if (this.control.getNoOfDecimals() == 0) {
            noOfDecimals.append("0");
        } else {
            noOfDecimals.append("0.");
            for (int i = 0; i < this.control.getNoOfDecimals(); ++i) {
                noOfDecimals.append("0");
            }
        }
        this.valueFormat = new DecimalFormat(noOfDecimals.toString(), new DecimalFormatSymbols(Locale.US));
    }

    private void updateBarColor(Color BAR_COLOR) {
        switch (this.orientation) {
            case VERTICAL: {
                this.bar.setStroke((Paint)new LinearGradient(this.bar.getStartX() - this.control.getBarWidth() / 2.0, 0.0, this.bar.getStartX() + this.control.getBarWidth() / 2.0, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, BAR_COLOR), new Stop(0.5, BAR_COLOR), new Stop(1.0, BAR_COLOR.darker())}));
                break;
            }
            default: {
                this.bar.setStroke((Paint)new LinearGradient(0.0, this.bar.getStartY() - this.control.getBarWidth() / 2.0, 0.0, this.bar.getStartY() + this.control.getBarWidth() / 2.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, BAR_COLOR), new Stop(0.5, BAR_COLOR), new Stop(1.0, BAR_COLOR.darker())}));
            }
        }
    }

    public final void drawNodeGauge() {
        this.width = this.control.getPrefWidth();
        this.height = this.control.getPrefHeight();
        this.orientation = this.width < this.height ? Orientation.VERTICAL : Orientation.HORIZONTAL;
        double size = this.width < this.height ? this.height : this.width;
        this.center = new Point2D(this.width / 2.0, this.height / 2.0);
        switch (this.orientation) {
            case VERTICAL: {
                this.stepsize = Math.abs((this.height - 2.0 * this.control.getBarWidth() - this.valueText.getLayoutBounds().getHeight() - 5.0 - this.control.getBarWidth() / 2.0) / this.control.getRange());
                break;
            }
            default: {
                this.stepsize = Math.abs((this.width - 2.0 * this.control.getBarWidth()) / this.control.getRange());
            }
        }
        this.gauge.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, this.width, this.width);
        IBOUNDS.setOpacity(0.0);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setRadius(0.01 * size);
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setRadius(0.005 * size);
        INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
        INNER_GLOW.setOffsetY(-1.0);
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.65));
        Line BAR_BACKGROUND = new Line();
        switch (this.orientation) {
            case VERTICAL: {
                BAR_BACKGROUND.setStartX(this.center.getX());
                BAR_BACKGROUND.setStartY(this.height - this.control.getBarWidth());
                BAR_BACKGROUND.setEndX(this.center.getX());
                BAR_BACKGROUND.setEndY(this.control.getBarWidth() + this.valueText.getLayoutBounds().getHeight() + 5.0 + this.control.getBarWidth() / 2.0);
                break;
            }
            default: {
                BAR_BACKGROUND.setStartX(this.control.getBarWidth());
                BAR_BACKGROUND.setStartY(this.center.getY());
                BAR_BACKGROUND.setEndX(this.width - this.control.getBarWidth());
                BAR_BACKGROUND.setEndY(this.center.getY());
            }
        }
        BAR_BACKGROUND.setFill(null);
        BAR_BACKGROUND.setSmooth(true);
        BAR_BACKGROUND.setStroke((Paint)this.control.getBarBackgroundColor());
        BAR_BACKGROUND.setStrokeWidth(this.control.getBarWidth());
        if (this.control.isRoundedBar()) {
            BAR_BACKGROUND.setStrokeLineCap(StrokeLineCap.ROUND);
        } else {
            BAR_BACKGROUND.setStrokeLineCap(StrokeLineCap.BUTT);
        }
        BAR_BACKGROUND.setEffect((Effect)INNER_SHADOW);
        switch (this.orientation) {
            case VERTICAL: {
                this.bar.setStartX(BAR_BACKGROUND.getStartX());
                this.bar.setStartY(BAR_BACKGROUND.getStartY());
                this.bar.setEndX(BAR_BACKGROUND.getEndX());
                this.bar.setEndY(BAR_BACKGROUND.getStartY() - (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize);
                break;
            }
            default: {
                this.bar.setStartX(BAR_BACKGROUND.getStartX());
                this.bar.setStartY(BAR_BACKGROUND.getStartY());
                this.bar.setEndX(this.control.getBarWidth() + (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize);
                this.bar.setEndY(BAR_BACKGROUND.getEndY());
            }
        }
        this.bar.setFill(null);
        this.bar.setSmooth(true);
        if (!this.control.getSections().isEmpty()) {
            for (Section section : this.control.getSections()) {
                if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                    this.updateBarColor(section.getColor());
                    break;
                }
                this.updateBarColor(this.control.getBarColor());
            }
        }
        if (this.control.isRoundedBar()) {
            this.bar.setStrokeLineCap(StrokeLineCap.ROUND);
        } else {
            this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        }
        this.bar.setStrokeWidth(this.control.getBarWidth());
        this.bar.setEffect((Effect)INNER_SHADOW);
        this.valueText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getValueLabelFontSize()));
        this.valueText.setTextAlignment(TextAlignment.CENTER);
        this.valueText.setTextOrigin(VPos.BOTTOM);
        this.valueText.setText(this.valueFormat.format(this.gaugeValue.doubleValue()));
        this.valueText.setEffect((Effect)INNER_GLOW);
        this.unitText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getUnitLabelFontSize()));
        this.unitText.setTextAlignment(TextAlignment.CENTER);
        this.unitText.setTextOrigin(VPos.BOTTOM);
        this.unitText.setText(this.control.getUnit());
        this.unitText.setEffect((Effect)INNER_GLOW);
        this.minLabel.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)this.control.getMinMaxLabelFontSize()));
        this.minLabel.setFill((Paint)this.control.getMinLabelColor());
        this.minLabel.setTextAlignment(TextAlignment.CENTER);
        this.minLabel.setTextOrigin(VPos.BOTTOM);
        this.minLabel.setText(this.valueFormat.format(this.control.getMinValue()));
        this.maxLabel.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)this.control.getMinMaxLabelFontSize()));
        this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
        this.maxLabel.setTextAlignment(TextAlignment.CENTER);
        this.maxLabel.setTextOrigin(VPos.BOTTOM);
        this.maxLabel.setText(this.valueFormat.format(this.control.getMaxValue()));
        switch (this.orientation) {
            case VERTICAL: {
                this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) / 2.0);
                this.valueText.setLayoutY(this.valueText.getLayoutBounds().getHeight());
                this.unitText.setLayoutX(this.center.getX() - this.control.getBarWidth() / 2.0 - this.unitText.getLayoutBounds().getHeight() - 5.0);
                this.unitText.setLayoutY(BAR_BACKGROUND.getEndY() + (BAR_BACKGROUND.getStartY() - BAR_BACKGROUND.getEndY()) / 2.0 + this.unitText.getLayoutBounds().getHeight() / 2.0);
                this.minLabel.setLayoutX(this.center.getX() - this.control.getBarWidth() / 2.0 - this.minLabel.getLayoutBounds().getWidth() - 2.0);
                this.minLabel.setLayoutY(BAR_BACKGROUND.getStartY());
                this.maxLabel.setLayoutX(this.center.getX() - this.control.getBarWidth() / 2.0 - this.maxLabel.getLayoutBounds().getWidth() - 2.0);
                this.maxLabel.setLayoutY(BAR_BACKGROUND.getEndY() + this.maxLabel.getLayoutBounds().getHeight());
                break;
            }
            default: {
                this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) / 2.0);
                this.valueText.setLayoutY(this.center.getY() - this.control.getBarWidth() / 2.0 - 2.0);
                this.unitText.setLayoutX((this.width - this.unitText.getLayoutBounds().getWidth()) / 2.0);
                this.unitText.setLayoutY(this.center.getY() + this.control.getBarWidth() / 2.0 + this.unitText.getLayoutBounds().getHeight() + 2.0);
                this.minLabel.setLayoutX(BAR_BACKGROUND.getStartX());
                this.minLabel.setLayoutY(this.center.getY() + this.control.getBarWidth() / 2.0 + this.minLabel.getLayoutBounds().getHeight() + 2.0);
                this.maxLabel.setLayoutX(BAR_BACKGROUND.getEndX() - this.maxLabel.getLayoutBounds().getWidth());
                this.maxLabel.setLayoutY(this.center.getY() + this.control.getBarWidth() / 2.0 + this.maxLabel.getLayoutBounds().getHeight() + 2.0);
            }
        }
        this.gauge.getChildren().addAll((Object[])new Node[]{IBOUNDS, BAR_BACKGROUND, this.bar, this.valueText, this.unitText, this.minLabel, this.maxLabel});
        this.gauge.setCache(true);
        this.gauge.setCacheHint(CacheHint.QUALITY);
    }

    private void drawCanvasGauge(GraphicsContext CTX) {
        this.stepsize = Orientation.VERTICAL == this.orientation ? Math.abs((this.height - 2.0 * this.control.getBarWidth() - this.valueText.getLayoutBounds().getHeight() - 5.0 - this.control.getBarWidth() / 2.0) / this.control.getRange()) : Math.abs((this.width - 2.0 * this.control.getBarWidth()) / this.control.getRange());
        CTX.clearRect(0.0, 0.0, this.width, this.height);
        CTX.setStroke((Paint)this.control.getBarFrameColor());
        CTX.setLineWidth(this.control.getBarWidth() + 2.0);
        if (this.control.isRoundedBar()) {
            CTX.setLineCap(StrokeLineCap.ROUND);
        } else {
            CTX.setLineCap(StrokeLineCap.BUTT);
        }
        if (Orientation.VERTICAL == this.orientation) {
            CTX.strokeLine(this.center.getX(), this.height - this.control.getBarWidth(), this.center.getX(), this.control.getBarWidth() + this.valueText.getLayoutBounds().getHeight() + 5.0 + this.control.getBarWidth() / 2.0);
        } else {
            CTX.strokeLine(this.control.getBarWidth(), this.center.getY(), this.width - this.control.getBarWidth(), this.center.getY());
        }
        CTX.setStroke((Paint)this.control.getBarBackgroundColor());
        CTX.setLineWidth(this.control.getBarWidth());
        if (this.control.isRoundedBar()) {
            CTX.setLineCap(StrokeLineCap.ROUND);
        } else {
            CTX.setLineCap(StrokeLineCap.BUTT);
        }
        if (Orientation.VERTICAL == this.orientation) {
            CTX.strokeLine(this.center.getX(), this.height - this.control.getBarWidth(), this.center.getX(), this.control.getBarWidth() + this.valueText.getLayoutBounds().getHeight() + 5.0 + this.control.getBarWidth() / 2.0 - (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize);
        } else {
            CTX.strokeLine(this.control.getBarWidth(), this.center.getY(), this.width - this.control.getBarWidth() + (this.gaugeValue.get() - this.control.getMinValue()) * this.stepsize, this.center.getY());
        }
        if (this.control.isValueLabelVisible()) {
            CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getValueLabelFontSize()));
            CTX.setFill((Paint)this.control.getValueLabelColor());
            CTX.setTextAlign(TextAlignment.CENTER);
            CTX.setTextBaseline(VPos.CENTER);
            if (Orientation.VERTICAL == this.orientation) {
                CTX.fillText(this.valueFormat.format(this.gaugeValue.doubleValue()), this.width / 2.0, this.control.getValueLabelFontSize());
            } else {
                CTX.fillText(this.valueFormat.format(this.gaugeValue.doubleValue()), this.width / 2.0, this.control.getValueLabelFontSize());
            }
        }
        if (this.control.isUnitLabelVisible() && !this.control.getUnit().isEmpty()) {
            CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getUnitLabelFontSize()));
            CTX.setFill((Paint)this.control.getUnitLabelColor());
            CTX.setTextAlign(TextAlignment.CENTER);
            CTX.setTextBaseline(VPos.BOTTOM);
            if (Orientation.VERTICAL == this.orientation) {
                CTX.fillText(this.control.getUnit(), this.width / 2.0, this.height - this.control.getUnitLabelFontSize());
            } else {
                CTX.fillText(this.control.getUnit(), this.width / 2.0, this.height - this.control.getUnitLabelFontSize());
            }
        }
    }
}

