/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.SimpleRadialGaugeBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.SimpleRadialGauge;

public class SimpleRadialGaugeSkin
extends GaugeSkinBase<SimpleRadialGauge, SimpleRadialGaugeBehavior> {
    private static final double INSETS = 4.0;
    private SimpleRadialGauge control;
    private boolean isDirty;
    private boolean initialized;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane gauge;
    private Point2D center;
    private Arc bar;
    private Text valueText;
    private NumberFormat valueFormat;
    private Text unitText;
    private Timeline timeline;
    private DoubleProperty gaugeValue;
    private double size;
    private Text minLabel;
    private Text maxLabel;
    private Stop[] barGradientStops;
    private double xy;
    private double wh;
    private double startAngle;
    private double length;
    private Canvas alertIndicator;

    public SimpleRadialGaugeSkin(SimpleRadialGauge CONTROL) {
        super(CONTROL, new SimpleRadialGaugeBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.gauge = new Pane();
        this.center = new Point2D(100.0, 100.0);
        this.bar = new Arc();
        this.valueText = new Text(Double.toString(this.control.getValue()));
        this.valueFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        this.unitText = new Text(this.control.getUnit());
        this.timeline = new Timeline();
        this.gaugeValue = new SimpleDoubleProperty(this.control.getValue());
        this.size = 200.0;
        this.minLabel = new Text(this.valueFormat.format(this.control.getMinValue()));
        this.maxLabel = new Text(this.valueFormat.format(this.control.getMaxValue()));
        this.xy = (this.control.getBarWidth() + 2.0) / 2.0 + 4.0;
        this.wh = this.size - 8.0 - this.control.getBarWidth() - 2.0;
        this.startAngle = -(150.0 - (360.0 - this.control.getRadialRange().ANGLE_RANGE) / 2.0);
        this.length = this.control.getRadialRange().ANGLE_RANGE;
        this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
        this.alertIndicator = this.createAlertIndicatorCanvas(this.control.getPrefWidth() * 0.165, this.control.getPrefHeight() * 0.135, (Paint)this.control.getThresholdColor().COLOR);
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(200.0, 200.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.center = new Point2D(this.control.getPrefWidth() / 2.0, this.control.getPrefHeight() / 2.0);
        this.registerChangeListener((ObservableValue)this.control.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.heightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.minWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.minHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.maxWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.maxHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.minValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.maxValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.gaugeModelProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barFrameColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barBackgroundColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.valueLabelColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.unitLabelColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.unitProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.barColorProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.barWidthProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.roundedBarProperty(), "BAR");
        this.registerChangeListener((ObservableValue)this.control.valueLabelFontSizeProperty(), "LABEL");
        this.registerChangeListener((ObservableValue)this.control.noOfDecimalsProperty(), "LABEL");
        this.registerChangeListener((ObservableValue)this.control.minLabelColorProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.maxLabelColorProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.minMaxLabelFontSizeProperty(), "MIN_MAX_LABEL");
        this.registerChangeListener((ObservableValue)this.control.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)this.control.minLabelVisibleProperty(), "MIN_LABEL_VISIBLE");
        this.registerChangeListener((ObservableValue)this.gaugeValue, "GAUGE_VALUE");
        this.valueText.setFill((Paint)this.control.getValueLabelColor());
        this.unitText.setFill((Paint)this.control.getUnitLabelColor());
        this.minLabel.setFill((Paint)this.control.getMinLabelColor());
        this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
        this.addBindings();
        this.updateNumberFormat();
        if (this.control.isCanvasMode()) {
            for (Section section : this.control.getSections()) {
                if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                    this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, section.getColor().darker()), new Stop(1.0, section.getColor().brighter())};
                    break;
                }
                this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
            }
        }
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.bar.visibleProperty().isBound()) {
            this.bar.visibleProperty().unbind();
        }
        this.bar.visibleProperty().bind((ObservableValue)this.gaugeValue.greaterThan((ObservableNumberValue)this.control.minValueProperty()));
        if (this.minLabel.visibleProperty().isBound()) {
            this.minLabel.visibleProperty().unbind();
        }
        this.minLabel.visibleProperty().bind((ObservableValue)this.control.minLabelVisibleProperty());
        if (this.maxLabel.visibleProperty().isBound()) {
            this.maxLabel.visibleProperty().unbind();
        }
        this.maxLabel.visibleProperty().bind((ObservableValue)this.control.maxLabelVisibleProperty());
        if (this.valueText.visibleProperty().isBound()) {
            this.valueText.visibleProperty().unbind();
        }
        this.valueText.visibleProperty().bind((ObservableValue)this.control.valueLabelVisibleProperty());
        if (this.unitText.visibleProperty().isBound()) {
            this.unitText.visibleProperty().unbind();
        }
        this.unitText.visibleProperty().bind((ObservableValue)this.control.unitLabelVisibleProperty());
        if (this.valueText.fillProperty().isBound()) {
            this.valueText.fillProperty().unbind();
        }
        this.valueText.fillProperty().bind(this.control.valueLabelColorProperty());
        if (this.unitText.fillProperty().isBound()) {
            this.unitText.fillProperty().unbind();
        }
        this.unitText.fillProperty().bind(this.control.unitLabelColorProperty());
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("WIDTH".equals(PROPERTY)) {
            this.recalcParameters();
            this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) / 2.0);
            this.valueText.setLayoutY((this.size - this.valueText.getLayoutBounds().getHeight()) / 2.0 + this.control.getValueLabelFontSize());
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.alertIndicator = this.createAlertIndicatorCanvas(this.control.getPrefWidth() * 0.165, this.control.getPrefHeight() * 0.135, (Paint)this.control.getThresholdColor().COLOR);
            this.repaint();
        } else if ("HEIGHT".equals(PROPERTY)) {
            this.recalcParameters();
            this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) / 2.0);
            this.valueText.setLayoutY((this.size - this.valueText.getLayoutBounds().getHeight()) / 2.0 + this.control.getValueLabelFontSize());
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.alertIndicator = this.createAlertIndicatorCanvas(this.control.getPrefWidth() * 0.165, this.control.getPrefHeight() * 0.135, (Paint)this.control.getThresholdColor().COLOR);
            this.repaint();
        } else if ("FULL_REPAINT".equals(PROPERTY)) {
            this.alertIndicator = this.createAlertIndicatorCanvas(this.control.getPrefWidth() * 0.165, this.control.getPrefHeight() * 0.135, (Paint)this.control.getThresholdColor().COLOR);
            this.repaint();
        } else if ("VALUE".equals(PROPERTY)) {
            if (this.control.isValueAnimationEnabled()) {
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.gaugeValue, (Object)this.control.getValue(), Interpolator.EASE_BOTH);
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)this.control.getTimeToValueInMs()), new KeyValue[]{KEY_VALUE});
                this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        SimpleRadialGaugeSkin.this.gaugeValue.set(SimpleRadialGaugeSkin.this.control.getValue());
                    }
                });
                this.timeline = new Timeline();
                this.timeline.getKeyFrames().add((Object)KEY_FRAME);
                this.timeline.play();
            } else {
                this.gaugeValue.set(this.control.getValue());
            }
        } else if ("BAR".equals(PROPERTY)) {
            if (this.control.isCanvasMode()) {
                this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
                this.drawCanvasGauge(this.ctx);
            } else {
                this.drawNodeGauge();
            }
        } else if ("LABEL".equals(PROPERTY)) {
            this.updateNumberFormat();
            this.repaint();
        } else if ("MIN_MAX_LABEL".equals(PROPERTY)) {
            this.minLabel.setFill((Paint)this.control.getMinLabelColor());
            this.minLabel.setFont(Font.font((String)"Verdana", (double)this.control.getMinMaxLabelFontSize()));
            this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
            this.maxLabel.setFont(Font.font((String)"Verdana", (double)this.control.getMinMaxLabelFontSize()));
            this.repaint();
        } else if ("GAUGE_VALUE".equals(PROPERTY)) {
            if (!this.control.getSections().isEmpty()) {
                for (Section section : this.control.getSections()) {
                    if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                        this.updateBarColor(section.getColor());
                        break;
                    }
                    this.updateBarColor(this.control.getBarColor());
                }
            }
            this.valueText.setText(this.valueFormat.format(this.gaugeValue.get()));
            this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) / 2.0);
            this.valueText.setLayoutY((this.size - this.valueText.getLayoutBounds().getHeight()) / 2.0 + this.control.getValueLabelFontSize());
            this.bar.setLength(-this.gaugeValue.get() * this.control.getAngleStep());
            if (this.control.isThresholdBehaviorInverted() && this.gaugeValue.doubleValue() < this.control.getThreshold()) {
                this.control.setThresholdExceeded(true);
            } else if (!this.control.isThresholdBehaviorInverted() && this.gaugeValue.doubleValue() > this.control.getThreshold()) {
                this.control.setThresholdExceeded(true);
            } else {
                this.control.setThresholdExceeded(false);
            }
            this.alertIndicator.setVisible(this.control.isThresholdExceeded());
            if (this.control.isCanvasMode()) {
                for (Section section : this.control.getSections()) {
                    if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                        this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, section.getColor().darker()), new Stop(1.0, section.getColor().brighter())};
                        break;
                    }
                    this.barGradientStops = new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.8, this.control.getBarColor().darker()), new Stop(1.0, this.control.getBarColor().brighter())};
                }
                this.drawCanvasGauge(this.ctx);
            }
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.isCanvasMode()) {
            this.alertIndicator.setLayoutX((this.size - this.alertIndicator.getWidth()) * 0.5);
            this.alertIndicator.setLayoutY(this.size * 0.6);
            this.drawCanvasGauge(this.ctx);
            this.getChildren().setAll((Object[])new Node[]{this.canvas, this.alertIndicator});
        } else {
            this.drawNodeGauge();
            this.getChildren().setAll((Object[])new Node[]{this.gauge});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final SimpleRadialGauge getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double PREF_HEIGHT) {
        double prefWidth = 200.0;
        if (PREF_HEIGHT != -1.0) {
            prefWidth = Math.max(0.0, PREF_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double PREF_WIDTH) {
        double prefHeight = 200.0;
        if (PREF_WIDTH != -1.0) {
            prefHeight = Math.max(0.0, PREF_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefHeight);
    }

    @Override
    protected double computeMinWidth(double MIN_HEIGHT) {
        return super.computeMinWidth(Math.max(50.0, MIN_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMinHeight(double MIN_WIDTH) {
        return super.computeMinHeight(Math.max(50.0, MIN_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    @Override
    protected double computeMaxWidth(double MAX_HEIGHT) {
        return super.computeMaxWidth(Math.max(200.0, MAX_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMaxHeight(double MAX_WIDTH) {
        return super.computeMaxHeight(Math.max(200.0, MAX_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private void updateNumberFormat() {
        StringBuilder noOfDecimals = new StringBuilder(5);
        if (this.control.getNoOfDecimals() == 0) {
            noOfDecimals.append("0");
        } else {
            noOfDecimals.append("0.");
            for (int i = 0; i < this.control.getNoOfDecimals(); ++i) {
                noOfDecimals.append("0");
            }
        }
        this.valueFormat = new DecimalFormat(noOfDecimals.toString(), new DecimalFormatSymbols(Locale.US));
    }

    private void updateBarColor(Color BAR_COLOR) {
        double RADIUS = this.size / 2.0 - 4.0;
        this.bar.setStroke((Paint)new RadialGradient(0.0, 0.0, this.center.getX(), this.center.getY(), RADIUS, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getBarColor()), new Stop((RADIUS - this.control.getBarWidth()) / RADIUS, Color.TRANSPARENT), new Stop((RADIUS - this.control.getBarWidth() + 1.0) / RADIUS, BAR_COLOR.darker()), new Stop((RADIUS - this.control.getBarWidth() / 2.0) / RADIUS, BAR_COLOR), new Stop(1.0, BAR_COLOR.deriveColor(0.85, 0.85, 0.85, 1.0))}));
    }

    private void recalcParameters() {
        this.size = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        this.xy = (this.control.getBarWidth() + 2.0) / 2.0 + 4.0;
        this.wh = this.size - 8.0 - this.control.getBarWidth() - 2.0;
        this.length = this.control.getRadialRange().ANGLE_RANGE;
        this.startAngle = -(150.0 - (360.0 - this.length) / 2.0);
    }

    private void drawNodeGauge() {
        this.size = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double RADIUS = this.size / 2.0 - 4.0;
        double ARC_RADIUS = RADIUS - this.control.getBarWidth() / 2.0;
        this.center = new Point2D(this.size / 2.0, this.size / 2.0);
        this.gauge.getChildren().clear();
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setRadius(0.01 * this.size);
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setRadius(0.005 * this.size);
        INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
        INNER_GLOW.setOffsetY(-1.0);
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.65));
        Arc BAR_BACKGROUND = new Arc();
        BAR_BACKGROUND.setCenterX(this.center.getX());
        BAR_BACKGROUND.setCenterY(this.center.getY());
        BAR_BACKGROUND.setRadiusX(ARC_RADIUS);
        BAR_BACKGROUND.setRadiusY(ARC_RADIUS);
        BAR_BACKGROUND.setStartAngle(-(90.0 - (360.0 - this.control.getRadialRange().ANGLE_RANGE) / 2.0));
        BAR_BACKGROUND.setLength(this.control.getRadialRange().ANGLE_RANGE);
        BAR_BACKGROUND.setType(ArcType.OPEN);
        BAR_BACKGROUND.setFill(null);
        BAR_BACKGROUND.setSmooth(true);
        BAR_BACKGROUND.setStroke((Paint)this.control.getBarBackgroundColor());
        BAR_BACKGROUND.setStrokeWidth(this.control.getBarWidth());
        if (this.control.isRoundedBar()) {
            BAR_BACKGROUND.setStrokeLineCap(StrokeLineCap.ROUND);
        } else {
            BAR_BACKGROUND.setStrokeLineCap(StrokeLineCap.BUTT);
        }
        BAR_BACKGROUND.setEffect((Effect)INNER_SHADOW);
        this.bar.setCenterX(this.center.getX());
        this.bar.setCenterY(this.center.getY());
        this.bar.setRadiusX(BAR_BACKGROUND.getRadiusX());
        this.bar.setRadiusY(BAR_BACKGROUND.getRadiusY());
        this.bar.setStartAngle(this.control.getRadialRange().ANGLE_RANGE - (90.0 - (360.0 - this.control.getRadialRange().ANGLE_RANGE) / 2.0));
        this.bar.setLength(-this.gaugeValue.get() * this.control.getAngleStep());
        this.bar.setType(ArcType.OPEN);
        this.bar.setFill(null);
        this.bar.setSmooth(true);
        if (!this.control.getSections().isEmpty()) {
            for (Section section : this.control.getSections()) {
                if (this.gaugeValue.get() - this.control.getMinValue() > section.getStart() && this.gaugeValue.get() - this.control.getMinValue() < section.getStop()) {
                    this.updateBarColor(section.getColor());
                    break;
                }
                this.updateBarColor(this.control.getBarColor());
            }
        }
        if (this.control.isRoundedBar()) {
            this.bar.setStrokeLineCap(StrokeLineCap.ROUND);
        } else {
            this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        }
        this.bar.setStrokeWidth(this.control.getBarWidth());
        this.bar.setEffect((Effect)INNER_SHADOW);
        this.valueText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getValueLabelFontSize()));
        this.valueText.setTextAlignment(TextAlignment.CENTER);
        this.valueText.setTextOrigin(VPos.BASELINE);
        this.valueText.setText(this.valueFormat.format(this.gaugeValue.get()));
        this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) / 2.0);
        this.valueText.setLayoutY((this.size - this.valueText.getLayoutBounds().getHeight()) / 2.0 + this.control.getValueLabelFontSize());
        this.valueText.setEffect((Effect)INNER_GLOW);
        this.unitText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getUnitLabelFontSize()));
        this.unitText.setTextAlignment(TextAlignment.CENTER);
        this.unitText.setTextOrigin(VPos.BOTTOM);
        this.unitText.setText(this.control.getUnit());
        this.unitText.setLayoutX((this.size - this.unitText.getLayoutBounds().getWidth()) / 2.0);
        this.unitText.setLayoutY(this.size - this.unitText.getLayoutBounds().getHeight());
        this.unitText.setEffect((Effect)INNER_GLOW);
        this.minLabel.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)this.control.getMinMaxLabelFontSize()));
        this.minLabel.setFill((Paint)this.control.getMinLabelColor());
        this.minLabel.setTextAlignment(TextAlignment.CENTER);
        this.minLabel.setTextOrigin(VPos.BOTTOM);
        this.minLabel.setText(this.valueFormat.format(this.control.getMinValue()));
        this.minLabel.setLayoutX(this.size * 0.025);
        this.minLabel.setLayoutY(this.size - this.minLabel.getLayoutBounds().getHeight() - this.size * 0.025);
        this.maxLabel.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)this.control.getMinMaxLabelFontSize()));
        this.maxLabel.setFill((Paint)this.control.getMaxLabelColor());
        this.maxLabel.setTextAlignment(TextAlignment.CENTER);
        this.maxLabel.setTextOrigin(VPos.BOTTOM);
        this.maxLabel.setText(this.valueFormat.format(this.control.getMaxValue()));
        this.maxLabel.setLayoutX(this.size - this.maxLabel.getLayoutBounds().getWidth() - this.size * 0.025);
        this.maxLabel.setLayoutY(this.size - this.maxLabel.getLayoutBounds().getHeight() - this.size * 0.025);
        this.alertIndicator.setLayoutX((this.size - this.alertIndicator.getWidth()) * 0.5);
        this.alertIndicator.setLayoutY(this.size * 0.6);
        this.gauge.getChildren().addAll((Object[])new Node[]{BAR_BACKGROUND, this.bar, this.valueText, this.unitText, this.minLabel, this.maxLabel, this.alertIndicator});
        this.gauge.setCache(true);
        this.gauge.setCacheHint(CacheHint.QUALITY);
    }

    private void drawCanvasGauge(GraphicsContext CTX) {
        CTX.clearRect(0.0, 0.0, this.size, this.size);
        CTX.setStroke((Paint)this.control.getBarFrameColor());
        CTX.setLineWidth(this.control.getBarWidth() + 2.0);
        if (this.control.isRoundedBar()) {
            CTX.setLineCap(StrokeLineCap.ROUND);
        } else {
            CTX.setLineCap(StrokeLineCap.BUTT);
        }
        CTX.strokeArc(this.xy, this.xy, this.wh, this.wh, this.startAngle, -this.length, ArcType.OPEN);
        CTX.setStroke((Paint)this.control.getBarBackgroundColor());
        CTX.setLineWidth(this.control.getBarWidth());
        if (this.control.isRoundedBar()) {
            CTX.setLineCap(StrokeLineCap.ROUND);
        } else {
            CTX.setLineCap(StrokeLineCap.BUTT);
        }
        CTX.strokeArc(this.xy, this.xy, this.wh, this.wh, this.startAngle, -this.length, ArcType.OPEN);
        CTX.setStroke((Paint)new RadialGradient(0.0, 0.0, 0.5 * this.size, 0.5 * this.size, 0.5 * this.wh, false, CycleMethod.NO_CYCLE, this.barGradientStops));
        CTX.setLineWidth(this.control.getBarWidth());
        if (this.control.isRoundedBar()) {
            CTX.setLineCap(StrokeLineCap.ROUND);
        } else {
            CTX.setLineCap(StrokeLineCap.BUTT);
        }
        CTX.strokeArc(this.xy, this.xy, this.wh, this.wh, this.startAngle, -this.gaugeValue.doubleValue() * this.control.getAngleStep(), ArcType.OPEN);
        if (this.control.isValueLabelVisible()) {
            CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getValueLabelFontSize()));
            CTX.setFill((Paint)this.control.getValueLabelColor());
            CTX.setTextAlign(TextAlignment.CENTER);
            CTX.setTextBaseline(VPos.CENTER);
            CTX.fillText(this.valueFormat.format(this.gaugeValue.doubleValue()), this.size / 2.0, this.size / 2.0);
        }
        if (this.control.isUnitLabelVisible() && !this.control.getUnit().isEmpty()) {
            CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)this.control.getUnitLabelFontSize()));
            CTX.setFill((Paint)this.control.getUnitLabelColor());
            CTX.setTextAlign(TextAlignment.CENTER);
            CTX.setTextBaseline(VPos.BOTTOM);
            CTX.fillText(this.control.getUnit(), this.size / 2.0, this.size - this.control.getUnitLabelFontSize());
        }
    }
}

