/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import javafx.animation.AnimationTimer;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradientBuilder;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.RadialGradientBuilder;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.SVGPathBuilder;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.scene.transform.ScaleBuilder;
import javafx.scene.transform.Transform;
import jfxtras.labs.scene.control.SlideLock;

public class SlideLockSkin
extends Region
implements Skin<SlideLock> {
    private final SlideLock CONTROL;
    private Group button;
    private Text text;
    private EventHandler<MouseEvent> mouseHandler;
    private EventHandler<TouchEvent> touchHandler;
    private AnimationTimer currentSpotlightAnim;

    public SlideLockSkin(SlideLock slideLock) {
        this.CONTROL = slideLock;
        if (this.CONTROL.getPrefWidth() <= 0.0 || this.CONTROL.getPrefHeight() <= 0.0) {
            this.CONTROL.setPrefSize(523.28571, 188.0);
        }
        this.button = new Group();
        this.text = new Text(this.CONTROL.getText());
        this.mouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseEvent.MOUSE_PRESSED == event.getEventType()) {
                    SlideLockSkin.this.buttonPressAction((Node)SlideLockSkin.this.button, event.getX(), event.getY());
                } else if (MouseEvent.MOUSE_DRAGGED == event.getEventType()) {
                    SlideLockSkin.this.moveButtonAction((Node)SlideLockSkin.this.button, event.getX(), event.getY());
                } else if (MouseEvent.MOUSE_RELEASED == event.getEventType()) {
                    SlideLockSkin.this.buttonSnapBack();
                }
            }
        };
        this.touchHandler = new EventHandler<TouchEvent>(){

            public void handle(TouchEvent event) {
                if (TouchEvent.TOUCH_PRESSED == event.getEventType()) {
                    SlideLockSkin.this.buttonPressAction((Node)SlideLockSkin.this.button, event.getTouchPoint().getX(), event.getTouchPoint().getY());
                } else if (TouchEvent.TOUCH_MOVED == event.getEventType()) {
                    SlideLockSkin.this.moveButtonAction((Node)SlideLockSkin.this.button, event.getTouchPoint().getX(), event.getTouchPoint().getY());
                } else if (TouchEvent.TOUCH_RELEASED == event.getEventType()) {
                    SlideLockSkin.this.buttonSnapBack();
                }
            }
        };
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.drawControl();
        this.addHandlers();
        this.startAnimations();
    }

    private void startAnimations() {
        double spotlightRadius = 70.0;
        if (this.currentSpotlightAnim != null) {
            this.currentSpotlightAnim.stop();
        }
        this.currentSpotlightAnim = new AnimationTimer(){
            long startTime = System.currentTimeMillis();
            long duration = 0L;
            double x = -70.0;

            public void handle(long now) {
                long elapsedTime = System.currentTimeMillis() - this.startTime;
                this.duration += elapsedTime;
                if (this.duration > 150L) {
                    RadialGradient lightColor = RadialGradientBuilder.create().radius(70.0).centerX(this.x).centerY(SlideLockSkin.this.text.getY()).proportional(false).stops(new Stop[]{new Stop(0.0, Color.WHITE), new Stop(0.5, Color.WHITE), new Stop(1.0, Color.web((String)"#555555"))}).build();
                    this.x += 10.0;
                    if (this.x > SlideLockSkin.this.text.getBoundsInParent().getMaxX() + 70.0) {
                        this.x = -70.0;
                    }
                    SlideLockSkin.this.text.setFill((Paint)lightColor);
                    this.startTime = System.currentTimeMillis();
                    this.duration = 0L;
                }
            }
        };
        this.currentSpotlightAnim.start();
    }

    public void layoutChildren() {
        this.drawControl();
        this.startAnimations();
        super.layoutChildren();
    }

    public SlideLock getSkinnable() {
        return this.CONTROL;
    }

    public Node getNode() {
        return this;
    }

    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void addHandlers() {
        this.setOnMousePressed(this.mouseHandler);
        this.setOnMouseDragged(this.mouseHandler);
        this.setOnMouseReleased(this.mouseHandler);
        this.setOnTouchPressed(this.touchHandler);
        this.setOnTouchMoved(this.touchHandler);
        this.setOnTouchReleased(this.touchHandler);
    }

    private void buttonPressAction(Node slideButton, double X, double Y) {
        if (slideButton.getBoundsInParent().contains(X, Y)) {
            this.CONTROL.setStartX(X - this.CONTROL.getEndX());
        }
    }

    private void moveButtonAction(Node slideButton, double X, double Y) {
        double WIDTH = this.CONTROL.getPrefWidth();
        double HEIGHT = this.CONTROL.getPrefHeight();
        double SCALE_FACTOR_X = WIDTH / 523.28571;
        double SCALE_FACTOR_Y = HEIGHT / 188.0;
        System.out.println(X + ", " + Y);
        if (slideButton.getBoundsInParent().contains(X, Y)) {
            this.CONTROL.setEndX(X - this.CONTROL.getStartX());
            if (slideButton.getTranslateX() < 33.0) {
                this.CONTROL.setLocked(true);
                this.CONTROL.setEndX(33.0);
            } else if (slideButton.getTranslateX() > 375.0) {
                this.CONTROL.setLocked(false);
                this.CONTROL.setEndX(375.0);
            } else {
                this.CONTROL.setLocked(true);
            }
            double opacity = 1.0 - slideButton.getTranslateX() / 200.0;
            if (opacity < 0.0) {
                opacity = 0.0;
            }
            this.CONTROL.setTextOpacity(opacity);
            this.currentSpotlightAnim.stop();
        }
    }

    private void buttonSnapBack() {
        if (this.CONTROL.isLocked()) {
            this.CONTROL.getSnapButtonBackAnim().play();
            this.currentSpotlightAnim.start();
        }
    }

    private void drawControl() {
        double WIDTH = this.CONTROL.getPrefWidth();
        double HEIGHT = this.CONTROL.getPrefHeight();
        double SCALE_FACTOR_X = WIDTH / 523.28571;
        double SCALE_FACTOR_Y = HEIGHT / 188.0;
        Scale SCALE = ScaleBuilder.create().x(WIDTH / 523.28571).y(HEIGHT / 188.0).pivotX(0.0).pivotY(0.0).build();
        Rectangle backgroundRect = ((RectangleBuilder)RectangleBuilder.create().id("slide-background")).width(WIDTH).height(HEIGHT).build();
        backgroundRect.visibleProperty().bind((ObservableValue)this.CONTROL.backgroundVisibleProperty());
        Rectangle slideArea = ((RectangleBuilder)RectangleBuilder.create().id("slide-area")).x(0.0612476117 * WIDTH).y(0.2463297872 * HEIGHT).width(0.8829200973 * WIDTH).height(0.5319148936 * HEIGHT).arcWidth(0.079787234 * HEIGHT).arcHeight(0.079787234 * HEIGHT).build();
        SVGPath glareRect = ((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)SVGPathBuilder.create().fill((Paint)LinearGradientBuilder.create().proportional(true).startX(0.0).startY(0.0).endX(0.0).endY(1.0).stops(new Stop[]{new Stop(0.0, Color.web((String)"f0f0f0", (double)1.0)), new Stop(1.0, Color.web((String)"f0f0f0", (double)0.0))}).build())).opacity(0.274)).transforms(new Transform[]{SCALE})).content("m 0,0 0,94 32,0 0,-27.218747 C 30.998808,55.222973 37.761737,45.9354 46.156457,45.93665 l 431.687503,0.06427 c 8.39472,0.0013 15.15487,9.290837 15.15315,20.814756 l -0.004,27.218754 30.28125,0 0,-94.0000031 L 0,0 z").id("glare-frame")).build();
        glareRect.visibleProperty().bind((ObservableValue)this.CONTROL.backgroundVisibleProperty());
        this.text.setText(this.CONTROL.getText());
        this.text.setId("slide-text");
        this.text.getTransforms().clear();
        this.text.getTransforms().add((Object)SCALE);
        this.drawSlideButton();
        this.button.translateXProperty().bind((ObservableValue)this.CONTROL.endXProperty().multiply(SCALE_FACTOR_X));
        this.button.setTranslateY(49.0 * SCALE_FACTOR_Y);
        this.text.setTranslateX(33.0 + this.button.getBoundsInParent().getWidth() + 0.1063829787 * HEIGHT);
        this.text.setTranslateY(0.5744680851 * HEIGHT);
        this.text.opacityProperty().bind((ObservableValue)this.CONTROL.textOpacityProperty());
        Rectangle topGlareRect = ((RectangleBuilder)((RectangleBuilder)((RectangleBuilder)RectangleBuilder.create().id("slide-top-glare")).fill((Paint)Color.WHITE)).width(WIDTH).height(0.5 * HEIGHT).opacity(0.0627451)).build();
        topGlareRect.visibleProperty().bind((ObservableValue)this.CONTROL.backgroundVisibleProperty());
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{backgroundRect, slideArea, glareRect, this.text, this.button, topGlareRect});
    }

    private void drawSlideButton() {
        double WIDTH = this.CONTROL.getPrefWidth();
        double HEIGHT = this.CONTROL.getPrefHeight();
        double SCALE_X = WIDTH / 523.28571;
        double SCALE_Y = HEIGHT / 188.0;
        Scale scale = new Scale();
        scale.setX(SCALE_X);
        scale.setY(SCALE_Y);
        scale.setPivotX(0.0);
        scale.setPivotY(0.0);
        this.button.getChildren().clear();
        Rectangle gradientRect = ((RectangleBuilder)((RectangleBuilder)RectangleBuilder.create().x(0.0358943492 * WIDTH).y(0.0649521277 * HEIGHT).width(0.156464544 * WIDTH).height(0.3616446809 * HEIGHT).arcWidth(0.0929042553 * HEIGHT).arcHeight(0.0929042553 * HEIGHT).fill(this.CONTROL.getButtonArrowBackgroundColor())).id("button-gradient-rect")).build();
        this.button.getChildren().add((Object)gradientRect);
        SVGPath arrowBlurShadow = ((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)SVGPathBuilder.create().fill((Paint)Color.BLACK)).effect((Effect)new GaussianBlur(5.0))).transforms(new Transform[]{scale})).content("m 17.40912,2.47162 c -8.27303,0 -14.9375,7.04253 -14.9375,15.78125 l 0,59.9375 c 0,8.73872 6.66447,15.75 14.9375,15.75 l 84.625,0 c 8.27303,0 14.9375,-7.01128 14.9375,-15.75 l 0,-59.9375 c 0,-8.73872 -6.66447,-15.78125 -14.9375,-15.78125 l -84.625,0 z m 45.0625,18.15625 27.5625,27.59375 -27.5625,27.5625 0,-15.5625 -33.0625,0 0,-24 33.0625,0 0,-15.59375 z").id("#button-arrow-blur-shadow")).build();
        this.button.getChildren().add((Object)arrowBlurShadow);
        SVGPath arrowStencilCrisp = ((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)SVGPathBuilder.create().content("m 17.40912,0.47162 c -8.27303,0 -14.9375,7.04253 -14.9375,15.78125 l 0,59.9375 c 0,8.73872 6.66447,15.75 14.9375,15.75 l 84.625,0 c 8.27303,0 14.9375,-7.01128 14.9375,-15.75 l 0,-59.9375 c 0,-8.73872 -6.66447,-15.78125 -14.9375,-15.78125 l -84.625,0 z m 45.0625,18.15625 27.5625,27.59375 -27.5625,27.5625 0,-15.5625 -33.0625,0 0,-24 33.0625,0 0,-15.59375 z").fill(this.CONTROL.getButtonColor())).id("#button-arrow-stencil-crisp")).transforms(new Transform[]{scale})).build();
        this.button.getChildren().add((Object)arrowStencilCrisp);
        SVGPath glareRect = ((SVGPathBuilder)((SVGPathBuilder)((SVGPathBuilder)SVGPathBuilder.create().content("m 17.83252,1.67757 c -8.27303,0 -14.9375,7.21042 -14.9375,16.15746 l 0,28.31557 114.5,0 0,-28.31557 c 0,-8.94704 -6.66447,-16.15746 -14.9375,-16.15746 l -84.625,0 z").fill((Paint)LinearGradientBuilder.create().proportional(true).startX(0.0).startY(1.0).endX(0.0).endY(0.0).stops(new Stop[]{new Stop(0.0, Color.web((String)"f4f4f4", (double)0.6)), new Stop(1.0, Color.web((String)"ffffff", (double)0.2063063))}).build())).id("#button-arrow-glare-rect")).transforms(new Transform[]{scale})).build();
        glareRect.visibleProperty().bind((ObservableValue)this.CONTROL.buttonGlareVisibleProperty());
        this.button.getChildren().add((Object)glareRect);
        this.button.setCache(true);
    }
}

