/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.Direction;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import jfxtras.labs.internal.scene.control.behavior.XYControlBehavior;
import jfxtras.labs.scene.control.gauge.XYControl;

public class XYControlSkin
extends SkinBase<XYControl, XYControlBehavior> {
    private XYControl control;
    private EventHandler handler;
    private StackPane area;
    private StackPane incrementX;
    private StackPane decrementX;
    private StackPane incrementY;
    private StackPane decrementY;
    private StackPane horSlider;
    private StackPane horSliderThumb;
    private StackPane verSlider;
    private StackPane verSliderThumb;
    private StackPane reset;
    private StackPane thumb;
    private double thumbX;
    private double thumbY;
    private double mouseX;
    private double mouseY;
    private boolean isDirty;
    private boolean initialized;

    public XYControlSkin(XYControl CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new XYControlBehavior(CONTROL));
        this.control = CONTROL;
        this.handler = new EventHandler<Event>(){

            public void handle(Event EVENT) {
                if (MouseEvent.MOUSE_CLICKED == EVENT.getEventType()) {
                    if (XYControlSkin.this.incrementX.equals(EVENT.getSource())) {
                        XYControlSkin.this.control.incrementX();
                    } else if (XYControlSkin.this.decrementX.equals(EVENT.getSource())) {
                        XYControlSkin.this.control.decrementX();
                    } else if (XYControlSkin.this.incrementY.equals(EVENT.getSource())) {
                        XYControlSkin.this.control.decrementY();
                    } else if (XYControlSkin.this.decrementY.equals(EVENT.getSource())) {
                        XYControlSkin.this.control.incrementY();
                    } else if (XYControlSkin.this.reset.equals(EVENT.getSource())) {
                        XYControlSkin.this.control.reset();
                    }
                } else if (MouseEvent.MOUSE_PRESSED == EVENT.getEventType()) {
                    if (XYControlSkin.this.thumb.equals(EVENT.getSource())) {
                        XYControlSkin.this.mouseX = ((MouseEvent)EVENT).getSceneX();
                        XYControlSkin.this.mouseY = ((MouseEvent)EVENT).getSceneY();
                        XYControlSkin.this.thumbX = XYControlSkin.this.thumb.getLayoutX();
                        XYControlSkin.this.thumbY = XYControlSkin.this.thumb.getLayoutY();
                    }
                } else if (MouseEvent.MOUSE_DRAGGED == EVENT.getEventType()) {
                    if (XYControlSkin.this.thumb.equals(EVENT.getSource())) {
                        XYControlSkin.this.thumbX += (((MouseEvent)EVENT).getSceneX() - XYControlSkin.this.mouseX) * (((XYControlSkin)XYControlSkin.this).control.getSensitivity().STEP_SIZE * 10.0);
                        XYControlSkin.this.thumbY += (((MouseEvent)EVENT).getSceneY() - XYControlSkin.this.mouseY) * (((XYControlSkin)XYControlSkin.this).control.getSensitivity().STEP_SIZE * 10.0);
                        if (XYControlSkin.this.thumbX > XYControlSkin.this.area.getLayoutX() + XYControlSkin.this.area.getLayoutBounds().getWidth() - XYControlSkin.this.thumb.getLayoutBounds().getWidth()) {
                            XYControlSkin.this.thumbX = XYControlSkin.this.area.getLayoutX() + XYControlSkin.this.area.getLayoutBounds().getWidth() - XYControlSkin.this.thumb.getLayoutBounds().getWidth();
                        } else if (XYControlSkin.this.thumbX < XYControlSkin.this.area.getLayoutX()) {
                            XYControlSkin.this.thumbX = XYControlSkin.this.area.getLayoutX();
                        }
                        if (XYControlSkin.this.thumbY > XYControlSkin.this.area.getLayoutY() + XYControlSkin.this.area.getLayoutBounds().getHeight() - XYControlSkin.this.thumb.getLayoutBounds().getHeight()) {
                            XYControlSkin.this.thumbY = XYControlSkin.this.area.getLayoutY() + XYControlSkin.this.area.getLayoutBounds().getHeight() - XYControlSkin.this.thumb.getLayoutBounds().getHeight();
                        } else if (XYControlSkin.this.thumbY < XYControlSkin.this.area.getLayoutY()) {
                            XYControlSkin.this.thumbY = XYControlSkin.this.area.getLayoutY();
                        }
                        double x = XYControlSkin.this.thumbX / ((XYControlSkin.this.area.getLayoutBounds().getWidth() - XYControlSkin.this.thumb.getLayoutBounds().getWidth()) / 2.0) - 1.0;
                        double y = (XYControlSkin.this.thumbY / (-(XYControlSkin.this.area.getLayoutBounds().getHeight() - XYControlSkin.this.thumb.getLayoutBounds().getHeight()) / 2.0) + 1.0) * -1.0;
                        XYControlSkin.this.control.setXValue(x);
                        XYControlSkin.this.control.setYValue(y);
                        XYControlSkin.this.mouseX = ((MouseEvent)EVENT).getSceneX();
                        XYControlSkin.this.mouseY = ((MouseEvent)EVENT).getSceneY();
                    }
                } else if (MouseEvent.MOUSE_RELEASED == EVENT.getEventType()) {
                    if (XYControlSkin.this.thumb.equals(EVENT.getSource())) {
                        // empty if block
                    }
                } else if (ScrollEvent.SCROLL == EVENT.getEventType()) {
                    if (((ScrollEvent)EVENT).getDeltaY() < -30.0) {
                        switch (XYControlSkin.this.control.getSensitivity()) {
                            case COARSE: {
                                break;
                            }
                            case MEDIUM: {
                                XYControlSkin.this.control.setSensitivity(XYControl.Sensitivity.COARSE);
                                break;
                            }
                            case FINE: {
                                XYControlSkin.this.control.setSensitivity(XYControl.Sensitivity.MEDIUM);
                            }
                        }
                    } else if (((ScrollEvent)EVENT).getDeltaY() > 30.0) {
                        switch (XYControlSkin.this.control.getSensitivity()) {
                            case COARSE: {
                                XYControlSkin.this.control.setSensitivity(XYControl.Sensitivity.MEDIUM);
                                break;
                            }
                            case MEDIUM: {
                                XYControlSkin.this.control.setSensitivity(XYControl.Sensitivity.FINE);
                                break;
                            }
                        }
                    }
                }
            }
        };
        this.area = new StackPane();
        this.incrementX = new StackPane();
        this.decrementX = new StackPane();
        this.incrementY = new StackPane();
        this.decrementY = new StackPane();
        this.horSlider = new StackPane();
        this.horSliderThumb = new StackPane();
        this.verSlider = new StackPane();
        this.verSliderThumb = new StackPane();
        this.reset = new StackPane();
        this.thumb = new StackPane();
        this.thumbX = 95.0;
        this.thumbY = 95.0;
        this.mouseX = 0.0;
        this.mouseY = 0.0;
        this.initialized = false;
        this.isDirty = false;
        this.getStyleClass().add((Object)"xy-control");
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(220.0, 220.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.xValueProperty(), "X");
        this.registerChangeListener((ObservableValue)this.control.yValueProperty(), "Y");
        this.registerChangeListener((ObservableValue)this.control.xAxisLabelProperty(), "X_AXIS_LABEL");
        this.registerChangeListener((ObservableValue)this.control.yAxisLabelProperty(), "Y_AXIS_LABEL");
        this.registerChangeListener((ObservableValue)this.control.xAxisLabelVisibleProperty(), "X_AXIS_LABEL_VISIBILITY");
        this.registerChangeListener((ObservableValue)this.control.yAxisLabelVisibleProperty(), "Y_AXIS_LABEL_VISIBILITY");
        this.registerChangeListener((ObservableValue)this.control.sensitivityProperty(), "SENSITIVITY");
        this.incrementX.addEventFilter(MouseEvent.MOUSE_CLICKED, this.handler);
        this.decrementX.addEventFilter(MouseEvent.MOUSE_CLICKED, this.handler);
        this.incrementY.addEventFilter(MouseEvent.MOUSE_CLICKED, this.handler);
        this.decrementY.addEventFilter(MouseEvent.MOUSE_CLICKED, this.handler);
        this.reset.addEventFilter(MouseEvent.MOUSE_CLICKED, this.handler);
        this.thumb.addEventFilter(MouseEvent.MOUSE_PRESSED, this.handler);
        this.thumb.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.handler);
        this.thumb.addEventFilter(MouseEvent.MOUSE_RELEASED, this.handler);
        this.addEventFilter(ScrollEvent.SCROLL, this.handler);
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("X".equals(PROPERTY)) {
            double areaWidth = this.area.getLayoutBounds().getWidth() - this.thumb.getLayoutBounds().getWidth();
            double posX = this.control.getXValue() * areaWidth / 2.0 + areaWidth / 2.0;
            this.thumb.setLayoutX(posX);
            this.horSliderThumb.setLayoutX(this.control.getXValue() * this.horSlider.getLayoutBounds().getWidth() / 2.0 + this.horSlider.getLayoutBounds().getWidth() / 2.0 - this.horSliderThumb.getLayoutBounds().getWidth() / 2.0 + this.decrementX.getLayoutBounds().getWidth());
        } else if ("Y".equals(PROPERTY)) {
            double areaHeight = this.area.getLayoutBounds().getHeight() - this.thumb.getLayoutBounds().getHeight();
            double posY = this.control.getYValue() * areaHeight / 2.0 + areaHeight / 2.0;
            this.thumb.setLayoutY(posY);
            this.verSliderThumb.setLayoutY(this.control.getYValue() * this.verSlider.getLayoutBounds().getHeight() / 2.0 + this.verSlider.getLayoutBounds().getHeight() / 2.0 - this.verSliderThumb.getLayoutBounds().getHeight() / 2.0 + this.incrementY.getLayoutBounds().getHeight());
        } else if ("X_AXIS_LABEL".equals(PROPERTY)) {
            this.repaint();
        } else if ("Y_AXIS_LABEL".equals(PROPERTY)) {
            this.repaint();
        } else if ("X_AXIS_LABEL_VISIBILITY".equals(PROPERTY)) {
            this.repaint();
        } else if ("Y_AXIS_LABEL_VISIBILITY".equals(PROPERTY)) {
            this.repaint();
        } else if ("SENSITIVITY".equals(PROPERTY)) {
            switch (this.control.getSensitivity()) {
                case COARSE: {
                    this.thumb.setStyle("-fx-sensitivity-color: red;");
                    this.horSliderThumb.setStyle("-fx-sensitivity-color: red;");
                    this.verSliderThumb.setStyle("-fx-sensitivity-color: red;");
                    break;
                }
                case MEDIUM: {
                    this.thumb.setStyle("-fx-sensitivity-color: rgb(255, 191, 0);");
                    this.horSliderThumb.setStyle("-fx-sensitivity-color: rgb(255, 191, 0);");
                    this.verSliderThumb.setStyle("-fx-sensitivity-color: rgb(255, 191, 0);");
                    break;
                }
                case FINE: {
                    this.thumb.setStyle("-fx-sensitivity-color: green;");
                    this.horSliderThumb.setStyle("-fx-sensitivity-color: green;");
                    this.verSliderThumb.setStyle("-fx-sensitivity-color: green;");
                }
            }
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawControl();
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final XYControl getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 220.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 220.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void drawControl() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double AREA_SIZE = 0.9090909091 * SIZE;
        double BUTTON_SIZE = 0.0909090909 * SIZE;
        Font FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.055 * AREA_SIZE));
        this.getStyleClass().setAll((Object[])new String[]{"xy-control"});
        Pane pane = new Pane();
        pane.getStyleClass().setAll((Object[])new String[]{"xy-control"});
        Rectangle areaFrame = new Rectangle(0.0, 0.0, AREA_SIZE, AREA_SIZE);
        areaFrame.setFill((Paint)new LinearGradient(0.0, 0.0, areaFrame.getLayoutBounds().getMaxX(), areaFrame.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)64, (int)64, (int)64)), new Stop(0.49, Color.rgb((int)64, (int)64, (int)64)), new Stop(0.5, Color.rgb((int)240, (int)240, (int)240)), new Stop(1.0, Color.rgb((int)240, (int)240, (int)240))}));
        Rectangle areaBackground = new Rectangle(1.0, 1.0, areaFrame.getLayoutBounds().getWidth() - 2.0, areaFrame.getLayoutBounds().getWidth() - 2.0);
        areaBackground.setFill((Paint)new LinearGradient(0.0, areaBackground.getLayoutBounds().getMinY(), 0.0, areaBackground.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)220, (int)220, (int)220)), new Stop(1.0, Color.rgb((int)180, (int)180, (int)180))}));
        Line xAxis = new Line(1.0, AREA_SIZE / 2.0, AREA_SIZE - 1.0, AREA_SIZE / 2.0);
        xAxis.setFill(null);
        xAxis.setStroke((Paint)Color.rgb((int)38, (int)38, (int)38));
        Line yAxis = new Line(AREA_SIZE / 2.0, 1.0, AREA_SIZE / 2.0, AREA_SIZE - 1.0);
        yAxis.setFill(null);
        yAxis.setStroke((Paint)Color.rgb((int)38, (int)38, (int)38));
        this.area.getChildren().setAll((Object[])new Node[]{areaFrame, areaBackground, xAxis, yAxis});
        this.area.relocate(0.0, 0.0);
        pane.getChildren().add((Object)this.area);
        this.decrementX.getStyleClass().add((Object)"xy-button");
        this.decrementX.relocate(0.0, AREA_SIZE);
        Group arrowDecX = this.createArrow(Direction.LEFT, BUTTON_SIZE);
        this.decrementX.getChildren().add((Object)arrowDecX);
        StackPane.setAlignment((Node)arrowDecX, (Pos)Pos.CENTER);
        StackPane.setMargin((Node)arrowDecX, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        pane.getChildren().add((Object)this.decrementX);
        this.horSlider.getStyleClass().add((Object)"xy-slider-horizontal");
        Rectangle horSliderBounds = new Rectangle(AREA_SIZE - 2.0 * BUTTON_SIZE, BUTTON_SIZE);
        horSliderBounds.setOpacity(0.0);
        Text xAxisLabel = new Text(this.control.getXAxisLabel());
        xAxisLabel.setFont(FONT);
        xAxisLabel.getStyleClass().add((Object)"arrow");
        xAxisLabel.setTextOrigin(VPos.CENTER);
        xAxisLabel.setTextAlignment(TextAlignment.CENTER);
        xAxisLabel.setVisible(this.control.isXAxisLabelVisible());
        this.horSlider.getChildren().addAll((Object[])new Node[]{horSliderBounds, xAxisLabel});
        this.horSlider.relocate(BUTTON_SIZE, AREA_SIZE);
        pane.getChildren().add((Object)this.horSlider);
        Rectangle horThumb = new Rectangle(3.0, BUTTON_SIZE);
        horThumb.getStyleClass().add((Object)"xy-slider-horizontal-thumb");
        this.horSliderThumb.getChildren().add((Object)horThumb);
        this.horSliderThumb.relocate(AREA_SIZE / 2.0 - 1.0, AREA_SIZE);
        this.horSliderThumb.getStyleClass().clear();
        this.horSliderThumb.getStyleClass().addAll((Object[])new String[]{"xy-slider-horizontal-thumb"});
        pane.getChildren().add((Object)this.horSliderThumb);
        this.incrementX.getStyleClass().add((Object)"xy-button");
        this.incrementX.relocate(AREA_SIZE - BUTTON_SIZE, AREA_SIZE);
        Group arrowIncX = this.createArrow(Direction.RIGHT, BUTTON_SIZE);
        this.incrementX.getChildren().add((Object)arrowIncX);
        StackPane.setAlignment((Node)arrowIncX, (Pos)Pos.CENTER);
        StackPane.setMargin((Node)arrowIncX, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        pane.getChildren().add((Object)this.incrementX);
        this.incrementY.getStyleClass().add((Object)"xy-button");
        this.incrementY.relocate(AREA_SIZE, 0.0);
        Group arrowIncY = this.createArrow(Direction.UP, BUTTON_SIZE);
        this.incrementY.getChildren().add((Object)arrowIncY);
        StackPane.setAlignment((Node)arrowIncY, (Pos)Pos.CENTER);
        StackPane.setMargin((Node)arrowIncY, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        pane.getChildren().add((Object)this.incrementY);
        this.verSlider.getStyleClass().add((Object)"xy-slider-vertical");
        Group group = new Group();
        Rectangle verSliderBounds = new Rectangle(BUTTON_SIZE, AREA_SIZE - 2.0 * BUTTON_SIZE);
        verSliderBounds.setOpacity(0.0);
        Text yAxisLabel = new Text(this.control.getYAxisLabel());
        yAxisLabel.setFont(FONT);
        yAxisLabel.getStyleClass().add((Object)"arrow");
        yAxisLabel.setTextOrigin(VPos.CENTER);
        yAxisLabel.setTextAlignment(TextAlignment.CENTER);
        yAxisLabel.setVisible(this.control.isYAxisLabelVisible());
        yAxisLabel.setRotate(-90.0);
        yAxisLabel.setLayoutX(-yAxisLabel.getLayoutBounds().getHeight());
        yAxisLabel.setLayoutY(verSliderBounds.getLayoutBounds().getHeight() / 2.0);
        group.getChildren().addAll((Object[])new Node[]{verSliderBounds, yAxisLabel});
        this.verSlider.getChildren().addAll((Object[])new Node[]{group});
        this.verSlider.relocate(AREA_SIZE, BUTTON_SIZE);
        pane.getChildren().add((Object)this.verSlider);
        Rectangle verThumb = new Rectangle(BUTTON_SIZE, 3.0);
        verThumb.getStyleClass().add((Object)"xy-slider-vertical-thumb");
        this.verSliderThumb.getChildren().add((Object)verThumb);
        this.verSliderThumb.relocate(AREA_SIZE, AREA_SIZE / 2.0 - 1.0);
        this.verSliderThumb.getStyleClass().clear();
        this.verSliderThumb.getStyleClass().addAll((Object[])new String[]{"xy-slider-vertical-thumb"});
        pane.getChildren().add((Object)this.verSliderThumb);
        this.decrementY.getStyleClass().add((Object)"xy-button");
        this.decrementY.relocate(AREA_SIZE, AREA_SIZE - BUTTON_SIZE);
        Group arrowDecY = this.createArrow(Direction.DOWN, BUTTON_SIZE);
        this.decrementY.getChildren().add((Object)arrowDecY);
        StackPane.setAlignment((Node)arrowDecY, (Pos)Pos.CENTER);
        StackPane.setMargin((Node)arrowDecY, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        pane.getChildren().add((Object)this.decrementY);
        this.reset.getStyleClass().addAll((Object[])new String[]{"xy-button"});
        this.reset.relocate(AREA_SIZE, AREA_SIZE);
        Group RESET_GROUP = new Group();
        Rectangle IBOUNDS = new Rectangle(BUTTON_SIZE, BUTTON_SIZE);
        IBOUNDS.setOpacity(0.0);
        Ellipse ZERO = new Ellipse(0.5 * BUTTON_SIZE, 0.5 * BUTTON_SIZE, 0.02 * AREA_SIZE, 0.025 * AREA_SIZE);
        ZERO.setStrokeWidth(0.01 * AREA_SIZE);
        ZERO.getStyleClass().add((Object)"zero");
        RESET_GROUP.getChildren().addAll((Object[])new Node[]{IBOUNDS, ZERO});
        this.reset.getChildren().add((Object)RESET_GROUP);
        pane.getChildren().add((Object)this.reset);
        this.thumb.getStyleClass().clear();
        this.thumb.getStyleClass().addAll((Object[])new String[]{"xy-thumb"});
        this.thumb.relocate(AREA_SIZE / 2.0 - 5.0, AREA_SIZE / 2.0 - 5.0);
        pane.getChildren().add((Object)this.thumb);
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    private Group createArrow(Direction DIRECTION, double SIZE) {
        double WIDTH = SIZE;
        double HEIGHT = SIZE;
        Rectangle IBOUNDS = new Rectangle(SIZE, SIZE);
        IBOUNDS.setOpacity(0.0);
        Group ARROW = new Group();
        Path PATH = new Path();
        PATH.setFillRule(FillRule.EVEN_ODD);
        switch (DIRECTION) {
            case UP: {
                PATH.getElements().add((Object)new MoveTo(0.25 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.75 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.25 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new ClosePath());
                break;
            }
            case RIGHT: {
                PATH.getElements().add((Object)new MoveTo(0.25 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.75 * WIDTH, 0.5 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.25 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.25 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new ClosePath());
                break;
            }
            case DOWN: {
                PATH.getElements().add((Object)new MoveTo(0.25 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.75 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.25 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new ClosePath());
                break;
            }
            case LEFT: {
                PATH.getElements().add((Object)new MoveTo(0.75 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.25 * WIDTH, 0.5 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.75 * WIDTH, 0.75 * HEIGHT));
                PATH.getElements().add((Object)new LineTo(0.75 * WIDTH, 0.25 * HEIGHT));
                PATH.getElements().add((Object)new ClosePath());
            }
        }
        PATH.getStyleClass().add((Object)"arrow");
        ARROW.getChildren().addAll((Object[])new Node[]{IBOUNDS, PATH});
        return ARROW;
    }
}

