/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin.window;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.skin.window.ResizeMode;
import jfxtras.labs.internal.scene.control.skin.window.TitleBar;
import jfxtras.labs.scene.control.window.SelectableNode;
import jfxtras.labs.scene.control.window.Window;
import jfxtras.labs.scene.control.window.WindowIcon;
import jfxtras.labs.util.WindowUtil;

public class DefaultWindowSkin
extends SkinBase<Window, BehaviorBase<Window>> {
    private double mouseX;
    private double mouseY;
    private double nodeX = 0.0;
    private double nodeY = 0.0;
    private boolean dragging = false;
    private boolean zoomable = true;
    private double minScale = 0.1;
    private double maxScale = 10.0;
    private double scaleIncrement = 0.001;
    private ResizeMode resizeMode;
    private boolean RESIZE_TOP;
    private boolean RESIZE_LEFT;
    private boolean RESIZE_BOTTOM;
    private boolean RESIZE_RIGHT;
    private TitleBar titleBar;
    private Window control;
    private Pane root = new Pane();
    private double contentScale = 1.0;
    private double oldHeight;
    private Timeline minimizeTimeLine;

    public DefaultWindowSkin(Window w) {
        super((Control)w, new BehaviorBase((Control)w));
        this.control = w;
        this.titleBar = new TitleBar(this.control);
        this.titleBar.setTitle("");
        this.init();
    }

    private void init() {
        this.getChildren().add((Object)this.root);
        this.root.getChildren().add((Object)this.titleBar);
        for (WindowIcon i : this.control.getLeftIcons()) {
            this.titleBar.addLeftIcon((Node)i);
        }
        for (WindowIcon i : this.control.getRightIcons()) {
            this.titleBar.addRightIcon((Node)i);
        }
        this.control.getLeftIcons().addListener((ListChangeListener)new ListChangeListener<WindowIcon>(){

            public void onChanged(ListChangeListener.Change<? extends WindowIcon> change) {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        }
                        continue;
                    }
                    if (change.wasUpdated()) continue;
                    if (change.wasRemoved()) {
                        for (WindowIcon i : change.getRemoved()) {
                            DefaultWindowSkin.this.titleBar.removeLeftIcon((Node)i);
                        }
                        continue;
                    }
                    if (!change.wasAdded()) continue;
                    for (WindowIcon i : change.getAddedSubList()) {
                        DefaultWindowSkin.this.titleBar.addLeftIcon((Node)i);
                    }
                }
            }
        });
        this.control.getRightIcons().addListener((ListChangeListener)new ListChangeListener<WindowIcon>(){

            public void onChanged(ListChangeListener.Change<? extends WindowIcon> change) {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        }
                        continue;
                    }
                    if (change.wasUpdated()) continue;
                    if (change.wasRemoved()) {
                        for (WindowIcon i : change.getRemoved()) {
                            DefaultWindowSkin.this.titleBar.removeRightIcon((Node)i);
                        }
                        continue;
                    }
                    if (!change.wasAdded()) continue;
                    for (WindowIcon i : change.getAddedSubList()) {
                        DefaultWindowSkin.this.titleBar.addRightIcon((Node)i);
                    }
                }
            }
        });
        this.control.minimizedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, final Boolean newValue) {
                boolean storeOldHeight;
                if (oldValue == newValue) {
                    return;
                }
                boolean bl = storeOldHeight = DefaultWindowSkin.this.minimizeTimeLine == null && newValue != false;
                if (DefaultWindowSkin.this.minimizeTimeLine != null) {
                    DefaultWindowSkin.this.minimizeTimeLine.stop();
                    DefaultWindowSkin.this.minimizeTimeLine = null;
                }
                double newHeight = newValue != false ? DefaultWindowSkin.this.titleBar.getHeight() : DefaultWindowSkin.this.oldHeight;
                if (storeOldHeight) {
                    DefaultWindowSkin.this.oldHeight = DefaultWindowSkin.this.control.getPrefHeight();
                }
                DefaultWindowSkin.this.minimizeTimeLine = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)DefaultWindowSkin.this.control.prefHeightProperty(), (Object)DefaultWindowSkin.this.control.getPrefHeight())}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)DefaultWindowSkin.this.control.prefHeightProperty(), (Object)newHeight)})});
                DefaultWindowSkin.this.minimizeTimeLine.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

                    public void changed(ObservableValue<? extends Animation.Status> ov, Animation.Status oldStatus, Animation.Status newStatus) {
                        if (newStatus == Animation.Status.STOPPED) {
                            DefaultWindowSkin.this.minimizeTimeLine = null;
                            if (newValue.booleanValue()) {
                                DefaultWindowSkin.this.control.getContentPane().setVisible(false);
                            }
                        }
                    }
                });
                DefaultWindowSkin.this.minimizeTimeLine.play();
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new MinimizeHeightListener(this.control, this.titleBar));
        this.initMouseEventHandlers();
        this.titleBar.setTitle(this.control.getTitle());
        this.control.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                DefaultWindowSkin.this.titleBar.setTitle(newValue);
                DefaultWindowSkin.this.control.autosize();
            }
        });
        this.root.getChildren().add((Object)this.control.getContentPane());
        this.control.getContentPane().setManaged(false);
        this.control.contentPaneProperty().addListener((ChangeListener)new ChangeListener<Pane>(){

            public void changed(ObservableValue<? extends Pane> ov, Pane oldValue, Pane newValue) {
                DefaultWindowSkin.this.root.getChildren().remove((Object)oldValue);
                DefaultWindowSkin.this.root.getChildren().add((Object)newValue);
                newValue.setManaged(false);
            }
        });
        this.titleBar.setStyle(this.control.getStyle());
        this.control.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                DefaultWindowSkin.this.titleBar.setStyle(t1);
            }
        });
        this.titleBar.getStyleClass().setAll((Object[])new String[]{this.control.getTitleBarStyleClass()});
        this.titleBar.getLabel().getStyleClass().setAll((Object[])new String[]{this.control.getTitleBarStyleClass()});
        this.control.titleBarStyleClassProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                DefaultWindowSkin.this.titleBar.getStyleClass().setAll((Object[])new String[]{t1});
                DefaultWindowSkin.this.titleBar.getLabel().getStyleClass().setAll((Object[])new String[]{t1});
            }
        });
        this.titleBar.getStylesheets().setAll((Collection)this.control.getStylesheets());
        this.control.getStylesheets().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        }
                        continue;
                    }
                    if (change.wasUpdated()) continue;
                    if (change.wasRemoved()) {
                        for (String i : change.getRemoved()) {
                            DefaultWindowSkin.this.titleBar.getStylesheets().remove((Object)i);
                        }
                        continue;
                    }
                    if (!change.wasAdded()) continue;
                    for (String i : change.getAddedSubList()) {
                        DefaultWindowSkin.this.titleBar.getStylesheets().add((Object)i);
                    }
                }
            }
        });
        this.control.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    DropShadow shadow = new DropShadow(20.0, Color.WHITE);
                    Glow effect = new Glow(0.5);
                    DefaultWindowSkin.this.control.setEffect((Effect)effect);
                } else {
                    DefaultWindowSkin.this.control.setEffect(null);
                }
            }
        });
    }

    private void initMouseEventHandlers() {
        this.onMousePressedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Window n = DefaultWindowSkin.this.control;
                double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                DefaultWindowSkin.this.mouseX = event.getSceneX();
                DefaultWindowSkin.this.mouseY = event.getSceneY();
                DefaultWindowSkin.this.nodeX = n.getLayoutX() * parentScaleX;
                DefaultWindowSkin.this.nodeY = n.getLayoutY() * parentScaleY;
                if (DefaultWindowSkin.this.control.isMoveToFront()) {
                    DefaultWindowSkin.this.control.toFront();
                }
                if (DefaultWindowSkin.this.control.isSelected()) {
                    DefaultWindowSkin.this.selectedWindowsToFront();
                }
            }
        });
        this.onMouseDraggedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Window n = DefaultWindowSkin.this.control;
                double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                double scaleX = ((Transform)n.localToSceneTransformProperty().getValue()).getMxx();
                double scaleY = ((Transform)n.localToSceneTransformProperty().getValue()).getMyy();
                Bounds boundsInScene = DefaultWindowSkin.this.control.localToScene(DefaultWindowSkin.this.control.getBoundsInLocal());
                double sceneX = boundsInScene.getMinX();
                double sceneY = boundsInScene.getMinY();
                double offsetX = event.getSceneX() - DefaultWindowSkin.this.mouseX;
                double offsetY = event.getSceneY() - DefaultWindowSkin.this.mouseY;
                if (DefaultWindowSkin.this.resizeMode == ResizeMode.NONE && DefaultWindowSkin.this.control.isMovable()) {
                    DefaultWindowSkin.this.nodeX += offsetX;
                    DefaultWindowSkin.this.nodeY += offsetY;
                    double scaledX = DefaultWindowSkin.this.nodeX * 1.0 / parentScaleX;
                    double scaledY = DefaultWindowSkin.this.nodeY * 1.0 / parentScaleY;
                    double offsetForAllX = scaledX - n.getLayoutX();
                    double offsetForAllY = scaledY - n.getLayoutY();
                    n.setLayoutX(scaledX);
                    n.setLayoutY(scaledY);
                    DefaultWindowSkin.this.dragging = true;
                    if (DefaultWindowSkin.this.control.isSelected()) {
                        DefaultWindowSkin.this.dragSelectedWindows(offsetForAllX, offsetForAllY);
                    }
                } else {
                    double newWidth;
                    double xDiff;
                    double newHeight;
                    double yDiff;
                    double insetOffset;
                    double width = n.getBoundsInLocal().getMaxX() - n.getBoundsInLocal().getMinX();
                    double height = n.getBoundsInLocal().getMaxY() - n.getBoundsInLocal().getMinY();
                    if (DefaultWindowSkin.this.RESIZE_TOP) {
                        insetOffset = DefaultWindowSkin.this.getInsets().getTop() / 2.0;
                        yDiff = sceneY / parentScaleY + insetOffset - event.getSceneY() / parentScaleY;
                        newHeight = DefaultWindowSkin.this.control.getPrefHeight() + yDiff;
                        if (newHeight > DefaultWindowSkin.this.control.minHeight(0.0)) {
                            DefaultWindowSkin.this.control.setLayoutY(DefaultWindowSkin.this.control.getLayoutY() - yDiff);
                            DefaultWindowSkin.this.control.setPrefHeight(newHeight);
                        }
                    }
                    if (DefaultWindowSkin.this.RESIZE_LEFT) {
                        insetOffset = DefaultWindowSkin.this.getInsets().getLeft() / 2.0;
                        xDiff = sceneX / parentScaleX + insetOffset - event.getSceneX() / parentScaleX;
                        newWidth = DefaultWindowSkin.this.control.getPrefWidth() + xDiff;
                        if (newWidth > Math.max(DefaultWindowSkin.this.control.minWidth(0.0), DefaultWindowSkin.this.control.getContentPane().minWidth(0.0))) {
                            DefaultWindowSkin.this.control.setLayoutX(DefaultWindowSkin.this.control.getLayoutX() - xDiff);
                            DefaultWindowSkin.this.control.setPrefWidth(newWidth);
                        }
                    }
                    if (DefaultWindowSkin.this.RESIZE_BOTTOM) {
                        insetOffset = DefaultWindowSkin.this.getInsets().getBottom() / 2.0;
                        newHeight = yDiff = event.getSceneY() / parentScaleY - sceneY / parentScaleY - insetOffset;
                        if ((newHeight = Math.max(newHeight, DefaultWindowSkin.this.control.minHeight(0.0))) < DefaultWindowSkin.this.control.maxHeight(0.0)) {
                            DefaultWindowSkin.this.control.setPrefHeight(newHeight);
                        }
                    }
                    if (DefaultWindowSkin.this.RESIZE_RIGHT) {
                        insetOffset = DefaultWindowSkin.this.getInsets().getRight() / 2.0;
                        newWidth = xDiff = event.getSceneX() / parentScaleX - sceneX / parentScaleY - insetOffset;
                        if ((newWidth = Math.max(newWidth, Math.max(DefaultWindowSkin.this.control.getContentPane().minWidth(0.0), DefaultWindowSkin.this.control.minWidth(0.0)))) < DefaultWindowSkin.this.control.maxWidth(0.0)) {
                            DefaultWindowSkin.this.control.setPrefWidth(newWidth);
                        }
                    }
                }
                DefaultWindowSkin.this.mouseX = event.getSceneX();
                DefaultWindowSkin.this.mouseY = event.getSceneY();
            }
        });
        this.onMouseClickedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DefaultWindowSkin.this.dragging = false;
            }
        });
        this.onMouseMovedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (DefaultWindowSkin.this.control.isMinimized() || !DefaultWindowSkin.this.control.isResizableWindow()) {
                    DefaultWindowSkin.this.RESIZE_TOP = false;
                    DefaultWindowSkin.this.RESIZE_LEFT = false;
                    DefaultWindowSkin.this.RESIZE_BOTTOM = false;
                    DefaultWindowSkin.this.RESIZE_RIGHT = false;
                    DefaultWindowSkin.this.resizeMode = ResizeMode.NONE;
                    return;
                }
                Window n = DefaultWindowSkin.this.control;
                double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                double scaleX = ((Transform)n.localToSceneTransformProperty().getValue()).getMxx();
                double scaleY = ((Transform)n.localToSceneTransformProperty().getValue()).getMyy();
                double border = DefaultWindowSkin.this.control.getResizableBorderWidth() * scaleX;
                double diffMinX = Math.abs(n.getLayoutBounds().getMinX() - t.getX() + DefaultWindowSkin.this.getInsets().getLeft());
                double diffMinY = Math.abs(n.getLayoutBounds().getMinY() - t.getY() + DefaultWindowSkin.this.getInsets().getTop());
                double diffMaxX = Math.abs(n.getLayoutBounds().getMaxX() - t.getX() - DefaultWindowSkin.this.getInsets().getRight());
                double diffMaxY = Math.abs(n.getLayoutBounds().getMaxY() - t.getY() - DefaultWindowSkin.this.getInsets().getBottom());
                boolean left = diffMinX * scaleX < Math.max(border, DefaultWindowSkin.this.getInsets().getLeft() / 2.0 * scaleX);
                boolean top = diffMinY * scaleY < Math.max(border, DefaultWindowSkin.this.getInsets().getTop() / 2.0 * scaleY);
                boolean right = diffMaxX * scaleX < Math.max(border, DefaultWindowSkin.this.getInsets().getRight() / 2.0 * scaleX);
                boolean bottom = diffMaxY * scaleY < Math.max(border, DefaultWindowSkin.this.getInsets().getBottom() / 2.0 * scaleY);
                DefaultWindowSkin.this.RESIZE_TOP = false;
                DefaultWindowSkin.this.RESIZE_LEFT = false;
                DefaultWindowSkin.this.RESIZE_BOTTOM = false;
                DefaultWindowSkin.this.RESIZE_RIGHT = false;
                if (left && !top && !bottom) {
                    n.setCursor(Cursor.W_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.LEFT;
                    DefaultWindowSkin.this.RESIZE_LEFT = true;
                } else if (left && top && !bottom) {
                    n.setCursor(Cursor.NW_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.TOP_LEFT;
                    DefaultWindowSkin.this.RESIZE_LEFT = true;
                    DefaultWindowSkin.this.RESIZE_TOP = true;
                } else if (left && !top && bottom) {
                    n.setCursor(Cursor.SW_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.BOTTOM_LEFT;
                    DefaultWindowSkin.this.RESIZE_LEFT = true;
                    DefaultWindowSkin.this.RESIZE_BOTTOM = true;
                } else if (right && !top && !bottom) {
                    n.setCursor(Cursor.E_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.RIGHT;
                    DefaultWindowSkin.this.RESIZE_RIGHT = true;
                } else if (right && top && !bottom) {
                    n.setCursor(Cursor.NE_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.TOP_RIGHT;
                    DefaultWindowSkin.this.RESIZE_RIGHT = true;
                    DefaultWindowSkin.this.RESIZE_TOP = true;
                } else if (right && !top && bottom) {
                    n.setCursor(Cursor.SE_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.BOTTOM_RIGHT;
                    DefaultWindowSkin.this.RESIZE_RIGHT = true;
                    DefaultWindowSkin.this.RESIZE_BOTTOM = true;
                } else if (top && !left && !right) {
                    n.setCursor(Cursor.N_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.TOP;
                    DefaultWindowSkin.this.RESIZE_TOP = true;
                } else if (bottom && !left && !right) {
                    n.setCursor(Cursor.S_RESIZE);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.BOTTOM;
                    DefaultWindowSkin.this.RESIZE_BOTTOM = true;
                } else {
                    n.setCursor(Cursor.DEFAULT);
                    DefaultWindowSkin.this.resizeMode = ResizeMode.NONE;
                }
                DefaultWindowSkin.this.control.autosize();
            }
        });
    }

    private void selectedWindowsToFront() {
        for (SelectableNode sN : WindowUtil.getDefaultClipboard().getSelectedItems()) {
            if (sN == this.control || !(sN instanceof Window)) continue;
            Window selectedWindow = (Window)sN;
            if (!this.control.getParent().equals(selectedWindow.getParent()) || !selectedWindow.isMoveToFront()) continue;
            selectedWindow.toFront();
        }
    }

    private void dragSelectedWindows(double offsetForAllX, double offsetForAllY) {
        for (SelectableNode sN : WindowUtil.getDefaultClipboard().getSelectedItems()) {
            if (sN == this.control || !(sN instanceof Window)) continue;
            Window selectedWindow = (Window)sN;
            if (!this.control.getParent().equals(selectedWindow.getParent())) continue;
            selectedWindow.setLayoutX(selectedWindow.getLayoutX() + offsetForAllX);
            selectedWindow.setLayoutY(selectedWindow.getLayoutY() + offsetForAllY);
        }
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    public void removeNode(Node n) {
        this.getChildren().remove((Object)n);
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double minScale) {
        this.minScale = minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = maxScale;
    }

    public double getScaleIncrement() {
        return this.scaleIncrement;
    }

    public void setScaleIncrement(double scaleIncrement) {
        this.scaleIncrement = scaleIncrement;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.root.relocate(0.0, 0.0);
        this.root.resize(this.root.getWidth() + this.getInsets().getLeft() + this.getInsets().getRight(), this.root.getHeight() + this.getInsets().getTop() + this.getInsets().getBottom());
        this.titleBar.relocate(0.0, 0.0);
        double titleBarWidth = this.titleBar.prefWidth(0.0);
        double windowWidth = this.root.getWidth();
        if (titleBarWidth > windowWidth) {
            this.setWidth(titleBarWidth);
        }
        double newTitleBarWidth = Math.max(titleBarWidth, windowWidth);
        this.titleBar.resize(newTitleBarWidth, this.titleBar.prefHeight(0.0));
        double leftAndRight = this.getInsets().getLeft() + this.getInsets().getRight();
        double topAndBottom = this.getInsets().getTop() + this.getInsets().getBottom();
        this.control.getContentPane().relocate(this.getInsets().getLeft(), this.titleBar.prefHeight(0.0));
        this.control.getContentPane().resize(this.root.getWidth() - leftAndRight, this.root.getHeight() - this.getInsets().getBottom() - this.titleBar.prefHeight(0.0));
        this.titleBar.layoutChildren();
    }

    protected double computeMinWidth(double d) {
        double result = this.root.minWidth(d);
        result = Math.max(result, this.titleBar.prefWidth(d));
        return result;
    }

    protected double computePrefWidth(double d) {
        return this.computeMinWidth(d);
    }

    protected double computeMinHeight(double d) {
        double result = this.root.minHeight(d);
        double minHeight = this.titleBar.prefHeight(d);
        if (!this.control.isMinimized() && this.control.getContentPane().isVisible()) {
            minHeight += this.control.getContentPane().minHeight(d) + this.getInsets().getBottom();
        }
        result = Math.max(result, minHeight);
        return result;
    }

    static class MinimizeHeightListener
    implements ChangeListener<Number> {
        private Window control;
        private TitleBar titleBar;

        public MinimizeHeightListener(Window control, TitleBar titleBar) {
            this.control = control;
            this.titleBar = titleBar;
        }

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            if (this.control.isMinimized() && this.control.getPrefHeight() < this.titleBar.minHeight(0.0) + this.control.getContentPane().minHeight(0.0)) {
                this.control.getContentPane().setVisible(false);
            } else if (!this.control.isMinimized() && this.control.getPrefHeight() >= this.titleBar.minHeight(0.0) + this.control.getContentPane().minHeight(0.0)) {
                this.control.getContentPane().setVisible(true);
            }
        }
    }
}

