/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin.window;

import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import jfxtras.labs.scene.control.window.Window;

class TitleBar
extends HBox {
    public static final String DEFAULT_STYLE_CLASS = "window-titlebar";
    private Pane leftIconPane;
    private Pane rightIconPane;
    private Text label = new Text();
    private double iconSpacing = 3.0;
    Window control;
    private double offset = 40.0;
    private double originalTitleWidth;

    public TitleBar(Window w) {
        this.control = w;
        this.setManaged(false);
        this.getStylesheets().setAll((Collection)w.getStylesheets());
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setSpacing(8.0);
        this.leftIconPane = new IconPane();
        this.rightIconPane = new IconPane();
        this.getChildren().add((Object)this.leftIconPane);
        this.getChildren().add((Object)this.label);
        this.getChildren().add((Object)this.rightIconPane);
        this.control.boundsInParentProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds t, Bounds t1) {
                if (TitleBar.this.control.getTitle() == null || TitleBar.this.getLabel().getText() == null || TitleBar.this.getLabel().getText().isEmpty()) {
                    return;
                }
                double maxIconWidth = Math.max(TitleBar.this.leftIconPane.getWidth(), TitleBar.this.rightIconPane.getWidth());
                if (!TitleBar.this.control.getTitle().equals(TitleBar.this.getLabel().getText())) {
                    if (TitleBar.this.originalTitleWidth + maxIconWidth * 2.0 + TitleBar.this.offset < TitleBar.this.getWidth()) {
                        TitleBar.this.getLabel().setText(TitleBar.this.control.getTitle());
                    }
                } else if (!"...".equals(TitleBar.this.getLabel().getText()) && TitleBar.this.originalTitleWidth + maxIconWidth * 2.0 + TitleBar.this.offset >= TitleBar.this.getWidth()) {
                    TitleBar.this.getLabel().setText("...");
                }
            }
        });
    }

    public void setTitle(String title) {
        this.getLabel().setText(title);
        this.originalTitleWidth = this.getLabel().getBoundsInParent().getWidth();
        double maxIconWidth = Math.max(this.leftIconPane.getWidth(), this.rightIconPane.getWidth());
        if (this.originalTitleWidth + maxIconWidth * 2.0 + this.offset >= this.getWidth()) {
            this.getLabel().setText("...");
        }
    }

    public String getTitle() {
        return this.getLabel().getText();
    }

    public void addLeftIcon(Node n) {
        this.leftIconPane.getChildren().add((Object)n);
    }

    public void addRightIcon(Node n) {
        this.rightIconPane.getChildren().add((Object)n);
    }

    public void removeLeftIcon(Node n) {
        this.leftIconPane.getChildren().remove((Object)n);
    }

    public void removeRightIcon(Node n) {
        this.rightIconPane.getChildren().remove((Object)n);
    }

    protected double computeMinWidth(double h) {
        double result = super.computeMinWidth(h);
        double iconWidth = Math.max(this.leftIconPane.prefWidth(h), this.rightIconPane.prefWidth(h)) * 2.0;
        result = Math.max(result, iconWidth + this.getInsets().getLeft() + this.getInsets().getRight());
        return result + this.iconSpacing * 2.0 + this.offset;
    }

    protected double computePrefWidth(double h) {
        return this.computeMinWidth(h);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.leftIconPane.resizeRelocate(this.getInsets().getLeft(), this.getInsets().getTop(), this.leftIconPane.prefWidth(Double.NEGATIVE_INFINITY), this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom());
        this.rightIconPane.resize(this.rightIconPane.prefWidth(Double.NEGATIVE_INFINITY), this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom());
        this.rightIconPane.relocate(this.getWidth() - this.rightIconPane.getWidth() - this.getInsets().getRight(), this.getInsets().getTop());
    }

    public Text getLabel() {
        return this.label;
    }

    private static class IconPane
    extends Pane {
        private double spacing = 2.0;

        public IconPane() {
            this.setManaged(false);
            this.setPrefWidth(-1.0);
            this.setMinWidth(-1.0);
        }

        protected void layoutChildren() {
            int count = 0;
            double width = this.getHeight();
            double height = this.getHeight();
            for (Node n : this.getManagedChildren()) {
                double x = (width + this.spacing) * (double)count;
                n.resizeRelocate(x, 0.0, width, height);
                ++count;
            }
        }

        protected double computeMinWidth(double h) {
            return this.getHeight() * (double)this.getChildren().size() + this.spacing * (double)(this.getChildren().size() - 1);
        }

        protected double computeMaxWidth(double h) {
            return this.computeMinWidth(h);
        }

        protected double computePrefWidth(double h) {
            return this.computeMinWidth(h);
        }
    }
}

