/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.CoordinateStringFormater;
import jfxtras.labs.map.MapControlable;
import jfxtras.labs.map.Mercator;
import jfxtras.labs.map.TilesMouseHandler;
import jfxtras.labs.map.ZoomButtonFactory;
import jfxtras.labs.map.ZoomInButtonFactory;
import jfxtras.labs.map.ZoomOutButtonFactory;
import jfxtras.labs.map.ZoomSliderFactory;
import jfxtras.labs.map.render.LicenseRenderer;
import jfxtras.labs.map.render.MapLineable;
import jfxtras.labs.map.render.MapMarkable;
import jfxtras.labs.map.render.MapOverlayable;
import jfxtras.labs.map.render.MapPolygonable;
import jfxtras.labs.map.render.TileRenderer;
import jfxtras.labs.map.tile.TileRepository;
import jfxtras.labs.map.tile.TileSource;
import jfxtras.labs.map.tile.ZoomBounds;

public final class MapPane
extends Pane
implements MapControlable {
    private static final double ZOOM_DIFF = 0.01;
    private static final int INITIAL_ZOOM = 9;
    private static final int SIZE = 400;
    private static final int START = 0;
    private static final String STYLE_LOC = "cursorLocation";
    private TileRenderer tileRenderer;
    private List<MapMarkable> mapMarkerList;
    private List<MapPolygonable> mapPolygonList;
    private List<MapLineable> mapLineList;
    private List<MapOverlayable> mapOverlayList;
    private Point center;
    private int zoom;
    private Slider zoomSlider;
    private Button zoomInButton;
    private Button zoomOutButton;
    private VBox zoomControlsVbox;
    private boolean ignoreRepaint;
    private Rectangle clipMask = new Rectangle();
    private Group tilesGroup;
    private Text cursorLocationText;
    private Point lastDragPoint = new Point();
    private SimpleIntegerProperty mapX;
    private SimpleIntegerProperty mapWidth;
    private SimpleIntegerProperty mapHeight;
    private SimpleIntegerProperty trailTime = new SimpleIntegerProperty(30);
    private SimpleBooleanProperty mapTrailsVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty mapRoutesVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty showZoomControls = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty mapMarkersVisible;
    private boolean cursorLocationVisible;
    private SimpleIntegerProperty mapY;
    private SimpleBooleanProperty mapVehiclesVisible = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty mapPolygonsVisible = new SimpleBooleanProperty(true);
    private CoordinateStringFormater formater;

    public MapPane(TileSource ts) {
        this(ts, 0, 0, 800, 600, 9);
    }

    public MapPane(TileSource tileSource, int x, int y, int width, int height, int zoom) {
        this.zoom = zoom;
        this.cursorLocationVisible = true;
        this.tilesGroup = new Group();
        TilesMouseHandler handler = new TilesMouseHandler(this);
        handler.setEventPublisher(this.tilesGroup);
        this.buildMapBounds(x, y);
        this.mapMarkersVisible = new SimpleBooleanProperty(true);
        TileRepository tileCache = new TileRepository(tileSource);
        this.tileRenderer = new TileRenderer(tileCache);
        this.mapMarkerList = new ArrayList<MapMarkable>();
        this.mapPolygonList = new ArrayList<MapPolygonable>();
        this.mapLineList = new ArrayList<MapLineable>();
        this.mapOverlayList = new ArrayList<MapOverlayable>();
        this.buildZoomControls();
        int tileSize = tileSource.getTileSize();
        this.setMinSize(tileSize, tileSize);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setDisplayPositionByLatLon(0.0, 0.0);
        DropShadow ds = new DropShadow();
        ds.setOffsetY(3.0);
        ds.setColor(Color.BLACK);
        this.cursorLocationText = new Text("");
        this.cursorLocationText.setId(STYLE_LOC);
        this.cursorLocationText.setEffect((Effect)ds);
        this.cursorLocationText.setFontSmoothingType(FontSmoothingType.LCD);
        this.clipMask.setFill((Paint)Color.WHITE);
        this.tilesGroup.setClip((Node)this.clipMask);
        this.getChildren().add((Object)this.tilesGroup);
        this.getChildren().add((Object)this.zoomControlsVbox);
        this.getChildren().add((Object)this.cursorLocationText);
        this.addResizeListeners();
        this.setPrefSize(width, height);
        this.setMinWidth(width);
        this.setMinHeight(height);
        this.formater = new CoordinateStringFormater();
    }

    private void addResizeListeners() {
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                MapPane.this.setMapWidth(newValue.doubleValue());
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                MapPane.this.setMapHeight(newValue.doubleValue());
            }
        });
    }

    private void buildMapBounds(int x, int y) {
        this.mapX = new SimpleIntegerProperty(x);
        this.mapX.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int val = newValue.intValue();
                MapPane.this.setLayoutX(val);
                MapPane.this.clipMask.setLayoutX((double)val);
            }
        });
        this.mapY = new SimpleIntegerProperty(y);
        this.mapY.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int val = newValue.intValue();
                MapPane.this.setLayoutY(val);
                MapPane.this.clipMask.setLayoutY((double)val);
            }
        });
        this.mapWidth = new SimpleIntegerProperty(400);
        this.mapWidth.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int val = newValue.intValue();
                MapPane.this.setMinWidth(val);
                MapPane.this.setMaxWidth(val);
                MapPane.this.setPrefWidth(val);
                MapPane.this.clipMask.setWidth((double)val);
                MapPane.this.adjustCursorLocationText();
                MapPane.this.renderControl();
            }
        });
        this.mapHeight = new SimpleIntegerProperty(400);
        this.mapHeight.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int val = newValue.intValue();
                MapPane.this.setMinHeight(val);
                MapPane.this.setMaxHeight(val);
                MapPane.this.setPrefHeight(val);
                MapPane.this.clipMask.setHeight((double)val);
                MapPane.this.adjustCursorLocationText();
                MapPane.this.renderControl();
            }
        });
    }

    @Override
    public void setCursorLocationText(double x, double y) {
        if (this.cursorLocationVisible) {
            Coordinate coord = this.getCoordinate((int)x, (int)y);
            this.cursorLocationText.setText(this.formater.format(coord));
        }
    }

    @Override
    public void adjustCursorLocationText() {
        double strwidth = this.cursorLocationText.getBoundsInParent().getWidth();
        double x = (double)(this.getMapWidth() / 2) - strwidth / 2.0;
        int y = this.getMapHeight() - 28;
        this.cursorLocationText.setLayoutX(x);
        this.cursorLocationText.setLayoutY((double)y);
    }

    protected void buildZoomControls() {
        this.ignoreRepaint = true;
        ZoomSliderFactory zoomSliderFactory = new ZoomSliderFactory(this);
        this.zoomSlider = zoomSliderFactory.create();
        ZoomButtonFactory zoomButtonFactory = new ZoomInButtonFactory(this);
        this.zoomInButton = zoomButtonFactory.create();
        zoomButtonFactory = new ZoomOutButtonFactory(this);
        this.zoomOutButton = zoomButtonFactory.create();
        this.zoomControlsVbox = new VBox();
        this.zoomControlsVbox.getChildren().add((Object)this.zoomInButton);
        this.zoomControlsVbox.getChildren().add((Object)this.zoomSlider);
        this.zoomControlsVbox.getChildren().add((Object)this.zoomOutButton);
        this.zoomControlsVbox.setLayoutX((double)(-this.mapX.get() + 10));
        this.zoomControlsVbox.setLayoutY((double)(-this.mapY.get() + 20));
        this.ignoreRepaint = false;
    }

    public void setMapBounds(int x, int y, int width, int height) {
        this.mapX.set(x);
        this.mapY.set(y);
        this.mapWidth.set(width);
        this.mapHeight.set(height);
    }

    public void setDisplayPositionByLatLon(double lat, double lon) {
        this.setDisplayPositionByLatLon(lat, lon, this.zoom);
    }

    public void setDisplayPositionByLatLon(double lat, double lon, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getMapWidth() / 2, this.getMapHeight() / 2), lat, lon, zoom);
    }

    public void setDisplayPositionByLatLon(Point mapPoint, double lat, double lon, int zoom) {
        int x = Mercator.lonToX(lon, zoom);
        int y = Mercator.latToY(lat, zoom);
        this.setDisplayPosition(mapPoint, x, y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point(this.getMapWidth() / 2, this.getMapHeight() / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.getTileSource().getMaxZoom() || zoom < this.getTileSource().getMinZoom()) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + this.getMapWidth() / 2;
        p.y = y - mapPoint.y + this.getMapHeight() / 2;
        this.center = p;
        this.ignoreRepaint = true;
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.zoomChanged(oldZoom);
            }
            if (Math.abs(this.zoomSlider.getValue() - (double)zoom) > 0.01) {
                this.zoomSlider.setValue((double)zoom);
            }
        }
        finally {
            this.ignoreRepaint = false;
            this.renderControl();
        }
    }

    public void setDisplayToFitMapMarkers() {
        if (this.mapMarkerList != null && !this.mapMarkerList.isEmpty()) {
            int y;
            int x_min = Integer.MAX_VALUE;
            int y_min = Integer.MAX_VALUE;
            int x_max = Integer.MIN_VALUE;
            int y_max = Integer.MIN_VALUE;
            int mapZoomMax = this.getTileSource().getMaxZoom();
            for (MapMarkable marker : this.mapMarkerList) {
                int x = Mercator.lonToX(marker.getLon(), mapZoomMax);
                int y2 = Mercator.latToY(marker.getLat(), mapZoomMax);
                x_max = Math.max(x_max, x);
                y_max = Math.max(y_max, y2);
                x_min = Math.min(x_min, x);
                y_min = Math.min(y_min, y2);
            }
            int height = Math.max(0, this.getMapHeight());
            int width = Math.max(0, this.getMapWidth());
            int newZoom = mapZoomMax;
            int x = x_max - x_min;
            for (y = y_max - y_min; x > width || y > height; x >>= 1, y >>= 1) {
                --newZoom;
            }
            x = x_min + (x_max - x_min) / 2;
            y = y_min + (y_max - y_min) / 2;
            int z = 1 << mapZoomMax - newZoom;
            this.setDisplayPosition(x /= z, y /= z, newZoom);
        }
    }

    public void setDisplayToFitMapRectangle() {
        if (this.mapPolygonList != null && !this.mapPolygonList.isEmpty()) {
            int y;
            int x_min = Integer.MAX_VALUE;
            int y_min = Integer.MAX_VALUE;
            int x_max = Integer.MIN_VALUE;
            int y_max = Integer.MIN_VALUE;
            int mapZoomMax = this.getTileSource().getMaxZoom();
            int height = Math.max(0, this.getMapHeight());
            int width = Math.max(0, this.getMapWidth());
            int newZoom = mapZoomMax;
            int x = x_max - x_min;
            for (y = y_max - y_min; x > width || y > height; x >>= 1, y >>= 1) {
                --newZoom;
            }
            x = x_min + (x_max - x_min) / 2;
            y = y_min + (y_max - y_min) / 2;
            int z = 1 << mapZoomMax - newZoom;
            this.setDisplayPosition(x /= z, y /= z, newZoom);
        }
    }

    public Coordinate getCenterCoordinate() {
        double lon = Mercator.xToLon(this.center.x, this.zoom);
        double lat = Mercator.yToLat(this.center.y, this.zoom);
        return new Coordinate(lat, lon);
    }

    public Coordinate getCoordinate(Point mapPoint) {
        return this.getCoordinate(mapPoint.x, mapPoint.y);
    }

    @Override
    public Coordinate getCoordinate(int mapPointX, int mapPointY) {
        int x = this.center.x + mapPointX - this.getMapWidth() / 2;
        int y = this.center.y + mapPointY - this.getMapHeight() / 2;
        double lon = Mercator.xToLon(x, this.zoom);
        double lat = Mercator.yToLat(y, this.zoom);
        return new Coordinate(lat, lon);
    }

    @Override
    public Point getMapPoint(double lat, double lon, boolean checkOutside) {
        int x = Mercator.lonToX(lon, this.zoom);
        int y = Mercator.latToY(lat, this.zoom);
        if (checkOutside && ((x -= this.center.x - this.getMapWidth() / 2) < 0 || (y -= this.center.y - this.getMapHeight() / 2) < 0 || x > this.getMapWidth() || y > this.getMapHeight())) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    public Point getMapPoint(Coordinate coord) {
        return this.getMapPoint(coord.getLatitude(), coord.getLongitude(), false);
    }

    @Override
    public void moveMap(int x, int y) {
        this.center.x += x;
        this.center.y += y;
        this.renderControl();
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    @Override
    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    @Override
    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    @Override
    public void zoomOut(Point mapPoint) {
        this.setZoom(this.zoom - 1, mapPoint);
    }

    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.getTileSource().getMaxZoom() || zoom < this.getTileSource().getMinZoom() || zoom == this.zoom) {
            return;
        }
        Coordinate zoomPos = this.getCoordinate(mapPoint);
        this.setDisplayPositionByLatLon(mapPoint, zoomPos.getLatitude(), zoomPos.getLongitude(), zoom);
    }

    @Override
    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point(this.getMapWidth() / 2, this.getMapHeight() / 2));
    }

    protected void zoomChanged(int oldZoom) {
        this.zoomSlider.setTooltip(new Tooltip("Zoom level " + this.zoom));
        this.zoomInButton.setTooltip(new Tooltip("Zoom to level " + (this.zoom + 1)));
        this.zoomOutButton.setTooltip(new Tooltip("Zoom to level " + (this.zoom - 1)));
        this.zoomOutButton.setDisable(this.zoom <= this.getTileSource().getMinZoom());
        this.zoomInButton.setDisable(this.zoom >= this.getTileSource().getMaxZoom());
    }

    public void setMapMarkerVisible(boolean mapMarkersVisible) {
        this.mapMarkersVisible.set(mapMarkersVisible);
        this.renderControl();
    }

    public void setMapMarkerList(List<MapMarkable> mapMarkerList) {
        this.mapMarkerList = mapMarkerList;
        this.renderControl();
    }

    public List<MapMarkable> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void removeMapOverlay(MapOverlayable overlay) {
        this.mapOverlayList.remove(overlay);
        this.renderControl();
    }

    public void addMapOverlay(MapOverlayable overlay) {
        this.mapOverlayList.add(overlay);
        this.renderControl();
    }

    public void setMapPolygonList(List<MapPolygonable> mapPolygonList) {
        this.mapPolygonList = mapPolygonList;
        this.renderControl();
    }

    public List<MapPolygonable> getMapRectangleList() {
        return this.mapPolygonList;
    }

    public void addMapLine(MapLineable line) {
        this.mapLineList.add(line);
        this.renderControl();
    }

    public void removeMapMarker(MapLineable line) {
        this.mapLineList.remove(line);
        this.renderControl();
    }

    public void addMapMarker(MapMarkable marker) {
        this.mapMarkerList.add(marker);
        this.renderControl();
    }

    public void removeMapMarker(MapMarkable marker) {
        this.mapMarkerList.remove(marker);
        this.renderControl();
    }

    public void addMapPolygon(MapPolygonable polygon) {
        this.mapPolygonList.add(polygon);
        this.renderControl();
    }

    public void removeMapPolygon(MapPolygonable polygon) {
        this.mapPolygonList.remove(polygon);
        this.renderControl();
    }

    public void setZoomContolsVisible(boolean visible) {
        this.zoomSlider.setVisible(visible);
        this.zoomInButton.setVisible(visible);
        this.zoomOutButton.setVisible(visible);
        this.zoomControlsVbox.setVisible(visible);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        int minZoom = tileSource.getMinZoom();
        int maxZoom = tileSource.getMaxZoom();
        if (maxZoom > ZoomBounds.MAX.getValue()) {
            throw new IllegalArgumentException("Maximum zoom level too high");
        }
        if (minZoom < ZoomBounds.Min.getValue()) {
            throw new IllegalArgumentException("Minumim zoom level too low");
        }
        this.tileRenderer.setTileSource(tileSource);
        this.zoomSlider.setMin((double)tileSource.getMinZoom());
        this.zoomSlider.setMax((double)tileSource.getMaxZoom());
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.renderControl();
    }

    protected void renderControl() {
        boolean changed = this.renderMap();
        if (changed) {
            this.setZoomContolsVisible(this.showZoomControls.get());
            this.renderOverlays();
            this.renderPolygons();
            this.renderMarkers();
            this.renderAttribution();
        }
    }

    protected boolean renderMap() {
        return this.tileRenderer.render(this);
    }

    protected void renderOverlays() {
        for (MapOverlayable overlay : this.mapOverlayList) {
            overlay.render(this);
        }
    }

    protected void renderPolygons() {
        if (this.mapPolygonsVisible.get() && this.mapPolygonList != null) {
            for (MapPolygonable polygon : this.mapPolygonList) {
                polygon.render(this);
            }
        }
    }

    protected void renderMarkers() {
        if (this.mapMarkersVisible.get() && this.mapMarkerList != null) {
            for (MapMarkable marker : this.mapMarkerList) {
                marker.render(this);
            }
            for (MapLineable line : this.mapLineList) {
                line.render(this);
            }
        }
    }

    protected void renderAttribution() {
        if (this.getTileSource().isAttributionRequired()) {
            LicenseRenderer renderer = new LicenseRenderer();
            renderer.render(this);
        }
    }

    @Override
    public Point getLastDragPoint() {
        return this.lastDragPoint;
    }

    @Override
    public void setLastDragPoint(Point point) {
        this.lastDragPoint = point;
    }

    public void setMapX(int val) {
        this.mapX.set(val);
    }

    @Override
    public int getMapX() {
        return this.mapX.get();
    }

    public void setMapY(int val) {
        this.mapY.set(val);
    }

    @Override
    public int getMapY() {
        return this.mapY.get();
    }

    public void setMapWidth(double val) {
        this.mapWidth.set((int)val);
    }

    @Override
    public int getMapWidth() {
        return this.mapWidth.get();
    }

    public void setMapHeight(double val) {
        this.mapHeight.set((int)val);
    }

    @Override
    public int getMapHeight() {
        return this.mapHeight.get();
    }

    public void setTrailTime(int val) {
        this.trailTime.set(val);
    }

    public void setMapVehiclesVisible(boolean val) {
        this.mapVehiclesVisible.set(val);
        this.renderControl();
    }

    public boolean isMapVehiclesVisible() {
        return this.mapVehiclesVisible.get();
    }

    public void setMapPolygonsVisible(boolean val) {
        this.mapPolygonsVisible.set(val);
        this.renderControl();
    }

    public boolean isMapPolygonsVisible() {
        return this.mapPolygonsVisible.get();
    }

    public void setMapRoutesVisible(boolean val) {
        this.mapRoutesVisible.set(val);
        this.renderControl();
    }

    public boolean isMapRoutesVisible() {
        return this.mapRoutesVisible.get();
    }

    public void setShowZoomControls(boolean val) {
        this.showZoomControls.set(val);
        this.renderControl();
    }

    public boolean isShowZoomControls() {
        return this.showZoomControls.get();
    }

    public void setMapTrailsVisible(boolean val) {
        this.mapTrailsVisible.set(val);
        this.renderControl();
    }

    public boolean isMapTrailsVisible() {
        return this.mapTrailsVisible.get();
    }

    public void setMonochromeMode(boolean val) {
        this.tileRenderer.setMonoChrome(val);
        this.renderControl();
    }

    public void setTileGridVisible(boolean val) {
        this.tileRenderer.setTileGridVisible(val);
        this.renderControl();
    }

    @Override
    public void setCursorLocationVisible(boolean val) {
        this.cursorLocationVisible = val;
    }

    @Override
    public TileSource getTileSource() {
        return this.tileRenderer.getTileSource();
    }

    @Override
    public boolean isIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    @Override
    public Group getTilesGroup() {
        return this.tilesGroup;
    }

    @Override
    public Point getCenter() {
        return this.center;
    }
}

