/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import jfxtras.labs.map.MapControlable;

public class ZoomSliderFactory {
    private MapControlable controlable;

    public ZoomSliderFactory(MapControlable controlable) {
        this.controlable = controlable;
    }

    protected Slider create() {
        Slider slider = new Slider();
        slider.setOrientation(Orientation.VERTICAL);
        slider.setShowTickLabels(true);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(1.0);
        int minZoom = this.controlable.getTileSource().getMinZoom();
        slider.setValue((double)minZoom);
        slider.setMin((double)minZoom);
        slider.setMax((double)this.controlable.getTileSource().getMaxZoom());
        slider.setPrefSize(30.0, 150.0);
        slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                ZoomSliderFactory.this.controlable.setZoom(new_val.intValue());
            }
        });
        return slider;
    }
}

