/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import jfxtras.labs.map.render.AbstractMapMarker;

public class ImageMapMarker
extends AbstractMapMarker {
    private double rotate;
    private ImageView imageView;

    public ImageMapMarker(Image img, double lat, double lon) {
        this(img, lat, lon, 0.0);
    }

    public ImageMapMarker(Image img, double lat, double lon, double rotate) {
        super(lat, lon);
        this.rotate = rotate;
        this.imageView = new ImageView(img);
        Light.Distant light = new Light.Distant();
        light.setAzimuth(-135.0);
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        lighting.setSurfaceScale(5.0);
        Color color = Color.rgb((int)0, (int)0, (int)0, (double)0.7);
        DropShadow dropShadow = this.createShadow(color);
        dropShadow.setInput((Effect)lighting);
        this.imageView.setEffect((Effect)dropShadow);
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double val) {
        this.rotate = val;
    }

    @Override
    List<? extends Node> createChildren(Point position) {
        int size_w = (int)this.imageView.getImage().getWidth();
        int size_h = (int)this.imageView.getImage().getHeight();
        this.imageView.setTranslateX((double)(position.x - size_w / 2));
        this.imageView.setTranslateY((double)(position.y - size_h / 2));
        this.imageView.setRotate(this.rotate);
        return Collections.singletonList(this.imageView);
    }

    @Override
    public Node getNode() {
        return this.imageView;
    }
}

