/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.MapControlable;
import jfxtras.labs.map.render.Renderable;
import jfxtras.labs.map.tile.TileSource;

public class LicenseRenderer
implements Renderable {
    private static final String STYLE_RIGHTS = "copyRight";
    public static final String STYLE_TERMS = "termsOfUse";

    @Override
    public void render(MapControlable mapController) {
        String termsOfUse;
        Image attrImage;
        TileSource tileSource = mapController.getTileSource();
        Group tilesGroup = mapController.getTilesGroup();
        int x = mapController.getMapX();
        int y = mapController.getMapY();
        int width = mapController.getMapWidth();
        int height = mapController.getMapHeight();
        int yText = height - 8;
        Coordinate topLeft = mapController.getCoordinate(x, y);
        Coordinate bottomRight = mapController.getCoordinate(width, height);
        String attrTxt = tileSource.getAttributionText(mapController.getZoom(), topLeft, bottomRight);
        if (attrTxt != null) {
            Text attrText = this.createLicenseText(attrTxt);
            attrText.setId(STYLE_RIGHTS);
            double strwidth = attrText.getBoundsInParent().getWidth();
            attrText.setLayoutX((double)width - strwidth);
            attrText.setLayoutY((double)yText);
            tilesGroup.getChildren().add((Object)attrText);
        }
        if ((attrImage = tileSource.getAttributionImage()) != null) {
            ImageView attImgView = new ImageView(attrImage);
            DropShadow ds = new DropShadow();
            ds.setOffsetY(3.0);
            ds.setColor(Color.BLACK);
            attImgView.setEffect((Effect)ds);
            attImgView.setLayoutX(8.0);
            attImgView.setLayoutY((double)yText - (attrImage.getHeight() + 15.0));
            tilesGroup.getChildren().add((Object)attImgView);
        }
        if ((termsOfUse = tileSource.getTermsOfUseURL()) != null) {
            Text termsText = this.createLicenseText("Terms Of Use");
            termsText.setUnderline(true);
            termsText.setId(STYLE_TERMS);
            termsText.setLayoutX(8.0);
            termsText.setLayoutY((double)yText);
            termsText.setOnMouseEntered((EventHandler)new MouseEnteredAdapter(termsText));
            termsText.setOnMouseClicked((EventHandler)new MouseClickedAdapter(termsOfUse));
            tilesGroup.getChildren().add((Object)termsText);
        }
    }

    private Text createLicenseText(String attrTxt) {
        Text txt = new Text(attrTxt);
        DropShadow ds = new DropShadow();
        ds.setOffsetY(3.0);
        ds.setColor(Color.BLACK);
        txt.setEffect((Effect)ds);
        txt.setFontSmoothingType(FontSmoothingType.LCD);
        txt.setFill((Paint)Color.WHITE);
        return txt;
    }

    private class MouseEnteredAdapter
    implements EventHandler<MouseEvent> {
        private Text text;

        MouseEnteredAdapter(Text text) {
            this.text = text;
        }

        public void handle(MouseEvent t) {
            this.text.setCursor(Cursor.HAND);
        }
    }

    private class MouseClickedAdapter
    implements EventHandler<MouseEvent> {
        private String url;

        MouseClickedAdapter(String termsOfUse) {
            this.url = termsOfUse;
        }

        public void handle(MouseEvent me) {
            try {
                URI u = new URI(this.url);
                Desktop.getDesktop().browse(u);
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

