/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.RadialGradientBuilder;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;
import jfxtras.labs.map.render.AbstractMapMarker;

public class SimpleMapMarker
extends AbstractMapMarker {
    private Circle sphere;
    private int radius;

    public SimpleMapMarker(double lat, double lon) {
        this(10, Color.YELLOW, lat, lon);
    }

    public SimpleMapMarker(int radius, Color color, double lat, double lon) {
        super(lat, lon);
        this.radius = radius;
        this.sphere = ((CircleBuilder)CircleBuilder.create().centerX((double)radius).centerY((double)radius).radius((double)radius).cache(true)).build();
        RadialGradient rgrad = RadialGradientBuilder.create().centerX(this.sphere.getCenterX() - this.sphere.getRadius() / 3.0).centerY(this.sphere.getCenterY() - this.sphere.getRadius() / 3.0).radius(this.sphere.getRadius()).proportional(false).stops(new Stop[]{new Stop(0.0, color), new Stop(1.0, Color.BLACK)}).build();
        this.sphere.setFill((Paint)rgrad);
        this.sphere.setEffect((Effect)this.createShadow(Color.rgb((int)50, (int)50, (int)50, (double)0.7)));
    }

    @Override
    List<? extends Node> createChildren(Point position) {
        this.sphere.setTranslateX((double)(position.x - this.radius));
        this.sphere.setTranslateY((double)(position.y - this.radius));
        return Collections.singletonList(this.sphere);
    }

    @Override
    public Node getNode() {
        return this.sphere;
    }
}

