/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import jfxtras.labs.map.MapControlable;
import jfxtras.labs.map.render.MapRenderable;
import jfxtras.labs.map.tile.Tile;
import jfxtras.labs.map.tile.TileCacheable;
import jfxtras.labs.map.tile.TileSource;

public class TileRenderer
implements MapRenderable {
    private static final Point[] movePoints = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    private static final int START = 0;
    private final TileCacheable tileCache;
    private boolean monoChrome;
    private boolean tileGridVisible;

    public TileRenderer(TileCacheable tileCache) {
        this.tileCache = tileCache;
    }

    @Override
    public boolean render(MapControlable mapController) {
        boolean changed = false;
        List<TileImage> tileImages = this.loadTiles(mapController);
        if (!tileImages.isEmpty()) {
            this.renderTileImages(mapController, tileImages);
            changed = true;
        }
        return changed;
    }

    private List<TileImage> loadTiles(MapControlable mapController) {
        boolean start_top;
        ArrayList<TileImage> tileImages = new ArrayList<TileImage>();
        TileSource tileSource = this.tileCache.getTileSource();
        int tilesize = tileSource.getTileSize();
        Point center = mapController.getCenter();
        int diff_left = center.x % tilesize;
        int diff_right = tilesize - diff_left;
        int diff_top = center.y % tilesize;
        int diff_bottom = tilesize - diff_top;
        boolean start_left = diff_left < diff_right;
        boolean bl = start_top = diff_top < diff_bottom;
        int iMove = start_top ? (start_left ? 2 : 3) : (start_left ? 1 : 0);
        int zoom = mapController.getZoom();
        int x_max = mapController.getMapWidth();
        int y_max = mapController.getMapHeight();
        int x_min = -tilesize;
        int y_min = -tilesize;
        int posx = x_max / 2 - diff_left;
        int posy = y_max / 2 - diff_top;
        int tilex = center.x / tilesize;
        int tiley = center.y / tilesize;
        boolean added = true;
        int x = 0;
        while (added) {
            added = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    Tile tile;
                    if (x_min <= posx && posx <= x_max && y_min <= posy && posy <= y_max && (tile = this.tileCache.getTile(tilex, tiley, zoom)) != null) {
                        added = true;
                        TileImage tileImage = new TileImage(tile.getImageView(), posx, posy);
                        tileImages.add(tileImage);
                    }
                    Point next = movePoints[iMove];
                    posx += next.x * tilesize;
                    posy += next.y * tilesize;
                    tilex += next.x;
                    tiley += next.y;
                }
                iMove = (iMove + 1) % movePoints.length;
            }
        }
        return tileImages;
    }

    private void renderTileImages(MapControlable mapController, List<TileImage> tileImages) {
        int tilesize = this.tileCache.getTileSource().getTileSize();
        Group tilesGroup = mapController.getTilesGroup();
        tilesGroup.getChildren().clear();
        for (TileImage tileImage : tileImages) {
            ImageView imageView = tileImage.getImageView();
            int posx = tileImage.getPosX();
            int posy = tileImage.getPosY();
            imageView.translateXProperty().set((double)posx);
            imageView.translateYProperty().set((double)posy);
            if (this.monoChrome) {
                this.setMonochromeEffect(imageView);
            }
            if (this.tileGridVisible) {
                tilesGroup.getChildren().add((Object)this.createGrid(posx, posy, tilesize));
            }
            tilesGroup.getChildren().add((Object)imageView);
        }
    }

    private void setMonochromeEffect(ImageView imageView) {
        ColorAdjust monochrome = new ColorAdjust();
        monochrome.setSaturation(-1.0);
        monochrome.setContrast(-0.3);
        monochrome.setBrightness(-0.3);
        imageView.setEffect((Effect)monochrome);
    }

    protected Path createGrid(int posx, int posy, int tilesize) {
        Path path = new Path();
        path.getElements().add((Object)new MoveTo((double)posx, (double)posy));
        path.getElements().add((Object)new LineTo((double)(posx + tilesize), (double)posy));
        path.getElements().add((Object)new LineTo((double)(posx + tilesize), (double)(posy + tilesize)));
        path.getElements().add((Object)new LineTo((double)posx, (double)(posy + tilesize)));
        path.getElements().add((Object)new LineTo((double)posx, (double)posy));
        path.setStrokeWidth(1.0);
        path.setStroke((Paint)Color.BLACK);
        return path;
    }

    public void setTileSource(TileSource tileSource) {
        this.tileCache.setTileSource(tileSource);
    }

    public TileSource getTileSource() {
        return this.tileCache.getTileSource();
    }

    public void setMonoChrome(boolean monoChrome) {
        this.monoChrome = monoChrome;
    }

    public void setTileGridVisible(boolean tileGridVisible) {
        this.tileGridVisible = tileGridVisible;
    }

    private class TileImage {
        private ImageView imageView;
        private int posX;
        private int posY;

        TileImage(ImageView imageView, int posX, int posY) {
            this.imageView = imageView;
            this.posX = posX;
            this.posY = posY;
        }

        ImageView getImageView() {
            return this.imageView;
        }

        int getPosX() {
            return this.posX;
        }

        int getPosY() {
            return this.posY;
        }
    }
}

