/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import jfxtras.labs.map.tile.AbstractTilePathBuilder;

public class BingTilePathBuilder
extends AbstractTilePathBuilder {
    private String tilePath;

    public BingTilePathBuilder() {
        this.setTileType("jpeg");
    }

    @Override
    public String buildPath(int zoom, int tilex, int tiley) {
        String quadtree = this.computeQuadTree(zoom, tilex, tiley);
        StringBuilder builder = new StringBuilder();
        builder.append(this.tilePath).append(quadtree).append(".").append(this.getTileType()).append("?g=587");
        return builder.toString();
    }

    private String computeQuadTree(int zoom, int tilex, int tiley) {
        StringBuilder k = new StringBuilder();
        for (int i = zoom; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tilex & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tiley & mask) != 0) {
                digit = (char)(digit + 2);
            }
            k.append(digit);
        }
        return k.toString();
    }

    public void setTilePath(String tilePath) {
        this.tilePath = tilePath;
    }
}

