/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;
import jfxtras.labs.map.tile.ApiKeyTileSourceFactory;
import jfxtras.labs.map.tile.BingTilePathBuilder;
import jfxtras.labs.map.tile.BingTileSource;
import jfxtras.labs.map.tile.BingType;
import jfxtras.labs.map.tile.TileSource;
import jfxtras.labs.map.tile.attribution.Attribution;
import jfxtras.labs.map.tile.attribution.BingAttributionLoader;
import jfxtras.labs.map.tile.attribution.BingImageMetaDataHandler;
import jfxtras.labs.map.tile.attribution.BingMapMetaDataHandler;
import jfxtras.labs.map.tile.attribution.BingMetaDataHandler;

public class BingTileSourceFactory
extends ApiKeyTileSourceFactory<BingType> {
    private Map<BingType, List<Attribution>> attrMap = new HashMap<BingType, List<Attribution>>();
    private static final int ZOOM = 19;
    private static final String TILE_URL = "http://ecn.t2.tiles.virtualearth.net/tiles/";

    public BingTileSourceFactory(String apiKey) {
        super(apiKey);
    }

    @Override
    public TileSource create() {
        return this.create(BingType.Map);
    }

    @Override
    public TileSource create(BingType type) {
        BingTileSource tileSource;
        BingTilePathBuilder tilePathBuilder = new BingTilePathBuilder();
        List<Attribution> attributions = this.getAttributions(type);
        if (BingType.Aerial.equals((Object)type)) {
            tileSource = new BingTileSource("Bing Aerial Maps", TILE_URL);
            tilePathBuilder.setTilePath("tiles/a");
        } else {
            tileSource = new BingTileSource("Bing Maps", TILE_URL);
            tilePathBuilder.setTilePath("tiles/r");
        }
        tileSource.setTilePathBuilder(tilePathBuilder);
        tileSource.setAttributions(attributions);
        tileSource.setApiKey(this.getApiKey());
        tileSource.setMaxZoom(19);
        tileSource.setTermsOfUserURL("http://opengeodata.org/microsoft-imagery-details");
        Image image = new Image(this.getClass().getResourceAsStream("bing_maps.png"));
        tileSource.setAttributionImage(image);
        tileSource.setAttributionLinkURL("http://go.microsoft.com/?linkid=9710837");
        tileSource.setAttributionRequired(true);
        return tileSource;
    }

    private List<Attribution> getAttributions(BingType type) {
        List<Attribution> attr = this.attrMap.get((Object)type);
        if (attr == null) {
            attr = this.loadAttributions(type);
            this.attrMap.put(type, attr);
        }
        return attr;
    }

    private List<Attribution> loadAttributions(BingType type) {
        BingMetaDataHandler handler = BingType.Aerial.equals((Object)type) ? new BingImageMetaDataHandler(this.getApiKey()) : new BingMapMetaDataHandler(this.getApiKey());
        BingAttributionLoader loader = new BingAttributionLoader(handler);
        return loader.load();
    }
}

