/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import java.io.File;
import javafx.animation.AnimationTimer;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class Tile {
    private static volatile Image delayImage;
    private static volatile Image errorImage;
    private static final String HTTP = "http:";
    private static final double COMPLETE = 1.0;
    private static final int DIM = 256;
    private ImageView imageView = new ImageView();
    private String tileLocation;
    private SimpleBooleanProperty imageLoadedProperty;

    public Tile(String tileLocation, Image image) {
        this(tileLocation);
        this.imageView.setImage(image);
    }

    public Tile(String tileLocation) {
        this.tileLocation = tileLocation;
        this.imageLoadedProperty = new SimpleBooleanProperty();
    }

    public void loadImage() {
        this.imageLoadedProperty.set(false);
        if (this.tileLocation.startsWith(HTTP)) {
            this.loadFromHttp();
        } else {
            this.loadFromFile();
        }
    }

    private void loadFromHttp() {
        this.imageView.setImage(this.getDelayImage());
        this.imageView.setFitWidth(256.0);
        this.imageView.setFitHeight(256.0);
        final Image img = new Image(this.tileLocation, true);
        final AnimationTimer timer = new AnimationTimer(){

            public void handle(long l) {
                Tile.this.rotateImageView();
            }
        };
        timer.start();
        img.progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number old_val, Number new_val) {
                if (new_val.doubleValue() == 1.0) {
                    timer.stop();
                    Tile.this.resetImageView();
                    Tile.this.setLoadedImage(img);
                }
            }
        });
    }

    private void loadFromFile() {
        File file = new File(this.tileLocation);
        if (file.exists()) {
            Image image = new Image(file.toURI().toString());
            this.setLoadedImage(image);
        } else {
            this.imageView.setImage(this.getErrorImage());
        }
    }

    private Image getDelayImage() {
        if (delayImage == null) {
            delayImage = new Image(this.getClass().getResourceAsStream("wait_tile.png"));
        }
        return delayImage;
    }

    private Image getErrorImage() {
        if (errorImage == null) {
            errorImage = new Image(this.getClass().getResourceAsStream("error.png"));
        }
        return errorImage;
    }

    private void rotateImageView() {
        double angle = this.imageView.getRotate();
        this.imageView.setRotate(angle += 1.0);
    }

    private void resetImageView() {
        this.imageView.setRotate(0.0);
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public SimpleBooleanProperty imageLoadedProperty() {
        return this.imageLoadedProperty;
    }

    private void setLoadedImage(Image image) {
        this.imageView.setImage(image);
        this.imageLoadedProperty.set(true);
    }
}

