/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile.attribution;

import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.tile.attribution.Attribution;

public class AttributtionStringBuilder {
    private StringBuilder builder = new StringBuilder();
    private int zoom;
    private Coordinate topLeft;
    private Coordinate bottomRight;

    public AttributtionStringBuilder(int zoom, Coordinate topLeft, Coordinate bottomRight) {
        this.zoom = zoom;
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public void append(Attribution attr) {
        if (attr.getMaxZoom() == Integer.MAX_VALUE) {
            this.appendText(attr);
        } else if (this.zoom <= attr.getMaxZoom() && this.zoom >= attr.getMinZoom() && this.isMaxLongitudeGreater(attr) && this.isMinLongitudeSmaller(attr) && this.isMinLatitudeSmaller(attr) && this.isMaxLatitudeGreater(attr)) {
            this.appendText(attr);
        }
    }

    private boolean isMaxLongitudeGreater(Attribution attr) {
        return this.topLeft.getLongitude() < attr.getMax().getLongitude();
    }

    private boolean isMinLongitudeSmaller(Attribution attr) {
        return this.bottomRight.getLongitude() > attr.getMin().getLongitude();
    }

    private boolean isMinLatitudeSmaller(Attribution attr) {
        return this.topLeft.getLatitude() > attr.getMin().getLatitude();
    }

    private boolean isMaxLatitudeGreater(Attribution attr) {
        return this.bottomRight.getLatitude() < attr.getMax().getLatitude();
    }

    public String toString() {
        return this.builder.toString();
    }

    private void appendText(Attribution attr) {
        this.builder.append(attr.getText()).append(" ");
    }
}

