/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile.attribution;

import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.tile.attribution.Attribution;
import jfxtras.labs.map.tile.attribution.BingMetaDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BingImageMetaDataHandler
extends BingMetaDataHandler {
    private static final String METADATA = "http://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial/0,0?zl=1&mapVersion=v1&include=ImageryProviders&output=xml";
    private double southLat;
    private double northLat;
    private double eastLon;
    private double westLon;
    private boolean inCoverage = false;

    public BingImageMetaDataHandler(String apiKey) {
        super(apiKey);
    }

    @Override
    public void startElement(String uri, String stripped, String tagName, Attributes attrs) throws SAXException {
        switch (tagName) {
            case "ImageryProvider": {
                this.attribution = new Attribution();
                break;
            }
            case "CoverageArea": {
                this.inCoverage = true;
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String stripped, String tagName) throws SAXException {
        if ("ImageryProvider".equals(tagName)) {
            this.attributions.add(this.attribution);
        } else if ("Attribution".equals(tagName)) {
            this.attribution.setText(this.text);
        } else if (this.inCoverage && "ZoomMin".equals(tagName)) {
            this.attribution.setMinZoom(Integer.parseInt(this.text));
        } else if (this.inCoverage && "ZoomMax".equals(tagName)) {
            this.attribution.setMaxZoom(Integer.parseInt(this.text));
        } else if (this.inCoverage && "SouthLatitude".equals(tagName)) {
            this.southLat = Double.parseDouble(this.text);
        } else if (this.inCoverage && "NorthLatitude".equals(tagName)) {
            this.northLat = Double.parseDouble(this.text);
        } else if (this.inCoverage && "EastLongitude".equals(tagName)) {
            this.eastLon = Double.parseDouble(this.text);
        } else if (this.inCoverage && "WestLongitude".equals(tagName)) {
            this.westLon = Double.parseDouble(this.text);
        } else if ("BoundingBox".equals(tagName)) {
            this.attribution.setMin(new Coordinate(this.southLat, this.westLon));
            this.attribution.setMax(new Coordinate(this.northLat, this.eastLon));
        } else if ("CoverageArea".equals(tagName)) {
            this.inCoverage = false;
        }
        this.text = "";
    }

    @Override
    public String getMetaData(String key) {
        return METADATA + key;
    }
}

