/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.util.Callback;

public class Agenda
extends Control {
    private final ObservableList<Appointment> appointments = FXCollections.observableArrayList();
    private final ObservableList<AppointmentGroup> appointmentGroups = FXCollections.observableArrayList();
    private final ObjectProperty<Locale> iLocaleObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final ObjectProperty<Calendar> displayedCalendarObjectProperty = new SimpleObjectProperty<Calendar>((Object)this, "displayedCalendar", Calendar.getInstance()){

        public void set(Calendar value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed");
            }
            super.set((Object)value);
        }
    };
    private final ObservableList<Appointment> selectedAppointments = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "calendarRangeCallback", null);
    private final ObjectProperty<Callback<CalendarRange, Appointment>> createAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "createAppointmentCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "editAppointmentCallback", null);

    public Agenda() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.constructAppointments();
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    public ObservableList<Appointment> appointments() {
        return this.appointments;
    }

    private void constructAppointments() {
        this.appointments.addListener((ListChangeListener)new ListChangeListener<Appointment>(){

            public void onChanged(ListChangeListener.Change<? extends Appointment> changes) {
                while (changes.next()) {
                    for (Appointment lAppointment : changes.getRemoved()) {
                        Agenda.this.selectedAppointments.remove((Object)lAppointment);
                    }
                }
            }
        });
    }

    public ObservableList<AppointmentGroup> appointmentGroups() {
        return this.appointmentGroups;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.iLocaleObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.iLocaleObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.iLocaleObjectProperty.setValue((Object)value);
    }

    public Agenda withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<Calendar> displayedCalendar() {
        return this.displayedCalendarObjectProperty;
    }

    public Calendar getDisplayedCalendar() {
        return (Calendar)this.displayedCalendarObjectProperty.getValue();
    }

    public void setDisplayedCalendar(Calendar value) {
        this.displayedCalendarObjectProperty.setValue((Object)value);
    }

    public Agenda withDisplayedCalendar(Calendar value) {
        this.setDisplayedCalendar(value);
        return this;
    }

    public ObservableList<Appointment> selectedAppointments() {
        return this.selectedAppointments;
    }

    public ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackProperty() {
        return this.calendarRangeCallbackObjectProperty;
    }

    public Callback<CalendarRange, Void> getCalendarRangeCallback() {
        return (Callback)this.calendarRangeCallbackObjectProperty.getValue();
    }

    public void setCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.calendarRangeCallbackObjectProperty.setValue(value);
    }

    public Agenda withCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.setCalendarRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<CalendarRange, Appointment>> createAppointmentCallbackProperty() {
        return this.createAppointmentCallbackObjectProperty;
    }

    public Callback<CalendarRange, Appointment> getCreateAppointmentCallback() {
        return (Callback)this.createAppointmentCallbackObjectProperty.getValue();
    }

    public void setCreateAppointmentCallback(Callback<CalendarRange, Appointment> value) {
        this.createAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withCreateAppointmentCallback(Callback<CalendarRange, Appointment> value) {
        this.setCreateAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackProperty() {
        return this.editAppointmentCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getEditAppointmentCallback() {
        return (Callback)this.editAppointmentCallbackObjectProperty.getValue();
    }

    public void setEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.editAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.setEditAppointmentCallback(value);
        return this;
    }

    public void refresh() {
        ((AgendaSkin)this.getSkin()).refresh();
    }

    public static String quickFormatCalendar(Calendar value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat lSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        return lSimpleDateFormat.format(value.getTime());
    }

    public static String quickFormatCalendar(List<Calendar> value) {
        if (value == null) {
            return "null";
        }
        String s = value.size() + "x [";
        for (Calendar lCalendar : value) {
            if (!s.endsWith("[")) {
                s = s + ",";
            }
            s = s + Agenda.quickFormatCalendar(lCalendar);
        }
        s = s + "]";
        return s;
    }

    public static class AppointmentGroupImpl
    implements AppointmentGroup {
        private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
        private final ObjectProperty<String> styleClassObjectProperty = new SimpleObjectProperty((Object)this, "styleClass");

        public ObjectProperty<String> descriptionProperty() {
            return this.descriptionObjectProperty;
        }

        @Override
        public String getDescription() {
            return (String)this.descriptionObjectProperty.getValue();
        }

        @Override
        public void setDescription(String value) {
            this.descriptionObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withDescription(String value) {
            this.setDescription(value);
            return this;
        }

        public ObjectProperty<String> styleClassProperty() {
            return this.styleClassObjectProperty;
        }

        @Override
        public String getStyleClass() {
            return (String)this.styleClassObjectProperty.getValue();
        }

        @Override
        public void setStyleClass(String value) {
            this.styleClassObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withStyleClass(String value) {
            this.setStyleClass(value);
            return this;
        }
    }

    public static interface AppointmentGroup {
        public String getDescription();

        public void setDescription(String var1);

        public String getStyleClass();

        public void setStyleClass(String var1);
    }

    public static class AppointmentImpl
    implements Appointment {
        private final ObjectProperty<Calendar> startTimeObjectProperty = new SimpleObjectProperty((Object)this, "startTime");
        private final ObjectProperty<Calendar> endTimeObjectProperty = new SimpleObjectProperty((Object)this, "endTime");
        private final ObjectProperty<Boolean> wholeDayObjectProperty = new SimpleObjectProperty((Object)this, "wholeDay", (Object)false);
        private final ObjectProperty<String> summaryObjectProperty = new SimpleObjectProperty((Object)this, "summary");
        private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
        private final ObjectProperty<String> locationObjectProperty = new SimpleObjectProperty((Object)this, "location");
        private final ObjectProperty<AppointmentGroup> appointmentGroupObjectProperty = new SimpleObjectProperty((Object)this, "appointmentGroup");

        public ObjectProperty<Calendar> startTimeProperty() {
            return this.startTimeObjectProperty;
        }

        @Override
        public Calendar getStartTime() {
            return (Calendar)this.startTimeObjectProperty.getValue();
        }

        @Override
        public void setStartTime(Calendar value) {
            this.startTimeObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withStartTime(Calendar value) {
            this.setStartTime(value);
            return this;
        }

        public ObjectProperty<Calendar> endTimeProperty() {
            return this.endTimeObjectProperty;
        }

        @Override
        public Calendar getEndTime() {
            return (Calendar)this.endTimeObjectProperty.getValue();
        }

        @Override
        public void setEndTime(Calendar value) {
            this.endTimeObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withEndTime(Calendar value) {
            this.setEndTime(value);
            return this;
        }

        public ObjectProperty<Boolean> wholeDayProperty() {
            return this.wholeDayObjectProperty;
        }

        @Override
        public Boolean isWholeDay() {
            return (Boolean)this.wholeDayObjectProperty.getValue();
        }

        @Override
        public void setWholeDay(Boolean value) {
            this.wholeDayObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withWholeDay(Boolean value) {
            this.setWholeDay(value);
            return this;
        }

        public ObjectProperty<String> summaryProperty() {
            return this.summaryObjectProperty;
        }

        @Override
        public String getSummary() {
            return (String)this.summaryObjectProperty.getValue();
        }

        @Override
        public void setSummary(String value) {
            this.summaryObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withSummary(String value) {
            this.setSummary(value);
            return this;
        }

        public ObjectProperty<String> descriptionProperty() {
            return this.descriptionObjectProperty;
        }

        @Override
        public String getDescription() {
            return (String)this.descriptionObjectProperty.getValue();
        }

        @Override
        public void setDescription(String value) {
            this.descriptionObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withDescription(String value) {
            this.setDescription(value);
            return this;
        }

        public ObjectProperty<String> locationProperty() {
            return this.locationObjectProperty;
        }

        @Override
        public String getLocation() {
            return (String)this.locationObjectProperty.getValue();
        }

        @Override
        public void setLocation(String value) {
            this.locationObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withLocation(String value) {
            this.setLocation(value);
            return this;
        }

        public ObjectProperty<AppointmentGroup> appointmentGroupProperty() {
            return this.appointmentGroupObjectProperty;
        }

        @Override
        public AppointmentGroup getAppointmentGroup() {
            return (AppointmentGroup)this.appointmentGroupObjectProperty.getValue();
        }

        @Override
        public void setAppointmentGroup(AppointmentGroup value) {
            this.appointmentGroupObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withAppointmentGroup(AppointmentGroup value) {
            this.setAppointmentGroup(value);
            return this;
        }

        public String toString() {
            return super.toString() + ", " + Agenda.quickFormatCalendar(this.getStartTime()) + " - " + Agenda.quickFormatCalendar(this.getEndTime());
        }
    }

    public static interface Appointment {
        public Calendar getStartTime();

        public void setStartTime(Calendar var1);

        public Calendar getEndTime();

        public void setEndTime(Calendar var1);

        public Boolean isWholeDay();

        public void setWholeDay(Boolean var1);

        public String getSummary();

        public void setSummary(String var1);

        public String getDescription();

        public void setDescription(String var1);

        public String getLocation();

        public void setLocation(String var1);

        public AppointmentGroup getAppointmentGroup();

        public void setAppointmentGroup(AppointmentGroup var1);
    }

    public static interface AgendaSkin {
        public void refresh();
    }

    public static class CalendarRange {
        Calendar start;
        Calendar end;

        public CalendarRange(Calendar start, Calendar end) {
            this.start = start;
            this.end = end;
        }

        public Calendar getStartCalendar() {
            return this.start;
        }

        public Calendar getEndCalendar() {
            return this.end;
        }
    }
}

