/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;

public class BigDecimalField
extends Control {
    private final ObjectProperty<BigDecimal> number;
    private final ObjectProperty<BigDecimal> stepwidth;
    private final ObjectProperty<NumberFormat> format;
    private final StringProperty promptText;
    private final ObjectProperty<BigDecimal> maxValue;
    private final ObjectProperty<BigDecimal> minValue;

    public BigDecimalField() {
        this.setStyle(null);
        this.getStyleClass().add((Object)"big-decimal-field");
        this.number = new SimpleObjectProperty((Object)this, "number");
        this.stepwidth = new SimpleObjectProperty((Object)this, "stepwidth", (Object)BigDecimal.ONE);
        this.maxValue = new SimpleObjectProperty((Object)this, "maxValue");
        this.minValue = new SimpleObjectProperty((Object)this, "minValue");
        this.format = new SimpleObjectProperty((Object)this, "format", (Object)NumberFormat.getNumberInstance());
        this.promptText = new SimpleStringProperty((Object)this, "promptText", "");
        this.setFocusTraversable(false);
    }

    public BigDecimalField(BigDecimal number) {
        this();
        this.setNumber(number);
    }

    public BigDecimalField(BigDecimal initialValue, BigDecimal stepwidth, NumberFormat format) {
        this();
        this.number.set((Object)initialValue);
        this.stepwidth.set((Object)stepwidth);
        this.format.set((Object)format);
    }

    public String getText() {
        if (this.number.getValue() != null) {
            return this.getFormat().format(this.number.getValue());
        }
        return null;
    }

    public void setText(String formattedNumber) {
        try {
            Number parsedNumber = this.getFormat().parse(formattedNumber);
            this.setNumber(new BigDecimal(parsedNumber.toString()));
        }
        catch (ParseException ex) {
            Logger.getLogger(BigDecimalField.class.getName()).log(Level.INFO, null, ex);
        }
    }

    public void increment() {
        if (this.getNumber() != null && this.getStepwidth() != null) {
            BigDecimal newValue = this.getNumber().add(this.getStepwidth());
            if (!this.checkBounds(newValue)) {
                return;
            }
            this.setNumber(newValue);
        }
    }

    public void decrement() {
        if (this.getNumber() != null && this.getStepwidth() != null) {
            BigDecimal newValue = this.getNumber().subtract(this.getStepwidth());
            if (!this.checkBounds(newValue)) {
                return;
            }
            this.setNumber(newValue);
        }
    }

    public BigDecimal getNumber() {
        return (BigDecimal)this.number.getValue();
    }

    public void setNumber(BigDecimal value) {
        if (!this.checkBounds(value)) {
            String message = MessageFormat.format("number {0} is out of bounds({1}, {2})", value, this.minValue.get(), this.maxValue.get());
            throw new IllegalArgumentException(message);
        }
        this.number.set((Object)value);
    }

    private boolean checkBounds(BigDecimal value) {
        if (value != null && this.getMaxValue() != null && value.compareTo(this.getMaxValue()) > 0) {
            return false;
        }
        return value == null || this.getMinValue() == null || value.compareTo(this.getMinValue()) >= 0;
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.number;
    }

    public BigDecimal getStepwidth() {
        return (BigDecimal)this.stepwidth.getValue();
    }

    public void setStepwidth(BigDecimal value) {
        this.stepwidth.set((Object)value);
    }

    public ObjectProperty<BigDecimal> stepwidthProperty() {
        return this.stepwidth;
    }

    public NumberFormat getFormat() {
        return (NumberFormat)this.format.getValue();
    }

    public final void setFormat(NumberFormat value) {
        this.format.set((Object)value);
    }

    public ObjectProperty<NumberFormat> formatProperty() {
        return this.format;
    }

    public String getPromptText() {
        return this.promptText.getValue();
    }

    public final void setPromptText(String value) {
        this.promptText.setValue(value);
    }

    public StringProperty promptTextProperty() {
        return this.promptText;
    }

    public BigDecimal getMaxValue() {
        return (BigDecimal)this.maxValue.getValue();
    }

    public void setMaxValue(BigDecimal value) {
        this.maxValue.set((Object)value);
    }

    public ObjectProperty<BigDecimal> maxValueProperty() {
        return this.maxValue;
    }

    public BigDecimal getMinValue() {
        return (BigDecimal)this.minValue.getValue();
    }

    public void setMinValue(BigDecimal value) {
        this.minValue.set((Object)value);
    }

    public ObjectProperty<BigDecimal> minValueProperty() {
        return this.minValue;
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm();
    }
}

