/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;

public class BigDecimalLabel
extends Label {
    private ObjectProperty<BigDecimal> number = new SimpleObjectProperty();
    private final ObjectProperty<NumberFormat> format = new SimpleObjectProperty();

    public final BigDecimal getNumber() {
        return (BigDecimal)this.number.get();
    }

    public final void setNumber(BigDecimal value) {
        this.number.set((Object)value);
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.number;
    }

    public NumberFormat getFormat() {
        return (NumberFormat)this.format.getValue();
    }

    public final void setFormat(NumberFormat value) {
        this.format.set((Object)value);
    }

    public ObjectProperty<NumberFormat> formatProperty() {
        return this.format;
    }

    public BigDecimalLabel() {
        this(BigDecimal.ZERO);
    }

    public BigDecimalLabel(BigDecimal value) {
        this(value, NumberFormat.getInstance());
    }

    public BigDecimalLabel(BigDecimal value, NumberFormat nf) {
        this.setFormat(nf);
        this.initHandlers();
        this.setNumber(value);
    }

    private void initHandlers() {
        this.numberProperty().addListener((ChangeListener)new ChangeListener<BigDecimal>(){

            public void changed(ObservableValue<? extends BigDecimal> observable, BigDecimal oldValue, BigDecimal newValue) {
                BigDecimalLabel.this.setText(BigDecimalLabel.this.getFormattedString());
            }
        });
        this.formatProperty().addListener((ChangeListener)new ChangeListener<NumberFormat>(){

            public void changed(ObservableValue<? extends NumberFormat> observable, NumberFormat olValue, NumberFormat newValue) {
                BigDecimalLabel.this.setText(BigDecimalLabel.this.getFormattedString());
            }
        });
    }

    private String getFormattedString() {
        if (this.getNumber() == null || this.getFormat() == null) {
            return null;
        }
        try {
            String formattedString = this.getFormat().format(this.getNumber());
            return formattedString;
        }
        catch (Exception e) {
            this.setText("n/a");
            e.printStackTrace();
            return null;
        }
    }
}

