/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.SVGPath;
import jfxtras.labs.scene.control.BreadcrumbItem;
import jfxtras.labs.util.BreadcrumbBarEventHandler;

public class BreadcrumbBar
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "breadcrumbbar";
    private final ReadOnlyListProperty<BreadcrumbItem> items = new SimpleListProperty(FXCollections.observableArrayList(new ArrayList()));
    private final ObjectProperty<BreadcrumbItem> homeItem = new SimpleObjectProperty();
    private final ObjectProperty<BreadcrumbBarEventHandler> onItemAction = new SimpleObjectProperty();

    public BreadcrumbBar() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPrefHeight(30.0);
        this.setPrefWidth(200.0);
        this.onItemAction.addListener((ChangeListener)new ChangeListener<BreadcrumbBarEventHandler>(){

            public void changed(ObservableValue<? extends BreadcrumbBarEventHandler> observable, BreadcrumbBarEventHandler oldValue, BreadcrumbBarEventHandler newValue) {
                if (oldValue != null) {
                    for (BreadcrumbItem i : BreadcrumbBar.this.itemsProperty()) {
                        i.removeEventHandler(MouseEvent.MOUSE_CLICKED, oldValue);
                    }
                }
                if (newValue != null) {
                    for (BreadcrumbItem i : BreadcrumbBar.this.itemsProperty()) {
                        i.addEventHandler(MouseEvent.MOUSE_CLICKED, newValue);
                    }
                }
            }
        });
        ((ObservableList)this.items.get()).addListener((ListChangeListener)new ListChangeListener<BreadcrumbItem>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChanged(ListChangeListener.Change<? extends BreadcrumbItem> c) {
                while (c.next()) {
                    if (!c.wasAdded() || BreadcrumbBar.this.onItemAction.get() == null) continue;
                    for (BreadcrumbItem i : c.getAddedSubList()) {
                        i.addEventHandler(MouseEvent.MOUSE_CLICKED, BreadcrumbBar.this.getOnItemAction());
                    }
                }
                c.reset();
                ReadOnlyListProperty<BreadcrumbItem> readOnlyListProperty = BreadcrumbBar.this.itemsProperty();
                synchronized (readOnlyListProperty) {
                    for (BreadcrumbItem item : BreadcrumbBar.this.itemsProperty()) {
                        ((SimpleBooleanProperty)item.firstProperty()).set(BreadcrumbBar.this.items.indexOf((Object)item) == 0);
                    }
                }
            }
        });
    }

    public final ReadOnlyListProperty<BreadcrumbItem> itemsProperty() {
        return this.items;
    }

    public final ObjectProperty<BreadcrumbItem> homeItemProperty() {
        return this.homeItem;
    }

    public final BreadcrumbItem getHomeItem() {
        return (BreadcrumbItem)((Object)this.homeItemProperty().get());
    }

    public final void setHomeItem(BreadcrumbItem homeItem) {
        this.homeItemProperty().set((Object)homeItem);
    }

    public final ObjectProperty<BreadcrumbBarEventHandler> onItemActionProperty() {
        return this.onItemAction;
    }

    public final BreadcrumbBarEventHandler getOnItemAction() {
        return (BreadcrumbBarEventHandler)this.onItemActionProperty().get();
    }

    public final void setOnItemAction(BreadcrumbBarEventHandler handler) {
        this.onItemActionProperty().set((Object)handler);
    }

    public final BreadcrumbItem addItem(BreadcrumbItem item) {
        if (item != null) {
            this.itemsProperty().add((Object)item);
        }
        return item;
    }

    public final BreadcrumbItem addHome(Node content) {
        Image icon = new Image(((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/home.png").toExternalForm());
        BreadcrumbItem hItem = new BreadcrumbItem(this, "", icon, content);
        if (this.getHomeItem() == null) {
            ((SimpleListProperty)this.itemsProperty()).add(0, (Object)hItem);
        } else {
            ((SimpleListProperty)this.itemsProperty()).set(0, (Object)hItem);
        }
        this.setHomeItem(hItem);
        return hItem;
    }

    public final BreadcrumbItem addItem(String text, Image icon, Node content) {
        BreadcrumbItem item = new BreadcrumbItem(this, text, icon, content);
        return this.addItem(item);
    }

    public final BreadcrumbItem addItem(String text, SVGPath svgIcon, Node content) {
        BreadcrumbItem item = new BreadcrumbItem(this, text, svgIcon, content);
        return this.addItem(item);
    }

    public final BreadcrumbItem addItem(String text, Node content) {
        BreadcrumbItem item = new BreadcrumbItem(this, text, (Image)null, content);
        return this.addItem(item);
    }

    public final BreadcrumbItem addItem(Image icon, Node content) {
        BreadcrumbItem item = new BreadcrumbItem(this, null, icon, content);
        return this.addItem(item);
    }

    public final boolean removeItem(BreadcrumbItem item) {
        boolean deleted = false;
        if (item != null) {
            int index = this.items.indexOf((Object)item);
            if (index == this.items.size() - 1) {
                deleted = ((SimpleListProperty)this.itemsProperty()).remove((Object)item);
            } else if (index < this.items.size()) {
                int previousSize = this.items.size();
                ((SimpleListProperty)this.itemsProperty()).remove(index, this.items.size());
                deleted = previousSize > this.items.size();
            }
        }
        return deleted;
    }

    public final boolean removeItem(int index) {
        boolean deleted = false;
        if (index >= 0 && index < this.itemsProperty().getSize()) {
            deleted = this.removeItem((BreadcrumbItem)((Object)this.itemsProperty().get(index)));
        }
        return deleted;
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm();
    }
}

