/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;

public class CalendarPicker
extends Control {
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar");
    private final ObservableList<Calendar> calendars = FXCollections.observableArrayList();
    private volatile ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final SimpleObjectProperty<Mode> modeObjectProperty = new SimpleObjectProperty<Mode>((Object)this, "mode", Mode.SINGLE){

        public void set(Mode value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed");
            }
            super.set((Object)value);
        }
    };
    private volatile ObjectProperty<Boolean> showTimeObjectProperty = new SimpleObjectProperty((Object)this, "showTime", (Object)false);

    public CalendarPicker() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)CalendarPicker.class.getSimpleName());
        this.constructCalendar();
        this.constructCalendars();
        this.constructLocale();
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + CalendarPicker.class.getSimpleName() + ".css").toString();
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    private void constructCalendar() {
        this.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                if (newValue != null && !CalendarPicker.this.calendars().contains((Object)newValue)) {
                    CalendarPicker.this.calendars().add((Object)newValue);
                }
                if (oldValue != null) {
                    CalendarPicker.this.calendars().remove((Object)oldValue);
                }
            }
        });
    }

    public ObservableList<Calendar> calendars() {
        return this.calendars;
    }

    private void constructCalendars() {
        this.calendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> change) {
                if (!CalendarPicker.this.calendars().contains((Object)CalendarPicker.this.getCalendar())) {
                    if (CalendarPicker.this.calendars().size() > 0) {
                        CalendarPicker.this.setCalendar((Calendar)CalendarPicker.this.calendars().get(0));
                    } else {
                        CalendarPicker.this.setCalendar(null);
                    }
                }
            }
        });
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    private void constructLocale() {
        this.localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
            }
        });
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.modeObjectProperty;
    }

    public Mode getMode() {
        return (Mode)((Object)this.modeObjectProperty.getValue());
    }

    public void setMode(Mode value) {
        this.modeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withMode(Mode value) {
        this.setMode(value);
        return this;
    }

    public ObjectProperty<Boolean> showTimeProperty() {
        return this.showTimeObjectProperty;
    }

    public Boolean getShowTime() {
        return (Boolean)this.showTimeObjectProperty.getValue();
    }

    public void setShowTime(Boolean value) {
        this.showTimeObjectProperty.setValue((Object)value);
    }

    public CalendarPicker withShowTime(Boolean value) {
        this.setShowTime(value);
        return this;
    }

    public static String quickFormatCalendar(Calendar value) {
        if (value == null) {
            return "null";
        }
        SimpleDateFormat lSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1);
        lSimpleDateFormat.applyPattern("yyyy-MM-dd");
        return value == null ? "null" : lSimpleDateFormat.format(value.getTime());
    }

    public static String quickFormatCalendar(List<Calendar> value) {
        if (value == null) {
            return "null";
        }
        String s = value.size() + "x [";
        for (Calendar lCalendar : value) {
            if (!s.endsWith("[")) {
                s = s + ",";
            }
            s = s + CalendarPicker.quickFormatCalendar(lCalendar);
        }
        s = s + "]";
        return s;
    }

    public static enum Mode {
        SINGLE,
        MULTIPLE,
        RANGE;

    }
}

