/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigInteger;
import java.util.AbstractList;

public class ListSpinnerBigIntegerList
extends AbstractList<BigInteger> {
    private BigInteger from;
    private int size;
    private BigInteger step;

    public ListSpinnerBigIntegerList() {
        this(BigInteger.valueOf(-1073741824L).add(BigInteger.ONE), BigInteger.valueOf(0x3FFFFFFFL), BigInteger.ONE);
    }

    public ListSpinnerBigIntegerList(BigInteger from, BigInteger to) {
        this(from, to, from.compareTo(to) > 0 ? BigInteger.valueOf(-1L) : BigInteger.ONE);
    }

    public ListSpinnerBigIntegerList(BigInteger from, BigInteger to, BigInteger step) {
        this.from = from;
        this.size = to.subtract(from).divide(step).add(BigInteger.ONE).intValue();
        if (this.size < 0) {
            throw new IllegalArgumentException("This results in a negative size: " + from + ", " + to + "," + step);
        }
        this.step = step;
    }

    @Override
    public BigInteger get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be < 0: " + index);
        }
        BigInteger lValue = this.from.add(BigInteger.valueOf(index).multiply(this.step));
        return lValue;
    }

    @Override
    public int indexOf(Object o) {
        BigInteger lValue = (BigInteger)o;
        BigInteger lIndexBigInteger = lValue.subtract(this.from).divide(this.step);
        int lIndex = lIndexBigInteger.intValue();
        if (lIndex > this.size) {
            return -1;
        }
        BigInteger lValueAtIndex = this.get(lIndex);
        if (!o.equals(lValueAtIndex)) {
            return -1;
        }
        return lIndex;
    }

    @Override
    public int size() {
        return this.size;
    }
}

