/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.util.Calendar;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.time.calendar.LocalDate;
import jfxtras.labs.scene.control.CalendarPicker;

public class LocalDatePicker
extends CalendarPicker {
    private final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    private final ObservableList<LocalDate> localDates = FXCollections.observableArrayList();

    public LocalDatePicker() {
        this.construct();
    }

    public LocalDatePicker(LocalDate localDate) {
        this.construct();
        this.setLocalDate(localDate);
    }

    private void construct() {
        this.constructLocalDate();
        this.constructLocalDates();
    }

    public ObjectProperty<LocalDate> localDateProperty() {
        return this.localDateObjectProperty;
    }

    public LocalDate getLocalDate() {
        return (LocalDate)this.localDateObjectProperty.getValue();
    }

    public void setLocalDate(LocalDate value) {
        this.localDateObjectProperty.setValue((Object)value);
    }

    public LocalDatePicker withLocalDate(LocalDate value) {
        this.setLocalDate(value);
        return this;
    }

    private void constructLocalDate() {
        this.calendarProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observableValue, Calendar oldValue, Calendar newValue) {
                LocalDatePicker.this.localDateProperty().set((Object)LocalDatePicker.this.createLocalDateFromCalendar(newValue));
            }
        });
        this.localDateProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observableValue, LocalDate oldValue, LocalDate newValue) {
                LocalDatePicker.this.calendarProperty().set(newValue == null ? null : LocalDatePicker.this.createCalendarFromLocalDate(newValue));
            }
        });
    }

    public ObservableList<LocalDate> localDates() {
        return this.localDates;
    }

    private void constructLocalDates() {
        this.calendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> change) {
                while (change.next()) {
                    LocalDate lLocalDate;
                    for (Calendar lCalendar : change.getRemoved()) {
                        lLocalDate = LocalDatePicker.this.createLocalDateFromCalendar(lCalendar);
                        if (!LocalDatePicker.this.localDates().contains((Object)lLocalDate)) continue;
                        LocalDatePicker.this.localDates().remove((Object)lLocalDate);
                    }
                    for (Calendar lCalendar : change.getAddedSubList()) {
                        lLocalDate = LocalDatePicker.this.createLocalDateFromCalendar(lCalendar);
                        if (LocalDatePicker.this.localDates().contains((Object)lLocalDate)) continue;
                        LocalDatePicker.this.localDates().add((Object)lLocalDate);
                    }
                }
            }
        });
        this.localDates().addListener((ListChangeListener)new ListChangeListener<LocalDate>(){

            public void onChanged(ListChangeListener.Change<? extends LocalDate> change) {
                while (change.next()) {
                    Calendar lCalendar;
                    for (LocalDate lLocalDate : change.getRemoved()) {
                        lCalendar = LocalDatePicker.this.createCalendarFromLocalDate(lLocalDate);
                        if (!LocalDatePicker.this.calendars().contains((Object)lCalendar)) continue;
                        LocalDatePicker.this.calendars().remove((Object)lCalendar);
                    }
                    for (LocalDate lLocalDate : change.getAddedSubList()) {
                        lCalendar = LocalDatePicker.this.createCalendarFromLocalDate(lLocalDate);
                        if (LocalDatePicker.this.calendars().contains((Object)lCalendar)) continue;
                        LocalDatePicker.this.calendars().add((Object)lCalendar);
                    }
                }
            }
        });
    }

    private Calendar createCalendarFromLocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(this.getLocale());
        lCalendar.set(1, localDate.getYear());
        lCalendar.set(2, localDate.getMonthOfYear().getValue() - 1);
        lCalendar.set(5, localDate.getDayOfMonth());
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    private LocalDate createLocalDateFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalDate lLocalDate = LocalDate.of((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5));
        return lLocalDate;
    }
}

