/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.ControlBuilder;
import javafx.scene.paint.Paint;
import javafx.util.Builder;
import jfxtras.labs.scene.control.SlideLock;

public class SlideLockBuilder<B extends SlideLockBuilder<B>>
extends ControlBuilder<B>
implements Builder<SlideLock> {
    private HashMap<String, Property> properties = new HashMap();

    protected SlideLockBuilder() {
    }

    public static final SlideLockBuilder create() {
        return new SlideLockBuilder();
    }

    public final SlideLockBuilder backgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.properties.put("BACKGROUND_VISIBLE", (Property)new SimpleBooleanProperty(BACKGROUND_VISIBLE));
        return this;
    }

    public final SlideLockBuilder locked(boolean LOCKED) {
        this.properties.put("LOCKED", (Property)new SimpleBooleanProperty(LOCKED));
        return this;
    }

    public final SlideLockBuilder text(String TEXT) {
        this.properties.put("TEXT", (Property)new SimpleStringProperty(TEXT));
        return this;
    }

    public final SlideLockBuilder textOpacity(double TEXT_OPACITY) {
        this.properties.put("TEXT_OPACITY", (Property)new SimpleDoubleProperty(TEXT_OPACITY));
        return this;
    }

    public final SlideLockBuilder buttonArrowBackgroundColor(Paint COLOR) {
        this.properties.put("BUTTON_ARROW_BG_COLOR", (Property)new SimpleObjectProperty((Object)COLOR));
        return this;
    }

    public final SlideLockBuilder buttonColor(Paint COLOR) {
        this.properties.put("BUTTON_COLOR", (Property)new SimpleObjectProperty((Object)COLOR));
        return this;
    }

    public final SlideLockBuilder buttonGlareVisible(boolean VISIBLE) {
        this.properties.put("BUTTON_GLARE", (Property)new SimpleBooleanProperty(VISIBLE));
        return this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("PREF_WIDTH", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)((Object)this);
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("PREF_HEIGHT", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)((Object)this);
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("LAYOUT_X", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)((Object)this);
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("LAYOUT_Y", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)((Object)this);
    }

    public final SlideLock build() {
        SlideLock CONTROL = new SlideLock();
        for (String key : this.properties.keySet()) {
            if ("LOCKED".equals(key)) {
                CONTROL.setLocked(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BACKGROUND_VISIBLE".equals(key)) {
                CONTROL.setBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("TEXT".equals(key)) {
                CONTROL.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("TEXT_OPACITY".equals(key)) {
                CONTROL.setTextOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("PREF_WIDTH".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("PREF_HEIGHT".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("LAYOUT_X".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("LAYOUT_Y".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BUTTON_ARROW_BG_COLOR".equals(key)) {
                CONTROL.setButtonArrowBackgroundColor((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BUTTON_COLOR".equals(key)) {
                CONTROL.setButtonColor((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"BUTTON_GLARE".equals(key)) continue;
            CONTROL.setButtonGlareVisible(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

