/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.Content;

public class ContentBuilder
implements Builder<Content> {
    private HashMap<String, Property> properties = new HashMap();

    public static final ContentBuilder create() {
        return new ContentBuilder();
    }

    public final ContentBuilder color(Content.MatrixColor MATRIX_COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)MATRIX_COLOR));
        return this;
    }

    public final ContentBuilder type(Content.Type TYPE) {
        this.properties.put("type", (Property)new SimpleObjectProperty((Object)TYPE));
        return this;
    }

    public final ContentBuilder origin(Point2D ORIGIN) {
        this.properties.put("origin", (Property)new SimpleObjectProperty((Object)ORIGIN));
        return this;
    }

    public final ContentBuilder origin(int ORIGIN_X, int ORIGIN_Y) {
        this.properties.put("origin", (Property)new SimpleObjectProperty((Object)new Point2D((double)ORIGIN_X, (double)ORIGIN_Y)));
        return this;
    }

    public final ContentBuilder area(Rectangle AREA) {
        Rectangle RECT = new Rectangle(AREA.getX(), AREA.getY(), AREA.getX() + AREA.getWidth(), AREA.getY() + AREA.getHeight());
        this.properties.put("area", (Property)new SimpleObjectProperty((Object)RECT));
        return this;
    }

    public final ContentBuilder area(int ORIGIN_X, int ORIGIN_Y, int END_X, int END_Y) {
        this.properties.put("area", (Property)new SimpleObjectProperty((Object)new Rectangle((double)ORIGIN_X, (double)ORIGIN_Y, (double)END_X, (double)END_Y)));
        return this;
    }

    public final ContentBuilder bmpName(String BMP_NAME) {
        this.properties.put("bmpName", (Property)new SimpleStringProperty(BMP_NAME));
        return this;
    }

    public final ContentBuilder txtContent(String TXT_CONTENT) {
        this.properties.put("txtContent", (Property)new SimpleStringProperty(TXT_CONTENT));
        return this;
    }

    public final ContentBuilder font(Content.MatrixFont FONT) {
        this.properties.put("matrixFont", (Property)new SimpleObjectProperty((Object)FONT));
        return this;
    }

    public final ContentBuilder fontGap(Content.Gap FONT_GAP) {
        this.properties.put("fontGap", (Property)new SimpleObjectProperty((Object)FONT_GAP));
        return this;
    }

    public final ContentBuilder align(Content.Align TXT_ALIGN) {
        this.properties.put("align", (Property)new SimpleObjectProperty((Object)TXT_ALIGN));
        return this;
    }

    public final ContentBuilder effect(Content.Effect EFFECT) {
        this.properties.put("effect", (Property)new SimpleObjectProperty((Object)EFFECT));
        return this;
    }

    public final ContentBuilder postEffect(Content.PostEffect POST_EFFECT) {
        this.properties.put("postEffect", (Property)new SimpleObjectProperty((Object)POST_EFFECT));
        return this;
    }

    public final ContentBuilder pause(Integer PAUSE) {
        this.properties.put("pause", (Property)new SimpleIntegerProperty(PAUSE.intValue()));
        return this;
    }

    public final ContentBuilder lapse(Integer TIME_LAPSE) {
        this.properties.put("lapse", (Property)new SimpleIntegerProperty(TIME_LAPSE.intValue()));
        return this;
    }

    public final ContentBuilder order(Content.RotationOrder ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return this;
    }

    public final ContentBuilder clear(Boolean CLEAR) {
        this.properties.put("clear", (Property)new SimpleBooleanProperty(CLEAR.booleanValue()));
        return this;
    }

    public Content build() {
        Content CONTROL = new Content();
        for (String key : this.properties.keySet()) {
            if ("color".equals(key)) {
                CONTROL.setColor((Content.MatrixColor)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("type".equals(key)) {
                CONTROL.setType((Content.Type)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("origin".equals(key)) {
                CONTROL.setOrigin((Point2D)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("area".equals(key)) {
                CONTROL.setArea((Rectangle)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("bmpName".equals(key)) {
                CONTROL.setBmpName((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("txtContent".equals(key)) {
                CONTROL.setTxtContent((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("matrixFont".equals(key)) {
                CONTROL.setMatrixFont((Content.MatrixFont)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("fontGap".equals(key)) {
                CONTROL.setFontGap((Content.Gap)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("align".equals(key)) {
                CONTROL.setTxtAlign((Content.Align)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("effect".equals(key)) {
                CONTROL.setEffect((Content.Effect)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("postEffect".equals(key)) {
                CONTROL.setPostEffect((Content.PostEffect)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("pause".equals(key)) {
                CONTROL.setPause(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lapse".equals(key)) {
                CONTROL.setLapse(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("order".equals(key)) {
                CONTROL.setOrder((Content.RotationOrder)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if (!"clear".equals(key)) continue;
            CONTROL.setClear(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

