/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.ControlBuilder;
import javafx.scene.paint.Color;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.ColorDef;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.Lcd;
import jfxtras.labs.scene.control.gauge.LcdDesign;
import jfxtras.labs.scene.control.gauge.LedColor;
import jfxtras.labs.scene.control.gauge.Linear;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Radial;
import jfxtras.labs.scene.control.gauge.RadialHalfN;
import jfxtras.labs.scene.control.gauge.RadialHalfS;
import jfxtras.labs.scene.control.gauge.RadialQuarterE;
import jfxtras.labs.scene.control.gauge.RadialQuarterN;
import jfxtras.labs.scene.control.gauge.RadialQuarterS;
import jfxtras.labs.scene.control.gauge.RadialQuarterW;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.SimpleLinearGauge;
import jfxtras.labs.scene.control.gauge.SimpleRadialGauge;
import jfxtras.labs.scene.control.gauge.StyleModel;

public class GaugeBuilder<B extends GaugeBuilder<B>>
extends ControlBuilder<B>
implements Builder<Gauge> {
    private HashMap<String, Property> gaugeProperties = new HashMap();
    private HashMap<String, Property> styleProperties = new HashMap();

    protected GaugeBuilder() {
    }

    public static final GaugeBuilder<?> create() {
        return new GaugeBuilder();
    }

    public final Gauge build() {
        GaugeType gaugeType = GaugeType.RADIAL;
        double prefWidth = -1.0;
        double prefHeight = -1.0;
        double layoutX = -1.0;
        double layoutY = -1.0;
        Gauge.RadialRange radialRange = Gauge.RadialRange.RADIAL_300;
        GaugeModel gaugeModel = this.gaugeProperties.containsKey("gaugeModel") ? (GaugeModel)((ObjectProperty)this.gaugeProperties.get("gaugeModel")).get() : new GaugeModel();
        StyleModel styleModel = this.styleProperties.containsKey("styleModel") ? (StyleModel)((ObjectProperty)this.styleProperties.get("styleModel")).get() : new StyleModel();
        for (String key : this.gaugeProperties.keySet()) {
            if ("gaugeType".equals(key)) {
                gaugeType = (GaugeType)((Object)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                gaugeModel.setValue(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("valueAnimationEnabled".equals(key)) {
                gaugeModel.setValueAnimationEnabled(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("animationDuration".equals(key)) {
                gaugeModel.setAnimationDuration(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("redrawTolerance".equals(key)) {
                gaugeModel.setRedrawTolerance(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("minValue".equals(key)) {
                gaugeModel.setMinValue(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("maxValue".equals(key)) {
                gaugeModel.setMaxValue(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("threshold".equals(key)) {
                gaugeModel.setThreshold(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("thresholdBehaviorInverted".equals(key)) {
                gaugeModel.setThresholdBehaviorInverted(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("radialRange".equals(key)) {
                radialRange = (Gauge.RadialRange)((Object)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                gaugeModel.setTitle((String)((StringProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("unit".equals(key)) {
                gaugeModel.setUnit((String)((StringProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lcdValueCoupled".equals(key)) {
                gaugeModel.setLcdValueCoupled(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lcdThreshold".equals(key)) {
                gaugeModel.setLcdThreshold(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lcdThresholdBehaviorInverted".equals(key)) {
                gaugeModel.setLcdThresholdBehaviorInverted(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lcdUnitString".equals(key)) {
                gaugeModel.setLcdUnit((String)((StringProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lcdNumberSystem".equals(key)) {
                gaugeModel.setLcdNumberSystem((Gauge.NumberSystem)((Object)((ObjectProperty)this.gaugeProperties.get(key)).get()));
                continue;
            }
            if ("maxNoOfMajorTicks".equals(key)) {
                gaugeModel.setMaxNoOfMajorTicks(((IntegerProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("maxNoOfMinorTicks".equals(key)) {
                gaugeModel.setMaxNoOfMinorTicks(((IntegerProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("majorTickSpacing".equals(key)) {
                gaugeModel.setMajorTickSpacing(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("minorTickSpacing".equals(key)) {
                gaugeModel.setMinorTickSpacing(((DoubleProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("trend".equals(key)) {
                gaugeModel.setTrend((Gauge.Trend)((Object)((ObjectProperty)this.gaugeProperties.get(key)).get()));
                continue;
            }
            if ("niceScaling".equals(key)) {
                gaugeModel.setNiceScaling(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("tightScale".equals(key)) {
                gaugeModel.setTightScale(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("largeNumberScale".equals(key)) {
                gaugeModel.setLargeNumberScale(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("lastLabelVisible".equals(key)) {
                gaugeModel.setLastLabelVisible(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("sectionsArray".equals(key)) {
                gaugeModel.setSections((Section[])((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("sectionsList".equals(key)) {
                gaugeModel.setSections((List)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("areasArray".equals(key)) {
                gaugeModel.setAreas((Section[])((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("areasList".equals(key)) {
                gaugeModel.setAreas((List)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("tickMarkSectionsArray".equals(key)) {
                gaugeModel.setTickMarkSections((Section[])((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("tickMarkSectionsList".equals(key)) {
                gaugeModel.setTickMarkSections((List)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("markersArray".equals(key)) {
                gaugeModel.setMarkers((Marker[])((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("markersList".equals(key)) {
                gaugeModel.setMarkers((List)((ObjectProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("endlessMode".equals(key)) {
                gaugeModel.setEndlessMode(((BooleanProperty)this.gaugeProperties.get(key)).get());
                continue;
            }
            if ("prefWidth".equals(key)) {
                prefWidth = ((DoubleProperty)this.gaugeProperties.get(key)).get();
                continue;
            }
            if ("prefHeight".equals(key)) {
                prefHeight = ((DoubleProperty)this.gaugeProperties.get(key)).get();
                continue;
            }
            if ("layoutX".equals(key)) {
                layoutX = ((DoubleProperty)this.gaugeProperties.get(key)).get();
                continue;
            }
            if (!"layoutY".equals(key)) continue;
            layoutY = ((DoubleProperty)this.gaugeProperties.get(key)).get();
        }
        for (String key : this.styleProperties.keySet()) {
            if ("bargraph".equals(key)) {
                styleModel.setBargraph(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("minMeasuredValueVisible".equals(key)) {
                styleModel.setMinMeasuredValueVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("maxMeasuredValueVisible".equals(key)) {
                styleModel.setMaxMeasuredValueVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("thresholdVisible".equals(key)) {
                styleModel.setThresholdVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("thresholdColor".equals(key)) {
                styleModel.setThresholdColor((Gauge.ThresholdColor)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("frameDesign".equals(key)) {
                styleModel.setFrameDesign((Gauge.FrameDesign)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("frameBaseColor".equals(key)) {
                styleModel.setFrameBaseColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("frameVisible".equals(key)) {
                styleModel.setFrameVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("backgroundDesign".equals(key)) {
                styleModel.setBackgroundDesign((Gauge.BackgroundDesign)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("backgroundVisible".equals(key)) {
                styleModel.setBackgroundVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("knobDesign".equals(key)) {
                styleModel.setKnobDesign((Gauge.KnobDesign)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("knobColor".equals(key)) {
                styleModel.setKnobColor((Gauge.KnobColor)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("knobsVisible".equals(key)) {
                if (gaugeModel.isEndlessMode()) {
                    styleModel.setKnobsVisible(false);
                    continue;
                }
                styleModel.setKnobsVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("pointerType".equals(key)) {
                styleModel.setPointerType((Gauge.PointerType)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("valueColor".equals(key)) {
                styleModel.setValueColor((ColorDef)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("pointerGlowEnabled".equals(key)) {
                styleModel.setPointerGlowEnabled(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("pointerShadowEnabled".equals(key)) {
                styleModel.setPointerShadowEnabled(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("ledVisible".equals(key)) {
                styleModel.setLedVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("ledColor".equals(key)) {
                styleModel.setLedColor((LedColor)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("userLedVisible".equals(key)) {
                styleModel.setUserLedVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("userLedColor".equals(key)) {
                styleModel.setUserLedColor((LedColor)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("userLedOn".equals(key)) {
                styleModel.setUserLedOn(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("userLedBlinking".equals(key)) {
                styleModel.setUserLedBlinking(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("titleFont".equals(key)) {
                styleModel.setTitleFont((String)((StringProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("unitFont".equals(key)) {
                styleModel.setUnitFont((String)((StringProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("foregroundType".equals(key)) {
                styleModel.setForegroundType((Radial.ForegroundType)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("foregroundVisible".equals(key)) {
                styleModel.setForegroundVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdThresholdVisible".equals(key)) {
                styleModel.setLcdThresholdVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdDesign".equals(key)) {
                styleModel.setLcdDesign((LcdDesign)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("lcdVisible".equals(key)) {
                styleModel.setLcdVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdUnitStringVisible".equals(key)) {
                styleModel.setLcdUnitVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdNumberSystemVisible".equals(key)) {
                styleModel.setLcdNumberSystemVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdUnitFont".equals(key)) {
                styleModel.setLcdUnitFont((String)((StringProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdTitleFont".equals(key)) {
                styleModel.setLcdTitleFont((String)((StringProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdValueFont".equals(key)) {
                styleModel.setLcdValueFont((Gauge.LcdFont)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("lcdDecimals".equals(key)) {
                styleModel.setLcdDecimals(((IntegerProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdBlinking".equals(key)) {
                styleModel.setLcdBlinking(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("lcdBackgroundVisible".equals(key)) {
                styleModel.setLcdBackgroundVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("glowVisible".equals(key)) {
                styleModel.setGlowVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("glowOn".equals(key)) {
                styleModel.setGlowOn(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("tickmarksVisible".equals(key)) {
                styleModel.setTickmarksVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("majorTickmarksVisible".equals(key)) {
                styleModel.setMajorTicksVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("majorTickmarkType".equals(key)) {
                styleModel.setMajorTickmarkType((Gauge.TickmarkType)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("majorTickmarkColor".equals(key)) {
                styleModel.setMajorTickmarkColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("majorTickmarkColorEnabled".equals(key)) {
                styleModel.setMajorTickmarkColorEnabled(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("minorTickmarksVisible".equals(key)) {
                styleModel.setMinorTicksVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("minorTickmarkColor".equals(key)) {
                styleModel.setMinorTickmarkColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("minorTickmarkColorEnabled".equals(key)) {
                styleModel.setMinorTickmarkColorEnabled(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("tickLabelsVisible".equals(key)) {
                styleModel.setTickLabelsVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("tickLabelOrientation".equals(key)) {
                styleModel.setTickLabelOrientation((Gauge.TicklabelOrientation)((Object)((ObjectProperty)this.styleProperties.get(key)).get()));
                continue;
            }
            if ("tickmarkGlowEnabled".equals(key)) {
                styleModel.setTickmarkGlowEnabled(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("tickmarkGlowColor".equals(key)) {
                styleModel.setTickmarkGlowColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("sectionsVisible".equals(key)) {
                styleModel.setSectionsVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("sectionsHighlighting".equals(key)) {
                styleModel.setSectionsHighlighting(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("showSectionTickmarksOnly".equals(key)) {
                styleModel.setShowSectionTickmarksOnly(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("areasVisible".equals(key)) {
                styleModel.setAreasVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("areasHighlighting".equals(key)) {
                styleModel.setAreasHighlighting(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("markersVisible".equals(key)) {
                styleModel.setMarkersVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("textureColor".equals(key)) {
                styleModel.setTextureColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("simpleGradientBaseColor".equals(key)) {
                styleModel.setSimpleGradientBaseColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("titleVisible".equals(key)) {
                styleModel.setTitleVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("unitVisible".equals(key)) {
                styleModel.setUnitVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("trendVisible".equals(key)) {
                styleModel.setTrendVisible(((BooleanProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("trendUpColor".equals(key)) {
                styleModel.setTrendUpColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("trendRisingColor".equals(key)) {
                styleModel.setTrendRisingColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("trendSteadyColor".equals(key)) {
                styleModel.setTrendSteadyColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if ("trendFallingColor".equals(key)) {
                styleModel.setTrendFallingColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
                continue;
            }
            if (!"trendDownColor".equals(key)) continue;
            styleModel.setTrendDownColor((Color)((ObjectProperty)this.styleProperties.get(key)).get());
        }
        double WIDTH = prefWidth == -1.0 ? 200.0 : prefWidth;
        double HEIGHT = prefHeight == -1.0 ? 200.0 : prefHeight;
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        switch (gaugeType) {
            case LCD: {
                Lcd lcd = new Lcd(gaugeModel, styleModel);
                if (prefWidth != -1.0) {
                    lcd.setPrefWidth(prefWidth);
                }
                if (prefHeight != -1.0) {
                    lcd.setPrefHeight(prefHeight);
                }
                super.applyTo((Control)lcd);
                return lcd;
            }
            case LINEAR: {
                Linear linear = new Linear(gaugeModel, styleModel);
                if (prefWidth != -1.0) {
                    linear.setPrefWidth(prefWidth);
                }
                if (prefHeight != -1.0) {
                    linear.setPrefHeight(prefHeight);
                }
                if (layoutX != -1.0) {
                    linear.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    linear.setLayoutY(layoutY);
                }
                super.applyTo((Control)linear);
                return linear;
            }
            case RADIAL_HALF_N: {
                RadialHalfN radialHalfN = new RadialHalfN(gaugeModel, styleModel);
                radialHalfN.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialHalfN.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialHalfN.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialHalfN);
                return radialHalfN;
            }
            case RADIAL_HALF_S: {
                RadialHalfS radialHalfS = new RadialHalfS(gaugeModel, styleModel);
                radialHalfS.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialHalfS.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialHalfS.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialHalfS);
                return radialHalfS;
            }
            case RADIAL_QUARTER_N: {
                RadialQuarterN radialQuarterN = new RadialQuarterN(gaugeModel, styleModel);
                radialQuarterN.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialQuarterN.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialQuarterN.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialQuarterN);
                return radialQuarterN;
            }
            case RADIAL_QUARTER_E: {
                RadialQuarterE radialQuarterE = new RadialQuarterE(gaugeModel, styleModel);
                radialQuarterE.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialQuarterE.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialQuarterE.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialQuarterE);
                return radialQuarterE;
            }
            case RADIAL_QUARTER_S: {
                RadialQuarterS radialQuarterS = new RadialQuarterS(gaugeModel, styleModel);
                radialQuarterS.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialQuarterS.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialQuarterS.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialQuarterS);
                return radialQuarterS;
            }
            case RADIAL_QUARTER_W: {
                RadialQuarterW radialQuarterW = new RadialQuarterW(gaugeModel, styleModel);
                radialQuarterW.setPrefSize(SIZE, SIZE);
                if (layoutX != -1.0) {
                    radialQuarterW.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    radialQuarterW.setLayoutY(layoutY);
                }
                super.applyTo((Control)radialQuarterW);
                return radialQuarterW;
            }
            case SIMPLE_RADIAL_GAUGE: {
                SimpleRadialGauge simpleRadialGauge = new SimpleRadialGauge(gaugeModel);
                simpleRadialGauge.setPrefSize(SIZE, SIZE);
                simpleRadialGauge.setRadialRange(Gauge.RadialRange.RADIAL_300);
                if (layoutX != -1.0) {
                    simpleRadialGauge.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    simpleRadialGauge.setLayoutY(layoutY);
                }
                super.applyTo((Control)simpleRadialGauge);
                return simpleRadialGauge;
            }
            case SIMPLE_LINEAR_GAUGE: {
                SimpleLinearGauge simpleLinearGauge = new SimpleLinearGauge();
                if (prefWidth != -1.0) {
                    simpleLinearGauge.setPrefWidth(prefWidth);
                }
                if (prefHeight != -1.0) {
                    simpleLinearGauge.setPrefHeight(prefHeight);
                }
                if (layoutX != -1.0) {
                    simpleLinearGauge.setLayoutX(layoutX);
                }
                if (layoutY != -1.0) {
                    simpleLinearGauge.setLayoutY(layoutY);
                }
                super.applyTo((Control)simpleLinearGauge);
                return simpleLinearGauge;
            }
        }
        Radial radial = new Radial(gaugeModel, styleModel);
        if (radialRange == Gauge.RadialRange.RADIAL_90 || radialRange == Gauge.RadialRange.RADIAL_180 || radialRange == Gauge.RadialRange.RADIAL_270 || radialRange == Gauge.RadialRange.RADIAL_300 || radialRange == Gauge.RadialRange.RADIAL_360) {
            radial.setRadialRange(radialRange);
        }
        radial.setPrefSize(SIZE, SIZE);
        if (layoutX != -1.0) {
            radial.setLayoutX(layoutX);
        }
        if (layoutY != -1.0) {
            radial.setLayoutY(layoutY);
        }
        super.applyTo((Control)radial);
        return radial;
    }

    public final B gaugeModel(GaugeModel GAUGE_MODEL) {
        this.gaugeProperties.put("gaugeModel", (Property)new SimpleObjectProperty((Object)GAUGE_MODEL));
        return (B)((Object)this);
    }

    public final B gaugeType(GaugeType GAUGE_TYPE) {
        this.gaugeProperties.put("gaugeType", (Property)new SimpleObjectProperty((Object)GAUGE_TYPE));
        return (B)((Object)this);
    }

    public final B value(double VALUE) {
        this.gaugeProperties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)((Object)this);
    }

    public final GaugeBuilder valueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.gaugeProperties.put("valueAnimationEnabled", (Property)new SimpleBooleanProperty(VALUE_ANIMATION_ENABLED));
        return this;
    }

    public final GaugeBuilder animationDuration(double ANIMATION_DURATION) {
        this.gaugeProperties.put("animationDuration", (Property)new SimpleDoubleProperty(ANIMATION_DURATION));
        return this;
    }

    public final GaugeBuilder redrawTolerance(double REDRAW_TOLERANCE) {
        this.gaugeProperties.put("redrawTolerance", (Property)new SimpleDoubleProperty(REDRAW_TOLERANCE));
        return this;
    }

    public final GaugeBuilder minValue(double MIN_VALUE) {
        this.gaugeProperties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return this;
    }

    public final GaugeBuilder maxValue(double MAX_VALUE) {
        this.gaugeProperties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return this;
    }

    public final GaugeBuilder threshold(double THRESHOLD) {
        this.gaugeProperties.put("threshold", (Property)new SimpleDoubleProperty(THRESHOLD));
        return this;
    }

    public final GaugeBuilder thresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeProperties.put("thresholdBehaviorInverted", (Property)new SimpleBooleanProperty(THRESHOLD_BEHAVIOR_INVERTED));
        return this;
    }

    public final GaugeBuilder radialRange(Gauge.RadialRange RADIAL_RANGE) {
        this.gaugeProperties.put("radialRange", (Property)new SimpleObjectProperty((Object)RADIAL_RANGE));
        return this;
    }

    public final GaugeBuilder title(String TITLE) {
        this.gaugeProperties.put("title", (Property)new SimpleStringProperty(TITLE));
        return this;
    }

    public final GaugeBuilder unit(String UNIT) {
        this.gaugeProperties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return this;
    }

    public final GaugeBuilder lcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.gaugeProperties.put("lcdValueCoupled", (Property)new SimpleBooleanProperty(LCD_VALUE_COUPLED));
        return this;
    }

    public final GaugeBuilder lcdThreshold(double LCD_THRESHOLD) {
        this.gaugeProperties.put("lcdThreshold", (Property)new SimpleDoubleProperty(LCD_THRESHOLD));
        return this;
    }

    public final GaugeBuilder lcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeProperties.put("lcdThresholdBehaviorInverted", (Property)new SimpleBooleanProperty(LCD_THRESHOLD_BEHAVIOR_INVERTED));
        return this;
    }

    public final GaugeBuilder lcdUnitString(String LCD_UNIT_STRING) {
        this.gaugeProperties.put("lcdUnitString", (Property)new SimpleStringProperty(LCD_UNIT_STRING));
        return this;
    }

    public final GaugeBuilder lcdNumberSystem(Gauge.NumberSystem LCD_NUMBER_SYSTEM) {
        this.gaugeProperties.put("lcdNumberSystem", (Property)new SimpleObjectProperty((Object)LCD_NUMBER_SYSTEM));
        return this;
    }

    public final GaugeBuilder maxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.gaugeProperties.put("maxNoOfMajorTicks", (Property)new SimpleIntegerProperty(MAX_NO_OF_MAJOR_TICKS));
        return this;
    }

    public final GaugeBuilder maxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.gaugeProperties.put("maxNoOfMinorTicks", (Property)new SimpleIntegerProperty(MAX_NO_OF_MINOR_TICKS));
        return this;
    }

    public final GaugeBuilder majorTickSpacing(double MAJOR_TICK_SPACING) {
        this.gaugeProperties.put("majorTickSpacing", (Property)new SimpleDoubleProperty(MAJOR_TICK_SPACING));
        return this;
    }

    public final GaugeBuilder minorTickSpacing(double MINOR_TICK_SPACING) {
        this.gaugeProperties.put("minorTickSpacing", (Property)new SimpleDoubleProperty(MINOR_TICK_SPACING));
        return this;
    }

    public final GaugeBuilder trend(Gauge.Trend TREND) {
        this.gaugeProperties.put("trend", (Property)new SimpleObjectProperty((Object)TREND));
        return this;
    }

    public final GaugeBuilder niceScaling(boolean NICE_SCALING) {
        this.gaugeProperties.put("niceScaling", (Property)new SimpleBooleanProperty(NICE_SCALING));
        return this;
    }

    public final GaugeBuilder tightScale(boolean TIGHT_SCALE) {
        this.gaugeProperties.put("tightScale", (Property)new SimpleBooleanProperty(TIGHT_SCALE));
        return this;
    }

    public final GaugeBuilder largeNumberScale(boolean LARGE_NUMBER_SCALE) {
        this.gaugeProperties.put("largeNumberScale", (Property)new SimpleBooleanProperty(LARGE_NUMBER_SCALE));
        return this;
    }

    public final GaugeBuilder lastLabelVisible(boolean LAST_LABEL_VISIBLE) {
        this.gaugeProperties.put("lastLabelVisible", (Property)new SimpleBooleanProperty(LAST_LABEL_VISIBLE));
        return this;
    }

    public final GaugeBuilder sections(Section ... SECTION_ARRAY) {
        this.gaugeProperties.put("sectionsArray", (Property)new SimpleObjectProperty((Object)SECTION_ARRAY));
        return this;
    }

    public final GaugeBuilder sections(List<Section> SECTIONS) {
        this.gaugeProperties.put("sectionsList", (Property)new SimpleObjectProperty(SECTIONS));
        return this;
    }

    public final GaugeBuilder areas(Section ... AREAS_ARRAY) {
        this.gaugeProperties.put("areasArray", (Property)new SimpleObjectProperty((Object)AREAS_ARRAY));
        return this;
    }

    public final GaugeBuilder areas(List<Section> AREAS) {
        this.gaugeProperties.put("areasList", (Property)new SimpleObjectProperty(AREAS));
        return this;
    }

    public final GaugeBuilder markers(Marker ... MARKER_ARRAY) {
        this.gaugeProperties.put("markersArray", (Property)new SimpleObjectProperty((Object)MARKER_ARRAY));
        return this;
    }

    public final GaugeBuilder markers(List<Marker> MARKERS) {
        this.gaugeProperties.put("markersList", (Property)new SimpleObjectProperty(MARKERS));
        return this;
    }

    public final GaugeBuilder endlessMode(boolean ENDLESS_MODE) {
        this.gaugeProperties.put("endlessMode", (Property)new SimpleBooleanProperty(ENDLESS_MODE));
        return this;
    }

    public final B prefWidth(double WIDTH) {
        this.gaugeProperties.put("prefWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)((Object)this);
    }

    public final B prefHeight(double HEIGHT) {
        this.gaugeProperties.put("prefHeight", (Property)new SimpleDoubleProperty(HEIGHT));
        return (B)((Object)this);
    }

    public final B layoutX(double LAYOUT_X) {
        this.gaugeProperties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)((Object)this);
    }

    public final B layoutY(double LAYOUT_Y) {
        this.gaugeProperties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)((Object)this);
    }

    public final B styleModel(StyleModel STYLE_MODEL) {
        this.styleProperties.put("styleModel", (Property)new SimpleObjectProperty((Object)STYLE_MODEL));
        return (B)((Object)this);
    }

    public final GaugeBuilder bargraph(boolean BARGRAPH) {
        this.styleProperties.put("bargraph", (Property)new SimpleBooleanProperty(BARGRAPH));
        return this;
    }

    public final GaugeBuilder minMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.styleProperties.put("minMeasuredValueVisible", (Property)new SimpleBooleanProperty(MIN_MEASURED_VALUE_VISIBLE));
        return this;
    }

    public final GaugeBuilder maxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.styleProperties.put("maxMeasuredValueVisible", (Property)new SimpleBooleanProperty(MAX_MEASURED_VALUE_VISIBLE));
        return this;
    }

    public final GaugeBuilder thresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.styleProperties.put("thresholdVisible", (Property)new SimpleBooleanProperty(THRESHOLD_VISIBLE));
        return this;
    }

    public final GaugeBuilder thresholdColor(Gauge.ThresholdColor THRESHOLD_COLOR) {
        this.styleProperties.put("thresholdColor", (Property)new SimpleObjectProperty((Object)THRESHOLD_COLOR));
        return this;
    }

    public final GaugeBuilder frameDesign(Gauge.FrameDesign FRAME_DESIGN) {
        this.styleProperties.put("frameDesign", (Property)new SimpleObjectProperty((Object)FRAME_DESIGN));
        return this;
    }

    public final GaugeBuilder frameBaseColor(Color FRAME_BASE_COLOR) {
        this.styleProperties.put("frameBaseColor", (Property)new SimpleObjectProperty((Object)FRAME_BASE_COLOR));
        return this;
    }

    public final GaugeBuilder frameVisible(boolean FRAME_VISIBLE) {
        this.styleProperties.put("frameVisible", (Property)new SimpleBooleanProperty(FRAME_VISIBLE));
        return this;
    }

    public final GaugeBuilder backgroundDesign(Gauge.BackgroundDesign BACKGROUND_DESIGN) {
        this.styleProperties.put("backgroundDesign", (Property)new SimpleObjectProperty((Object)BACKGROUND_DESIGN));
        return this;
    }

    public final GaugeBuilder backgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.styleProperties.put("backgroundVisible", (Property)new SimpleBooleanProperty(BACKGROUND_VISIBLE));
        return this;
    }

    public final GaugeBuilder knobDesign(Gauge.KnobDesign KNOB_DESIGN) {
        this.styleProperties.put("knobDesign", (Property)new SimpleObjectProperty((Object)KNOB_DESIGN));
        return this;
    }

    public final GaugeBuilder knobColor(Gauge.KnobColor KNOB_COLOR) {
        this.styleProperties.put("knobColor", (Property)new SimpleObjectProperty((Object)KNOB_COLOR));
        return this;
    }

    public final GaugeBuilder knobsVisible(boolean KNOBS_VISIBLE) {
        this.styleProperties.put("knobsVisible", (Property)new SimpleBooleanProperty(KNOBS_VISIBLE));
        return this;
    }

    public final GaugeBuilder pointerType(Gauge.PointerType POINTER_TYPE) {
        this.styleProperties.put("pointerType", (Property)new SimpleObjectProperty((Object)POINTER_TYPE));
        return this;
    }

    public final GaugeBuilder valueColor(ColorDef VALUE_COLOR) {
        this.styleProperties.put("valueColor", (Property)new SimpleObjectProperty((Object)VALUE_COLOR));
        return this;
    }

    public final GaugeBuilder pointerGlowEnabled(boolean POINTER_GLOW_ENABLED) {
        this.styleProperties.put("pointerGlowEnabled", (Property)new SimpleBooleanProperty(POINTER_GLOW_ENABLED));
        return this;
    }

    public final GaugeBuilder pointerShadowEnabled(boolean POINTER_SHADOW_ENABLED) {
        this.styleProperties.put("pointerShadowEnabled", (Property)new SimpleBooleanProperty(POINTER_SHADOW_ENABLED));
        return this;
    }

    public final GaugeBuilder ledVisible(boolean LED_VISIBLE) {
        this.styleProperties.put("ledVisible", (Property)new SimpleBooleanProperty(LED_VISIBLE));
        return this;
    }

    public final GaugeBuilder ledColor(LedColor LED_COLOR) {
        this.styleProperties.put("ledColor", (Property)new SimpleObjectProperty((Object)LED_COLOR));
        return this;
    }

    public final GaugeBuilder userLedVisible(boolean USER_LED_VISIBLE) {
        this.styleProperties.put("userLedVisible", (Property)new SimpleBooleanProperty(USER_LED_VISIBLE));
        return this;
    }

    public final GaugeBuilder userLedColor(LedColor USER_LED_COLOR) {
        this.styleProperties.put("userLedColor", (Property)new SimpleObjectProperty((Object)USER_LED_COLOR));
        return this;
    }

    public final GaugeBuilder userLedOn(boolean USER_LED_ON) {
        this.styleProperties.put("userLedOn", (Property)new SimpleBooleanProperty(USER_LED_ON));
        return this;
    }

    public final GaugeBuilder userLedBlinking(boolean USER_LED_BLINKING) {
        this.styleProperties.put("userLedBlinking", (Property)new SimpleBooleanProperty(USER_LED_BLINKING));
        return this;
    }

    public final GaugeBuilder titleFont(String TITLE_FONT) {
        this.styleProperties.put("titleFont", (Property)new SimpleStringProperty(TITLE_FONT));
        return this;
    }

    public final GaugeBuilder unitfont(String UNIT_FONT) {
        this.styleProperties.put("unitFont", (Property)new SimpleStringProperty(UNIT_FONT));
        return this;
    }

    public final GaugeBuilder foregroundType(Radial.ForegroundType FOREGROUND_TYPE) {
        this.styleProperties.put("foregroundType", (Property)new SimpleObjectProperty((Object)FOREGROUND_TYPE));
        return this;
    }

    public final GaugeBuilder foregroundVisible(boolean FOREGROUND_VISIBLE) {
        this.styleProperties.put("foregroundVisible", (Property)new SimpleBooleanProperty(FOREGROUND_VISIBLE));
        return this;
    }

    public final GaugeBuilder lcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.styleProperties.put("lcdThresholdVisible", (Property)new SimpleBooleanProperty(LCD_THRESHOLD_VISIBLE));
        return this;
    }

    public final GaugeBuilder lcdDesign(LcdDesign LCD_Design) {
        this.styleProperties.put("lcdDesign", (Property)new SimpleObjectProperty((Object)LCD_Design));
        return this;
    }

    public final GaugeBuilder lcdVisible(boolean LCD_VISIBLE) {
        this.styleProperties.put("lcdVisible", (Property)new SimpleBooleanProperty(LCD_VISIBLE));
        return this;
    }

    public final GaugeBuilder lcdUnitStringVisible(boolean LCD_UNIT_STRING_VISIBLE) {
        this.styleProperties.put("lcdUnitStringVisible", (Property)new SimpleBooleanProperty(LCD_UNIT_STRING_VISIBLE));
        return this;
    }

    public final GaugeBuilder lcdNumberSystemVisible(boolean NUMBER_SYSTEM_VISIBLE) {
        this.styleProperties.put("lcdNumberSystemVisible", (Property)new SimpleBooleanProperty(NUMBER_SYSTEM_VISIBLE));
        return this;
    }

    public final GaugeBuilder lcdUnitFont(String UNIT_FONT) {
        this.styleProperties.put("lcdUnitFont", (Property)new SimpleStringProperty(UNIT_FONT));
        return this;
    }

    public final GaugeBuilder lcdTitleFont(String TITLE_FONT) {
        this.styleProperties.put("lcdTitleFont", (Property)new SimpleStringProperty(TITLE_FONT));
        return this;
    }

    public final GaugeBuilder lcdValueFont(Gauge.LcdFont VALUE_FONT) {
        this.styleProperties.put("lcdValueFont", (Property)new SimpleObjectProperty((Object)VALUE_FONT));
        return this;
    }

    public final GaugeBuilder lcdDecimals(int LCD_DECIMALS) {
        this.styleProperties.put("lcdDecimals", (Property)new SimpleIntegerProperty(LCD_DECIMALS));
        return this;
    }

    public final GaugeBuilder lcdBlinking(boolean LCD_BLINKING) {
        this.styleProperties.put("lcdBlinking", (Property)new SimpleBooleanProperty(LCD_BLINKING));
        return this;
    }

    public final GaugeBuilder lcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.styleProperties.put("lcdBackgroundVisible", (Property)new SimpleBooleanProperty(LCD_BACKGROUND_VISIBLE));
        return this;
    }

    public final GaugeBuilder glowVisible(boolean GLOW_VISIBLE) {
        this.styleProperties.put("glowVisible", (Property)new SimpleBooleanProperty(GLOW_VISIBLE));
        return this;
    }

    public final GaugeBuilder glowOn(boolean GLOW_ON) {
        this.styleProperties.put("glowOn", (Property)new SimpleBooleanProperty(GLOW_ON));
        return this;
    }

    public final GaugeBuilder pulsatingGlow(boolean PULSATING_GLOW) {
        this.styleProperties.put("pulsatingGlow", (Property)new SimpleBooleanProperty(PULSATING_GLOW));
        return this;
    }

    public final GaugeBuilder glowColor(Color GLOW_COLOR) {
        this.styleProperties.put("glowColor", (Property)new SimpleObjectProperty((Object)GLOW_COLOR));
        return this;
    }

    public final GaugeBuilder tickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.styleProperties.put("tickmarksVisible", (Property)new SimpleBooleanProperty(TICKMARKS_VISIBLE));
        return this;
    }

    public final GaugeBuilder majorTickmarksVisible(boolean MAJOR_TICKMARKS_VISIBLE) {
        this.styleProperties.put("majorTickmarksVisible", (Property)new SimpleBooleanProperty(MAJOR_TICKMARKS_VISIBLE));
        return this;
    }

    public final GaugeBuilder majorTickmarkType(Gauge.TickmarkType TICKMARK_TYPE) {
        this.styleProperties.put("majorTickmarkType", (Property)new SimpleObjectProperty((Object)TICKMARK_TYPE));
        return this;
    }

    public final GaugeBuilder majorTickmarkColor(Color MAJOR_TICKMAKR_COLOR) {
        this.styleProperties.put("majorTickmarkColor", (Property)new SimpleObjectProperty((Object)MAJOR_TICKMAKR_COLOR));
        return this;
    }

    public final GaugeBuilder majorTickmarkColorEnabled(boolean MAJOR_TICKMARK_COLOR_ENABLED) {
        this.styleProperties.put("majorTickmarkColorEnabled", (Property)new SimpleBooleanProperty(MAJOR_TICKMARK_COLOR_ENABLED));
        return this;
    }

    public final GaugeBuilder minorTickmarksVisible(boolean MINOR_TICKMARKS_VISIBLE) {
        this.styleProperties.put("minorTickmarksVisible", (Property)new SimpleBooleanProperty(MINOR_TICKMARKS_VISIBLE));
        return this;
    }

    public final GaugeBuilder minorTickmarkColor(Color MINOR_TICKMARK_COLOR) {
        this.styleProperties.put("minorTickmarkColor", (Property)new SimpleObjectProperty((Object)MINOR_TICKMARK_COLOR));
        return this;
    }

    public final GaugeBuilder minorTickmarkColorEnabled(boolean MINOR_TICKMARK_COLOR_ENABLED) {
        this.styleProperties.put("minorTickmarkColorEnabled", (Property)new SimpleBooleanProperty(MINOR_TICKMARK_COLOR_ENABLED));
        return this;
    }

    public final GaugeBuilder tickLabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.styleProperties.put("tickLablesVisible", (Property)new SimpleBooleanProperty(TICKLABELS_VISIBLE));
        return this;
    }

    public final GaugeBuilder tickLabelOrientation(Gauge.TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.styleProperties.put("tickLabelOrientation", (Property)new SimpleObjectProperty((Object)TICKLABEL_ORIENTATION));
        return this;
    }

    public final GaugeBuilder tickLabelNumberFormat(Gauge.NumberFormat TICKLABEL_NUMBER_FORMAT) {
        this.styleProperties.put("tickLabelNumberFormat", (Property)new SimpleObjectProperty((Object)TICKLABEL_NUMBER_FORMAT));
        return this;
    }

    public final GaugeBuilder tickmarkGlowEnabled(boolean TICKMARK_GLOW_ENABLED) {
        this.styleProperties.put("tickmarkGlowEnabled", (Property)new SimpleBooleanProperty(TICKMARK_GLOW_ENABLED));
        return this;
    }

    public final GaugeBuilder tickmarkGlowColor(Color TICKMARK_GLOW_COLOR) {
        this.styleProperties.put("tickmarkGlowColor", (Property)new SimpleObjectProperty((Object)TICKMARK_GLOW_COLOR));
        return this;
    }

    public final GaugeBuilder sectionsVisible(boolean SECTIONS_VISIBLE) {
        this.styleProperties.put("sectionsVisible", (Property)new SimpleBooleanProperty(SECTIONS_VISIBLE));
        return this;
    }

    public final GaugeBuilder sectionsHighlighting(boolean SECTIONS_HIGHLIGHTING) {
        this.styleProperties.put("sectionsHighlighting", (Property)new SimpleBooleanProperty(SECTIONS_HIGHLIGHTING));
        return this;
    }

    public final GaugeBuilder showSectionTickmarksOnly(boolean SHOW_SECTION_TICKMARKS_ONLY) {
        this.styleProperties.put("showSectionTickmarksOnly", (Property)new SimpleBooleanProperty(SHOW_SECTION_TICKMARKS_ONLY));
        return this;
    }

    public final GaugeBuilder areasVisible(boolean AREAS_VISIBLE) {
        this.styleProperties.put("areasVisible", (Property)new SimpleBooleanProperty(AREAS_VISIBLE));
        return this;
    }

    public final GaugeBuilder areasHighlighting(boolean AREAS_HIGHLIGHTING) {
        this.styleProperties.put("areasHighlighting", (Property)new SimpleBooleanProperty(AREAS_HIGHLIGHTING));
        return this;
    }

    public final GaugeBuilder markersVisible(boolean MARKERS_VISIBLE) {
        this.styleProperties.put("markersVisible", (Property)new SimpleBooleanProperty(MARKERS_VISIBLE));
        return this;
    }

    public final GaugeBuilder textureColor(Color TEXTURE_COLOR) {
        this.styleProperties.put("textureColor", (Property)new SimpleObjectProperty((Object)TEXTURE_COLOR));
        return this;
    }

    public final GaugeBuilder simpleGradientBaseColor(Color SIMPLE_GRADIENT_BASE_COLOR) {
        this.styleProperties.put("simpleGradientBaseColor", (Property)new SimpleObjectProperty((Object)SIMPLE_GRADIENT_BASE_COLOR));
        return this;
    }

    public final GaugeBuilder titleVisible(boolean TITLE_VISIBLE) {
        this.styleProperties.put("titleVisible", (Property)new SimpleBooleanProperty(TITLE_VISIBLE));
        return this;
    }

    public final GaugeBuilder unitVisible(boolean UNIT_VISIBLE) {
        this.styleProperties.put("unitVisible", (Property)new SimpleBooleanProperty(UNIT_VISIBLE));
        return this;
    }

    public final GaugeBuilder trendVisible(boolean TREND_VISIBLE) {
        this.styleProperties.put("trendVisible", (Property)new SimpleBooleanProperty(TREND_VISIBLE));
        return this;
    }

    public final GaugeBuilder trendUpColor(Color TREND_UP_COLOR) {
        this.styleProperties.put("trendUpColor", (Property)new SimpleObjectProperty((Object)TREND_UP_COLOR));
        return this;
    }

    public final GaugeBuilder trendRisingColor(Color TREND_RISING_COLOR) {
        this.styleProperties.put("trendRisingColor", (Property)new SimpleObjectProperty((Object)TREND_RISING_COLOR));
        return this;
    }

    public final GaugeBuilder trendSteadyColor(Color TREND_STEADY_COLOR) {
        this.styleProperties.put("trendSteadyColor", (Property)new SimpleObjectProperty((Object)TREND_STEADY_COLOR));
        return this;
    }

    public final GaugeBuilder trendFallingColor(Color TREND_FALLING_COLOR) {
        this.styleProperties.put("trendFallingColor", (Property)new SimpleObjectProperty((Object)TREND_FALLING_COLOR));
        return this;
    }

    public final GaugeBuilder trendDownColor(Color TREND_DOWN_COLOR) {
        this.styleProperties.put("trendDownColor", (Property)new SimpleObjectProperty((Object)TREND_DOWN_COLOR));
        return this;
    }

    public static enum GaugeType {
        LCD,
        LINEAR,
        RADIAL_HALF_N,
        RADIAL_HALF_S,
        RADIAL_QUARTER_N,
        RADIAL_QUARTER_E,
        RADIAL_QUARTER_S,
        RADIAL_QUARTER_W,
        RADIAL,
        SIMPLE_RADIAL_GAUGE,
        SIMPLE_LINEAR_GAUGE;

    }
}

