/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.ControlBuilder;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.LinearScale;

public class LinearScaleBuilder<B extends LinearScaleBuilder<B>>
extends ControlBuilder<B>
implements Builder<LinearScale> {
    private Map<String, Property> properties = new HashMap<String, Property>();

    protected LinearScaleBuilder() {
    }

    public static LinearScaleBuilder create() {
        return new LinearScaleBuilder();
    }

    public final LinearScaleBuilder minValue(double MIN_VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return this;
    }

    public final LinearScaleBuilder maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return this;
    }

    public final LinearScaleBuilder niceScaling(boolean NICE_SCALING) {
        this.properties.put("niceScaling", (Property)new SimpleBooleanProperty(NICE_SCALING));
        return this;
    }

    public final LinearScaleBuilder maxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.properties.put("maxNoOfMajorTicks", (Property)new SimpleIntegerProperty(MAX_NO_OF_MAJOR_TICKS));
        return this;
    }

    public final LinearScaleBuilder maxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.properties.put("maxNoOfMinorTicks", (Property)new SimpleIntegerProperty(MAX_NO_OF_MINOR_TICKS));
        return this;
    }

    public final LinearScaleBuilder majorTickSpacing(double MAJOR_TICK_SPACING) {
        this.properties.put("majorTickSpacing", (Property)new SimpleDoubleProperty(MAJOR_TICK_SPACING));
        return this;
    }

    public final LinearScaleBuilder minorTickSpacing(double MINOR_TICK_SPACING) {
        this.properties.put("minorTickSpacing", (Property)new SimpleDoubleProperty(MINOR_TICK_SPACING));
        return this;
    }

    public final LinearScaleBuilder tightScale(boolean TIGHT_SCALE) {
        this.properties.put("tightScale", (Property)new SimpleBooleanProperty(TIGHT_SCALE));
        return this;
    }

    public final LinearScaleBuilder largeNumberScale(boolean LARGE_NUMBER_SCALE) {
        this.properties.put("largeNumberScale", (Property)new SimpleBooleanProperty(LARGE_NUMBER_SCALE));
        return this;
    }

    public LinearScale build() {
        LinearScale CONTROL = new LinearScale();
        for (String key : this.properties.keySet()) {
            if ("minValue".equals(key)) {
                CONTROL.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxValue".equals(key)) {
                CONTROL.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("niceScaling".equals(key)) {
                CONTROL.setNiceScaling(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxNoOfMajorTicks".equals(key)) {
                CONTROL.setMaxNoOfMajorTicks(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxNoOfMinorTicks".equals(key)) {
                CONTROL.setMaxNoOfMinorTicks(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tightScale".equals(key)) {
                CONTROL.setTightScale(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"largeNumberScale".equals(key)) continue;
            CONTROL.setLargeNumberScale(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

