/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.ControlBuilder;
import javafx.scene.paint.Color;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.Content;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.MatrixPanel;

public class MatrixPanelBuilder<B extends MatrixPanelBuilder<B>>
extends ControlBuilder<B>
implements Builder<MatrixPanel> {
    private HashMap<String, Property> properties = new HashMap();

    public static final MatrixPanelBuilder create() {
        return new MatrixPanelBuilder();
    }

    public final MatrixPanelBuilder ledWidth(int LED_WIDTH) {
        this.properties.put("ledWidth", (Property)new SimpleIntegerProperty(LED_WIDTH));
        return this;
    }

    public final MatrixPanelBuilder ledHeight(int LED_HEIGHT) {
        this.properties.put("ledHeight", (Property)new SimpleIntegerProperty(LED_HEIGHT));
        return this;
    }

    public final MatrixPanelBuilder contents(List<Content> CONTENTS) {
        this.properties.put("contentsList", (Property)new SimpleObjectProperty(CONTENTS));
        return this;
    }

    public final MatrixPanelBuilder contents(Content[] CONTENT_ARRAY) {
        this.properties.put("contentsArray", (Property)new SimpleObjectProperty((Object)CONTENT_ARRAY));
        return this;
    }

    public final MatrixPanelBuilder frameDesign(Gauge.FrameDesign FRAME_DESIGN) {
        this.properties.put("frameDesign", (Property)new SimpleObjectProperty((Object)FRAME_DESIGN));
        return this;
    }

    public final MatrixPanelBuilder frameBaseColor(Color FRAME_BASE_COLOR) {
        this.properties.put("frameBaseColor", (Property)new SimpleObjectProperty((Object)FRAME_BASE_COLOR));
        return this;
    }

    public final MatrixPanelBuilder frameVisible(boolean FRAME_VISIBLE) {
        this.properties.put("frameVisible", (Property)new SimpleBooleanProperty(FRAME_VISIBLE));
        return this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)((Object)this);
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)((Object)this);
    }

    public final MatrixPanel build() {
        MatrixPanel CONTROL = new MatrixPanel();
        for (String key : this.properties.keySet()) {
            if ("ledWidth".equals(key)) {
                CONTROL.setLedWidth(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledHeight".equals(key)) {
                CONTROL.setLedHeight(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("contentsList".equals(key)) {
                CONTROL.setContents((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("contentsArray".equals(key)) {
                CONTROL.setContents((Content[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("frameDesign".equals(key)) {
                CONTROL.setFrameDesign((Gauge.FrameDesign)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("frameBaseColor".equals(key)) {
                CONTROL.setFrameBaseColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"frameVisible".equals(key)) continue;
            CONTROL.setFrameVisible(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

