/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class Rater
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "rater";
    private ObjectProperty<Color> brightColor;
    private ObjectProperty<Color> darkColor;
    private IntegerProperty noOfStars;
    private IntegerProperty rating;

    public Rater() {
        this(Color.rgb((int)255, (int)231, (int)81), Color.rgb((int)255, (int)126, (int)18));
    }

    public Rater(Color BRIGHT_COLOR, Color DARK_COLOR) {
        this.brightColor = new SimpleObjectProperty((Object)BRIGHT_COLOR);
        this.darkColor = new SimpleObjectProperty((Object)DARK_COLOR);
        this.noOfStars = new SimpleIntegerProperty(5);
        this.rating = new SimpleIntegerProperty(0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final Color getDarkColor() {
        return (Color)this.darkColor.get();
    }

    public final void setDarkColor(Color DARK_COLOR) {
        this.darkColor.set((Object)DARK_COLOR);
    }

    public final ObjectProperty<Color> darkColorProperty() {
        return this.darkColor;
    }

    public final Color getBrightColor() {
        return (Color)this.brightColor.get();
    }

    public final void setBrightColor(Color BRIGHT_COLOR) {
        this.brightColor.set((Object)BRIGHT_COLOR);
    }

    public final ObjectProperty<Color> brightColorProperty() {
        return this.brightColor;
    }

    public final int getNoOfStars() {
        return this.noOfStars.get();
    }

    public final void setNoOfStars(int NO_OF_STARS) {
        this.noOfStars.set(NO_OF_STARS < 1 ? 1 : (NO_OF_STARS > 10 ? 10 : NO_OF_STARS));
    }

    public final IntegerProperty noOfStarsProperty() {
        return this.noOfStars;
    }

    public final int getRating() {
        return this.rating.get();
    }

    public final void setRating(int RATING) {
        this.rating.set(RATING < 0 ? 0 : (RATING > this.noOfStars.get() ? this.noOfStars.get() : RATING));
    }

    public final IntegerProperty ratingProperty() {
        return this.rating;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH < HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize((double)this.noOfStars.get() * SIZE, SIZE);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }
}

