/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.util.Util;

public class SectionBuilder
implements Builder<Section> {
    private HashMap<String, Property> properties = new HashMap();

    protected SectionBuilder() {
    }

    public static final SectionBuilder create() {
        return new SectionBuilder();
    }

    public final SectionBuilder start(double START) {
        this.properties.put("start", (Property)new SimpleDoubleProperty(START));
        return this;
    }

    public final SectionBuilder stop(double STOP) {
        this.properties.put("stop", (Property)new SimpleDoubleProperty(STOP));
        return this;
    }

    public final SectionBuilder color(Color COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)COLOR));
        return this;
    }

    public final SectionBuilder color(String COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)Util.webColorToColor(COLOR)));
        return this;
    }

    public final SectionBuilder highlightColor(Color HIGHLIGHT_COLOR) {
        this.properties.put("highlightColor", (Property)new SimpleObjectProperty((Object)HIGHLIGHT_COLOR));
        return this;
    }

    public final SectionBuilder sectionArea(Shape SECTION_AREA) {
        this.properties.put("sectionArea", (Property)new SimpleObjectProperty((Object)SECTION_AREA));
        return this;
    }

    public final SectionBuilder filledArea(Shape FILLED_AREA) {
        this.properties.put("filledArea", (Property)new SimpleObjectProperty((Object)FILLED_AREA));
        return this;
    }

    public final SectionBuilder text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return this;
    }

    public final Section build() {
        Section CONTROL = new Section();
        for (String key : this.properties.keySet()) {
            if ("start".equals(key)) {
                CONTROL.setStart(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stop".equals(key)) {
                CONTROL.setStop(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("color".equals(key)) {
                CONTROL.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightColor".equals(key)) {
                CONTROL.setHighlightColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionArea".equals(key)) {
                CONTROL.setSectionArea((Shape)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("filledArea".equals(key)) {
                CONTROL.setFilledArea((Shape)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"text".equals(key)) continue;
            CONTROL.setText((String)((StringProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

