/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class SevenSegment
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "seven-segment";
    private ObjectProperty<Color> color;
    private BooleanProperty plainColor;
    private StringProperty character;
    private BooleanProperty dotOn;
    private Map<Integer, List<Segment>> mapping;
    private ObjectProperty<Map<Integer, List<Segment>>> customSegmentMapping;

    public SevenSegment() {
        this(" ", Color.rgb((int)255, (int)126, (int)18));
    }

    public SevenSegment(String CHARACTER) {
        this(CHARACTER, Color.rgb((int)255, (int)126, (int)18));
    }

    public SevenSegment(String CHARACTER, Color COLOR) {
        this.color = new SimpleObjectProperty((Object)COLOR);
        this.plainColor = new SimpleBooleanProperty(false);
        this.character = new SimpleStringProperty(CHARACTER);
        this.dotOn = new SimpleBooleanProperty(false);
        this.mapping = new HashMap<Integer, List<Segment>>(42);
        this.initMapping();
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    private void initMapping() {
        this.mapping.put(20, Arrays.asList(new Segment[0]));
        this.mapping.put(46, Arrays.asList(Segment.DOT));
        this.mapping.put(48, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.E, Segment.F));
        this.mapping.put(49, Arrays.asList(Segment.B, Segment.C));
        this.mapping.put(50, Arrays.asList(Segment.A, Segment.B, Segment.D, Segment.E, Segment.G));
        this.mapping.put(51, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.G));
        this.mapping.put(52, Arrays.asList(Segment.B, Segment.C, Segment.F, Segment.G));
        this.mapping.put(53, Arrays.asList(Segment.A, Segment.C, Segment.D, Segment.F, Segment.G));
        this.mapping.put(54, Arrays.asList(Segment.A, Segment.C, Segment.D, Segment.E, Segment.F, Segment.G));
        this.mapping.put(55, Arrays.asList(Segment.A, Segment.B, Segment.C));
        this.mapping.put(56, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.E, Segment.F, Segment.G));
        this.mapping.put(57, Arrays.asList(Segment.A, Segment.B, Segment.C, Segment.D, Segment.F, Segment.G));
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final boolean isPlainColor() {
        return this.plainColor.get();
    }

    public final void setPlainColor(boolean PLAIN_COLOR) {
        this.plainColor.set(PLAIN_COLOR);
    }

    public final BooleanProperty plainColorProperty() {
        return this.plainColor;
    }

    public final String getCharacter() {
        return (String)this.character.get();
    }

    public final void setCharacter(String CHARACTER) {
        this.character.set((Object)CHARACTER);
    }

    public final void setCharacter(Character CHARACTER) {
        this.character.set((Object)String.valueOf(CHARACTER));
    }

    public final void setCharacter(int CHARACTER) {
        this.character.set((Object)Integer.toString(CHARACTER));
    }

    public final StringProperty characterProperty() {
        return this.character;
    }

    public final boolean isDotOn() {
        return this.dotOn.get();
    }

    public final void setDotOn(boolean DOT_ON) {
        this.dotOn.set(DOT_ON);
    }

    public final BooleanProperty dotOnProperty() {
        return this.dotOn;
    }

    public final Map<Integer, List<Segment>> getCustomSegmentMapping() {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        return (Map)this.customSegmentMapping.get();
    }

    public final void setCustomSegmentMapping(Map<Integer, List<Segment>> CUSTOM_SEGMENT_MAPPING) {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        ((Map)this.customSegmentMapping.get()).clear();
        for (int key : CUSTOM_SEGMENT_MAPPING.keySet()) {
            ((Map)this.customSegmentMapping.get()).put(key, CUSTOM_SEGMENT_MAPPING.get(key));
        }
    }

    public final ObjectProperty<Map<Integer, List<Segment>>> customSegmentMappingProperty() {
        if (this.customSegmentMapping == null) {
            this.customSegmentMapping = new SimpleObjectProperty(new HashMap());
        }
        return this.customSegmentMapping;
    }

    public final Map<Integer, List<Segment>> getSegmentMapping() {
        HashMap<Integer, List<Segment>> segmentMapping = new HashMap<Integer, List<Segment>>(42);
        for (int key : this.mapping.keySet()) {
            segmentMapping.put(key, this.mapping.get(key));
        }
        return segmentMapping;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double width = WIDTH <= HEIGHT ? WIDTH : HEIGHT / 1.5;
        double height = WIDTH <= HEIGHT ? WIDTH * 1.5 : HEIGHT;
        super.setPrefSize(width, height);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    public static enum Segment {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        DOT;

    }
}

