/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.ControlBuilder;
import javafx.scene.paint.Color;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.SimpleGauge;
import jfxtras.labs.scene.control.gauge.SimpleLinearGauge;
import jfxtras.labs.scene.control.gauge.SimpleRadialGauge;

public class SimpleGaugeBuilder<B extends SimpleGaugeBuilder<B>>
extends ControlBuilder<B>
implements Builder<SimpleGauge> {
    private HashMap<String, Property> properties = new HashMap();

    protected SimpleGaugeBuilder() {
    }

    public static final SimpleGaugeBuilder create() {
        return new SimpleGaugeBuilder();
    }

    public final SimpleGaugeBuilder type(GaugeType TYPE) {
        this.properties.put("TYPE", (Property)new SimpleObjectProperty((Object)TYPE));
        return this;
    }

    public final SimpleGaugeBuilder model(GaugeModel MODEL) {
        this.properties.put("MODEL", (Property)new SimpleObjectProperty((Object)MODEL));
        return this;
    }

    public final SimpleGaugeBuilder minValue(double MIN_VALUE) {
        this.properties.put("MIN_VALUE", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return this;
    }

    public final SimpleGaugeBuilder maxValue(double MAX_VALUE) {
        this.properties.put("MAX_VALUE", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return this;
    }

    public final SimpleGaugeBuilder value(double VALUE) {
        this.properties.put("VALUE", (Property)new SimpleDoubleProperty(VALUE));
        return this;
    }

    public final SimpleGaugeBuilder valueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.properties.put("VALUE_ANIMATION_ENABLED", (Property)new SimpleBooleanProperty(VALUE_ANIMATION_ENABLED));
        return this;
    }

    public final SimpleGaugeBuilder barColor(Color BAR_COLOR) {
        this.properties.put("BAR_COLOR", (Property)new SimpleObjectProperty((Object)BAR_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder barWidth(double BAR_WIDTH) {
        this.properties.put("BAR_WIDTH", (Property)new SimpleDoubleProperty(BAR_WIDTH));
        return this;
    }

    public final SimpleGaugeBuilder valueLabelFontSize(double LABEL_FONT_SIZE) {
        this.properties.put("LABEL_FONT_SIZE", (Property)new SimpleDoubleProperty(LABEL_FONT_SIZE));
        return this;
    }

    public final SimpleGaugeBuilder unitFontSize(double UNIT_FONT_SIZE) {
        this.properties.put("UNIT_FONT_SIZE", (Property)new SimpleDoubleProperty(UNIT_FONT_SIZE));
        return this;
    }

    public final SimpleGaugeBuilder noOfDecimals(int NO_OF_DECIMALS) {
        this.properties.put("NO_OF_DECIMALS", (Property)new SimpleIntegerProperty(NO_OF_DECIMALS));
        return this;
    }

    public final SimpleGaugeBuilder sections(Section[] SECTIONS) {
        this.properties.put("SECTIONS_ARRAY", (Property)new SimpleObjectProperty((Object)SECTIONS));
        return this;
    }

    public final SimpleGaugeBuilder sections(List<Section> SECTIONS) {
        this.properties.put("SECTIONS_LIST", (Property)new SimpleObjectProperty(SECTIONS));
        return this;
    }

    public final SimpleGaugeBuilder unit(String UNIT) {
        this.properties.put("UNIT", (Property)new SimpleStringProperty(UNIT));
        return this;
    }

    public final SimpleGaugeBuilder barFrameColor(Color BAR_FRAME_COLOR) {
        this.properties.put("BAR_FRAME_COLOR", (Property)new SimpleObjectProperty((Object)BAR_FRAME_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder barBackgroundColor(Color BAR_BACKGROUND_COLOR) {
        this.properties.put("BAR_BACKGROUND_COLOR", (Property)new SimpleObjectProperty((Object)BAR_BACKGROUND_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder valueLabelColor(Color VALUE_LABEL_COLOR) {
        this.properties.put("VALUE_LABEL_COLOR", (Property)new SimpleObjectProperty((Object)VALUE_LABEL_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder unitLabelColor(Color UNIT_LABEL_COLOR) {
        this.properties.put("UNIT_LABEL_COLOR", (Property)new SimpleObjectProperty((Object)UNIT_LABEL_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder minLabelVisible(boolean MIN_LABEL_VISIBLE) {
        this.properties.put("MIN_LABEL_VISIBLE", (Property)new SimpleBooleanProperty(MIN_LABEL_VISIBLE));
        return this;
    }

    public final SimpleGaugeBuilder maxLabelVisible(boolean MAX_LABEL_VISIBLE) {
        this.properties.put("MAX_LABEL_VISIBLE", (Property)new SimpleBooleanProperty(MAX_LABEL_VISIBLE));
        return this;
    }

    public final SimpleGaugeBuilder minMaxLabelFontSize(double MIN_MAX_LABEL_FONT_SIZE) {
        this.properties.put("MIN_MAX_LABEL_FONT_SIZE", (Property)new SimpleDoubleProperty(MIN_MAX_LABEL_FONT_SIZE));
        return this;
    }

    public final SimpleGaugeBuilder minLabelColor(Color MIN_LABEL_COLOR) {
        this.properties.put("MIN_LABEL_COLOR", (Property)new SimpleObjectProperty((Object)MIN_LABEL_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder maxLabelColor(Color MAX_LABEL_COLOR) {
        this.properties.put("MAX_LABEL_COLOR", (Property)new SimpleObjectProperty((Object)MAX_LABEL_COLOR));
        return this;
    }

    public final SimpleGaugeBuilder roundedBar(boolean ROUNDED_BAR) {
        this.properties.put("ROUNDED_BAR", (Property)new SimpleBooleanProperty(ROUNDED_BAR));
        return this;
    }

    public final SimpleGaugeBuilder valueLabelVisible(boolean VALUE_LABEL_VISIBLE) {
        this.properties.put("VALUE_LABEL_VISIBLE", (Property)new SimpleBooleanProperty(VALUE_LABEL_VISIBLE));
        return this;
    }

    public final SimpleGaugeBuilder unitLabelVisible(boolean UNIT_LABEL_VISIBLE) {
        this.properties.put("UNIT_LABEL_VISIBLE", (Property)new SimpleBooleanProperty(UNIT_LABEL_VISIBLE));
        return this;
    }

    public final SimpleGaugeBuilder timeToValueInMs(double TIME_TO_VALUE_IN_MS) {
        this.properties.put("TIME_TO_VALUE_IN_MS", (Property)new SimpleDoubleProperty(TIME_TO_VALUE_IN_MS));
        return this;
    }

    public final SimpleGaugeBuilder canvasMode(boolean CANVAS_MODE) {
        this.properties.put("CANVAS_MODE", (Property)new SimpleBooleanProperty(CANVAS_MODE));
        return this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("PREF_WIDTH", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)((Object)this);
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("PREF_HEIGHT", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)((Object)this);
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("LAYOUT_X", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)((Object)this);
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("LAYOUT_Y", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)((Object)this);
    }

    public final SimpleGauge build() {
        SimpleGauge CONTROL;
        if (this.properties.containsKey("TYPE")) {
            switch ((GaugeType)((Object)((ObjectProperty)this.properties.get("TYPE")).get())) {
                case SIMPLE_LINEAR_GAUGE: {
                    CONTROL = new SimpleLinearGauge();
                    break;
                }
                default: {
                    CONTROL = new SimpleRadialGauge();
                    break;
                }
            }
        } else {
            CONTROL = new SimpleRadialGauge();
        }
        if (this.properties.containsKey("MODEL")) {
            CONTROL.setGaugeModel((GaugeModel)((ObjectProperty)this.properties.get("MODEL")).get());
        }
        if (this.properties.containsKey("PREF_WIDTH") && this.properties.containsKey("PREF_HEIGHT")) {
            CONTROL.setPrefSize(((DoubleProperty)this.properties.get("PREF_WIDTH")).get(), ((DoubleProperty)this.properties.get("PREF_HEIGHT")).get());
        }
        for (String key : this.properties.keySet()) {
            if ("MIN_VALUE".equals(key)) {
                CONTROL.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MAX_VALUE".equals(key)) {
                CONTROL.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("VALUE".equals(key)) {
                CONTROL.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("LAYOUT_X".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("LAYOUT_Y".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("VALUE_ANIMATION_ENABLED".equals(key)) {
                CONTROL.setValueAnimationEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BAR_COLOR".equals(key)) {
                CONTROL.setValueColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BAR_WIDTH".equals(key)) {
                CONTROL.setBarWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("LABEL_FONT_SIZE".equals(key)) {
                CONTROL.setValueLabelFontSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("NO_OF_DECIMALS".equals(key)) {
                CONTROL.setNoOfDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("SECTIONS_ARRAY".equals(key)) {
                CONTROL.setSections((Section[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("SECTIONS_LIST".equals(key)) {
                CONTROL.setSections((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("UNIT".equals(key)) {
                CONTROL.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BAR_FRAME_COLOR".equals(key)) {
                CONTROL.setBarFrameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("BAR_BACKGROUND_COLOR".equals(key)) {
                CONTROL.setBarBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("VALUE_LABEL_COLOR".equals(key)) {
                CONTROL.setValueLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("UNIT_LABEL_COLOR".equals(key)) {
                CONTROL.setUnitLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("UNIT_FONT_SIZE".equals(key)) {
                CONTROL.setUnitLabelFontSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MIN_LABEL_VISIBLE".equals(key)) {
                CONTROL.setMinLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MAX_LABEL_VISIBLE".equals(key)) {
                CONTROL.setMaxLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MIN_MAX_LABEL_FONT_SIZE".equals(key)) {
                CONTROL.setMinMaxLabelFontSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MIN_LABEL_COLOR".equals(key)) {
                CONTROL.setMinLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("MAX_LABEL_COLOR".equals(key)) {
                CONTROL.setMaxLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ROUNDED_BAR".equals(key)) {
                CONTROL.setRoundedBar(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("VALUE_LABEL_VISIBLE".equals(key)) {
                CONTROL.setValueLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("UNIT_LABEL_VISIBLE".equals(key)) {
                CONTROL.setUnitLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("TIME_TO_VALUE_IN_MS".equals(key)) {
                CONTROL.setTimeToValueInMs(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"CANVAS_MODE".equals(key)) continue;
            CONTROL.setCanvasMode(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }

    public static enum GaugeType {
        SIMPLE_RADIAL_GAUGE,
        SIMPLE_LINEAR_GAUGE;

    }
}

