/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class SplitFlap
extends Control {
    public static final String[] TIME_0_TO_5 = new String[]{"1", "2", "3", "4", "5", "0"};
    public static final String[] TIME_0_TO_9 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] NUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] ALPHANUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] EXTENDED = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", ".", ";", "@", "#", "+", "?", "!", "%", "$", "=", "<", ">"};
    private static final String DEFAULT_STYLE_CLASS = "split-flap";
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.rgb((int)56, (int)56, (int)56));
    private ObjectProperty<Color> upperFlapTopColor = new SimpleObjectProperty((Object)Color.rgb((int)43, (int)44, (int)39));
    private ObjectProperty<Color> upperFlapBottomColor = new SimpleObjectProperty((Object)Color.rgb((int)59, (int)58, (int)53));
    private ObjectProperty<Color> lowerFlapTopColor = new SimpleObjectProperty((Object)Color.rgb((int)59, (int)58, (int)53));
    private ObjectProperty<Color> lowerFlapBottomColor = new SimpleObjectProperty((Object)Color.rgb((int)40, (int)41, (int)35));
    private ObjectProperty<Color> textColor = new SimpleObjectProperty((Object)Color.WHITE);
    private ObjectProperty<Color> textUpperFlapColor = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)255, (int)255));
    private ObjectProperty<Color> textLowerFlapColor = new SimpleObjectProperty((Object)Color.rgb((int)248, (int)248, (int)248));
    private DoubleProperty flapCornerRadius = new SimpleDoubleProperty(6.0);
    private BooleanProperty upperFlapHighlightEnabled = new SimpleBooleanProperty(false);
    private BooleanProperty lowerFlapeHighlightEnabled = new SimpleBooleanProperty(false);
    private BooleanProperty darkFixtureEnabled = new SimpleBooleanProperty(true);
    private ObjectProperty<String[]> selection;
    private ArrayList<String> selectedSet;
    private BooleanProperty imageMode;
    private int currentSelectionIndex;
    private int nextSelectionIndex;
    private int previousSelectionIndex;
    private BooleanProperty interactive;
    private StringProperty text;
    private LongProperty flipTimeInMs;
    private BooleanProperty countdownMode;
    private BooleanProperty soundOn;
    private ObjectProperty<Sound> sound;
    private BooleanProperty frameVisible;
    private ObjectProperty<Color> frameTopColor;
    private ObjectProperty<Color> frameBottomColor;
    private BooleanProperty backgroundVisible;
    private boolean keepAspect;

    public SplitFlap() {
        this(EXTENDED, " ");
    }

    public SplitFlap(String[] CUSTOM_SELECTION) {
        this(CUSTOM_SELECTION, CUSTOM_SELECTION[0]);
    }

    public SplitFlap(String[] CUSTOM_SELECTION, String TEXT) {
        this.selection = new SimpleObjectProperty((Object)(CUSTOM_SELECTION.length == 0 ? EXTENDED : CUSTOM_SELECTION));
        this.selectedSet = new ArrayList(64);
        this.imageMode = new SimpleBooleanProperty(false);
        this.currentSelectionIndex = 0;
        this.nextSelectionIndex = 1;
        this.previousSelectionIndex = ((String[])this.selection.get()).length - 1;
        this.interactive = new SimpleBooleanProperty(false);
        this.text = new SimpleStringProperty(TEXT);
        this.flipTimeInMs = new SimpleLongProperty(200L);
        this.countdownMode = new SimpleBooleanProperty(false);
        this.soundOn = new SimpleBooleanProperty(false);
        this.sound = new SimpleObjectProperty((Object)Sound.SOUND2);
        this.frameVisible = new SimpleBooleanProperty(true);
        this.frameTopColor = new SimpleObjectProperty((Object)Color.rgb((int)52, (int)53, (int)43));
        this.frameBottomColor = new SimpleObjectProperty((Object)Color.rgb((int)61, (int)61, (int)55));
        this.backgroundVisible = new SimpleBooleanProperty(true);
        this.keepAspect = false;
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.selectedSet.addAll(Arrays.asList(EXTENDED));
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.lowerFlapTopColor.set((Object)COLOR.brighter());
        this.lowerFlapBottomColor.set((Object)COLOR);
        this.upperFlapTopColor.set((Object)COLOR.darker());
        this.upperFlapBottomColor.set((Object)COLOR);
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final Color getUpperFlapTopColor() {
        return (Color)this.upperFlapTopColor.get();
    }

    public final void setUpperFlapTopColor(Color UPPER_FLAP_TOP_COLOR) {
        this.upperFlapTopColor.set((Object)UPPER_FLAP_TOP_COLOR);
    }

    public final ObjectProperty<Color> upperFlapTopColorProperty() {
        return this.upperFlapTopColor;
    }

    public final Color getUpperFlapBottomColor() {
        return (Color)this.upperFlapBottomColor.get();
    }

    public final void setUpperFlapBottomColor(Color UPPER_FLAP_BOTTOM_COLOR) {
        this.upperFlapBottomColor.set((Object)UPPER_FLAP_BOTTOM_COLOR);
    }

    public final ObjectProperty<Color> upperFlapBottomColorProperty() {
        return this.upperFlapBottomColor;
    }

    public final Color getLowerFlapTopColor() {
        return (Color)this.lowerFlapTopColor.get();
    }

    public final void setLowerFlapTopColor(Color LOWER_FLAP_TOP_COLOR) {
        this.lowerFlapTopColor.set((Object)LOWER_FLAP_TOP_COLOR);
    }

    public final ObjectProperty<Color> lowerFlapTopColorProperty() {
        return this.lowerFlapTopColor;
    }

    public final Color getLowerFlapBottomColor() {
        return (Color)this.lowerFlapBottomColor.get();
    }

    public final void setLowerFlapBottomColor(Color LOWER_FLAP_BOTTOM_COLOR) {
        this.lowerFlapBottomColor.set((Object)LOWER_FLAP_BOTTOM_COLOR);
    }

    public final ObjectProperty<Color> lowerFlapBottomColorProperty() {
        return this.lowerFlapBottomColor;
    }

    public final Color getTextColor() {
        return (Color)this.textColor.get();
    }

    public final void setTextColor(Color COLOR) {
        this.textUpperFlapColor.set((Object)COLOR.darker());
        this.textLowerFlapColor.set((Object)COLOR.brighter());
        this.textColor.set((Object)COLOR);
    }

    public final ObjectProperty<Color> textColorProperty() {
        return this.textColor;
    }

    public final Color getTextUpperFlapColor() {
        return (Color)this.textUpperFlapColor.get();
    }

    public final void setTextUpperFlapColor(Color TEXT_UPPER_FLAP_COLOR) {
        this.textUpperFlapColor.set((Object)TEXT_UPPER_FLAP_COLOR);
    }

    public final ObjectProperty<Color> textUpperFlapColorProperty() {
        return this.textUpperFlapColor;
    }

    public final Color getTextLowerFlapColor() {
        return (Color)this.textLowerFlapColor.get();
    }

    public final void setTextLowerFlapColor(Color TEXT_LOWER_FLAP_COLOR) {
        this.textLowerFlapColor.set((Object)TEXT_LOWER_FLAP_COLOR);
    }

    public final ObjectProperty<Color> textLowerFlapColorProperty() {
        return this.textLowerFlapColor;
    }

    public final double getFlapCornerRadius() {
        return this.flapCornerRadius.get();
    }

    public final void setFlapCornerRadius(double FLAP_CORNER_RADIUS) {
        double radius = FLAP_CORNER_RADIUS < 0.0 ? 0.0 : (FLAP_CORNER_RADIUS > 20.0 ? 20.0 : FLAP_CORNER_RADIUS);
        this.flapCornerRadius.set(radius);
    }

    public final DoubleProperty flapCornerRadiusProperty() {
        return this.flapCornerRadius;
    }

    public final boolean isUpperFlapHighlightEnabled() {
        return this.upperFlapHighlightEnabled.get();
    }

    public final void setUpperFlapHighlightEnabled(boolean UPPER_FLAP_HIGHLIGHT_ENABLED) {
        this.upperFlapHighlightEnabled.set(UPPER_FLAP_HIGHLIGHT_ENABLED);
    }

    public final BooleanProperty upperFlapHighlightEnabledProperty() {
        return this.upperFlapHighlightEnabled;
    }

    public final boolean isLowerFlapHighlightEnabled() {
        return this.lowerFlapeHighlightEnabled.get();
    }

    public final void setLowerFlapHighlightEnabled(boolean LOWER_FLAP_HIGHLIGHT_ENABLED) {
        this.lowerFlapeHighlightEnabled.set(LOWER_FLAP_HIGHLIGHT_ENABLED);
    }

    public final BooleanProperty lowerFlapHighlightEnabledProperty() {
        return this.lowerFlapeHighlightEnabled;
    }

    public final boolean isDarkFixtureEnabled() {
        return this.darkFixtureEnabled.get();
    }

    public final void setDarkFixtureEnabled(boolean DARK_FIXTURE_ENABLED) {
        this.darkFixtureEnabled.set(DARK_FIXTURE_ENABLED);
    }

    public final BooleanProperty darkFixtureEnabledProperty() {
        return this.darkFixtureEnabled;
    }

    public final String[] getSelection() {
        return (String[])this.selection.get();
    }

    public final void setSelection(String[] SELECTION) {
        this.selectedSet.clear();
        if (SELECTION.length == 0) {
            this.selectedSet.addAll(Arrays.asList(EXTENDED));
        } else {
            this.selectedSet.addAll(Arrays.asList(SELECTION));
        }
        this.selection.set((Object)SELECTION);
    }

    public final ObjectProperty<String[]> selectionProperty() {
        return this.selection;
    }

    public final ArrayList<String> getSelectedSet() {
        return this.selectedSet;
    }

    public final boolean isImageMode() {
        return this.imageMode.get();
    }

    public final void setImageMode(boolean IMAGE_MODE) {
        this.imageMode.set(IMAGE_MODE);
    }

    public final BooleanProperty imageModeProperty() {
        return this.imageMode;
    }

    public final boolean isInteractive() {
        return this.interactive.get();
    }

    public final void setInteractive(boolean INTERACTIVE) {
        this.interactive.set(INTERACTIVE);
    }

    public final BooleanProperty interactiveProperty() {
        return this.interactive;
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String TEXT) {
        if (!TEXT.isEmpty() || this.selectedSet.contains(TEXT)) {
            this.text.set((Object)TEXT);
        } else {
            this.text.set((Object)this.selectedSet.get(0));
        }
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getNextText() {
        return this.selectedSet.get(this.nextSelectionIndex);
    }

    public final String getPreviousText() {
        return this.selectedSet.get(this.previousSelectionIndex);
    }

    public final long getFlipTimeInMs() {
        return this.flipTimeInMs.get();
    }

    public final void setFlipTimeInMs(long FLIP_TIME_IN_MS) {
        this.flipTimeInMs.set(FLIP_TIME_IN_MS < 16L ? 16L : (FLIP_TIME_IN_MS > 3000L ? 3000L : FLIP_TIME_IN_MS));
    }

    public final LongProperty flipTimeInMsProperty() {
        return this.flipTimeInMs;
    }

    public final boolean isCountdownMode() {
        return this.countdownMode.get();
    }

    public final void setCountdownMode(boolean COUNTDOWN_MODE) {
        this.countdownMode.set(COUNTDOWN_MODE);
    }

    public final BooleanProperty countdownModeProperty() {
        return this.countdownMode;
    }

    public final boolean isSoundOn() {
        return this.soundOn.get();
    }

    public final void setSoundOn(boolean SOUND_ON) {
        this.soundOn.set(SOUND_ON);
    }

    public final BooleanProperty soundOnProperty() {
        return this.soundOn;
    }

    public final Sound getSound() {
        return (Sound)((Object)this.sound.get());
    }

    public final void setSound(Sound SOUND) {
        this.sound.set((Object)SOUND);
    }

    public final ObjectProperty<Sound> soundProperty() {
        return this.sound;
    }

    public final boolean isBackgroundVisible() {
        return this.backgroundVisible.get();
    }

    public final void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.backgroundVisible.set(BACKGROUND_VISIBLE);
    }

    public final BooleanProperty backgroundVisibleProperty() {
        return this.backgroundVisible;
    }

    public final boolean isFrameVisible() {
        return this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.frameVisible.set(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        return this.frameVisible;
    }

    public final Color getFrameTopColor() {
        return (Color)this.frameTopColor.get();
    }

    public final void setFrameTopColor(Color FRAME_TOP_COLOR) {
        this.frameTopColor.set((Object)FRAME_TOP_COLOR);
    }

    public final ObjectProperty<Color> frameTopColorProperty() {
        return this.frameTopColor;
    }

    public final Color getFrameBottomColor() {
        return (Color)this.frameBottomColor.get();
    }

    public final void setFrameBottomColor(Color FRAME_BOTTOM_COLOR) {
        this.frameBottomColor.set((Object)FRAME_BOTTOM_COLOR);
    }

    public final ObjectProperty<Color> frameBottomColorProperty() {
        return this.frameBottomColor;
    }

    public final void flipForward() {
        this.setCountdownMode(false);
        this.previousSelectionIndex = this.currentSelectionIndex++;
        if (this.currentSelectionIndex >= this.selectedSet.size()) {
            this.currentSelectionIndex = 0;
        }
        this.nextSelectionIndex = this.currentSelectionIndex + 1;
        if (this.nextSelectionIndex >= this.selectedSet.size()) {
            this.nextSelectionIndex = 0;
        }
        this.setText(this.selectedSet.get(this.currentSelectionIndex));
    }

    public final void flipBackward() {
        this.setCountdownMode(true);
        this.previousSelectionIndex = this.currentSelectionIndex--;
        if (this.currentSelectionIndex < 0) {
            this.currentSelectionIndex = this.selectedSet.size() - 1;
        }
        this.nextSelectionIndex = this.currentSelectionIndex - 1;
        if (this.nextSelectionIndex < 0) {
            this.nextSelectionIndex = this.selectedSet.size() - 1;
        }
        this.setText(this.selectedSet.get(this.currentSelectionIndex));
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double prefHeight = WIDTH < HEIGHT * 0.5814977974 ? WIDTH * 1.7196969697 : HEIGHT;
        double prefWidth = prefHeight * 0.5814977974;
        if (this.keepAspect) {
            super.setPrefSize(prefWidth, prefHeight);
        } else {
            super.setPrefSize(WIDTH, HEIGHT);
        }
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    public static enum Sound {
        SOUND1,
        SOUND2,
        SOUND3;

    }
}

