/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class TickMark {
    private ObjectProperty<Type> type;
    private ObjectProperty<Indicator> indicator;
    private ObjectProperty<Color> indicatorColor;
    private BooleanProperty indicatorVisible;
    private StringProperty label;
    private ObjectProperty<Color> labelColor;
    private BooleanProperty labelVisible;
    private ObjectProperty<Font> labelFont;
    private DoubleProperty labelFontSizeFactor;
    private ObjectProperty<TickLabelOrientation> tickLabelOrientation;

    public TickMark() {
        this(Type.MINOR, Indicator.LINE, Color.BLACK, "", Color.BLACK, TickLabelOrientation.NORMAL);
    }

    public TickMark(Type TYPE, Indicator INDICATOR, String LABEL) {
        this(TYPE, INDICATOR, Color.BLACK, LABEL, Color.BLACK, TickLabelOrientation.NORMAL);
    }

    public TickMark(Type TYPE, Indicator INDICATOR, Color INDICATOR_COLOR, String LABEL, Color LABEL_COLOR, TickLabelOrientation TICK_LABEL_ORIENTATION) {
        this.type = new SimpleObjectProperty((Object)TYPE);
        this.indicator = new SimpleObjectProperty((Object)INDICATOR);
        this.indicatorColor = new SimpleObjectProperty((Object)INDICATOR_COLOR);
        this.indicatorVisible = new SimpleBooleanProperty(true);
        this.label = new SimpleStringProperty(LABEL);
        this.labelColor = new SimpleObjectProperty((Object)LABEL_COLOR);
        this.labelVisible = new SimpleBooleanProperty(TYPE != Type.MINOR);
        this.labelFont = new SimpleObjectProperty((Object)Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)8.0));
        this.labelFontSizeFactor = new SimpleDoubleProperty(0.035);
        this.tickLabelOrientation = new SimpleObjectProperty((Object)TICK_LABEL_ORIENTATION);
    }

    public final Type getType() {
        return (Type)((Object)this.type.get());
    }

    public final void setType(Type TYPE) {
        this.type.set((Object)TYPE);
    }

    public final ObjectProperty<Type> typeProperty() {
        return this.type;
    }

    public final Indicator getIndicator() {
        return (Indicator)((Object)this.indicator.get());
    }

    public final void setIndicator(Indicator INDICATOR) {
        this.indicator.set((Object)INDICATOR);
    }

    public final ObjectProperty<Indicator> indicatorProperty() {
        return this.indicator;
    }

    public final Color getIndicatorColor() {
        return (Color)this.indicatorColor.get();
    }

    public final void setIndicatorColor(Color INDICATOR_COLOR) {
        this.indicatorColor.set((Object)INDICATOR_COLOR);
    }

    public final ObjectProperty<Color> indicatorColorProperty() {
        return this.indicatorColor;
    }

    public final boolean isIndicatorVisible() {
        return this.indicatorVisible.get();
    }

    public final void setIndicatorVisible(boolean INDICATOR_VISIBLE) {
        this.indicatorVisible.set(INDICATOR_VISIBLE);
    }

    public final BooleanProperty indicatorVisibleProperty() {
        return this.indicatorVisible;
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final void setLabel(String LABEL) {
        this.label.set((Object)LABEL);
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public final Color getLabelColor() {
        return (Color)this.labelColor.get();
    }

    public final void setLabelColor(Color LABEL_COLOR) {
        this.labelColor.set((Object)LABEL_COLOR);
    }

    public final ObjectProperty<Color> labelColorProperty() {
        return this.labelColor;
    }

    public final boolean isLabelVisible() {
        return this.labelVisible.get();
    }

    public final void setLabelVisible(boolean LABEL_VISIBLE) {
        this.labelVisible.set(LABEL_VISIBLE);
    }

    public final BooleanProperty labelVisibleProperty() {
        return this.labelVisible;
    }

    public final Font getLabelFont() {
        return (Font)this.labelFont.get();
    }

    public final void setLabelFont(Font LABEL_FONT) {
        this.labelFont.set((Object)LABEL_FONT);
    }

    public final ObjectProperty<Font> labelFontProperty() {
        return this.labelFont;
    }

    public final double getLabelFontSizeFactor() {
        return this.labelFontSizeFactor.get();
    }

    public final void setLabelFontSizeFactor(double LABEL_FONT_SIZE_FACTOR) {
        this.labelFontSizeFactor.set(LABEL_FONT_SIZE_FACTOR < 0.0 ? 0.035 : (LABEL_FONT_SIZE_FACTOR > 1.0 ? 0.035 : LABEL_FONT_SIZE_FACTOR));
    }

    public final DoubleProperty labelFontSizeFactorProperty() {
        return this.labelFontSizeFactor;
    }

    public final TickLabelOrientation getTickLabelOrientation() {
        return (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public final void setTickLabelOrientation(TickLabelOrientation TICK_LABEL_ORIENTATION) {
        this.tickLabelOrientation.set((Object)TICK_LABEL_ORIENTATION);
    }

    public final ObjectProperty<TickLabelOrientation> tickLabelOrienationObjectProperty() {
        return this.tickLabelOrientation;
    }

    public static enum TickLabelOrientation {
        NORMAL,
        HORIZONTAL,
        TANGENT;

    }

    public static enum Indicator {
        LINE,
        CIRCLE,
        TRIANGLE,
        SQUARE;

    }

    public static enum Type {
        MINOR(0.0015, 0.3, 0.0133333333, 1.0),
        MEDIUM(0.0025, 0.5, 0.02, 1.0),
        MAJOR(0.005, 1.0, 0.03, 1.0);

        public double strokeWidthFactor;
        public double minStrokeWidth;
        public double strokeLengthFactor;
        public double minStrokeLength;

        private Type(double STROKE_WIDTH_FACTOR, double MIN_STROKE_WIDTH, double STROKE_LENGTH_FACTOR, double MIN_STROKE_LENGTH) {
            this.strokeWidthFactor = STROKE_WIDTH_FACTOR;
            this.minStrokeWidth = MIN_STROKE_WIDTH;
            this.strokeLengthFactor = STROKE_LENGTH_FACTOR;
            this.minStrokeLength = MIN_STROKE_LENGTH;
        }
    }
}

