/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.grid;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.scene.control.Control;
import javafx.util.Callback;
import jfxtras.labs.scene.control.grid.GridCell;
import jfxtras.labs.util.grid.SimpleStyleableDoubleProperty;

public class GridView<T>
extends Control {
    private ObjectProperty<ObservableList<T>> items;
    private ObjectProperty<Callback<GridView<T>, GridCell<T>>> cellFactory;
    private DoubleProperty cellWidth;
    private DoubleProperty cellHeight;
    private DoubleProperty horizontalCellSpacing;
    private DoubleProperty verticalCellSpacing;
    private ObjectProperty<HPos> horizontalAlignment;

    public GridView() {
        this(FXCollections.observableArrayList());
    }

    public GridView(ObservableList<T> items) {
        this.getStyleClass().add((Object)"grid-view");
        this.setItems(items);
    }

    public void setHorizontalCellSpacing(double value) {
        this.horizontalCellSpacingProperty().set(value);
    }

    public double getHorizontalCellSpacing() {
        return this.horizontalCellSpacing == null ? 12.0 : this.horizontalCellSpacing.get();
    }

    public final DoubleProperty horizontalCellSpacingProperty() {
        if (this.horizontalCellSpacing == null) {
            this.horizontalCellSpacing = new SimpleStyleableDoubleProperty((Object)this, "horizontalCellSpacing", StyleableProperties.HORIZONTAL_CELL_SPACING);
        }
        return this.horizontalCellSpacing;
    }

    public void setVerticalCellSpacing(double value) {
        this.verticalCellSpacingProperty().set(value);
    }

    public double getVerticalCellSpacing() {
        return this.verticalCellSpacing == null ? 12.0 : this.verticalCellSpacing.get();
    }

    public final DoubleProperty verticalCellSpacingProperty() {
        if (this.verticalCellSpacing == null) {
            this.verticalCellSpacing = new SimpleStyleableDoubleProperty((Object)this, "verticalCellSpacing", StyleableProperties.VERTICAL_CELL_SPACING);
        }
        return this.verticalCellSpacing;
    }

    public final DoubleProperty cellWidthProperty() {
        if (this.cellWidth == null) {
            this.cellWidth = new SimpleStyleableDoubleProperty((Object)this, "cellWidth", StyleableProperties.CELL_WIDTH);
        }
        return this.cellWidth;
    }

    public void setCellWidth(double value) {
        this.cellWidthProperty().set(value);
    }

    public double getCellWidth() {
        return this.cellWidth == null ? 64.0 : this.cellWidth.get();
    }

    public final DoubleProperty cellHeightProperty() {
        if (this.cellHeight == null) {
            this.cellHeight = new SimpleStyleableDoubleProperty((Object)this, "cellHeight", StyleableProperties.CELL_HEIGHT);
        }
        return this.cellHeight;
    }

    public void setCellHeight(double value) {
        this.cellHeightProperty().set(value);
    }

    public double getCellHeight() {
        return this.cellHeight == null ? 64.0 : this.cellHeight.get();
    }

    public final ObjectProperty<HPos> horizontalAlignmentProperty() {
        if (this.horizontalAlignment == null) {
            this.horizontalAlignment = new StyleableObjectProperty<HPos>(HPos.CENTER){

                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.HORIZONTAL_ALIGNMENT;
                }

                public Object getBean() {
                    return GridView.this;
                }

                public String getName() {
                    return "horizontalAlignment";
                }
            };
        }
        return this.horizontalAlignment;
    }

    public final void setHorizontalAlignment(HPos value) {
        this.horizontalAlignmentProperty().set((Object)value);
    }

    public final HPos getHorizontalAlignment() {
        return this.horizontalAlignment == null ? HPos.CENTER : (HPos)this.horizontalAlignment.get();
    }

    public final ObjectProperty<Callback<GridView<T>, GridCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<GridView<T>, GridCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<GridView<T>, GridCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<T> getItems() {
        return this.items == null ? null : (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleObjectProperty((Object)this, "items");
        }
        return this.items;
    }

    protected String getUserAgentStylesheet() {
        return GridView.class.getResource("gridview.css").toExternalForm();
    }

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    public List<StyleableProperty> impl_getStyleableProperties() {
        return GridView.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<GridView, HPos> HORIZONTAL_ALIGNMENT = new StyleableProperty<GridView, HPos>("-fx-horizontal-alignment", (StyleConverter)new EnumConverter(HPos.class), HPos.CENTER){

            public boolean isSettable(GridView n) {
                return n.horizontalAlignment == null || !n.horizontalAlignment.isBound();
            }

            public WritableValue<HPos> getWritableValue(GridView n) {
                return n.horizontalAlignmentProperty();
            }

            public HPos getInitialValue(GridView n) {
                return HPos.CENTER;
            }
        };
        private static final StyleableProperty<GridView, Number> CELL_WIDTH = new StyleableProperty<GridView, Number>("-fx-cell-width", (StyleConverter)SizeConverter.getInstance(), (Number)64.0){

            public boolean isSettable(GridView n) {
                return n.cellWidth == null || !n.cellWidth.isBound();
            }

            public WritableValue<Number> getWritableValue(GridView n) {
                return n.cellWidthProperty();
            }
        };
        private static final StyleableProperty<GridView, Number> CELL_HEIGHT = new StyleableProperty<GridView, Number>("-fx-cell-height", (StyleConverter)SizeConverter.getInstance(), (Number)64.0){

            public boolean isSettable(GridView n) {
                return n.cellHeight == null || !n.cellHeight.isBound();
            }

            public WritableValue<Number> getWritableValue(GridView n) {
                return n.cellHeightProperty();
            }
        };
        private static final StyleableProperty<GridView, Number> HORIZONTAL_CELL_SPACING = new StyleableProperty<GridView, Number>("-fx-horizontal-cell-spacing", (StyleConverter)SizeConverter.getInstance(), (Number)12.0){

            public boolean isSettable(GridView n) {
                return n.horizontalCellSpacing == null || !n.horizontalCellSpacing.isBound();
            }

            public WritableValue<Number> getWritableValue(GridView n) {
                return n.horizontalCellSpacingProperty();
            }
        };
        private static final StyleableProperty<GridView, Number> VERTICAL_CELL_SPACING = new StyleableProperty<GridView, Number>("-fx-vertical-cell-spacing", (StyleConverter)SizeConverter.getInstance(), (Number)12.0){

            public boolean isSettable(GridView n) {
                return n.verticalCellSpacing == null || !n.verticalCellSpacing.isBound();
            }

            public WritableValue<Number> getWritableValue(GridView n) {
                return n.verticalCellSpacingProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.impl_CSS_STYLEABLES());
            Collections.addAll(styleables, HORIZONTAL_ALIGNMENT, CELL_HEIGHT, CELL_WIDTH, HORIZONTAL_CELL_SPACING, VERTICAL_CELL_SPACING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

