/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.grid;

import java.util.HashMap;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.util.Builder;
import javafx.util.Callback;
import jfxtras.labs.scene.control.grid.GridCell;
import jfxtras.labs.scene.control.grid.GridView;

public class GridViewBuilder<B extends GridViewBuilder<B, T>, T>
implements Builder<GridView<T>> {
    private static final String ITEMS = "items";
    private static final String CELL_FACTORY = "cellFactory";
    private static final String CELL_WIDTH = "cellWidth";
    private static final String CELL_HEIGHT = "cellHeight";
    private static final String HORIZONTAL_CELL_SPACING = "horizontalCellSpacing";
    private static final String VERTICAL_CELL_SPACING = "verticalCellSpacing";
    private HashMap<String, Property> properties = new HashMap();

    protected GridViewBuilder() {
    }

    public static final <T, U extends GridViewBuilder<U, T>> GridViewBuilder<U, T> create(Class<T> cls) {
        return new GridViewBuilder();
    }

    public final GridViewBuilder<B, T> items(ObservableList<T> items) {
        this.properties.put(ITEMS, (Property)new SimpleObjectProperty(items));
        return this;
    }

    public final GridViewBuilder<B, T> cellFactory(Callback<GridView<T>, GridCell<T>> cellFactory) {
        this.properties.put(CELL_FACTORY, (Property)new SimpleObjectProperty(cellFactory));
        return this;
    }

    public final GridViewBuilder<B, T> cellWidth(double cellWidth) {
        this.properties.put(CELL_WIDTH, (Property)new SimpleObjectProperty((Object)cellWidth));
        return this;
    }

    public final GridViewBuilder<B, T> cellHeight(double cellHeight) {
        this.properties.put(CELL_HEIGHT, (Property)new SimpleObjectProperty((Object)cellHeight));
        return this;
    }

    public final GridViewBuilder<B, T> horizontalCellSpacing(double horizontalCellSpacing) {
        this.properties.put(HORIZONTAL_CELL_SPACING, (Property)new SimpleObjectProperty((Object)horizontalCellSpacing));
        return this;
    }

    public final GridViewBuilder<B, T> verticalCellSpacing(double verticalCellSpacing) {
        this.properties.put(VERTICAL_CELL_SPACING, (Property)new SimpleObjectProperty((Object)verticalCellSpacing));
        return this;
    }

    public GridView<T> build() {
        GridView control = new GridView();
        for (String key : this.properties.keySet()) {
            if (ITEMS.equals(key)) {
                control.setItems((ObservableList)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (CELL_FACTORY.equals(key)) {
                control.setCellFactory((Callback)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (CELL_WIDTH.equals(key)) {
                control.setCellWidth((Double)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (CELL_HEIGHT.equals(key)) {
                control.setCellHeight((Double)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (HORIZONTAL_CELL_SPACING.equals(key)) {
                control.setHorizontalCellSpacing((Double)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!VERTICAL_CELL_SPACING.equals(key)) continue;
            control.setVerticalCellSpacing((Double)((SimpleObjectProperty)this.properties.get(key)).get());
        }
        return control;
    }
}

