/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.radialmenu;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.FadeTransitionBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.PolylineBuilder;
import javafx.util.Duration;
import jfxtras.labs.scene.control.radialmenu.RadialMenuItem;

public class RadialContainerMenuItem
extends RadialMenuItem {
    private boolean selected = false;
    private final Group childAnimGroup = new Group();
    private FadeTransition fadeIn = null;
    private FadeTransition fadeOut = null;
    protected List<RadialMenuItem> items = new ArrayList<RadialMenuItem>();
    protected Polyline arrow = ((PolylineBuilder)((PolylineBuilder)PolylineBuilder.create().points(new Double[]{-5.0, -5.0, 5.0, 0.0, -5.0, 5.0, -5.0, -5.0}).fill((Paint)Color.GRAY)).stroke(null)).build();

    public RadialContainerMenuItem(double menuSize, Node graphic) {
        super(menuSize, graphic);
        this.initialize();
    }

    public RadialContainerMenuItem(double menuSize, String text, Node graphic) {
        super(menuSize, text, graphic);
        this.initialize();
    }

    private void initialize() {
        this.childAnimGroup.setVisible(false);
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!((Boolean)arg0.getValue()).booleanValue()) {
                    RadialContainerMenuItem.this.childAnimGroup.setVisible(false);
                    RadialContainerMenuItem.this.setSelected(false);
                }
            }
        });
        this.getChildren().add((Object)this.childAnimGroup);
        this.fadeIn = FadeTransitionBuilder.create().node((Node)this.childAnimGroup).duration(Duration.millis((double)400.0)).fromValue(0.0).toValue(1.0).build();
        this.fadeOut = ((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)this.childAnimGroup).duration(Duration.millis((double)400.0)).fromValue(1.0).toValue(0.0).onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                RadialContainerMenuItem.this.childAnimGroup.setVisible(false);
            }
        })).build();
        this.getChildren().add((Object)this.arrow);
    }

    public void addMenuItem(RadialMenuItem item) {
        item.backgroundColorProperty().bind((ObservableValue)this.backgroundColor);
        item.backgroundMouseOnColorProperty().bind((ObservableValue)this.backgroundMouseOnColor);
        item.innerRadiusProperty().bind((ObservableValue)this.radius);
        item.radiusProperty().bind((ObservableValue)this.radius.multiply(2).subtract((ObservableNumberValue)this.innerRadius));
        item.offsetProperty().bind((ObservableValue)this.offset.multiply(2.0));
        item.strokeColorProperty().bind((ObservableValue)this.strokeColor);
        item.clockwiseProperty().bind((ObservableValue)this.clockwise);
        item.backgroundVisibleProperty().bind((ObservableValue)this.backgroundVisible);
        item.strokeVisibleProperty().bind((ObservableValue)this.strokeVisible);
        this.items.add(item);
        this.childAnimGroup.getChildren().add((Object)item);
        double offset = 0.0;
        for (RadialMenuItem it : this.items) {
            it.startAngleProperty().bind((ObservableValue)this.startAngleProperty().add(offset));
            offset += it.getMenuSize();
        }
    }

    public void removeMenuItem(RadialMenuItem item) {
        this.items.remove((Object)item);
        this.childAnimGroup.getChildren().remove((Object)item);
        item.backgroundColorProperty().unbind();
        item.backgroundMouseOnColorProperty().unbind();
        item.innerRadiusProperty().unbind();
        item.radiusProperty().unbind();
        item.offsetProperty().unbind();
        item.strokeColorProperty().unbind();
        item.clockwiseProperty().unbind();
        item.backgroundVisibleProperty().unbind();
        item.strokeVisibleProperty().unbind();
    }

    public void removeMenuItem(int itemIndex) {
        RadialMenuItem item = this.items.get(itemIndex);
        this.removeMenuItem(item);
    }

    @Override
    protected void redraw() {
        super.redraw();
        if (this.selected) {
            this.path.setFill(this.backgroundVisible.get() ? (this.selected && this.backgroundMouseOnColor.get() != null ? (Paint)this.backgroundMouseOnColor.get() : (Paint)this.backgroundColor.get()) : null);
        }
        if (this.arrow != null) {
            this.arrow.setFill(this.backgroundVisible.get() ? (this.mouseOn && this.strokeColor.get() != null ? (Paint)this.strokeColor.get() : (Paint)this.strokeColor.get()) : null);
            this.arrow.setStroke(this.strokeVisible.get() ? (Paint)this.strokeColor.get() : null);
            if (!this.clockwise.get()) {
                this.arrow.setRotate(-(this.startAngle.get() + this.menuSize / 2.0));
                this.arrow.setTranslateX((this.radius.get() - this.arrow.getBoundsInLocal().getWidth() / 2.0) * Math.cos(Math.toRadians(this.startAngle.get() + this.menuSize / 2.0)) + this.translateX);
                this.arrow.setTranslateY(-(this.radius.get() - this.arrow.getBoundsInLocal().getHeight() / 2.0) * Math.sin(Math.toRadians(this.startAngle.get() + this.menuSize / 2.0)) + this.translateY);
            } else {
                this.arrow.setRotate(this.startAngle.get() + this.menuSize / 2.0);
                this.arrow.setTranslateX((this.radius.get() - this.arrow.getBoundsInLocal().getWidth() / 2.0) * Math.cos(Math.toRadians(this.startAngle.get() + this.menuSize / 2.0)) + this.translateX);
                this.arrow.setTranslateY((this.radius.get() - this.arrow.getBoundsInLocal().getHeight() / 2.0) * Math.sin(Math.toRadians(this.startAngle.get() + this.menuSize / 2.0)) + this.translateY);
            }
        }
    }

    @Override
    void setSelected(boolean selected) {
        this.selected = selected;
        if (this.selected) {
            double startOpacity = 0.0;
            if (this.fadeOut.getStatus() == Animation.Status.RUNNING) {
                this.fadeOut.stop();
                startOpacity = this.childAnimGroup.getOpacity();
            }
            this.childAnimGroup.setOpacity(startOpacity);
            this.childAnimGroup.setVisible(true);
            this.fadeIn.fromValueProperty().set(startOpacity);
            this.fadeIn.playFromStart();
        } else {
            double startOpacity = 1.0;
            if (this.fadeIn.getStatus() == Animation.Status.RUNNING) {
                this.fadeIn.stop();
                startOpacity = this.childAnimGroup.getOpacity();
            }
            this.fadeOut.fromValueProperty().set(startOpacity);
            this.fadeOut.playFromStart();
        }
        this.redraw();
    }

    @Override
    boolean isSelected() {
        return this.selected;
    }
}

